/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class StateHeaderBuilder
implements Serializer {
    private final short version;

    protected StateHeaderBuilder(DataInputStream stream) {
        try {
            this.version = Short.reverseBytes(stream.readShort());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static StateHeaderBuilder loadFromBinary(DataInputStream stream) {
        return new StateHeaderBuilder(stream);
    }

    protected StateHeaderBuilder(short version) {
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        this.version = version;
    }

    public static StateHeaderBuilder create(short version) {
        return new StateHeaderBuilder(version);
    }

    public short getVersion() {
        return this.version;
    }

    @Override
    public int getSize() {
        int size = 0;
        return size += 2;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeShort(Short.reverseBytes(this.getVersion())));
    }
}

