/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.LockHashAlgorithmDto;
import io.nem.symbol.catapult.builders.LockStatusDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.StateHeaderBuilder;
import java.io.DataInputStream;

public class SecretLockInfoBuilder
extends StateHeaderBuilder
implements Serializer {
    private final AddressDto ownerAddress;
    private final MosaicBuilder mosaic;
    private final HeightDto endHeight;
    private final LockStatusDto status;
    private final LockHashAlgorithmDto hashAlgorithm;
    private final Hash256Dto secret;
    private final AddressDto recipient;

    protected SecretLockInfoBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.ownerAddress = AddressDto.loadFromBinary(stream);
            this.mosaic = MosaicBuilder.loadFromBinary(stream);
            this.endHeight = HeightDto.loadFromBinary(stream);
            this.status = LockStatusDto.loadFromBinary(stream);
            this.hashAlgorithm = LockHashAlgorithmDto.loadFromBinary(stream);
            this.secret = Hash256Dto.loadFromBinary(stream);
            this.recipient = AddressDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static SecretLockInfoBuilder loadFromBinary(DataInputStream stream) {
        return new SecretLockInfoBuilder(stream);
    }

    protected SecretLockInfoBuilder(short version, AddressDto ownerAddress, MosaicBuilder mosaic, HeightDto endHeight, LockStatusDto status, LockHashAlgorithmDto hashAlgorithm, Hash256Dto secret, AddressDto recipient) {
        super(version);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(ownerAddress, "ownerAddress is null", new Object[0]);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(endHeight, "endHeight is null", new Object[0]);
        GeneratorUtils.notNull(status, "status is null", new Object[0]);
        GeneratorUtils.notNull(hashAlgorithm, "hashAlgorithm is null", new Object[0]);
        GeneratorUtils.notNull(secret, "secret is null", new Object[0]);
        GeneratorUtils.notNull(recipient, "recipient is null", new Object[0]);
        this.ownerAddress = ownerAddress;
        this.mosaic = mosaic;
        this.endHeight = endHeight;
        this.status = status;
        this.hashAlgorithm = hashAlgorithm;
        this.secret = secret;
        this.recipient = recipient;
    }

    public static SecretLockInfoBuilder create(short version, AddressDto ownerAddress, MosaicBuilder mosaic, HeightDto endHeight, LockStatusDto status, LockHashAlgorithmDto hashAlgorithm, Hash256Dto secret, AddressDto recipient) {
        return new SecretLockInfoBuilder(version, ownerAddress, mosaic, endHeight, status, hashAlgorithm, secret, recipient);
    }

    public AddressDto getOwnerAddress() {
        return this.ownerAddress;
    }

    public MosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public HeightDto getEndHeight() {
        return this.endHeight;
    }

    public LockStatusDto getStatus() {
        return this.status;
    }

    public LockHashAlgorithmDto getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public Hash256Dto getSecret() {
        return this.secret;
    }

    public AddressDto getRecipient() {
        return this.recipient;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.ownerAddress.getSize();
        size += this.mosaic.getSize();
        size += this.endHeight.getSize();
        size += this.status.getSize();
        size += this.hashAlgorithm.getSize();
        size += this.secret.getSize();
        return size += this.recipient.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.ownerAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaic);
            GeneratorUtils.writeEntity(dataOutputStream, this.endHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.status);
            GeneratorUtils.writeEntity(dataOutputStream, this.hashAlgorithm);
            GeneratorUtils.writeEntity(dataOutputStream, this.secret);
            GeneratorUtils.writeEntity(dataOutputStream, this.recipient);
        });
    }
}

