/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NamespaceAliasBuilder;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceLifetimeBuilder;
import io.nem.symbol.catapult.builders.NamespacePathBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.StateHeaderBuilder;
import java.io.DataInputStream;
import java.util.List;

public class RootNamespaceHistoryBuilder
extends StateHeaderBuilder
implements Serializer {
    private final NamespaceIdDto id;
    private final AddressDto ownerAddress;
    private final NamespaceLifetimeBuilder lifetime;
    private final NamespaceAliasBuilder rootAlias;
    private final List<NamespacePathBuilder> paths;

    protected RootNamespaceHistoryBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.id = NamespaceIdDto.loadFromBinary(stream);
            this.ownerAddress = AddressDto.loadFromBinary(stream);
            this.lifetime = NamespaceLifetimeBuilder.loadFromBinary(stream);
            this.rootAlias = NamespaceAliasBuilder.loadFromBinary(stream);
            long childrenCount = Long.reverseBytes(stream.readLong());
            this.paths = GeneratorUtils.loadFromBinaryArray(NamespacePathBuilder::loadFromBinary, stream, childrenCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static RootNamespaceHistoryBuilder loadFromBinary(DataInputStream stream) {
        return new RootNamespaceHistoryBuilder(stream);
    }

    protected RootNamespaceHistoryBuilder(short version, NamespaceIdDto id, AddressDto ownerAddress, NamespaceLifetimeBuilder lifetime, NamespaceAliasBuilder rootAlias, List<NamespacePathBuilder> paths) {
        super(version);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(id, "id is null", new Object[0]);
        GeneratorUtils.notNull(ownerAddress, "ownerAddress is null", new Object[0]);
        GeneratorUtils.notNull(lifetime, "lifetime is null", new Object[0]);
        GeneratorUtils.notNull(rootAlias, "rootAlias is null", new Object[0]);
        GeneratorUtils.notNull(paths, "paths is null", new Object[0]);
        this.id = id;
        this.ownerAddress = ownerAddress;
        this.lifetime = lifetime;
        this.rootAlias = rootAlias;
        this.paths = paths;
    }

    public static RootNamespaceHistoryBuilder create(short version, NamespaceIdDto id, AddressDto ownerAddress, NamespaceLifetimeBuilder lifetime, NamespaceAliasBuilder rootAlias, List<NamespacePathBuilder> paths) {
        return new RootNamespaceHistoryBuilder(version, id, ownerAddress, lifetime, rootAlias, paths);
    }

    public NamespaceIdDto getId() {
        return this.id;
    }

    public AddressDto getOwnerAddress() {
        return this.ownerAddress;
    }

    public NamespaceLifetimeBuilder getLifetime() {
        return this.lifetime;
    }

    public NamespaceAliasBuilder getRootAlias() {
        return this.rootAlias;
    }

    public List<NamespacePathBuilder> getPaths() {
        return this.paths;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.id.getSize();
        size += this.ownerAddress.getSize();
        size += this.lifetime.getSize();
        size += this.rootAlias.getSize();
        size += 8;
        return size += this.paths.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.id);
            GeneratorUtils.writeEntity(dataOutputStream, this.ownerAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.lifetime);
            GeneratorUtils.writeEntity(dataOutputStream, this.rootAlias);
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getPaths())));
            GeneratorUtils.writeList(dataOutputStream, this.paths);
        });
    }
}

