/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class ReceiptSourceBuilder
implements Serializer {
    private final int primaryId;
    private final int secondaryId;

    protected ReceiptSourceBuilder(DataInputStream stream) {
        try {
            this.primaryId = Integer.reverseBytes(stream.readInt());
            this.secondaryId = Integer.reverseBytes(stream.readInt());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static ReceiptSourceBuilder loadFromBinary(DataInputStream stream) {
        return new ReceiptSourceBuilder(stream);
    }

    protected ReceiptSourceBuilder(int primaryId, int secondaryId) {
        GeneratorUtils.notNull(primaryId, "primaryId is null", new Object[0]);
        GeneratorUtils.notNull(secondaryId, "secondaryId is null", new Object[0]);
        this.primaryId = primaryId;
        this.secondaryId = secondaryId;
    }

    public static ReceiptSourceBuilder create(int primaryId, int secondaryId) {
        return new ReceiptSourceBuilder(primaryId, secondaryId);
    }

    public int getPrimaryId() {
        return this.primaryId;
    }

    public int getSecondaryId() {
        return this.secondaryId;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        return size += 4;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getPrimaryId()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getSecondaryId()));
        });
    }
}

