/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.FinalizationEpochDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.VotingKeyDto;
import java.io.DataInputStream;

public class PinnedVotingKeyBuilder
implements Serializer {
    private final VotingKeyDto votingKey;
    private final FinalizationEpochDto startEpoch;
    private final FinalizationEpochDto endEpoch;

    protected PinnedVotingKeyBuilder(DataInputStream stream) {
        try {
            this.votingKey = VotingKeyDto.loadFromBinary(stream);
            this.startEpoch = FinalizationEpochDto.loadFromBinary(stream);
            this.endEpoch = FinalizationEpochDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static PinnedVotingKeyBuilder loadFromBinary(DataInputStream stream) {
        return new PinnedVotingKeyBuilder(stream);
    }

    protected PinnedVotingKeyBuilder(VotingKeyDto votingKey, FinalizationEpochDto startEpoch, FinalizationEpochDto endEpoch) {
        GeneratorUtils.notNull(votingKey, "votingKey is null", new Object[0]);
        GeneratorUtils.notNull(startEpoch, "startEpoch is null", new Object[0]);
        GeneratorUtils.notNull(endEpoch, "endEpoch is null", new Object[0]);
        this.votingKey = votingKey;
        this.startEpoch = startEpoch;
        this.endEpoch = endEpoch;
    }

    public static PinnedVotingKeyBuilder create(VotingKeyDto votingKey, FinalizationEpochDto startEpoch, FinalizationEpochDto endEpoch) {
        return new PinnedVotingKeyBuilder(votingKey, startEpoch, endEpoch);
    }

    public VotingKeyDto getVotingKey() {
        return this.votingKey;
    }

    public FinalizationEpochDto getStartEpoch() {
        return this.startEpoch;
    }

    public FinalizationEpochDto getEndEpoch() {
        return this.endEpoch;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.votingKey.getSize();
        size += this.startEpoch.getSize();
        return size += this.endEpoch.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.votingKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.startEpoch);
            GeneratorUtils.writeEntity(dataOutputStream, this.endEpoch);
        });
    }
}

