/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum MosaicSupplyChangeActionDto implements Serializer
{
    DECREASE(0),
    INCREASE(1);

    private final byte value;

    private MosaicSupplyChangeActionDto(byte value) {
        this.value = value;
    }

    public static MosaicSupplyChangeActionDto rawValueOf(byte value) {
        for (MosaicSupplyChangeActionDto current : MosaicSupplyChangeActionDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for MosaicSupplyChangeActionDto.");
    }

    @Override
    public int getSize() {
        return 1;
    }

    public byte getValue() {
        return this.value;
    }

    public static MosaicSupplyChangeActionDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return MosaicSupplyChangeActionDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

