/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicFlagsDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.EnumSet;

public class MosaicPropertiesBuilder
implements Serializer {
    private final EnumSet<MosaicFlagsDto> flags;
    private final byte divisibility;
    private final BlockDurationDto duration;

    protected MosaicPropertiesBuilder(DataInputStream stream) {
        try {
            this.flags = GeneratorUtils.toSet(MosaicFlagsDto.class, stream.readByte());
            this.divisibility = stream.readByte();
            this.duration = BlockDurationDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicPropertiesBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicPropertiesBuilder(stream);
    }

    protected MosaicPropertiesBuilder(EnumSet<MosaicFlagsDto> flags, byte divisibility, BlockDurationDto duration) {
        GeneratorUtils.notNull(flags, "flags is null", new Object[0]);
        GeneratorUtils.notNull(divisibility, "divisibility is null", new Object[0]);
        GeneratorUtils.notNull(duration, "duration is null", new Object[0]);
        this.flags = flags;
        this.divisibility = divisibility;
        this.duration = duration;
    }

    public static MosaicPropertiesBuilder create(EnumSet<MosaicFlagsDto> flags, byte divisibility, BlockDurationDto duration) {
        return new MosaicPropertiesBuilder(flags, divisibility, duration);
    }

    public EnumSet<MosaicFlagsDto> getFlags() {
        return this.flags;
    }

    public byte getDivisibility() {
        return this.divisibility;
    }

    public BlockDurationDto getDuration() {
        return this.duration;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += MosaicFlagsDto.values()[0].getSize();
        ++size;
        return size += this.duration.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte((byte)GeneratorUtils.toLong(MosaicFlagsDto.class, this.flags));
            dataOutputStream.writeByte(this.getDivisibility());
            GeneratorUtils.writeEntity(dataOutputStream, this.duration);
        });
    }
}

