/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicRestrictionTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;

public class MosaicGlobalRestrictionTransactionBodyBuilder
implements Serializer {
    private final UnresolvedMosaicIdDto mosaicId;
    private final UnresolvedMosaicIdDto referenceMosaicId;
    private final long restrictionKey;
    private final long previousRestrictionValue;
    private final long newRestrictionValue;
    private final MosaicRestrictionTypeDto previousRestrictionType;
    private final MosaicRestrictionTypeDto newRestrictionType;

    protected MosaicGlobalRestrictionTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.mosaicId = UnresolvedMosaicIdDto.loadFromBinary(stream);
            this.referenceMosaicId = UnresolvedMosaicIdDto.loadFromBinary(stream);
            this.restrictionKey = Long.reverseBytes(stream.readLong());
            this.previousRestrictionValue = Long.reverseBytes(stream.readLong());
            this.newRestrictionValue = Long.reverseBytes(stream.readLong());
            this.previousRestrictionType = MosaicRestrictionTypeDto.loadFromBinary(stream);
            this.newRestrictionType = MosaicRestrictionTypeDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicGlobalRestrictionTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicGlobalRestrictionTransactionBodyBuilder(stream);
    }

    protected MosaicGlobalRestrictionTransactionBodyBuilder(UnresolvedMosaicIdDto mosaicId, UnresolvedMosaicIdDto referenceMosaicId, long restrictionKey, long previousRestrictionValue, long newRestrictionValue, MosaicRestrictionTypeDto previousRestrictionType, MosaicRestrictionTypeDto newRestrictionType) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(referenceMosaicId, "referenceMosaicId is null", new Object[0]);
        GeneratorUtils.notNull(restrictionKey, "restrictionKey is null", new Object[0]);
        GeneratorUtils.notNull(previousRestrictionValue, "previousRestrictionValue is null", new Object[0]);
        GeneratorUtils.notNull(newRestrictionValue, "newRestrictionValue is null", new Object[0]);
        GeneratorUtils.notNull(previousRestrictionType, "previousRestrictionType is null", new Object[0]);
        GeneratorUtils.notNull(newRestrictionType, "newRestrictionType is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.referenceMosaicId = referenceMosaicId;
        this.restrictionKey = restrictionKey;
        this.previousRestrictionValue = previousRestrictionValue;
        this.newRestrictionValue = newRestrictionValue;
        this.previousRestrictionType = previousRestrictionType;
        this.newRestrictionType = newRestrictionType;
    }

    public static MosaicGlobalRestrictionTransactionBodyBuilder create(UnresolvedMosaicIdDto mosaicId, UnresolvedMosaicIdDto referenceMosaicId, long restrictionKey, long previousRestrictionValue, long newRestrictionValue, MosaicRestrictionTypeDto previousRestrictionType, MosaicRestrictionTypeDto newRestrictionType) {
        return new MosaicGlobalRestrictionTransactionBodyBuilder(mosaicId, referenceMosaicId, restrictionKey, previousRestrictionValue, newRestrictionValue, previousRestrictionType, newRestrictionType);
    }

    public UnresolvedMosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public UnresolvedMosaicIdDto getReferenceMosaicId() {
        return this.referenceMosaicId;
    }

    public long getRestrictionKey() {
        return this.restrictionKey;
    }

    public long getPreviousRestrictionValue() {
        return this.previousRestrictionValue;
    }

    public long getNewRestrictionValue() {
        return this.newRestrictionValue;
    }

    public MosaicRestrictionTypeDto getPreviousRestrictionType() {
        return this.previousRestrictionType;
    }

    public MosaicRestrictionTypeDto getNewRestrictionType() {
        return this.newRestrictionType;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        size += this.referenceMosaicId.getSize();
        size += 8;
        size += 8;
        size += 8;
        size += this.previousRestrictionType.getSize();
        return size += this.newRestrictionType.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaicId);
            GeneratorUtils.writeEntity(dataOutputStream, this.referenceMosaicId);
            dataOutputStream.writeLong(Long.reverseBytes(this.getRestrictionKey()));
            dataOutputStream.writeLong(Long.reverseBytes(this.getPreviousRestrictionValue()));
            dataOutputStream.writeLong(Long.reverseBytes(this.getNewRestrictionValue()));
            GeneratorUtils.writeEntity(dataOutputStream, this.previousRestrictionType);
            GeneratorUtils.writeEntity(dataOutputStream, this.newRestrictionType);
        });
    }
}

