/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicExpiryReceiptBuilder
extends ReceiptBuilder
implements Serializer {
    private final MosaicIdDto artifactId;

    protected MosaicExpiryReceiptBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.artifactId = MosaicIdDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicExpiryReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicExpiryReceiptBuilder(stream);
    }

    protected MosaicExpiryReceiptBuilder(short version, ReceiptTypeDto type, MosaicIdDto artifactId) {
        super(version, type);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(artifactId, "artifactId is null", new Object[0]);
        this.artifactId = artifactId;
    }

    public static MosaicExpiryReceiptBuilder create(short version, ReceiptTypeDto type, MosaicIdDto artifactId) {
        return new MosaicExpiryReceiptBuilder(version, type, artifactId);
    }

    public MosaicIdDto getArtifactId() {
        return this.artifactId;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.artifactId.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.artifactId);
        });
    }
}

