/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class InflationReceiptBuilder
extends ReceiptBuilder
implements Serializer {
    private final MosaicBuilder mosaic;

    protected InflationReceiptBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.mosaic = MosaicBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static InflationReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new InflationReceiptBuilder(stream);
    }

    protected InflationReceiptBuilder(short version, ReceiptTypeDto type, MosaicBuilder mosaic) {
        super(version, type);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        this.mosaic = mosaic;
    }

    public static InflationReceiptBuilder create(short version, ReceiptTypeDto type, MosaicBuilder mosaic) {
        return new InflationReceiptBuilder(version, type, mosaic);
    }

    public MosaicBuilder getMosaic() {
        return this.mosaic;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.mosaic.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaic);
        });
    }
}

