/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class Hash256Dto
implements Serializer {
    private final ByteBuffer hash256;

    public Hash256Dto(ByteBuffer hash256) {
        this.hash256 = hash256;
    }

    public Hash256Dto(DataInputStream stream) {
        try {
            this.hash256 = GeneratorUtils.readByteBuffer(stream, 32);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getHash256() {
        return this.hash256;
    }

    @Override
    public int getSize() {
        return 32;
    }

    public static Hash256Dto loadFromBinary(DataInputStream stream) {
        return new Hash256Dto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.hash256.array(), 0, this.hash256.array().length));
    }
}

