/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BitMaskable;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public final class GeneratorUtils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private GeneratorUtils() {
    }

    public static <T> void notNull(T object, String message, Object ... values) {
        if (object == null) {
            throw new NullPointerException(String.format(message, values));
        }
    }

    public static void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static void isFalse(boolean expression, String message, Object ... values) {
        GeneratorUtils.isTrue(!expression, message, values);
    }

    public static int toUnsignedInt(byte value) {
        return Byte.toUnsignedInt(value);
    }

    public static int toUnsignedInt(short value) {
        return Short.toUnsignedInt(value);
    }

    public static <T extends Enum<T>> long toLong(Class<T> enumClass, Set<T> enumSet) {
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        GeneratorUtils.isFalse(enumValues.length > 64, "The number of enum constants is greater than 64", new Object[0]);
        long result = 0L;
        for (Enum value : enumValues) {
            if (!enumSet.contains(value)) continue;
            result += ((BitMaskable)((Object)value)).getValueAsLong();
        }
        return result;
    }

    public static <T extends Enum<T>> EnumSet<T> toSet(Class<T> enumClass, long bitMaskValue) {
        EnumSet<T> results = EnumSet.noneOf(enumClass);
        for (Enum constant : (Enum[])enumClass.getEnumConstants()) {
            if (0L == (((BitMaskable)((Object)constant)).getValueAsLong() & bitMaskValue)) continue;
            results.add(constant);
        }
        return results;
    }

    public static <E extends RuntimeException> RuntimeException getExceptionToPropagate(Exception exception, Function<Exception, E> wrap) {
        if (exception instanceof ExecutionException && RuntimeException.class.isAssignableFrom(exception.getCause().getClass())) {
            return (RuntimeException)exception.getCause();
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new IllegalStateException(exception);
        }
        return (RuntimeException)wrap.apply(exception);
    }

    public static <E extends RuntimeException> RuntimeException getExceptionToPropagate(Exception exception) {
        return GeneratorUtils.getExceptionToPropagate(exception, RuntimeException::new);
    }

    public static <T, E extends RuntimeException> T propagate(Callable<T> callable, Function<Exception, E> wrap) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e, wrap);
        }
    }

    public static <T> T propagate(Callable<T> callable) {
        return GeneratorUtils.propagate(callable, RuntimeException::new);
    }

    public static byte[] serialize(ThrowingConsumer<DataOutputStream, Exception> consumer) {
        return GeneratorUtils.propagate(() -> {
            try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayStream);){
                    consumer.accept(dataOutputStream);
                    byArray = byteArrayStream.toByteArray();
                }
                return byArray;
            }
        });
    }

    public static void skipPadding(int size, DataInputStream dataInputStream) {
        GeneratorUtils.propagate(() -> {
            int padding = GeneratorUtils.getPadding(size);
            dataInputStream.skipBytes(padding);
            return null;
        });
    }

    public static void addPadding(int size, DataOutputStream dataOutputStream) {
        GeneratorUtils.propagate(() -> {
            for (int padding = GeneratorUtils.getPadding(size); padding > 0; --padding) {
                dataOutputStream.write(0);
            }
            return null;
        });
    }

    public static int getPadding(int size) {
        int alignment = 8;
        return 0 == size % alignment ? 0 : alignment - size % alignment;
    }

    public static <T> List<T> loadFromBinaryArray(Function<DataInputStream, T> builder, DataInputStream stream, long count) {
        ArrayList<T> list = new ArrayList<T>();
        int i = 0;
        while ((long)i < count) {
            list.add(builder.apply(stream));
            ++i;
        }
        return list;
    }

    public static <T extends Serializer> List<T> loadFromBinaryArrayRemaining(Function<DataInputStream, T> builder, DataInputStream stream, int payloadSize) throws IOException {
        ByteBuffer byteCount = ByteBuffer.allocate(payloadSize);
        stream.read(byteCount.array());
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byteCount.array()));
        ArrayList<Serializer> entities = new ArrayList<Serializer>();
        while (dataInputStream.available() > 0) {
            Serializer entity = (Serializer)builder.apply(dataInputStream);
            entities.add(entity);
            GeneratorUtils.skipPadding(entity.getSize(), dataInputStream);
        }
        return entities;
    }

    public static void writeList(DataOutputStream dataOutputStream, List<? extends Serializer> entities) throws IOException {
        for (Serializer serializer : entities) {
            byte[] entityBytes = serializer.serialize();
            dataOutputStream.write(entityBytes, 0, entityBytes.length);
        }
    }

    public static void writeEntity(DataOutputStream dataOutputStream, Serializer entity) throws IOException {
        byte[] entityBytes = entity.serialize();
        dataOutputStream.write(entityBytes, 0, entityBytes.length);
    }

    public static ByteBuffer readByteBuffer(DataInputStream stream, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        stream.readFully(buffer.array());
        return buffer;
    }

    public static int getSize(ByteBuffer buffer) {
        return buffer.array().length;
    }

    public static int getSize(Collection<?> collection) {
        return collection.size();
    }

    public static String toHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializer> T writeBuilderToFile(T builder, String file) {
        try (FileWriter writer = new FileWriter(new File(file), true);){
            String payload = GeneratorUtils.toHex(builder.serialize());
            String builderName = builder.getClass().getSimpleName();
            writer.write("- builder: " + builderName + "\n");
            writer.write("  payload: " + payload + "\n");
            T t = builder;
            return t;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

