/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MultisigAccountModificationTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import java.io.DataInputStream;
import java.util.List;

public class EmbeddedMultisigAccountModificationTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final MultisigAccountModificationTransactionBodyBuilder multisigAccountModificationTransactionBody;

    protected EmbeddedMultisigAccountModificationTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.multisigAccountModificationTransactionBody = MultisigAccountModificationTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedMultisigAccountModificationTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedMultisigAccountModificationTransactionBuilder(stream);
    }

    protected EmbeddedMultisigAccountModificationTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, byte minRemovalDelta, byte minApprovalDelta, List<UnresolvedAddressDto> addressAdditions, List<UnresolvedAddressDto> addressDeletions) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(minRemovalDelta, "minRemovalDelta is null", new Object[0]);
        GeneratorUtils.notNull(minApprovalDelta, "minApprovalDelta is null", new Object[0]);
        GeneratorUtils.notNull(addressAdditions, "addressAdditions is null", new Object[0]);
        GeneratorUtils.notNull(addressDeletions, "addressDeletions is null", new Object[0]);
        this.multisigAccountModificationTransactionBody = new MultisigAccountModificationTransactionBodyBuilder(minRemovalDelta, minApprovalDelta, addressAdditions, addressDeletions);
    }

    public static EmbeddedMultisigAccountModificationTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, byte minRemovalDelta, byte minApprovalDelta, List<UnresolvedAddressDto> addressAdditions, List<UnresolvedAddressDto> addressDeletions) {
        return new EmbeddedMultisigAccountModificationTransactionBuilder(signerPublicKey, version, network, type, minRemovalDelta, minApprovalDelta, addressAdditions, addressDeletions);
    }

    public byte getMinRemovalDelta() {
        return this.multisigAccountModificationTransactionBody.getMinRemovalDelta();
    }

    public byte getMinApprovalDelta() {
        return this.multisigAccountModificationTransactionBody.getMinApprovalDelta();
    }

    public List<UnresolvedAddressDto> getAddressAdditions() {
        return this.multisigAccountModificationTransactionBody.getAddressAdditions();
    }

    public List<UnresolvedAddressDto> getAddressDeletions() {
        return this.multisigAccountModificationTransactionBody.getAddressDeletions();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.multisigAccountModificationTransactionBody.getSize();
    }

    @Override
    public MultisigAccountModificationTransactionBodyBuilder getBody() {
        return this.multisigAccountModificationTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.multisigAccountModificationTransactionBody);
        });
    }
}

