/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.CosignatureBuilder;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilderHelper;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class AggregateTransactionBodyBuilder
implements Serializer {
    private final Hash256Dto transactionsHash;
    private final int aggregateTransactionHeader_Reserved1;
    private final List<EmbeddedTransactionBuilder> transactions;
    private final List<CosignatureBuilder> cosignatures;

    protected AggregateTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.transactionsHash = Hash256Dto.loadFromBinary(stream);
            int payloadSize = Integer.reverseBytes(stream.readInt());
            this.aggregateTransactionHeader_Reserved1 = Integer.reverseBytes(stream.readInt());
            ByteBuffer transactionBytes = ByteBuffer.allocate(payloadSize);
            stream.read(transactionBytes.array());
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(transactionBytes.array()));
            this.transactions = new ArrayList<EmbeddedTransactionBuilder>();
            while (dataInputStream.available() > 0) {
                EmbeddedTransactionBuilder embeddedTransactionBuilder = EmbeddedTransactionBuilderHelper.loadFromBinary(dataInputStream);
                this.transactions.add(embeddedTransactionBuilder);
                GeneratorUtils.skipPadding(embeddedTransactionBuilder.getSize(), dataInputStream);
            }
            this.cosignatures = new ArrayList<CosignatureBuilder>();
            while (stream.available() > 0) {
                this.cosignatures.add(CosignatureBuilder.loadFromBinary(stream));
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected AggregateTransactionBodyBuilder(Hash256Dto transactionsHash, List<EmbeddedTransactionBuilder> transactions, List<CosignatureBuilder> cosignatures) {
        GeneratorUtils.notNull(transactionsHash, "transactionsHash is null", new Object[0]);
        GeneratorUtils.notNull(transactions, "transactions is null", new Object[0]);
        GeneratorUtils.notNull(cosignatures, "cosignatures is null", new Object[0]);
        this.transactionsHash = transactionsHash;
        this.aggregateTransactionHeader_Reserved1 = 0;
        this.transactions = transactions;
        this.cosignatures = cosignatures;
    }

    public static AggregateTransactionBodyBuilder create(Hash256Dto transactionsHash, List<EmbeddedTransactionBuilder> transactions, List<CosignatureBuilder> cosignatures) {
        return new AggregateTransactionBodyBuilder(transactionsHash, transactions, cosignatures);
    }

    public Hash256Dto getTransactionsHash() {
        return this.transactionsHash;
    }

    private int getAggregateTransactionHeader_Reserved1() {
        return this.aggregateTransactionHeader_Reserved1;
    }

    public List<EmbeddedTransactionBuilder> getTransactions() {
        return this.transactions;
    }

    public List<CosignatureBuilder> getCosignatures() {
        return this.cosignatures;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.transactionsHash.getSize();
        size += 4;
        size += 4;
        size += this.transactions.stream().mapToInt(o -> o.getSize() + GeneratorUtils.getPadding(o.getSize())).sum();
        return size += this.cosignatures.stream().mapToInt(o -> o.getSize()).sum();
    }

    public static AggregateTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AggregateTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            int i;
            byte[] transactionsHashBytes = this.transactionsHash.serialize();
            dataOutputStream.write(transactionsHashBytes, 0, transactionsHashBytes.length);
            int transactionsSize = this.transactions.stream().mapToInt(o -> o.getSize() + GeneratorUtils.getPadding(o.getSize())).sum();
            dataOutputStream.writeInt(Integer.reverseBytes(transactionsSize));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getAggregateTransactionHeader_Reserved1()));
            for (i = 0; i < this.transactions.size(); ++i) {
                byte[] transactionsBytes = this.transactions.get(i).serialize();
                dataOutputStream.write(transactionsBytes, 0, transactionsBytes.length);
                GeneratorUtils.addPadding(transactionsBytes.length, dataOutputStream);
            }
            for (i = 0; i < this.cosignatures.size(); ++i) {
                byte[] cosignaturesBytes = this.cosignatures.get(i).serialize();
                dataOutputStream.write(cosignaturesBytes, 0, cosignaturesBytes.length);
            }
        });
    }
}

