/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.ReceiptSourceBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class AddressResolutionEntryBuilder
implements Serializer {
    private final ReceiptSourceBuilder source;
    private final AddressDto resolved;

    protected AddressResolutionEntryBuilder(DataInputStream stream) {
        try {
            this.source = ReceiptSourceBuilder.loadFromBinary(stream);
            this.resolved = AddressDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AddressResolutionEntryBuilder loadFromBinary(DataInputStream stream) {
        return new AddressResolutionEntryBuilder(stream);
    }

    protected AddressResolutionEntryBuilder(ReceiptSourceBuilder source, AddressDto resolved) {
        GeneratorUtils.notNull(source, "source is null", new Object[0]);
        GeneratorUtils.notNull(resolved, "resolved is null", new Object[0]);
        this.source = source;
        this.resolved = resolved;
    }

    public static AddressResolutionEntryBuilder create(ReceiptSourceBuilder source, AddressDto resolved) {
        return new AddressResolutionEntryBuilder(source, resolved);
    }

    public ReceiptSourceBuilder getSource() {
        return this.source;
    }

    public AddressDto getResolved() {
        return this.resolved;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.source.getSize();
        return size += this.resolved.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.source);
            GeneratorUtils.writeEntity(dataOutputStream, this.resolved);
        });
    }
}

