/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountKeyTypeFlagsDto;
import io.nem.symbol.catapult.builders.AccountStateFormatDto;
import io.nem.symbol.catapult.builders.AccountTypeDto;
import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.HeightActivityBucketsBuilder;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.ImportanceSnapshotBuilder;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.PinnedVotingKeyBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.StateHeaderBuilder;
import java.io.DataInputStream;
import java.util.EnumSet;
import java.util.List;

public class AccountStateBuilder
extends StateHeaderBuilder
implements Serializer {
    private final AddressDto address;
    private final HeightDto addressHeight;
    private final KeyDto publicKey;
    private final HeightDto publicKeyHeight;
    private final AccountTypeDto accountType;
    private final AccountStateFormatDto format;
    private final EnumSet<AccountKeyTypeFlagsDto> supplementalPublicKeysMask;
    private KeyDto linkedPublicKey;
    private KeyDto nodePublicKey;
    private KeyDto vrfPublicKey;
    private final List<PinnedVotingKeyBuilder> votingPublicKeys;
    private ImportanceSnapshotBuilder importanceSnapshots;
    private HeightActivityBucketsBuilder activityBuckets;
    private final List<MosaicBuilder> balances;

    protected AccountStateBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.address = AddressDto.loadFromBinary(stream);
            this.addressHeight = HeightDto.loadFromBinary(stream);
            this.publicKey = KeyDto.loadFromBinary(stream);
            this.publicKeyHeight = HeightDto.loadFromBinary(stream);
            this.accountType = AccountTypeDto.loadFromBinary(stream);
            this.format = AccountStateFormatDto.loadFromBinary(stream);
            this.supplementalPublicKeysMask = GeneratorUtils.toSet(AccountKeyTypeFlagsDto.class, stream.readByte());
            byte votingPublicKeysCount = stream.readByte();
            if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.LINKED)) {
                this.linkedPublicKey = KeyDto.loadFromBinary(stream);
            }
            if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.NODE)) {
                this.nodePublicKey = KeyDto.loadFromBinary(stream);
            }
            if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.VRF)) {
                this.vrfPublicKey = KeyDto.loadFromBinary(stream);
            }
            this.votingPublicKeys = GeneratorUtils.loadFromBinaryArray(PinnedVotingKeyBuilder::loadFromBinary, stream, votingPublicKeysCount);
            if (this.format == AccountStateFormatDto.HIGH_VALUE) {
                this.importanceSnapshots = ImportanceSnapshotBuilder.loadFromBinary(stream);
            }
            if (this.format == AccountStateFormatDto.HIGH_VALUE) {
                this.activityBuckets = HeightActivityBucketsBuilder.loadFromBinary(stream);
            }
            short balancesCount = Short.reverseBytes(stream.readShort());
            this.balances = GeneratorUtils.loadFromBinaryArray(MosaicBuilder::loadFromBinary, stream, balancesCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountStateBuilder loadFromBinary(DataInputStream stream) {
        return new AccountStateBuilder(stream);
    }

    protected AccountStateBuilder(short version, AddressDto address, HeightDto addressHeight, KeyDto publicKey, HeightDto publicKeyHeight, AccountTypeDto accountType, AccountStateFormatDto format, EnumSet<AccountKeyTypeFlagsDto> supplementalPublicKeysMask, KeyDto linkedPublicKey, KeyDto nodePublicKey, KeyDto vrfPublicKey, List<PinnedVotingKeyBuilder> votingPublicKeys, ImportanceSnapshotBuilder importanceSnapshots, HeightActivityBucketsBuilder activityBuckets, List<MosaicBuilder> balances) {
        super(version);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(address, "address is null", new Object[0]);
        GeneratorUtils.notNull(addressHeight, "addressHeight is null", new Object[0]);
        GeneratorUtils.notNull(publicKey, "publicKey is null", new Object[0]);
        GeneratorUtils.notNull(publicKeyHeight, "publicKeyHeight is null", new Object[0]);
        GeneratorUtils.notNull(accountType, "accountType is null", new Object[0]);
        GeneratorUtils.notNull(format, "format is null", new Object[0]);
        GeneratorUtils.notNull(supplementalPublicKeysMask, "supplementalPublicKeysMask is null", new Object[0]);
        if (supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.LINKED)) {
            GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        }
        if (supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.NODE)) {
            GeneratorUtils.notNull(nodePublicKey, "nodePublicKey is null", new Object[0]);
        }
        if (supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.VRF)) {
            GeneratorUtils.notNull(vrfPublicKey, "vrfPublicKey is null", new Object[0]);
        }
        GeneratorUtils.notNull(votingPublicKeys, "votingPublicKeys is null", new Object[0]);
        if (format == AccountStateFormatDto.HIGH_VALUE) {
            GeneratorUtils.notNull(importanceSnapshots, "importanceSnapshots is null", new Object[0]);
        }
        if (format == AccountStateFormatDto.HIGH_VALUE) {
            GeneratorUtils.notNull(activityBuckets, "activityBuckets is null", new Object[0]);
        }
        GeneratorUtils.notNull(balances, "balances is null", new Object[0]);
        this.address = address;
        this.addressHeight = addressHeight;
        this.publicKey = publicKey;
        this.publicKeyHeight = publicKeyHeight;
        this.accountType = accountType;
        this.format = format;
        this.supplementalPublicKeysMask = supplementalPublicKeysMask;
        this.linkedPublicKey = linkedPublicKey;
        this.nodePublicKey = nodePublicKey;
        this.vrfPublicKey = vrfPublicKey;
        this.votingPublicKeys = votingPublicKeys;
        this.importanceSnapshots = importanceSnapshots;
        this.activityBuckets = activityBuckets;
        this.balances = balances;
    }

    public static AccountStateBuilder createHighValue(short version, AddressDto address, HeightDto addressHeight, KeyDto publicKey, HeightDto publicKeyHeight, AccountTypeDto accountType, EnumSet<AccountKeyTypeFlagsDto> supplementalPublicKeysMask, KeyDto linkedPublicKey, KeyDto nodePublicKey, KeyDto vrfPublicKey, List<PinnedVotingKeyBuilder> votingPublicKeys, ImportanceSnapshotBuilder importanceSnapshots, HeightActivityBucketsBuilder activityBuckets, List<MosaicBuilder> balances) {
        AccountStateFormatDto format = AccountStateFormatDto.HIGH_VALUE;
        return new AccountStateBuilder(version, address, addressHeight, publicKey, publicKeyHeight, accountType, format, supplementalPublicKeysMask, linkedPublicKey, nodePublicKey, vrfPublicKey, votingPublicKeys, importanceSnapshots, activityBuckets, balances);
    }

    public static AccountStateBuilder createRegular(short version, AddressDto address, HeightDto addressHeight, KeyDto publicKey, HeightDto publicKeyHeight, AccountTypeDto accountType, EnumSet<AccountKeyTypeFlagsDto> supplementalPublicKeysMask, KeyDto linkedPublicKey, KeyDto nodePublicKey, KeyDto vrfPublicKey, List<PinnedVotingKeyBuilder> votingPublicKeys, List<MosaicBuilder> balances) {
        AccountStateFormatDto format = AccountStateFormatDto.REGULAR;
        return new AccountStateBuilder(version, address, addressHeight, publicKey, publicKeyHeight, accountType, format, supplementalPublicKeysMask, linkedPublicKey, nodePublicKey, vrfPublicKey, votingPublicKeys, null, null, balances);
    }

    public AddressDto getAddress() {
        return this.address;
    }

    public HeightDto getAddressHeight() {
        return this.addressHeight;
    }

    public KeyDto getPublicKey() {
        return this.publicKey;
    }

    public HeightDto getPublicKeyHeight() {
        return this.publicKeyHeight;
    }

    public AccountTypeDto getAccountType() {
        return this.accountType;
    }

    public AccountStateFormatDto getFormat() {
        return this.format;
    }

    public EnumSet<AccountKeyTypeFlagsDto> getSupplementalPublicKeysMask() {
        return this.supplementalPublicKeysMask;
    }

    public KeyDto getLinkedPublicKey() {
        if (!this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.LINKED)) {
            throw new IllegalStateException("supplementalPublicKeysMask is not set to LINKED.");
        }
        return this.linkedPublicKey;
    }

    public KeyDto getNodePublicKey() {
        if (!this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.NODE)) {
            throw new IllegalStateException("supplementalPublicKeysMask is not set to NODE.");
        }
        return this.nodePublicKey;
    }

    public KeyDto getVrfPublicKey() {
        if (!this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.VRF)) {
            throw new IllegalStateException("supplementalPublicKeysMask is not set to VRF.");
        }
        return this.vrfPublicKey;
    }

    public List<PinnedVotingKeyBuilder> getVotingPublicKeys() {
        return this.votingPublicKeys;
    }

    public ImportanceSnapshotBuilder getImportanceSnapshots() {
        if (this.format != AccountStateFormatDto.HIGH_VALUE) {
            throw new IllegalStateException("format is not set to HIGH_VALUE.");
        }
        return this.importanceSnapshots;
    }

    public HeightActivityBucketsBuilder getActivityBuckets() {
        if (this.format != AccountStateFormatDto.HIGH_VALUE) {
            throw new IllegalStateException("format is not set to HIGH_VALUE.");
        }
        return this.activityBuckets;
    }

    public List<MosaicBuilder> getBalances() {
        return this.balances;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.address.getSize();
        size += this.addressHeight.getSize();
        size += this.publicKey.getSize();
        size += this.publicKeyHeight.getSize();
        size += this.accountType.getSize();
        size += this.format.getSize();
        size += AccountKeyTypeFlagsDto.values()[0].getSize();
        ++size;
        if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.LINKED)) {
            size += this.linkedPublicKey.getSize();
        }
        if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.NODE)) {
            size += this.nodePublicKey.getSize();
        }
        if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.VRF)) {
            size += this.vrfPublicKey.getSize();
        }
        size += this.votingPublicKeys.stream().mapToInt(o -> o.getSize()).sum();
        if (this.format == AccountStateFormatDto.HIGH_VALUE) {
            size += this.importanceSnapshots.getSize();
        }
        if (this.format == AccountStateFormatDto.HIGH_VALUE) {
            size += this.activityBuckets.getSize();
        }
        size += 2;
        return size += this.balances.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.address);
            GeneratorUtils.writeEntity(dataOutputStream, this.addressHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.publicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.publicKeyHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.accountType);
            GeneratorUtils.writeEntity(dataOutputStream, this.format);
            dataOutputStream.writeByte((byte)GeneratorUtils.toLong(AccountKeyTypeFlagsDto.class, this.supplementalPublicKeysMask));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getVotingPublicKeys()));
            if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.LINKED)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.linkedPublicKey);
            }
            if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.NODE)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.nodePublicKey);
            }
            if (this.supplementalPublicKeysMask.contains(AccountKeyTypeFlagsDto.VRF)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.vrfPublicKey);
            }
            GeneratorUtils.writeList(dataOutputStream, this.votingPublicKeys);
            if (this.format == AccountStateFormatDto.HIGH_VALUE) {
                GeneratorUtils.writeEntity(dataOutputStream, this.importanceSnapshots);
            }
            if (this.format == AccountStateFormatDto.HIGH_VALUE) {
                GeneratorUtils.writeEntity(dataOutputStream, this.activityBuckets);
            }
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.getSize(this.getBalances())));
            GeneratorUtils.writeList(dataOutputStream, this.balances);
        });
    }
}

