/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class AccountRestrictionTransactionTypeValueBuilder
implements Serializer {
    private final List<EntityTypeDto> restrictionValues;

    protected AccountRestrictionTransactionTypeValueBuilder(DataInputStream stream) {
        try {
            long restrictionValuesCount = Long.reverseBytes(stream.readLong());
            this.restrictionValues = GeneratorUtils.loadFromBinaryArray(EntityTypeDto::loadFromBinary, stream, restrictionValuesCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountRestrictionTransactionTypeValueBuilder loadFromBinary(DataInputStream stream) {
        return new AccountRestrictionTransactionTypeValueBuilder(stream);
    }

    protected AccountRestrictionTransactionTypeValueBuilder(List<EntityTypeDto> restrictionValues) {
        GeneratorUtils.notNull(restrictionValues, "restrictionValues is null", new Object[0]);
        this.restrictionValues = restrictionValues;
    }

    public static AccountRestrictionTransactionTypeValueBuilder create(List<EntityTypeDto> restrictionValues) {
        return new AccountRestrictionTransactionTypeValueBuilder(restrictionValues);
    }

    public List<EntityTypeDto> getRestrictionValues() {
        return this.restrictionValues;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 8;
        return size += this.restrictionValues.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getRestrictionValues())));
            GeneratorUtils.writeList(dataOutputStream, this.restrictionValues);
        });
    }
}

