/*
 * Decompiled with CFR 0.152.
 */
package io.mikael.urlbuilder.util;

import io.mikael.urlbuilder.util.Rfc3986Util;
import io.mikael.urlbuilder.util.UrlParameterMultimap;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class Encoder {
    protected static final boolean IS_PATH = true;
    protected static final boolean IS_NOT_PATH = false;
    protected static final boolean IS_FRAGMENT = true;
    protected static final boolean IS_NOT_FRAGMENT = false;
    protected static final boolean IS_USERINFO = true;
    protected static final boolean IS_NOT_USERINFO = false;
    protected final Charset outputEncoding;

    public Encoder(Charset outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String encodeUserInfo(String input) {
        if (null == input || input.isEmpty()) {
            return "";
        }
        return this.urlEncode(input, false, false, true);
    }

    public String encodePath(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(input, "/", true);
        while (st.hasMoreElements()) {
            String element = st.nextToken();
            if ("/".equals(element)) {
                sb.append(element);
                continue;
            }
            if (element.isEmpty()) continue;
            sb.append(this.urlEncode(element, true, false, false));
        }
        return sb.toString();
    }

    public String encodeQueryParameters(UrlParameterMultimap queryParametersMultimap) {
        if (queryParametersMultimap == null) {
            throw new IllegalArgumentException("queryParametersMultimap is required to not be null.");
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : queryParametersMultimap.flatEntryList()) {
            sb.append(this.encodeQueryElement(e.getKey()));
            if (e.getValue() != null) {
                sb.append('=');
                sb.append(this.encodeQueryElement(e.getValue()));
            }
            sb.append('&');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    protected String encodeQueryElement(String input) {
        return this.urlEncode(input, false, false, false);
    }

    public String encodeFragment(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return this.urlEncode(input, false, true, false);
    }

    protected String urlEncode(String input, boolean isPath, boolean isFragment, boolean isUserInfo) {
        StringBuilder sb = new StringBuilder();
        char[] inputChars = input.toCharArray();
        for (int i = 0; i < Character.codePointCount(inputChars, 0, inputChars.length); ++i) {
            CharBuffer cb;
            int codePoint = Character.codePointAt(inputChars, i);
            if (Character.isBmpCodePoint(codePoint)) {
                char c = Character.toChars(codePoint)[0];
                if (isPath && Rfc3986Util.isPChar(c) && c != '+' || isFragment && Rfc3986Util.isFragmentSafe(c) || isUserInfo && c == ':' || Rfc3986Util.isUnreserved(c)) {
                    sb.append(c);
                    continue;
                }
                cb = CharBuffer.allocate(1);
                cb.append(c);
            } else {
                cb = CharBuffer.allocate(2);
                cb.append(Character.highSurrogate(codePoint));
                cb.append(Character.lowSurrogate(codePoint));
            }
            cb.rewind();
            ByteBuffer bb = this.outputEncoding.encode(cb);
            for (int j = 0; j < bb.limit(); ++j) {
                sb.append('%');
                sb.append(String.format(Locale.US, "%1$02X", bb.get(j)));
            }
        }
        return sb.toString();
    }
}

