/*
 * Decompiled with CFR 0.152.
 */
package io.mikael.urlbuilder.util;

import io.mikael.urlbuilder.util.UrlParameterMultimap;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Decoder {
    protected static final boolean DECODE_PLUS_AS_SPACE = true;
    protected static final boolean DO_NOT_DECODE_PLUS_AS_SPACE = false;
    protected final Charset inputEncoding;

    public Decoder(Charset inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public String decodeUserInfo(String userInfo) {
        if (null == userInfo || userInfo.isEmpty()) {
            return userInfo;
        }
        return this.urlDecode(userInfo, true);
    }

    public String decodeFragment(String fragment) {
        if (fragment == null || fragment.isEmpty()) {
            return fragment;
        }
        return this.urlDecode(fragment, false);
    }

    public UrlParameterMultimap parseQueryString(String query) {
        UrlParameterMultimap ret = UrlParameterMultimap.newMultimap();
        if (query == null || query.isEmpty()) {
            return ret;
        }
        for (String part : query.split("&")) {
            String[] kvp = part.split("=", 2);
            String key = this.urlDecode(kvp[0], true);
            String value = kvp.length == 2 ? this.urlDecode(kvp[1], true) : null;
            ret.add(key, value);
        }
        return ret;
    }

    protected byte[] nextDecodeableSequence(String input, int position) {
        int len = input.length();
        byte[] data = new byte[len];
        int j = 0;
        for (int i = position; i < len; ++i) {
            char c0 = input.charAt(i);
            if (c0 != '%' || len < i + 3) {
                return Arrays.copyOfRange(data, 0, j);
            }
            data[j++] = (byte)Integer.parseInt(input.substring(i + 1, i + 3), 16);
            i += 2;
        }
        return Arrays.copyOfRange(data, 0, j);
    }

    public String decodePath(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean RETURN_DELIMETERS = true;
        StringTokenizer st = new StringTokenizer(input, "/", true);
        while (st.hasMoreElements()) {
            String element = st.nextToken();
            if ("/".equals(element)) {
                sb.append(element);
                continue;
            }
            if (element.isEmpty()) continue;
            sb.append(this.urlDecode(element, false));
        }
        return sb.toString();
    }

    protected String urlDecode(String input, boolean decodePlusAsSpace) {
        StringBuilder sb = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char c0 = input.charAt(i);
            if (c0 == '+' && decodePlusAsSpace) {
                sb.append(' ');
                continue;
            }
            if (c0 != '%') {
                sb.append(c0);
                continue;
            }
            if (len < i + 3) {
                int endIndex = Math.min(input.length(), i + 2);
                sb.append(input.substring(i, endIndex));
                i += 3;
                continue;
            }
            byte[] bytes = this.nextDecodeableSequence(input, i);
            sb.append(this.inputEncoding.decode(ByteBuffer.wrap(bytes)));
            i += bytes.length * 3 - 1;
        }
        return sb.toString();
    }
}

