/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.websocket.client;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.WebSocketClientSettings;
import io.horizen.websocket.client.DisconnectionCode$;
import io.horizen.websocket.client.WebSocketReconnectionHandler;
import scala.Enumeration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001I4AAC\u0006\u0001)!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u00041\u0001\u0001\u0007I\u0011A\u0019\t\u000fU\u0002\u0001\u0019!C\u0001m!1A\b\u0001Q!\nIBQ!\u0010\u0001\u0005ByBQ\u0001\u0015\u0001\u0005BECQA\u001a\u0001\u0005B\u001dDQ\u0001\u001d\u0001\u0005BE\u00141\u0005R3gCVdGoV3c'>\u001c7.\u001a;SK\u000e|gN\\3di&|g\u000eS1oI2,'O\u0003\u0002\r\u001b\u000511\r\\5f]RT!AD\b\u0002\u0013],'m]8dW\u0016$(B\u0001\t\u0012\u0003\u001dAwN]5{K:T\u0011AE\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001+my\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001d;5\t1\"\u0003\u0002\u001f\u0017\tar+\u001a2T_\u000e\\W\r\u001e*fG>tg.Z2uS>t\u0007*\u00198eY\u0016\u0014\bC\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011)H/\u001b7\u000b\u0003\u0011\naa\u001d9be.T\u0018B\u0001\u0014\"\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u0006!1m\u001c8g!\tI#&D\u0001\u0010\u0013\tYsBA\fXK\n\u001cvnY6fi\u000ec\u0017.\u001a8u'\u0016$H/\u001b8hg\u00061A(\u001b8jiz\"\"AL\u0018\u0011\u0005q\u0001\u0001\"B\u0014\u0003\u0001\u0004A\u0013aF8o\u0007>tg.Z2u\r\u0006LG.\u001e:f\u0007>,h\u000e^3s+\u0005\u0011\u0004C\u0001\f4\u0013\t!tCA\u0002J]R\f1d\u001c8D_:tWm\u0019;GC&dWO]3D_VtG/\u001a:`I\u0015\fHCA\u001c;!\t1\u0002(\u0003\u0002:/\t!QK\\5u\u0011\u001dYD!!AA\u0002I\n1\u0001\u001f\u00132\u0003aygnQ8o]\u0016\u001cGOR1jYV\u0014XmQ8v]R,'\u000fI\u0001\u0013_:\u001cuN\u001c8fGRLwN\u001c$bS2,G\r\u0006\u0002@\u0005B\u0011a\u0003Q\u0005\u0003\u0003^\u0011qAQ8pY\u0016\fg\u000eC\u0003D\r\u0001\u0007A)A\u0003dCV\u001cX\r\u0005\u0002F\u001b:\u0011ai\u0013\b\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013N\ta\u0001\u0010:p_Rt\u0014\"\u0001\r\n\u00051;\u0012a\u00029bG.\fw-Z\u0005\u0003\u001d>\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u00051;\u0012aD8o\t&\u001c8m\u001c8oK\u000e$\u0018n\u001c8\u0015\u0007}\u0012F\fC\u0003T\u000f\u0001\u0007A+\u0001\u0003d_\u0012,\u0007CA+Y\u001d\tab+\u0003\u0002X\u0017\u0005\tB)[:d_:tWm\u0019;j_:\u001cu\u000eZ3\n\u0005eS&!\u0002,bYV,\u0017BA.\u0018\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000bu;\u0001\u0019\u00010\u0002\rI,\u0017m]8o!\ty6M\u0004\u0002aCB\u0011qiF\u0005\u0003E^\ta\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!mF\u0001\tO\u0016$H)\u001a7bsV\t\u0001\u000e\u0005\u0002j]6\t!N\u0003\u0002lY\u0006AA-\u001e:bi&|gN\u0003\u0002n/\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005=T'A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0014_:\u001cuN\u001c8fGRLwN\\*vG\u000e,7o\u001d\u000b\u0002o\u0001")
public class DefaultWebSocketReconnectionHandler
implements WebSocketReconnectionHandler,
SparkzLogging {
    private final WebSocketClientSettings conf;
    private int onConnectFailureCounter;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int onConnectFailureCounter() {
        return this.onConnectFailureCounter;
    }

    public void onConnectFailureCounter_$eq(int x$1) {
        this.onConnectFailureCounter = x$1;
    }

    @Override
    public boolean onConnectionFailed(Throwable cause) {
        boolean bl;
        this.onConnectFailureCounter_$eq(this.onConnectFailureCounter() + 1);
        if (this.onConnectFailureCounter() <= this.conf.reconnectionMaxAttempts()) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(new StringBuilder(45).append("onConnectFailure. Reconnecting... (attempt ").append(this.onConnectFailureCounter()).append(") ").append(cause.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onDisconnection(Enumeration.Value code, String reason) {
        BoxedUnit boxedUnit;
        this.onConnectFailureCounter_$eq(this.onConnectFailureCounter() + 1);
        if (this.onConnectFailureCounter() > this.conf.reconnectionMaxAttempts()) return false;
        Enumeration.Value value = code;
        Enumeration.Value value2 = DisconnectionCode$.MODULE$.ON_SUCCESS();
        if (value == null) {
            if (value2 == null) return false;
        } else if (value.equals(value2)) return false;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info(new StringBuilder(40).append("onDisconnect. Reconnecting... (attempt ").append(this.onConnectFailureCounter()).append(")").toString());
            boxedUnit = BoxedUnit.UNIT;
            return true;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return true;
    }

    @Override
    public FiniteDuration getDelay() {
        return this.conf.reconnectionDelay();
    }

    @Override
    public void onConnectionSuccess() {
        this.onConnectFailureCounter_$eq(0);
    }

    public DefaultWebSocketReconnectionHandler(WebSocketClientSettings conf) {
        this.conf = conf;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.onConnectFailureCounter = 0;
    }
}

