/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.storage;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.AbstractFeePaymentsInfo;
import io.horizen.chain.ActiveChain;
import io.horizen.chain.ActiveChain$;
import io.horizen.chain.MainchainBlockReferenceDataInfo;
import io.horizen.chain.MainchainBlockReferenceInfo;
import io.horizen.chain.MainchainHeaderBaseInfo;
import io.horizen.chain.MainchainHeaderInfo;
import io.horizen.chain.MainchainHeaderMetadata;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.chain.SidechainBlockInfoSerializer$;
import io.horizen.params.NetworkParams;
import io.horizen.storage.SidechainBlockInfoProvider;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.transaction.Transaction;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.package$;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.consensus.ModifierSemanticValidity;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\ruca\u0002\u001d:\u0003\u0003\u0001\u0015\u0011\u0007\u0005\tu\u0001\u0011\t\u0011)A\u0005/\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0005\u0003\u0013A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011\u001d\tY\u0003\u0001C\u0001\u0003[A\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u000bB\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u0011\u0005u\u0003\u0001)A\u0005\u0003/Bq!a\u0018\u0001\t\u0013\t\t\u0007C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005\u001d\u0005\u0001\"\u0005\u0002\n\"9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!a+\u0001\t\u0003\ti\u000bC\u0004\u00026\u0002!\t!a.\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002p\u0002!\t!!=\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0011\u001d\u00119\u0002\u0001C\u0001\u00053AqA!\r\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003:\u0001!\tAa\u000f\t\u000f\t5\u0003\u0001\"\u0001\u0003P!9!1\u000b\u0001\u0005\u0002\tU\u0003b\u0002B1\u0001\u0011\u0005!1\r\u0005\b\u0005_\u0002A\u0011\u0001B9\u0011\u001d\u0011i\b\u0001C\u0001\u0005\u007fBqA!$\u0001\t\u0003\u0011y\tC\u0004\u0003\u0012\u0002!\tAa%\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\"9!Q\u001a\u0001\u0005\u0002\t=\u0007b\u0002Bm\u0001\u0011\u0005!1\u001c\u0005\b\u0005K\u0004A\u0011\u0001Bt\u0011\u001d\u0011Y\u000f\u0001C\u0001\u0005[DqA!=\u0001\t\u0003\u0011\u0019\u0010C\u0004\u0003~\u0002!\tAa@\t\u000f\r\r\u0001\u0001\"\u0001\u0004\u0006!91\u0011\u0002\u0001\u0005\u0002\r-\u0001bBB\u000f\u0001\u0011\u00051q\u0004\u0005\b\u0007O\u0001A\u0011AB\u0015\u0011\u001d\u0019y\u0003\u0001C\u0001\u0007cAqa!\u0011\u0001\t\u0003\u0019\u0019\u0005C\u0004\u0004L\u0001!\ta!\u0014\t\u000f\rM\u0003\u0001\"\u0001\u0004V!91q\u000b\u0001\u0005B\re#AF!cgR\u0014\u0018m\u0019;ISN$xN]=Ti>\u0014\u0018mZ3\u000b\u0005iZ\u0014aB:u_J\fw-\u001a\u0006\u0003yu\nq\u0001[8sSj,gNC\u0001?\u0003\tIwn\u0001\u0001\u0016\r\u0005+\u0017QBA\u001a'\u0015\u0001!\t\u0013'P!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fMB\u0011\u0011JS\u0007\u0002s%\u00111*\u000f\u0002\u001b'&$Wm\u00195bS:\u0014En\\2l\u0013:4w\u000e\u0015:pm&$WM\u001d\t\u0003\u00136K!AT\u001d\u0003)MKG-Z2iC&t7\u000b^8sC\u001e,\u0017J\u001c4p!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003vi&d'\"\u0001+\u0002\rM\u0004\u0018M]6{\u0013\t1\u0016KA\u0007Ta\u0006\u00148N\u001f'pO\u001eLgn\u001a\t\u0003\u0013bK!!W\u001d\u0003\u000fM#xN]1hK\u0006y!\r\\8dWN+'/[1mSj,'\u000fE\u0002]C\u000el\u0011!\u0018\u0006\u0003=~\u000bQb]3sS\u0006d\u0017N_1uS>t'B\u00011T\u0003\u0011\u0019wN]3\n\u0005\tl&\u0001E*qCJ\\'pU3sS\u0006d\u0017N_3s!\t!W\r\u0004\u0001\u0005\u000b\u0019\u0004!\u0019A4\u0003\u0005Ak\u0015C\u00015l!\t\u0019\u0015.\u0003\u0002k\t\n9aj\u001c;iS:<\u0007g\u00017t{B!Q\u000e\u001d:}\u001b\u0005q'BA8<\u0003\u0015\u0011Gn\\2l\u0013\t\thN\u0001\nTS\u0012,7\r[1j]\ncwnY6CCN,\u0007C\u00013t\t%!X-!A\u0001\u0002\u000b\u0005QOA\u0002`IE\n\"\u0001\u001b<\u0011\u0005]TX\"\u0001=\u000b\u0005e\\\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:L!a\u001f=\u0003\u0017Q\u0013\u0018M\\:bGRLwN\u001c\t\u0003Iv$\u0011B`3\u0002\u0002\u0003\u0005)\u0011A@\u0003\u0007}##'E\u0002i\u0003\u0003\u00012!\\A\u0002\u0013\r\t)A\u001c\u0002\u0019'&$Wm\u00195bS:\u0014En\\2l\u0011\u0016\fG-\u001a:CCN,\u0017!\u00074fKB\u000b\u00170\\3oiNLeNZ8TKJL\u0017\r\\5{KJ\u0004B\u0001X1\u0002\fA\u0019A-!\u0004\u0005\u000f\u0005=\u0001A1\u0001\u0002\u0012\t\u0019a\tU%\u0012\u0007!\f\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIbO\u0001\u0006G\"\f\u0017N\\\u0005\u0005\u0003;\t9BA\fBEN$(/Y2u\r\u0016,\u0007+Y=nK:$8/\u00138g_\u00061\u0001/\u0019:b[N\u0004B!a\t\u0002(5\u0011\u0011Q\u0005\u0006\u0004\u0003?Y\u0014\u0002BA\u0015\u0003K\u0011QBT3uo>\u00148\u000eU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0006\u00020\u0005e\u00121HA\u001f\u0003\u007f\u0001r!\u0013\u0001d\u0003\u0017\t\t\u0004E\u0002e\u0003g!q!!\u000e\u0001\u0005\u0004\t9DA\u0001T#\rA\u0017q\u0006\u0005\u0006u\u0015\u0001\ra\u0016\u0005\u00065\u0016\u0001\ra\u0017\u0005\b\u0003\u000f)\u0001\u0019AA\u0005\u0011\u001d\ty\"\u0002a\u0001\u0003C\taBY3ti\ncwnY6JI.+\u00170\u0006\u0002\u0002FA!\u0011qIA'\u001b\t\tIEC\u0002\u0002Lm\nQ!\u001e;jYNLA!a\u0014\u0002J\t\u0001\")\u001f;f\u0003J\u0014\u0018-_,sCB\u0004XM]\u0001\u0010E\u0016\u001cHO\u00117pG.LEmS3zA\u0005Y\u0011m\u0019;jm\u0016\u001c\u0005.Y5o+\t\t9\u0006\u0005\u0003\u0002\u0016\u0005e\u0013\u0002BA.\u0003/\u00111\"Q2uSZ,7\t[1j]\u0006a\u0011m\u0019;jm\u0016\u001c\u0005.Y5oA\u0005yAn\\1e\u0003\u000e$\u0018N^3DQ\u0006Lg\u000e\u0006\u0002\u0002X\u0005a!\r\\8dW&sgm\\&fsR!\u0011QIA4\u0011\u001d\tIg\u0003a\u0001\u0003W\nqA\u00197pG.LE\r\u0005\u0003\u0002n\u0005\u0005e\u0002BA8\u0003{rA!!\u001d\u0002|9!\u00111OA=\u001b\t\t)HC\u0002\u0002x}\na\u0001\u0010:p_Rt\u0014\"\u0001+\n\u0005I\u001b\u0016bAA@#\u00069\u0001/Y2lC\u001e,\u0017\u0002BAB\u0003\u000b\u0013!\"T8eS\u001aLWM]%e\u0015\r\ty(U\u0001\u0013M\u0016,\u0007+Y=nK:$8/\u00138g_.+\u0017\u0010\u0006\u0003\u0002F\u0005-\u0005bBA5\u0019\u0001\u0007\u00111N\u0001\u0007Q\u0016Lw\r\u001b;\u0016\u0005\u0005E\u0005cA\"\u0002\u0014&\u0019\u0011Q\u0013#\u0003\u0007%sG/\u0001\u0005iK&<\u0007\u000e^(g)\u0011\tY*!)\u0011\u000b\r\u000bi*!%\n\u0007\u0005}EI\u0001\u0004PaRLwN\u001c\u0005\b\u0003Sr\u0001\u0019AA6\u0003-\u0011Wm\u001d;CY>\u001c7.\u00133\u0016\u0005\u0005-\u0014!\u00032fgR\u0014En\\2l+\u0005\u0019\u0017!\u00042fgR\u0014En\\2l\u0013:4w.\u0006\u0002\u00020B!\u0011QCAY\u0013\u0011\t\u0019,a\u0006\u0003%MKG-Z2iC&t'\t\\8dW&sgm\\\u0001\nE2|7m\u001b\"z\u0013\u0012$B!!/\u0002<B!1)!(d\u0011\u001d\tIG\u0005a\u0001\u0003W\nQB\u00197pG.LeNZ8Cs&#G\u0003BAX\u0003\u0003Dq!!\u001b\u0014\u0001\u0004\tY'A\ncY>\u001c7.\u00138g_>\u0003H/[8o\u0005fLE\r\u0006\u0003\u0002H\u0006%\u0007#B\"\u0002\u001e\u0006=\u0006bBA5)\u0001\u0007\u00111N\u0001\tG>tG/Y5ogR!\u0011qZAk!\r\u0019\u0015\u0011[\u0005\u0004\u0003'$%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003S*\u0002\u0019AA6\u0003y\u0011Gn\\2l\u0013:4wn\u00149uS>t')_%e\rJ|Wn\u0015;pe\u0006<W\r\u0006\u0003\u0002H\u0006m\u0007bBA5-\u0001\u0007\u00111N\u0001\u0019E2|7m[%oM>\u0014\u00150\u00133Ge>l7\u000b^8sC\u001e,G\u0003BAX\u0003CDq!!\u001b\u0018\u0001\u0004\tY'A\u0014hKRd\u0015m\u001d;NC&t7\r[1j]\"+\u0017\rZ3s\u0005\u0006\u001cX-\u00138g_&s7\r\\;tS>tG\u0003BAt\u0003[\u0004B!!\u0006\u0002j&!\u00111^A\f\u0005]i\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014()Y:f\u0013:4w\u000eC\u0004\u0002ja\u0001\r!a\u001b\u0002MQ|w.T1os\ncwnY6t/&$\bn\\;u\u001b\u000eDU-\u00193feN$\u0015\r^1TS:\u001cW\r\u0006\u0003\u0002P\u0006M\bbBA53\u0001\u0007\u00111N\u0001\u000ea\u0006\u0014XM\u001c;CY>\u001c7.\u00133\u0015\t\u0005e\u00181 \t\u0006\u0007\u0006u\u00151\u000e\u0005\b\u0003SR\u0002\u0019AA6\u00035\u0019\u0007.Y5o'\u000e|'/\u001a$peR!!\u0011\u0001B\u0005!\u0015\u0019\u0015Q\u0014B\u0002!\r\u0019%QA\u0005\u0004\u0005\u000f!%\u0001\u0002'p]\u001eDq!!\u001b\u001c\u0001\u0004\tY'A\bjg&s\u0017i\u0019;jm\u0016\u001c\u0005.Y5o)\u0011\tyMa\u0004\t\u000f\u0005%D\u00041\u0001\u0002l\u0005\u0011\u0012m\u0019;jm\u0016\u001c\u0005.Y5o\u00052|7m[%e)\u0011\tIP!\u0006\t\u000f\u00055U\u00041\u0001\u0002\u0012\u0006\u0001\u0012m\u0019;jm\u0016\u001c\u0005.Y5o'&t7-\u001a\u000b\u0007\u00057\u0011YC!\f\u0011\r\tu!QEA6\u001d\u0011\u0011yBa\t\u000f\t\u0005M$\u0011E\u0005\u0002\u000b&\u0019\u0011q\u0010#\n\t\t\u001d\"\u0011\u0006\u0002\u0004'\u0016\f(bAA@\t\"9\u0011\u0011\u000e\u0010A\u0002\u0005-\u0004b\u0002B\u0018=\u0001\u0007\u00111T\u0001\u0006Y&l\u0017\u000e^\u0001\u0011C\u000e$\u0018N^3DQ\u0006Lg.\u00114uKJ$bAa\u0007\u00036\t]\u0002bBA5?\u0001\u0007\u00111\u000e\u0005\b\u0005_y\u0002\u0019AAN\u0003):W\r^*jI\u0016\u001c\u0007.Y5o\u00052|7m[\"p]R\f\u0017N\\5oO6\u000b\u0017N\\2iC&t\u0007*Z1eKJ$B!!/\u0003>!9!q\b\u0011A\u0002\t\u0005\u0013aE7bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:ICND\u0007#B\"\u0003D\t\u001d\u0013b\u0001B#\t\n)\u0011I\u001d:bsB\u00191I!\u0013\n\u0007\t-CI\u0001\u0003CsR,\u0017!M4fiNKG-Z2iC&t'\t\\8dW\u000e{g\u000e^1j]&tw-T1j]\u000eD\u0017-\u001b8SK\u001a,'/\u001a8dK\u0012\u000bG/\u0019\u000b\u0005\u0003s\u0013\t\u0006C\u0004\u0003@\u0005\u0002\rA!\u0011\u0002A\u001d,G/T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3Cs\"\u000b7\u000f\u001b\u000b\u0005\u0005/\u0012y\u0006E\u0003D\u0003;\u0013I\u0006E\u0002n\u00057J1A!\u0018o\u0005]i\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW\rC\u0004\u0003@\t\u0002\rA!\u0011\u00021\u001d,G/T1j]\u000eD\u0017-\u001b8IK\u0006$WM\u001d\"z\u0011\u0006\u001c\b\u000e\u0006\u0003\u0003f\t5\u0004#B\"\u0002\u001e\n\u001d\u0004cA7\u0003j%\u0019!1\u000e8\u0003\u001f5\u000b\u0017N\\2iC&t\u0007*Z1eKJDqAa\u0010$\u0001\u0004\u0011\t%A\u0010hKRl\u0015-\u001b8dQ\u0006LgNU3gKJ,gnY3ECR\f')\u001f%bg\"$BAa\u001d\u0003|A)1)!(\u0003vA\u0019QNa\u001e\n\u0007\tedNA\u000eNC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK\u0012\u000bG/\u0019\u0005\b\u0005\u007f!\u0003\u0019\u0001B!\u0003Q:W\r^'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\u0013:4wNQ=NC&t7\r[1j]\ncwnY6IK&<\u0007\u000e\u001e\u000b\u0005\u0005\u0003\u0013I\tE\u0003D\u0003;\u0013\u0019\t\u0005\u0003\u0002\u0016\t\u0015\u0015\u0002\u0002BD\u0003/\u00111$T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3J]\u001a|\u0007b\u0002BFK\u0001\u0007\u0011\u0011S\u0001\u0010[\u0006Lgn\u00195bS:DU-[4ii\u0006\u0011s-\u001a;CKN$X*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-Z%oM>,\"A!!\u0002I\u001d,G/T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3J]\u001a|')\u001f%bg\"$BA!!\u0003\u0016\"9!qH\u0014A\u0002\t\u0005\u0013\u0001\t2vS2$W*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-Z%oM>$BBa!\u0003\u001c\n]&\u0011\u0019Bc\u0005\u0013DqA!()\u0001\u0004\u0011y*\u0001\u0004nG\"\u000b7\u000f\u001b\t\u0005\u0005C\u0013\tL\u0004\u0003\u0003$\n=f\u0002\u0002BS\u0005[sAAa*\u0003,:!\u00111\u000fBU\u0013\u0005q\u0014B\u0001\u001f>\u0013\r\tIbO\u0005\u0005\u0003\u007f\n9\"\u0003\u0003\u00034\nU&aE'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:ICND'\u0002BA@\u0003/AqA!/)\u0001\u0004\u0011Y,A\u0007sK\u001a,'/\u001a8dK&sgm\u001c\t\u0005\u0003+\u0011i,\u0003\u0003\u0003@\u0006]!aF'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:NKR\fG-\u0019;b\u0011\u001d\u0011\u0019\r\u000ba\u0001\u0003#\u000bQ\"\\2CY>\u001c7\u000eS3jO\"$\bb\u0002BdQ\u0001\u0007\u00111N\u0001 [\u0006Lgn\u00195bS:DU-\u00193feNKG-Z2iC&t'\t\\8dW&#\u0007b\u0002BfQ\u0001\u0007\u00111N\u0001'[\u0006Lgn\u00195bS:\u0014VMZ3sK:\u001cW\rR1uCNKG-Z2iC&t'\t\\8dW&#\u0017\u0001H4fi6\u000b\u0017N\\2iC&t\u0007*Y:iKN4uN]%oI\u0016DXm\u001d\u000b\u0005\u0005#\u0014\u0019\u000e\u0005\u0004\u0003\u001e\t\u0015\"q\u0014\u0005\b\u0005+L\u0003\u0019\u0001Bl\u0003Ai\u0017-\u001b8dQ\u0006Lg\u000eS3jO\"$8\u000f\u0005\u0004\u0003\u001e\t\u0015\u0012\u0011S\u0001\u001bO\u0016$()Z:u\u001b\u0006Lgn\u00195bS:DU-\u00193fe&sgm\\\u000b\u0003\u0005;\u0004RaQAO\u0005?\u0004B!!\u0006\u0003b&!!1]A\f\u0005Mi\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014\u0018J\u001c4p\u0003y9W\r^'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:J]\u001a|')\u001f%fS\u001eDG\u000f\u0006\u0003\u0003^\n%\bb\u0002BFW\u0001\u0007\u0011\u0011S\u0001\u001dO\u0016$X*Y5oG\"\f\u0017N\u001c%fC\u0012,'/\u00138g_\nK\b*Y:i)\u0011\u0011iNa<\t\u000f\t}B\u00061\u0001\u0003B\u00051s-\u001a;CKN$X*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-\u001a#bi\u0006LeNZ8\u0016\u0005\tU\b#B\"\u0002\u001e\n]\b\u0003BA\u000b\u0005sLAAa?\u0002\u0018\tyR*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-\u001a#bi\u0006LeNZ8\u0002U\u001d,G/T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3ECR\f\u0017J\u001c4p\u0005fDU-[4iiR!!Q_B\u0001\u0011\u001d\u0011YI\fa\u0001\u0003#\u000b\u0001fZ3u\u001b\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016$\u0015\r^1J]\u001a|')\u001f%bg\"$BA!>\u0004\b!9!qH\u0018A\u0002\t\u0005\u0013AB;qI\u0006$X\r\u0006\u0004\u0004\u000e\r]1\u0011\u0004\t\u0007\u0007\u001f\u0019\u0019\"!\r\u000e\u0005\rE!B\u0001*E\u0013\u0011\u0019)b!\u0005\u0003\u0007Q\u0013\u0018\u0010C\u0003pa\u0001\u00071\rC\u0004\u0004\u001cA\u0002\r!a,\u0002\u0013\tdwnY6J]\u001a|\u0017!F;qI\u0006$XMR3f!\u0006LX.\u001a8ug&sgm\u001c\u000b\u0007\u0007\u001b\u0019\tca\t\t\u000f\u0005%\u0014\u00071\u0001\u0002l!91QE\u0019A\u0002\u0005-\u0011a\u00044fKB\u000b\u00170\\3oiNLeNZ8\u0002%\u001d,GOR3f!\u0006LX.\u001a8ug&sgm\u001c\u000b\u0005\u0007W\u0019i\u0003E\u0003D\u0003;\u000bY\u0001C\u0004\u0002jI\u0002\r!a\u001b\u0002!M,W.\u00198uS\u000e4\u0016\r\\5eSRLH\u0003BB\u001a\u0007\u007f\u0001Ba!\u000e\u0004<5\u00111q\u0007\u0006\u0004\u0007sy\u0016!C2p]N,gn];t\u0013\u0011\u0019ida\u000e\u000315{G-\u001b4jKJ\u001cV-\\1oi&\u001cg+\u00197jI&$\u0018\u0010C\u0004\u0002jM\u0002\r!a\u001b\u0002-U\u0004H-\u0019;f'\u0016l\u0017M\u001c;jGZ\u000bG.\u001b3jif$ba!\u0004\u0004F\r\u001d\u0003\"B85\u0001\u0004\u0019\u0007bBB%i\u0001\u000711G\u0001\u0007gR\fG/^:\u0002\u001dM,G/Q:CKN$(\t\\8dWR11QBB(\u0007#BQa\\\u001bA\u0002\rDqaa\u00076\u0001\u0004\ty+A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005=\u0017!\u00047bgR4VM]:j_:LE-\u0006\u0002\u0004\\A)1)!(\u0002F\u0001")
public abstract class AbstractHistoryStorage<PM extends SidechainBlockBase<? extends Transaction, ? extends SidechainBlockHeaderBase>, FPI extends AbstractFeePaymentsInfo, S extends AbstractHistoryStorage<PM, FPI, S>>
implements SidechainBlockInfoProvider,
SidechainStorageInfo,
SparkzLogging {
    private final Storage storage;
    private final SparkzSerializer<PM> blockSerializer;
    private final SparkzSerializer<FPI> feePaymentsInfoSerializer;
    private final NetworkParams params;
    private final ByteArrayWrapper bestBlockIdKey;
    private final ActiveChain activeChain;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ByteArrayWrapper bestBlockIdKey() {
        return this.bestBlockIdKey;
    }

    private ActiveChain activeChain() {
        return this.activeChain;
    }

    private ActiveChain loadActiveChain() {
        if (this.storage.isEmpty()) {
            return ActiveChain$.MODULE$.apply(this.params.mainchainCreationBlockHeight());
        }
        ArrayBuffer activeChainBlocksInfo = new ArrayBuffer();
        activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.bestBlockId(), (Object)this.blockInfoByIdFromStorage(this.bestBlockId()))}));
        while (((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).height() > 1) {
            String id = ((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).parentId();
            activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)id, (Object)this.blockInfoByIdFromStorage(id))}));
        }
        ArrayBuffer orderedChainBlocks = (ArrayBuffer)activeChainBlocksInfo.reverse();
        Option mainchainBlockParent = orderedChainBlocks.headOption().flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlockInfo -> this.blockById((String)firstSidechainBlockInfo._1()).flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlock -> firstSidechainBlock.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)firstMainchainHeader -> io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(firstMainchainHeader.hashPrevBlock()))));
        return ActiveChain$.MODULE$.apply((ArrayBuffer<Tuple2<String, SidechainBlockInfo>>)orderedChainBlocks, (ByteArrayWrapper)mainchainBlockParent.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Loaded active chain miss mainchain parent");
        }), this.params.mainchainCreationBlockHeight());
    }

    private ByteArrayWrapper blockInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(9).append("blockInfo").append(blockId).toString()));
    }

    public ByteArrayWrapper feePaymentsInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(15).append("feePaymentsInfo").append(blockId).toString()));
    }

    public int height() {
        return this.activeChain().height();
    }

    public Option<Object> heightOf(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.height()));
    }

    public String bestBlockId() {
        return (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.bestBlockIdKey()))).map((Function1 & Serializable & scala.Serializable)d -> sparkz.util.package$.MODULE$.bytesToId(d.data())).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.params.sidechainGenesisBlockId());
    }

    public PM bestBlock() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return (PM)((SidechainBlockBase)this.blockById(this.bestBlockId()).get());
    }

    public SidechainBlockInfo bestBlockInfo() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return this.blockInfoById(this.bestBlockId());
    }

    public Option<PM> blockById(String blockId) {
        None$ none$;
        ByteArrayWrapper blockIdBytes = new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(blockId));
        Option baw = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(blockIdBytes)));
        Option option = baw;
        if (option instanceof Some) {
            Option option2;
            Some some = (Some)option;
            ByteArrayWrapper value = (ByteArrayWrapper)some.value();
            Try try_ = this.blockSerializer.parseBytesTry(value.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainBlockBase block = (SidechainBlockBase)success.value();
                option2 = Option$.MODULE$.apply((Object)block);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while sidechain block parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = option2;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("SidechainHistoryStorage:blockById: byte array is empty");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    @Override
    public SidechainBlockInfo blockInfoById(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionById(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(24).append("No block info for block ").append(blockId).toString());
        });
    }

    public Option<SidechainBlockInfo> blockInfoOptionById(String blockId) {
        return this.activeChain().blockInfoById(blockId).orElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoOptionByIdFromStorage(blockId));
    }

    public boolean contains(String blockId) {
        return this.isInActiveChain(blockId) || this.blockInfoOptionByIdFromStorage(blockId).nonEmpty();
    }

    private Option<SidechainBlockInfo> blockInfoOptionByIdFromStorage(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.blockInfoKey(blockId)))).flatMap((Function1 & Serializable & scala.Serializable)baw -> SidechainBlockInfoSerializer$.MODULE$.parseBytesTry(baw.data()).toOption());
    }

    private SidechainBlockInfo blockInfoByIdFromStorage(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionByIdFromStorage(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(36).append("No blockInfo in storage for blockId ").append(blockId).toString());
        });
    }

    public MainchainHeaderBaseInfo getLastMainchainHeaderBaseInfoInclusion(String blockId) {
        SidechainBlockInfo sidechainBlockInfo = this.blockInfoById(blockId);
        while (sidechainBlockInfo.mainchainHeaderBaseInfo().isEmpty()) {
            sidechainBlockInfo = this.blockInfoById(sidechainBlockInfo.parentId());
        }
        return (MainchainHeaderBaseInfo)sidechainBlockInfo.mainchainHeaderBaseInfo().last();
    }

    public boolean tooManyBlocksWithoutMcHeadersDataSince(String blockId) {
        SidechainBlockInfo sidechainBlockInfo = this.blockInfoById(blockId);
        int scBlocksCount = 0;
        boolean blockHasMcHeaders = sidechainBlockInfo.mainchainHeaderBaseInfo().nonEmpty();
        int maxBlocksWithoutMcHeaders = this.params.maxHistoryRewritingLength() - 1;
        while (!blockHasMcHeaders) {
            BoxedUnit boxedUnit;
            if (++scBlocksCount >= maxBlocksWithoutMcHeaders) {
                BoxedUnit boxedUnit2;
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("Unexpectedly large number of consecutive SC blocks with no mc block references");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return true;
            }
            String string = sidechainBlockInfo.parentId();
            String string2 = this.params.sidechainGenesisBlockId();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return false;
            }
            blockHasMcHeaders = (sidechainBlockInfo = this.blockInfoById(sidechainBlockInfo.parentId())).mainchainHeaderBaseInfo().nonEmpty();
            if (blockHasMcHeaders) {
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("found sc block {} which has {} mc block headers", new Object[]{sidechainBlockInfo.parentId(), BoxesRunTime.boxToInteger((int)sidechainBlockInfo.mainchainHeaderBaseInfo().size())});
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return false;
    }

    public Option<String> parentBlockId(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parentId());
    }

    public Option<Object> chainScoreFor(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.score()));
    }

    public boolean isInActiveChain(String blockId) {
        return this.activeChain().contains(blockId);
    }

    public Option<String> activeChainBlockId(int height) {
        return this.activeChain().idByHeight(height);
    }

    public Seq<String> activeChainSince(String blockId, Option<Object> limit) {
        return this.activeChain().chainSince(blockId, limit);
    }

    public Seq<String> activeChainAfter(String blockId, Option<Object> limit) {
        return this.activeChain().chainAfter(blockId, limit);
    }

    public Option<PM> getSidechainBlockContainingMainchainHeader(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcHeader(io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<PM> getSidechainBlockContainingMainchainReferenceData(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcReferenceData(io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<MainchainBlockReference> getMainchainBlockReferenceByHash(byte[] mainchainHeaderHash) {
        return this.getMainchainHeaderByHash(mainchainHeaderHash).flatMap((Function1 & Serializable & scala.Serializable)header -> this.getMainchainReferenceDataByHash(mainchainHeaderHash).map((Function1 & Serializable & scala.Serializable)data -> new MainchainBlockReference((MainchainHeader)header, (MainchainBlockReferenceData)data)));
    }

    public Option<MainchainHeader> getMainchainHeaderByHash(byte[] mainchainHeaderHash) {
        Option<PM> block = this.getSidechainBlockContainingMainchainHeader(mainchainHeaderHash);
        return block.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.mainchainHeaders().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainHeaderByHash$2(mainchainHeaderHash, header))));
    }

    public Option<MainchainBlockReferenceData> getMainchainReferenceDataByHash(byte[] mainchainHeaderHash) {
        Option<PM> block = this.getSidechainBlockContainingMainchainReferenceData(mainchainHeaderHash);
        return block.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mainchainBlockReferencesData().find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainReferenceDataByHash$2(mainchainHeaderHash, data))));
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByMainchainBlockHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).flatMap((Function1 & Serializable & scala.Serializable)hash -> this.getMainchainBlockReferenceInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)hash)));
    }

    public Option<MainchainBlockReferenceInfo> getBestMainchainBlockReferenceInfo() {
        return this.getMainchainBlockReferenceInfoByMainchainBlockHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainBlockReferenceInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    private MainchainBlockReferenceInfo buildMainchainBlockReferenceInfo(ByteArrayWrapper mcHash, MainchainHeaderMetadata referenceInfo, int mcBlockHeight, String mainchainHeaderSidechainBlockId, String mainchainReferenceDataSidechainBlockId) {
        return new MainchainBlockReferenceInfo(package$.MODULE$.wrapperToByteArray(mcHash), package$.MODULE$.wrapperToByteArray(referenceInfo.getParentId()), mcBlockHeight, sparkz.util.package$.MODULE$.idToBytes(mainchainHeaderSidechainBlockId), sparkz.util.package$.MODULE$.idToBytes(mainchainReferenceDataSidechainBlockId));
    }

    public Seq<ByteArrayWrapper> getMainchainHashesForIndexes(Seq<Object> mainchainHeights) {
        return (Seq)mainchainHeights.flatMap((Function1 & Serializable & scala.Serializable)mainchainHeight -> Option$.MODULE$.option2Iterable(this.activeChain().mcHashByMcHeight(BoxesRunTime.unboxToInt((Object)mainchainHeight))), Seq$.MODULE$.canBuildFrom());
    }

    public Option<MainchainHeaderInfo> getBestMainchainHeaderInfo() {
        return this.getMainchainHeaderInfoByHeight(this.activeChain().heightOfMcHeaders());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainHeaderInfo)this.getMainchainHeaderInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)mcHash)).get());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcHeadersHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Option<MainchainBlockReferenceDataInfo> getBestMainchainBlockReferenceDataInfo() {
        return this.getMainchainBlockReferenceDataInfoByHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainBlockReferenceDataInfo)this.getMainchainBlockReferenceDataInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)mcHash)).get());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainBlockReferenceDataInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Try<S> update(PM block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(block != null, (Function0 & Serializable & scala.Serializable)() -> "Block must be NOT NULL.");
            String string = block.parentId();
            String string2 = blockInfo.parentId();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Passed BlockInfo data conflicts to passed Block.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes())));
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(block.id())), new ByteArrayWrapper(block.bytes())));
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), toUpdate, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<S> updateFeePaymentsInfo(String blockId, FPI feePaymentsInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.feePaymentsInfoKey(blockId)), new ByteArrayWrapper(feePaymentsInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Option<FPI> getFeePaymentsInfo(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.feePaymentsInfoKey(blockId)))).flatMap((Function1 & Serializable & scala.Serializable)baw -> $this.feePaymentsInfoSerializer.parseBytesTry(baw.data()).toOption());
    }

    public ModifierSemanticValidity semanticValidity(String blockId) {
        ModifierSemanticValidity.Absent$ absent$;
        Option<SidechainBlockInfo> option = this.blockInfoOptionById(blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            SidechainBlockInfo info = (SidechainBlockInfo)some.value();
            absent$ = info.semanticValidity();
        } else if (None$.MODULE$.equals(option)) {
            absent$ = ModifierSemanticValidity.Absent$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return absent$;
    }

    public Try<S> updateSemanticValidity(PM block, ModifierSemanticValidity status) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SidechainBlockInfo oldInfo = (SidechainBlockInfo)this.activeChain().blockInfoById(block.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoById(block.id()));
            ModifierSemanticValidity x$1 = status;
            int x$2 = oldInfo.copy$default$1();
            long x$3 = oldInfo.copy$default$2();
            String x$4 = oldInfo.copy$default$3();
            long x$5 = oldInfo.copy$default$4();
            Seq<MainchainHeaderBaseInfo> x$6 = oldInfo.copy$default$6();
            Seq<ByteArrayWrapper> x$7 = oldInfo.copy$default$7();
            WithdrawalEpochInfo x$8 = oldInfo.copy$default$8();
            Option<VrfOutput> x$9 = oldInfo.copy$default$9();
            String x$10 = oldInfo.copy$default$10();
            SidechainBlockInfo blockInfo = oldInfo.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<S> setAsBestBlock(PM block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.bestBlockIdKey(), new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(block.id())))}), new ArrayList<ByteArrayWrapper>());
            Option mainchainParent = block.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)header -> io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(header.hashPrevBlock()));
            this.activeChain().setBestBlock(block.id(), blockInfo, (Option<ByteArrayWrapper>)mainchainParent);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderByHash$2(byte[] mainchainHeaderHash$2, MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$2)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.hash()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainReferenceDataByHash$2(byte[] mainchainHeaderHash$3, MainchainBlockReferenceData data) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$3)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(data.headerHash()));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$1, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)headerContainingId -> $this.activeChain().idByMcReferenceData(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)dataContainingId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$1).map((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.buildMainchainBlockReferenceInfo(mcHash$1, (MainchainHeaderMetadata)mcMetadata, mcHeight, (String)headerContainingId, (String)dataContainingId))));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderInfoByHash$5(ByteArrayWrapper mcHash$2, MainchainHeaderBaseInfo info) {
        return info.hash().equals(mcHash$2);
    }

    public static final /* synthetic */ Option $anonfun$getMainchainHeaderInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$2, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)sidechainBlockId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.activeChain().blockInfoById((String)sidechainBlockId).flatMap((Function1 & Serializable & scala.Serializable)blockInfo -> blockInfo.mainchainHeaderBaseInfo().find((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$5(mcHash$2, info))).map((Function1 & Serializable & scala.Serializable)mainchainBaseInfo -> new MainchainHeaderInfo(mcHash$2, mcMetadata.getParentId(), mcHeight, (String)sidechainBlockId, mainchainBaseInfo.cumulativeCommTreeHash())))));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceDataInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$3, int mcHeight) {
        return $this.activeChain().idByMcReferenceData(mcHash$3).map((Function1 & Serializable & scala.Serializable)sidechainBlockId -> new MainchainBlockReferenceDataInfo(mcHash$3, mcHeight, (String)sidechainBlockId));
    }

    public AbstractHistoryStorage(Storage storage, SparkzSerializer<PM> blockSerializer, SparkzSerializer<FPI> feePaymentsInfoSerializer, NetworkParams params) {
        this.storage = storage;
        this.blockSerializer = blockSerializer;
        this.feePaymentsInfoSerializer = feePaymentsInfoSerializer;
        this.params = params;
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(blockSerializer != null, (Function0 & Serializable & scala.Serializable)() -> "Block serializer must be NOT NULL.");
        Predef$.MODULE$.require(params != null, (Function0 & Serializable & scala.Serializable)() -> "params must be NOT NULL.");
        this.bestBlockIdKey = new ByteArrayWrapper((byte[])Array$.MODULE$.fill(32, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Byte()));
        this.activeChain = this.loadActiveChain();
    }
}

