/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.secret;

import io.horizen.cryptolibprovider.CryptoLibProvider;
import io.horizen.cryptolibprovider.VrfFunctions;
import io.horizen.secret.SecretCreator;
import io.horizen.secret.VrfSecretKey;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;

public class VrfKeyGenerator
implements SecretCreator<VrfSecretKey> {
    private static final VrfKeyGenerator instance;
    private static final byte[] domain;

    private VrfKeyGenerator() {
    }

    public static VrfKeyGenerator getInstance() {
        return instance;
    }

    @Override
    public VrfSecretKey generateSecret(byte[] seed) {
        EnumMap<VrfFunctions.KeyType, byte[]> keys = CryptoLibProvider.vrfFunctions().generatePublicAndSecretKeys(seed);
        return new VrfSecretKey(keys.get((Object)VrfFunctions.KeyType.SECRET), keys.get((Object)VrfFunctions.KeyType.PUBLIC));
    }

    @Override
    public byte[] salt() {
        return domain;
    }

    static {
        domain = "VrfKey".getBytes(StandardCharsets.UTF_8);
        instance = new VrfKeyGenerator();
    }
}

