/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.proof;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import io.horizen.json.Views;
import io.horizen.proof.ProofOfKnowledge;
import io.horizen.proposition.ProofOfKnowledgeProposition;
import io.horizen.secret.PrivateKey25519;
import io.horizen.utils.Ed25519;
import java.util.Arrays;
import java.util.Objects;

@JsonView(value={Views.Default.class})
public abstract class AbstractSignature25519<S extends PrivateKey25519, P extends ProofOfKnowledgeProposition<S>>
implements ProofOfKnowledge<S, P> {
    @JsonProperty(value="signature")
    protected final byte[] signatureBytes;

    public AbstractSignature25519(byte[] signatureBytes) {
        this.signatureBytes = Arrays.copyOf(signatureBytes, signatureBytes.length);
    }

    @Override
    public boolean isValid(P proposition, byte[] message) {
        return Ed25519.verify(this.signatureBytes, message, proposition.pubKeyBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSignature25519 that = (AbstractSignature25519)o;
        return Arrays.equals(this.signatureBytes, that.signatureBytes);
    }

    public int hashCode() {
        int result = Objects.hash(this.signatureBytes.length);
        result = 31 * result + Arrays.hashCode(this.signatureBytes);
        return result;
    }
}

