/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.websocket;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.api.rpc.request.RpcId;
import io.horizen.account.api.rpc.request.RpcRequest;
import io.horizen.account.api.rpc.response.RpcResponseError;
import io.horizen.account.api.rpc.response.RpcResponseSuccess;
import io.horizen.account.api.rpc.types.FilterQuery;
import io.horizen.account.api.rpc.utils.RpcCode;
import io.horizen.account.api.rpc.utils.RpcError;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.serialization.EthJsonMapper;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.websocket.LOGS_SUBSCRIPTION$;
import io.horizen.account.websocket.NEW_HEADS_SUBSCRIPTION$;
import io.horizen.account.websocket.NEW_PENDING_TRANSACTIONS_SUBSCRIPTION$;
import io.horizen.account.websocket.SUBSCRIBE_REQUEST$;
import io.horizen.account.websocket.SYNCING_SUBSCRIPTION$;
import io.horizen.account.websocket.UNSUBSCRIBE_REQUEST$;
import io.horizen.account.websocket.WebSocketAccountChannelImpl;
import io.horizen.account.websocket.WebSocketAccountServerEndpoint$;
import io.horizen.account.websocket.WebSocketAccountServerRef$;
import io.horizen.account.websocket.data.Subscription;
import io.horizen.account.websocket.data.SubscriptionWithFilter;
import io.horizen.network.SyncStatus;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparkz.util.SparkzLogging;

@ServerEndpoint(value="/")
@ScalaSignature(bytes="\u0006\u0001\r}a\u0001\u0002\u001c8\u0001\u0001CQa\u0014\u0001\u0005\u0002ACQa\u0015\u0001\u0005\u0002QCQ!\u001a\u0001\u0005\u0002\u0019DQA\u001f\u0001\u0005\u0002mDq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u00026\u0001!I!a\u000e\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA<\u0001\u0011%\u0011\u0011P\u0004\b\u0003;;\u0004\u0012BAP\r\u00191t\u0007#\u0003\u0002\"\"1qj\u0003C\u0001\u0003GC\u0011\"!*\f\u0001\u0004%\t!a*\t\u0013\u0005m6\u00021A\u0005\u0002\u0005u\u0006\u0002CAb\u0017\u0001\u0006K!!+\t\u0013\u0005\u00157\u00021A\u0005\u0002\u0005\u001d\u0007\"CAn\u0017\u0001\u0007I\u0011AAo\u0011!\t\to\u0003Q!\n\u0005%\u0007\"CAr\u0017\u0001\u0007I\u0011AAd\u0011%\t)o\u0003a\u0001\n\u0003\t9\u000f\u0003\u0005\u0002l.\u0001\u000b\u0015BAe\u0011%\tio\u0003a\u0001\n\u0003\ty\u000fC\u0005\u0002z.\u0001\r\u0011\"\u0001\u0002|\"A\u0011q`\u0006!B\u0013\t\t\u0010C\u0005\u0003\u0002-\u0001\r\u0011\"\u0001\u0002H\"I!1A\u0006A\u0002\u0013\u0005!Q\u0001\u0005\t\u0005\u0013Y\u0001\u0015)\u0003\u0002J\"I!1B\u0006C\u0002\u0013\u0005!Q\u0002\u0005\t\u0005+Y\u0001\u0015!\u0003\u0003\u0010!I!qC\u0006A\u0002\u0013%!\u0011\u0004\u0005\n\u0005[Y\u0001\u0019!C\u0005\u0005_A\u0001Ba\r\fA\u0003&!1\u0004\u0005\n\u0005kY\u0001\u0019!C\u0005\u0005oA\u0011Ba\u0019\f\u0001\u0004%IA!\u001a\t\u0011\t%4\u0002)Q\u0005\u0005sA\u0011Ba\u001b\f\u0005\u0004%IA!\u001c\t\u0011\tU4\u0002)A\u0005\u0005_BqAa\u001e\f\t\u0003\u0011I\bC\u0004\u0003\n.!\tAa#\t\u000f\tu5\u0002\"\u0001\u0003 \"9!1V\u0006\u0005\u0002\t5\u0006b\u0002B`\u0017\u0011\u0005!\u0011\u0019\u0005\b\u0005\u0007\\A\u0011\u0002Bc\u0011\u001d\u0011Im\u0003C\u0005\u0005\u0017DqAa6\f\t\u0003\u0011\t\rC\u0004\u0003Z.!\tAa7\t\u000f\t}7\u0002\"\u0001\u0003b\"9!Q]\u0006\u0005\u0002\t\u001d\bb\u0002Bv\u0017\u0011\u0005!Q\u001e\u0005\b\u0005c\\A\u0011\u0001Bz\u0011\u001d\u0011Ip\u0003C\u0001\u0005wDqAa@\f\t\u0003\u0019\t\u0001C\u0004\u0004\u0016-!\taa\u0006\u0003=]+'mU8dW\u0016$\u0018iY2pk:$8+\u001a:wKJ,e\u000e\u001a9pS:$(B\u0001\u001d:\u0003%9XMY:pG.,GO\u0003\u0002;w\u00059\u0011mY2pk:$(B\u0001\u001f>\u0003\u001dAwN]5{K:T\u0011AP\u0001\u0003S>\u001c\u0001aE\u0002\u0001\u0003\u001e\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013a!\u00118z%\u00164\u0007C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0011)H/\u001b7\u000b\u00031\u000baa\u001d9be.T\u0018B\u0001(J\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u0015\t\u0003%\u0002i\u0011aN\u0001\b_:\u001cEn\\:f)\t)\u0006\f\u0005\u0002C-&\u0011qk\u0011\u0002\u0005+:LG\u000fC\u0003Z\u0005\u0001\u0007!,A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005m{V\"\u0001/\u000b\u0005aj&\"\u00010\u0002\u000f)\f7.\u0019:uC&\u0011\u0001\r\u0018\u0002\b'\u0016\u001c8/[8oQ\t\u0011!\r\u0005\u0002\\G&\u0011A\r\u0018\u0002\b\u001f:\u001cEn\\:f\u0003\u001dyg.\u0012:s_J$2!V4i\u0011\u0015I6\u00011\u0001[\u0011\u0015I7\u00011\u0001k\u0003\u0005!\bCA6t\u001d\ta\u0017O\u0004\u0002na6\taN\u0003\u0002p\u007f\u00051AH]8pizJ\u0011\u0001R\u0005\u0003e\u000e\u000bq\u0001]1dW\u0006<W-\u0003\u0002uk\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003e\u000eC#aA<\u0011\u0005mC\u0018BA=]\u0005\u001dye.\u0012:s_J\f\u0011c\u001c8NKN\u001c\u0018mZ3SK\u000e,\u0017N^3e)\r)F0 \u0005\u00063\u0012\u0001\rA\u0017\u0005\u0006}\u0012\u0001\ra`\u0001\b[\u0016\u001c8/Y4f!\u0011\t\t!!\u0003\u000f\t\u0005\r\u0011Q\u0001\t\u0003[\u000eK1!a\u0002D\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\u0019\u0019FO]5oO*\u0019\u0011qA\")\u0007\u0011\t\t\u0002E\u0002\\\u0003'I1!!\u0006]\u0005%ye.T3tg\u0006<W-A\u0005tk\n\u001c8M]5cKR)Q+a\u0007\u0002\u001e!)\u0011,\u0002a\u00015\"9\u0011qD\u0003A\u0002\u0005\u0005\u0012A\u0003:qGJ+\u0017/^3tiB!\u00111EA\u0019\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012a\u0002:fcV,7\u000f\u001e\u0006\u0005\u0003W\ti#A\u0002sa\u000eT1!a\f:\u0003\r\t\u0007/[\u0005\u0005\u0003g\t)C\u0001\u0006Sa\u000e\u0014V-];fgR\f1\"\u001e8tk\n\u001c8M]5cKR)Q+!\u000f\u0002<!)\u0011L\u0002a\u00015\"9\u0011q\u0004\u0004A\u0002\u0005\u0005\u0012a\u00052bIJ\u00038MU3rk\u0016\u001cH\u000fU1sC6\u001cH\u0003BA!\u0003\u000f\u00022AQA\"\u0013\r\t)e\u0011\u0002\b\u0005>|G.Z1o\u0011\u001d\tIe\u0002a\u0001\u0003\u0017\n\u0011B\u001d9d!\u0006\u0014\u0018-\\:\u0011\t\u00055\u0013qL\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005AA-\u0019;bE&tGM\u0003\u0003\u0002V\u0005]\u0013a\u00026bG.\u001cxN\u001c\u0006\u0005\u00033\nY&A\u0005gCN$XM\u001d=nY*\u0011\u0011QL\u0001\u0004G>l\u0017\u0002BA1\u0003\u001f\u0012\u0001BS:p]:{G-Z\u0001\u0015GJ,\u0017\r^3Tk\n\u001c8M]5qi&|g.\u00133\u0015\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005[\u0006$\bN\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u001b\u0003\u0015\tKw-\u00138uK\u001e,'/\u0001\nuef<U\r\u001e*qGJ+\u0017/^3ti&#G\u0003BA>\u0003\u000f\u0003RAQA?\u0003\u0003K1!a D\u0005\u0019y\u0005\u000f^5p]B!\u00111EAB\u0013\u0011\t))!\n\u0003\u000bI\u00038-\u00133\t\u000byL\u0001\u0019A@)\u000f\u0001\tY)a&\u0002\u001aB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012r\u000baa]3sm\u0016\u0014\u0018\u0002BAK\u0003\u001f\u0013abU3sm\u0016\u0014XI\u001c3q_&tG/A\u0003wC2,X-\t\u0002\u0002\u001c\u0006\tq&\u0001\u0010XK\n\u001cvnY6fi\u0006\u001b7m\\;oiN+'O^3s\u000b:$\u0007o\\5oiB\u0011!kC\n\u0004\u0017\u0005;ECAAP\u0003M\u0019XOY:de&\u0004H/[8o\u0007>,h\u000e^3s+\t\tI\u000b\u0005\u0003\u0002,\u0006]VBAAW\u0015\u0011\ty+!-\u0002\r\u0005$x.\\5d\u0015\u0011\t\u0019,!.\u0002\u0015\r|gnY;se\u0016tGOC\u0002K\u0003_JA!!/\u0002.\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fqc];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001cu.\u001e8uKJ|F%Z9\u0015\u0007U\u000by\fC\u0005\u0002B:\t\t\u00111\u0001\u0002*\u0006\u0019\u0001\u0010J\u0019\u0002)M,(m]2sSB$\u0018n\u001c8D_VtG/\u001a:!\u0003UqWm\u001e%fC\u0012\u001c8+\u001e2tGJL\u0007\u000f^5p]N,\"!!3\u0011\u000b-\fY-a4\n\u0007\u00055WO\u0001\u0003MSN$\b\u0003BAi\u0003/l!!a5\u000b\u0007\u0005Uw'\u0001\u0003eCR\f\u0017\u0002BAm\u0003'\u0014AbU;cg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0011D\\3x\u0011\u0016\fGm]*vEN\u001c'/\u001b9uS>t7o\u0018\u0013fcR\u0019Q+a8\t\u0013\u0005\u0005\u0017#!AA\u0002\u0005%\u0017A\u00068fo\"+\u0017\rZ:Tk\n\u001c8M]5qi&|gn\u001d\u0011\u0002G9,w\u000fU3oI&tw\r\u0016:b]N\f7\r^5p]N\u001cVOY:de&\u0004H/[8og\u00069c.Z<QK:$\u0017N\\4Ue\u0006t7/Y2uS>t7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001cx\fJ3r)\r)\u0016\u0011\u001e\u0005\n\u0003\u0003$\u0012\u0011!a\u0001\u0003\u0013\fAE\\3x!\u0016tG-\u001b8h)J\fgn]1di&|gn]*vEN\u001c'/\u001b9uS>t7\u000fI\u0001\u0012Y><7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001cXCAAy!\u0015Y\u00171ZAz!\u0011\t\t.!>\n\t\u0005]\u00181\u001b\u0002\u0017'V\u00147o\u0019:jaRLwN\\,ji\"4\u0015\u000e\u001c;fe\u0006)Bn\\4t'V\u00147o\u0019:jaRLwN\\:`I\u0015\fHcA+\u0002~\"I\u0011\u0011Y\f\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\u0013Y><7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\b%\u0001\u000bts:\u001c\u0017N\\4Tk\n\u001c8M]5qi&|gn]\u0001\u0019gft7-\u001b8h'V\u00147o\u0019:jaRLwN\\:`I\u0015\fHcA+\u0003\b!I\u0011\u0011\u0019\u000e\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0016gft7-\u001b8h'V\u00147o\u0019:jaRLwN\\:!\u0003m9XMY*pG.,G/Q2d_VtGo\u00115b]:,G.S7qYV\u0011!q\u0002\t\u0004%\nE\u0011b\u0001B\no\tYr+\u001a2T_\u000e\\W\r^!dG>,h\u000e^\"iC:tW\r\\%na2\fAd^3c'>\u001c7.\u001a;BG\u000e|WO\u001c;DQ\u0006tg.\u001a7J[Bd\u0007%A\bxC2dW\r^!eIJ,7o]3t+\t\u0011Y\u0002\u0005\u0004\u0002\u0002\tu!\u0011E\u0005\u0005\u0005?\tiAA\u0002TKR\u0004BAa\t\u0003*5\u0011!Q\u0005\u0006\u0004\u0005OY\u0014aA3w[&!!1\u0006B\u0013\u0005\u001d\tE\r\u001a:fgN\f1c^1mY\u0016$\u0018\t\u001a3sKN\u001cXm]0%KF$2!\u0016B\u0019\u0011%\t\tmHA\u0001\u0002\u0004\u0011Y\"\u0001\txC2dW\r^!eIJ,7o]3tA\u0005!2-Y2iK\u0012\u0014En\\2lgJ+7-Z5qiN,\"A!\u000f\u0011\u000b-\fYMa\u000f\u0011\u000f\t\u0013iD!\u0011\u0003V%\u0019!qH\"\u0003\rQ+\b\u000f\\33!\u0011\u0011\u0019Ea\u0014\u000f\t\t\u0015#Q\n\b\u0005\u0005\u000f\u0012YED\u0002n\u0005\u0013J\u0011\u0001T\u0005\u0003\u0015.K!A]%\n\t\tE#1\u000b\u0002\u000b\u001b>$\u0017NZ5fe&#'B\u0001:J!\u0019\t\tA!\b\u0003XA!!\u0011\fB0\u001b\t\u0011YF\u0003\u0003\u0003^\u0005%\u0012!\u0002;za\u0016\u001c\u0018\u0002\u0002B1\u00057\u0012q\"\u0012;iKJ,W/\u001c'pOZKWm^\u0001\u0019G\u0006\u001c\u0007.\u001a3CY>\u001c7n\u001d*fG\u0016L\u0007\u000f^:`I\u0015\fHcA+\u0003h!I\u0011\u0011\u0019\u0012\u0002\u0002\u0003\u0007!\u0011H\u0001\u0016G\u0006\u001c\u0007.\u001a3CY>\u001c7n\u001d*fG\u0016L\u0007\u000f^:!\u0003Yi\u0017\r_\"bG\",GM\u00117pG.\u0014VmY3jaR\u001cXC\u0001B8!\r\u0011%\u0011O\u0005\u0004\u0005g\u001a%aA%oi\u00069R.\u0019=DC\u000eDW\r\u001a\"m_\u000e\\'+Z2fSB$8\u000fI\u0001%]>$\u0018NZ=TK6\fg\u000e^5dC2d\u0017pU;dG\u0016\u001c8OZ;m\u001b>$\u0017NZ5feR\u0019QKa\u001f\t\u000f\tud\u00051\u0001\u0003\u0000\u0005)!\r\\8dWB!!\u0011\u0011BC\u001b\t\u0011\u0019IC\u0002\u0003~eJAAa\"\u0003\u0004\na\u0011iY2pk:$(\t\\8dW\u0006Ybn\u001c;jMftUm\u001e)f]\u0012Lgn\u001a+sC:\u001c\u0018m\u0019;j_:$2!\u0016BG\u0011\u001d\u0011yi\na\u0001\u0005#\u000b!\u0001\u001e=\u0011\t\tM%\u0011T\u0007\u0003\u0005+S1Aa&:\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\tm%Q\u0013\u0002\u0014\u000bRDWM]3v[R\u0013\u0018M\\:bGRLwN\\\u0001\u001a]>$\u0018NZ=OK^,\u00050Z2Ue\u0006t7/Y2uS>t7\u000fF\u0002V\u0005CCqAa))\u0001\u0004\u0011)+\u0001\u0006oK^,\u00050Z2UqN\u0004Ra\u001bBT\u0005#K1A!+v\u0005\r\u0019V-]\u0001\u0012]>$\u0018NZ=Ts:\u001c7\u000b^1si\u0016$GcA+\u00030\"9!\u0011W\u0015A\u0002\tM\u0016AC:z]\u000e\u001cF/\u0019;vgB!!Q\u0017B^\u001b\t\u00119LC\u0002\u0003:n\nqA\\3uo>\u00148.\u0003\u0003\u0003>\n]&AC*z]\u000e\u001cF/\u0019;vg\u0006\tbn\u001c;jMf\u001c\u0016P\\2Ti>\u0004\b/\u001a3\u0015\u0003U\u000b1\u0003\u001d:pG\u0016\u001c8O\u00117pG.\u0014VmY3jaR$2!\u0016Bd\u0011\u001d\u0011ih\u000ba\u0001\u0005\u007f\n!c]3oIR\u0013\u0018M\\:bGRLwN\u001c'pOR)QK!4\u0003T\"9!q\u001a\u0017A\u0002\tE\u0017A\u0002;y\u0019><7\u000fE\u0003l\u0005O\u00139\u0006C\u0004\u0003V2\u0002\r!a=\u0002\u0019M,(m]2sSB$\u0018n\u001c8\u0002\u001d=tg+Y;mi\u000eC\u0017M\\4fI\u00069\u0012\r\u001a3OK^DU-\u00193t'V\u00147o\u0019:jaRLwN\u001c\u000b\u0004+\nu\u0007b\u0002Bk]\u0001\u0007\u0011qZ\u0001&C\u0012$g*Z<QK:$\u0017N\\4Ue\u0006t7/Y2uS>t7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:$2!\u0016Br\u0011\u001d\u0011)n\fa\u0001\u0003\u001f\f1#\u00193e\u0019><7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:$2!\u0016Bu\u0011\u001d\u0011)\u000e\ra\u0001\u0003g\fa#\u00193e'ft7-\u001b8h'V\u00147o\u0019:jaRLwN\u001c\u000b\u0004+\n=\bb\u0002Bkc\u0001\u0007\u0011qZ\u0001\u0013e\u0016lwN^3Tk\n\u001c8M]5qi&|g\u000e\u0006\u0003\u0002B\tU\bb\u0002B|e\u0001\u0007\u0011qM\u0001\u0017gV\u00147o\u0019:jaRLwN\\%e)>\u0014V-\\8wK\u0006i!/Z7pm\u0016\u001cVm]:j_:$2!\u0016B\u007f\u0011\u0015I6\u00071\u0001[\u0003\u0011\u0019XM\u001c3\u0015\u000bU\u001b\u0019aa\u0005\t\u000f\r\u0015A\u00071\u0001\u0004\b\u0005\tr/\u001a2t_\u000e\\W\r\u001e*fgB|gn]3\u0011\t\r%1qB\u0007\u0003\u0007\u0017QAa!\u0004\u0002p\u0005!A.\u00198h\u0013\u0011\u0019\tba\u0003\u0003\r=\u0013'.Z2u\u0011\u0015IF\u00071\u0001[\u0003=\u0019XM\u001c3Sa\u000e\u0014Vm\u001d9p]N,G#B+\u0004\u001a\ru\u0001bBB\u000ek\u0001\u00071qA\u0001\feB\u001c'+Z:q_:\u001cX\rC\u0003Zk\u0001\u0007!\f")
public class WebSocketAccountServerEndpoint
implements SparkzLogging {
    private final Logger logger;

    public static void sendRpcResponse(Object object, Session session) {
        WebSocketAccountServerEndpoint$.MODULE$.sendRpcResponse(object, session);
    }

    public static void send(Object object, Session session) {
        WebSocketAccountServerEndpoint$.MODULE$.send(object, session);
    }

    public static void removeSession(Session session) {
        WebSocketAccountServerEndpoint$.MODULE$.removeSession(session);
    }

    public static boolean removeSubscription(BigInteger bigInteger) {
        return WebSocketAccountServerEndpoint$.MODULE$.removeSubscription(bigInteger);
    }

    public static void addSyncingSubscription(Subscription subscription) {
        WebSocketAccountServerEndpoint$.MODULE$.addSyncingSubscription(subscription);
    }

    public static void addLogsSubscription(SubscriptionWithFilter subscriptionWithFilter) {
        WebSocketAccountServerEndpoint$.MODULE$.addLogsSubscription(subscriptionWithFilter);
    }

    public static void addNewPendingTransactionsSubscription(Subscription subscription) {
        WebSocketAccountServerEndpoint$.MODULE$.addNewPendingTransactionsSubscription(subscription);
    }

    public static void addNewHeadsSubscription(Subscription subscription) {
        WebSocketAccountServerEndpoint$.MODULE$.addNewHeadsSubscription(subscription);
    }

    public static void onVaultChanged() {
        WebSocketAccountServerEndpoint$.MODULE$.onVaultChanged();
    }

    public static void notifySyncStopped() {
        WebSocketAccountServerEndpoint$.MODULE$.notifySyncStopped();
    }

    public static void notifySyncStarted(SyncStatus syncStatus) {
        WebSocketAccountServerEndpoint$.MODULE$.notifySyncStarted(syncStatus);
    }

    public static void notifyNewExecTransactions(Seq<EthereumTransaction> seq) {
        WebSocketAccountServerEndpoint$.MODULE$.notifyNewExecTransactions(seq);
    }

    public static void notifyNewPendingTransaction(EthereumTransaction ethereumTransaction) {
        WebSocketAccountServerEndpoint$.MODULE$.notifyNewPendingTransaction(ethereumTransaction);
    }

    public static void notifySemanticallySuccessfulModifier(AccountBlock accountBlock) {
        WebSocketAccountServerEndpoint$.MODULE$.notifySemanticallySuccessfulModifier(accountBlock);
    }

    public static WebSocketAccountChannelImpl webSocketAccountChannelImpl() {
        return WebSocketAccountServerEndpoint$.MODULE$.webSocketAccountChannelImpl();
    }

    public static void syncingSubscriptions_$eq(List<Subscription> list) {
        WebSocketAccountServerEndpoint$.MODULE$.syncingSubscriptions_$eq(list);
    }

    public static List<Subscription> syncingSubscriptions() {
        return WebSocketAccountServerEndpoint$.MODULE$.syncingSubscriptions();
    }

    public static void logsSubscriptions_$eq(List<SubscriptionWithFilter> list) {
        WebSocketAccountServerEndpoint$.MODULE$.logsSubscriptions_$eq(list);
    }

    public static List<SubscriptionWithFilter> logsSubscriptions() {
        return WebSocketAccountServerEndpoint$.MODULE$.logsSubscriptions();
    }

    public static void newPendingTransactionsSubscriptions_$eq(List<Subscription> list) {
        WebSocketAccountServerEndpoint$.MODULE$.newPendingTransactionsSubscriptions_$eq(list);
    }

    public static List<Subscription> newPendingTransactionsSubscriptions() {
        return WebSocketAccountServerEndpoint$.MODULE$.newPendingTransactionsSubscriptions();
    }

    public static void newHeadsSubscriptions_$eq(List<Subscription> list) {
        WebSocketAccountServerEndpoint$.MODULE$.newHeadsSubscriptions_$eq(list);
    }

    public static List<Subscription> newHeadsSubscriptions() {
        return WebSocketAccountServerEndpoint$.MODULE$.newHeadsSubscriptions();
    }

    public static void subscriptionCounter_$eq(AtomicInteger atomicInteger) {
        WebSocketAccountServerEndpoint$.MODULE$.subscriptionCounter_$eq(atomicInteger);
    }

    public static AtomicInteger subscriptionCounter() {
        return WebSocketAccountServerEndpoint$.MODULE$.subscriptionCounter();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @OnClose
    public void onClose(Session session) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug(new StringBuilder(25).append("Websocket session closed ").append(session.getId()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        WebSocketAccountServerEndpoint$.MODULE$.removeSession(session);
    }

    @OnError
    public void onError(Session session, Throwable t) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isErrorEnabled()) {
            this.log().underlying().error(new StringBuilder(29).append("Error on websocket session ").append(session.getId()).append(": ").append(t.toString()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        WebSocketAccountServerEndpoint$.MODULE$.removeSession(session);
    }

    @OnMessage
    public void onMessageReceived(Session session, String message) {
        block15: {
            try {
                String response;
                boolean bl;
                RpcRequest rpcRequest = new RpcRequest(EthJsonMapper.getMapper().readTree(message));
                String string = rpcRequest.method;
                String string2 = SUBSCRIBE_REQUEST$.MODULE$.request();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    bl = true;
                } else {
                    String string4 = UNSUBSCRIBE_REQUEST$.MODULE$.request();
                    String string5 = string;
                    bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
                }
                if (bl) {
                    BoxedUnit boxedUnit;
                    if (this.badRpcRequestParams(rpcRequest.params)) {
                        BoxedUnit boxedUnit2;
                        if (this.log().underlying().isDebugEnabled()) {
                            this.log().underlying().debug("Missing or empty field params.");
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseError(rpcRequest.id, new RpcError(RpcCode.InvalidParams, "Missing or empty field params.", "")), session);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string6 = rpcRequest.method;
                        String string7 = SUBSCRIBE_REQUEST$.MODULE$.request();
                        String string8 = string6;
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            this.subscribe(session, rpcRequest);
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            String string9 = UNSUBSCRIBE_REQUEST$.MODULE$.request();
                            String string10 = string6;
                            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                this.unsubscribe(session, rpcRequest);
                                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                throw new MatchError((Object)string6);
                            }
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit5 = boxedUnit;
                    break block15;
                }
                Tuple2<String, Object> tuple2 = WebSocketAccountServerRef$.MODULE$.rpcProcessor().processEthRpc(new ObjectMapper().readTree(message));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String string11 = response = (String)tuple2._1();
                String response2 = string11;
                WebSocketAccountServerEndpoint$.MODULE$.sendRpcResponse(response2, session);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                BoxedUnit boxedUnit;
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseError((RpcId)this.tryGetRpcRequestId(message).orNull(Predef$.MODULE$.$conforms()), new RpcError(RpcCode.ExecutionError, "Websocket On receive message processing exception occurred", sw.toString())), session);
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(new StringBuilder(61).append("Websocket On receive message processing exception occurred = ").append(ex.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block15;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void subscribe(Session session, RpcRequest rpcRequest) {
        JsonNode rpcParams = rpcRequest.params;
        JsonNode subscribeMethod = rpcParams.get(0);
        String string = subscribeMethod.asText();
        String string2 = NEW_HEADS_SUBSCRIPTION$.MODULE$.method();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            BoxedUnit boxedUnit;
            BigInteger subscriptionId = this.createSubscriptionId();
            WebSocketAccountServerEndpoint$.MODULE$.addNewHeadsSubscription(new Subscription(session, subscriptionId));
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(new StringBuilder(29).append("New Subscription on newHeads ").append(session.getId()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseSuccess(rpcRequest.id, subscriptionId), session);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            String string4 = NEW_PENDING_TRANSACTIONS_SUBSCRIPTION$.MODULE$.method();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                BoxedUnit boxedUnit;
                BigInteger subscriptionId = this.createSubscriptionId();
                WebSocketAccountServerEndpoint$.MODULE$.addNewPendingTransactionsSubscription(new Subscription(session, subscriptionId));
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug(new StringBuilder(43).append("New Subscription on newPendingTransactions ").append(session.getId()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseSuccess(rpcRequest.id, subscriptionId), session);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else {
                String string6 = LOGS_SUBSCRIPTION$.MODULE$.method();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    BoxedUnit boxedUnit;
                    if (rpcParams.size() < 2) {
                        WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseError(rpcRequest.id, new RpcError(RpcCode.InvalidParams, "Missing filters (address, topics).", "")), session);
                    }
                    FilterQuery filterQuery = EthJsonMapper.deserialize(rpcParams.get(1).toString(), FilterQuery.class);
                    BigInteger subscriptionId = this.createSubscriptionId();
                    WebSocketAccountServerEndpoint$.MODULE$.addLogsSubscription(new SubscriptionWithFilter(session, subscriptionId, filterQuery));
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(25).append("New Subscription on logs ").append(session.getId()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseSuccess(rpcRequest.id, subscriptionId), session);
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    String string8 = SYNCING_SUBSCRIPTION$.MODULE$.method();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        BoxedUnit boxedUnit;
                        BigInteger subscriptionId = this.createSubscriptionId();
                        WebSocketAccountServerEndpoint$.MODULE$.addSyncingSubscription(new Subscription(session, subscriptionId));
                        if (this.log().underlying().isDebugEnabled()) {
                            this.log().underlying().debug(new StringBuilder(28).append("New Subscription on syncing ").append(session.getId()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseSuccess(rpcRequest.id, subscriptionId), session);
                        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit;
                        WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseError(rpcRequest.id, new RpcError(RpcCode.InvalidParams, new StringBuilder(30).append("unsupported subscription type ").append(string).toString(), "")), session);
                        if (this.log().underlying().isDebugEnabled()) {
                            this.log().underlying().debug(new StringBuilder(30).append("unsupported subscription type ").append(string).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit6 = boxedUnit;
                    }
                }
            }
        }
    }

    private void unsubscribe(Session session, RpcRequest rpcRequest) {
        BigInteger[] subscriptionIdsToRemove = EthJsonMapper.deserialize(rpcRequest.params.toString(), BigInteger[].class);
        boolean removedSubscription = WebSocketAccountServerEndpoint$.MODULE$.removeSubscription(subscriptionIdsToRemove[0]);
        if (!removedSubscription) {
            WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseError(rpcRequest.id, new RpcError(RpcCode.InvalidParams, "Subscription ID not found.", "")), session);
        } else {
            WebSocketAccountServerEndpoint$.MODULE$.send(new RpcResponseSuccess(rpcRequest.id, BoxesRunTime.boxToBoolean((boolean)true)), session);
        }
    }

    private boolean badRpcRequestParams(JsonNode rpcParams) {
        return rpcParams == null || !rpcParams.isArray() || rpcParams.size() < 1;
    }

    private BigInteger createSubscriptionId() {
        return BigInteger.valueOf(WebSocketAccountServerEndpoint$.MODULE$.subscriptionCounter().incrementAndGet());
    }

    /*
     * WARNING - void declaration
     */
    private Option<RpcId> tryGetRpcRequestId(String message) {
        void var2_2;
        BoxedUnit boxedUnit;
        Option rpcId = Option$.MODULE$.empty();
        try {
            JsonNode rpcRequest = EthJsonMapper.getMapper().readTree(message);
            if (rpcRequest.has("id")) {
                rpcId = Option$.MODULE$.apply((Object)new RpcId(rpcRequest.get("id")));
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable ex) {
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error("Missing id field in websocket request");
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public WebSocketAccountServerEndpoint() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

