/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.BigIntegerUInt256;
import io.horizen.account.utils.EthereumTransactionUtils;
import io.horizen.account.utils.RlpStreamDecoder;
import io.horizen.utils.BytesUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.utils.Numeric;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.VLQByteBufferReader;

public class EthereumTransactionDecoder {
    private EthereumTransactionDecoder() {
    }

    public static EthereumTransaction decode(String hexTransaction) {
        return EthereumTransactionDecoder.decode(Numeric.hexStringToByteArray((String)hexTransaction));
    }

    public static EthereumTransaction decode(byte[] transaction) {
        VLQByteBufferReader reader = new VLQByteBufferReader(ByteBuffer.wrap(transaction));
        EthereumTransaction tx = EthereumTransactionDecoder.decode((Reader)reader);
        int size = reader.remaining();
        if (size > 0) {
            byte[] trailingBytes = reader.getBytes(size);
            throw new IllegalArgumentException("Spurious bytes found in byte stream after obj parsing: [" + BytesUtils.toHexString(trailingBytes) + "]...");
        }
        return tx;
    }

    public static EthereumTransaction decode(Reader reader) {
        byte[] dataByte = new byte[]{reader.peekByte()};
        return EthereumTransactionDecoder.getTransactionType(dataByte) == TransactionType.EIP1559 ? EthereumTransactionDecoder.decodeEIP1559Transaction(reader) : EthereumTransactionDecoder.decodeLegacyTransaction(reader);
    }

    private static TransactionType getTransactionType(byte[] transaction) {
        byte firstByte = transaction[0];
        return firstByte == TransactionType.EIP1559.getRlpType() ? TransactionType.EIP1559 : TransactionType.LEGACY;
    }

    private static EthereumTransaction decodeEIP1559Transaction(Reader reader) {
        reader.getByte();
        RlpList rlpList = RlpStreamDecoder.decode(reader);
        return EthereumTransactionDecoder.RlpList2EIP1559Transaction(rlpList);
    }

    private static EthereumTransaction RlpList2EIP1559Transaction(RlpList rlpList) {
        RlpList values = (RlpList)rlpList.getValues().get(0);
        if (values.getValues().size() != 12) {
            throw new IllegalArgumentException("Error while decoding the EIP1559 tx bytes, unexpected number of values in rlp list: " + values.getValues().size());
        }
        long chainId = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(0), "chainId").longValueExact();
        BigInteger nonce = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(1), "gasNonce");
        BigInteger maxPriorityFeePerGas = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(2), "maxPriorityFeePerGas");
        BigInteger maxFeePerGas = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(3), "maxFeePerGas");
        BigInteger gasLimit = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(4), "gasLimit");
        byte[] toBytes = ((RlpString)values.getValues().get(5)).getBytes();
        Optional<AddressProposition> optTo = EthereumTransactionUtils.getToAddressFromBytes(toBytes);
        BigInteger value = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(6), "value");
        byte[] dataBytes = ((RlpString)values.getValues().get(7)).getBytes();
        if (((RlpList)values.getValues().get(8)).getValues().size() > 0) {
            throw new IllegalArgumentException("Access list is not supported");
        }
        BigInteger vOrig = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(9), "sig_v");
        BigInteger v = EthereumTransactionDecoder.getVFromRecId(vOrig);
        BigInteger r = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(10), "sig_r");
        BigInteger s = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(11), "sig_s");
        SignatureSecp256k1 realSignature = r.equals(BigInteger.ZERO) && s.equals(BigInteger.ZERO) ? null : new SignatureSecp256k1(v, r, s);
        return new EthereumTransaction(chainId, optTo, nonce, gasLimit, maxPriorityFeePerGas, maxFeePerGas, value, dataBytes, realSignature);
    }

    private static EthereumTransaction decodeLegacyTransaction(Reader reader) {
        RlpList rlpList = RlpStreamDecoder.decode(reader);
        return EthereumTransactionDecoder.RlpList2LegacyTransaction(rlpList);
    }

    private static BigInteger getCheckedValue(RlpString rawValueString, String fieldName) {
        byte[] rawValueBytes = rawValueString.getBytes();
        if (rawValueBytes.length > 1 && rawValueBytes[0] == 0) {
            throw new IllegalArgumentException("Error while rlp decoding payload of legacy tx, " + fieldName + " value has leading zero in rlp encoding: " + BytesUtils.toHexString(rawValueBytes));
        }
        return new BigIntegerUInt256(rawValueBytes).getBigInt();
    }

    private static EthereumTransaction RlpList2LegacyTransaction(RlpList rlpList) {
        SignatureSecp256k1 realSignature;
        long chainId;
        RlpList values = (RlpList)rlpList.getValues().get(0);
        if (values.getValues().size() != 9) {
            throw new IllegalArgumentException("Error while rlp decoding payload of legacy tx, unexpected number of values in rlp list: " + values.getValues().size());
        }
        BigInteger nonce = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(0), "gasNonce");
        BigInteger gasPrice = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(1), "gasPrice");
        BigInteger gasLimit = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(2), "gasLimit");
        byte[] toBytes = ((RlpString)values.getValues().get(3)).getBytes();
        Optional<AddressProposition> optTo = EthereumTransactionUtils.getToAddressFromBytes(toBytes);
        BigInteger value = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(4), "value");
        byte[] dataBytes = ((RlpString)values.getValues().get(5)).getBytes();
        BigInteger v = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(6), "sig_v");
        BigInteger r = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(7), "sig_r");
        BigInteger s = EthereumTransactionDecoder.getCheckedValue((RlpString)values.getValues().get(8), "sig_s");
        if (r.equals(BigInteger.ZERO) && s.equals(BigInteger.ZERO)) {
            chainId = v.longValueExact();
            realSignature = null;
        } else {
            chainId = EthereumTransactionDecoder.decodeEip155ChainId(v);
            realSignature = new SignatureSecp256k1(EthereumTransactionUtils.getRealV(v), r, s);
        }
        if (chainId != 0L) {
            return new EthereumTransaction(chainId, optTo, nonce, gasPrice, gasLimit, value, dataBytes, realSignature);
        }
        return new EthereumTransaction(optTo, nonce, gasPrice, gasLimit, value, dataBytes, realSignature);
    }

    private static long decodeEip155ChainId(BigInteger bv) {
        long v = bv.longValueExact();
        if (v == 27L || v == 28L) {
            return 0L;
        }
        return (v - 35L) / 2L;
    }

    private static BigInteger getVFromRecId(BigInteger recId) {
        return recId.add(BigInteger.valueOf(27L));
    }

    public static enum TransactionType {
        LEGACY(null),
        EIP1559((byte)2);

        final Byte type;

        private TransactionType(Byte type) {
            this.type = type;
        }

        public Byte getRlpType() {
            return this.type;
        }

        public boolean isLegacy() {
            return this.equals((Object)LEGACY);
        }

        public boolean isEip1559() {
            return this.equals((Object)EIP1559);
        }
    }
}

