/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import akka.util.ByteString;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.proposition.AddressPropositionSerializer;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountBlockFeeInfo$;
import io.horizen.account.utils.BigIntegerUInt256;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.PublicKey25519PropositionSerializer;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.proposition.VrfPublicKeySerializer;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Serializer;
import sparkz.util.serialization.Writer;

public final class AccountBlockFeeInfoSerializer$
implements SparkzSerializer<AccountBlockFeeInfo> {
    public static AccountBlockFeeInfoSerializer$ MODULE$;

    static {
        new AccountBlockFeeInfoSerializer$();
    }

    public ByteString toByteString(Object obj) {
        return SparkzSerializer.toByteString$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseByteString(ByteString byteString) {
        return SparkzSerializer.parseByteString$((SparkzSerializer)this, (ByteString)byteString);
    }

    public Try<AccountBlockFeeInfo> parseByteStringTry(ByteString byteString) {
        return SparkzSerializer.parseByteStringTry$((SparkzSerializer)this, (ByteString)byteString);
    }

    public byte[] toBytes(Object obj) {
        return SparkzSerializer.toBytes$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseBytes(byte[] bytes) {
        return SparkzSerializer.parseBytes$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<AccountBlockFeeInfo> parseBytesTry(byte[] bytes) {
        return SparkzSerializer.parseBytesTry$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<AccountBlockFeeInfo> parseTry(Reader r) {
        return Serializer.parseTry$((Serializer)this, (Reader)r);
    }

    public void serialize(AccountBlockFeeInfo obj, Writer w) {
        byte[] baseFeeByteArray = obj.baseFee().toByteArray();
        w.putInt(baseFeeByteArray.length);
        w.putBytes(baseFeeByteArray);
        byte[] forgerTipsByteArray = obj.forgerTips().toByteArray();
        w.putInt(forgerTipsByteArray.length);
        w.putBytes(forgerTipsByteArray);
        AddressPropositionSerializer.getSerializer().serialize(obj.forgerAddress(), w);
        obj.forgerKeys().foreach((Function1 & Serializable & scala.Serializable)keys -> {
            AccountBlockFeeInfoSerializer$.$anonfun$serialize$1(w, keys);
            return BoxedUnit.UNIT;
        });
    }

    public AccountBlockFeeInfo parse(Reader r) {
        AccountBlockFeeInfo accountBlockFeeInfo;
        int baseFeeLength = r.getInt();
        BigInteger baseFee = new BigIntegerUInt256(r.getBytes(baseFeeLength)).getBigInt();
        int forgerTipsLength = r.getInt();
        BigInteger forgerTips = new BigIntegerUInt256(r.getBytes(forgerTipsLength)).getBigInt();
        AddressProposition forgerRewardKey = AddressPropositionSerializer.getSerializer().parse(r);
        int n = r.remaining();
        switch (n) {
            case 0: {
                accountBlockFeeInfo = new AccountBlockFeeInfo(baseFee, forgerTips, forgerRewardKey, AccountBlockFeeInfo$.MODULE$.apply$default$4());
                break;
            }
            default: {
                PublicKey25519Proposition blockSignPublicKey = PublicKey25519PropositionSerializer.getSerializer().parse(r);
                VrfPublicKey vrfPublicKey = VrfPublicKeySerializer.getSerializer().parse(r);
                accountBlockFeeInfo = new AccountBlockFeeInfo(baseFee, forgerTips, forgerRewardKey, (Option<ForgerPublicKeys>)new Some((Object)new ForgerPublicKeys(blockSignPublicKey, vrfPublicKey)));
                break;
            }
        }
        return accountBlockFeeInfo;
    }

    public static final /* synthetic */ void $anonfun$serialize$1(Writer w$1, ForgerPublicKeys keys) {
        PublicKey25519PropositionSerializer.getSerializer().serialize(keys.blockSignPublicKey(), w$1);
        VrfPublicKeySerializer.getSerializer().serialize(keys.vrfPublicKey(), w$1);
    }

    private AccountBlockFeeInfoSerializer$() {
        MODULE$ = this;
        Serializer.$init$((Serializer)this);
        SparkzSerializer.$init$((SparkzSerializer)this);
    }
}

