/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state.nativescdata.forgerstakev2;

import io.horizen.account.network.ForgerInfo;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.nativescdata.forgerstakev2.ForgerMap$;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersListResponse;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedStakesByDelegatorResponse;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedStakesByForgerResponse;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeCheckpoint;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeDataDelegator;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeDataForger;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStartCmdOutput;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStorage;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStorage$ForgerKey$;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStorage$ForgerStakeHistory$;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeTotalCmdOutput;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.Address;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableViewLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sparkz.crypto.hash.Blake2b256$;

public final class StakeStorage$ {
    public static StakeStorage$ MODULE$;
    private final Address ACCOUNT;
    private final byte[] ActivationKey;

    static {
        new StakeStorage$();
    }

    public Address ACCOUNT() {
        return this.ACCOUNT;
    }

    public byte[] ActivationKey() {
        return this.ActivationKey;
    }

    public boolean isActive(BaseAccountStateView view) {
        byte[] activated = view.getAccountStorage(this.ACCOUNT(), this.ActivationKey());
        return BoxesRunTime.equalsNumNum((Number)new BigInteger(1, activated), (Number)BigInteger.ONE);
    }

    public void setActive(BaseAccountStateView view) {
        byte[] activated = BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.ONE);
        view.updateAccountStorage(this.ACCOUNT(), this.ActivationKey(), activated);
    }

    public void addForger(BaseAccountStateView view, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, int rewardShare, Address rewardAddress, int epochNumber, Address delegatorPublicKey, BigInteger stakedAmount) {
        StakeStorage.ForgerKey forgerKey = StakeStorage$ForgerKey$.MODULE$.apply(blockSignProposition, vrfPublicKey);
        if (ForgerMap$.MODULE$.existsForger(view, forgerKey)) {
            throw new ExecutionRevertedException("Forger already registered.");
        }
        ForgerMap$.MODULE$.addForger(view, forgerKey, blockSignProposition, vrfPublicKey, rewardShare, rewardAddress);
        StakeStorage.ForgerStakeHistory forgerHistory = new StakeStorage.ForgerStakeHistory(forgerKey);
        forgerHistory.addCheckpoint(view, epochNumber, stakedAmount);
        StakeStorage.DelegatorKey delegatorChkSumAddress = new StakeStorage.DelegatorKey(delegatorPublicKey);
        StakeStorage.StakeHistory stakeHistory = new StakeStorage.StakeHistory(forgerKey, delegatorChkSumAddress);
        stakeHistory.addCheckpoint(view, epochNumber, stakedAmount);
        this.addNewDelegator(view, forgerKey, delegatorChkSumAddress);
    }

    public void updateForger(BaseAccountStateView view, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, int rewardShare, Address rewardAddress) {
        StakeStorage.ForgerKey forgerKey;
        block3: {
            block2: {
                forgerKey = StakeStorage$ForgerKey$.MODULE$.apply(blockSignProposition, vrfPublicKey);
                ForgerInfo forger = (ForgerInfo)ForgerMap$.MODULE$.getForgerOption(view, forgerKey).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new ExecutionRevertedException("Forger doesn't exist.");
                });
                if (forger.rewardShare() > 0) break block2;
                Address address = forger.rewardAddress().address();
                Address address2 = Address.ZERO;
                if (!(address == null ? address2 != null : !address.equals(address2))) break block3;
            }
            throw new ExecutionRevertedException("Forger has already set reward share and reward address.");
        }
        ForgerMap$.MODULE$.updateForger(view, forgerKey, blockSignProposition, vrfPublicKey, rewardShare, rewardAddress);
    }

    private void addNewDelegator(BaseAccountStateView view, StakeStorage.ForgerKey forgerKey, StakeStorage.DelegatorKey delegator) {
        StakeStorage.DelegatorList listOfDelegators = new StakeStorage.DelegatorList(forgerKey);
        listOfDelegators.addDelegator(view, delegator);
        StakeStorage.DelegatorListOfForgerKeys listOfForgers = new StakeStorage.DelegatorListOfForgerKeys(delegator);
        listOfForgers.addForgerKey(view, forgerKey);
    }

    public PagedForgersListResponse getPagedListOfForgers(BaseAccountStateView view, int startPos, int pageSize) {
        return ForgerMap$.MODULE$.getPagedListOfForgers(view, startPos, pageSize);
    }

    public Option<ForgerInfo> getForger(BaseAccountStateView view, PublicKey25519Proposition signKey, VrfPublicKey vrfKey) {
        StakeStorage.ForgerKey forgerKey = StakeStorage$ForgerKey$.MODULE$.apply(signKey, vrfKey);
        return ForgerMap$.MODULE$.getForgerOption(view, forgerKey);
    }

    public void addStake(BaseAccountStateView view, PublicKey25519Proposition signKey, VrfPublicKey vrfPublicKey, int epochNumber, Address delegatorPublicKey, BigInteger stakedAmount) {
        block1: {
            StakeStorage.ForgerKey forgerKey = StakeStorage$ForgerKey$.MODULE$.apply(signKey, vrfPublicKey);
            StakeStorage.ForgerStakeHistory forgerHistory = new StakeStorage.ForgerStakeHistory(forgerKey);
            int forgerHistorySize = forgerHistory.getSize(view);
            if (forgerHistorySize == 0) {
                throw new ExecutionRevertedException("Forger doesn't exist.");
            }
            Function1 & Serializable & scala.Serializable addToStake = (Function1 & Serializable & scala.Serializable)latestStake -> latestStake.add(stakedAmount);
            forgerHistory.updateOrAddCheckpoint(view, forgerHistorySize, epochNumber, (Function1<BigInteger, BigInteger>)addToStake);
            StakeStorage.DelegatorKey delegatorChkSumAddress = new StakeStorage.DelegatorKey(delegatorPublicKey);
            StakeStorage.StakeHistory stakeHistory = new StakeStorage.StakeHistory(forgerKey, delegatorChkSumAddress);
            int stakeHistorySize = stakeHistory.getSize(view);
            stakeHistory.updateOrAddCheckpoint(view, stakeHistorySize, epochNumber, (Function1<BigInteger, BigInteger>)addToStake);
            if (stakeHistorySize != 0) break block1;
            this.addNewDelegator(view, forgerKey, delegatorChkSumAddress);
        }
    }

    public void removeStake(BaseAccountStateView view, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, int epochNumber, Address delegatorPublicKey, BigInteger stakedAmount) {
        StakeStorage.ForgerKey forgerKey = StakeStorage$ForgerKey$.MODULE$.apply(blockSignProposition, vrfPublicKey);
        StakeStorage.ForgerStakeHistory forgerHistory = new StakeStorage.ForgerStakeHistory(forgerKey);
        int forgerHistorySize = forgerHistory.getSize(view);
        if (forgerHistorySize == 0) {
            throw new ExecutionRevertedException("Forger doesn't exist.");
        }
        StakeStorage.DelegatorKey delegatorChkSumAddress = new StakeStorage.DelegatorKey(delegatorPublicKey);
        StakeStorage.StakeHistory stakeHistory = new StakeStorage.StakeHistory(forgerKey, delegatorChkSumAddress);
        int stakeHistorySize = stakeHistory.getSize(view);
        if (stakeHistorySize == 0) {
            throw new ExecutionRevertedException(new StringBuilder(46).append("Delegator ").append(BytesUtils.toHexString(delegatorChkSumAddress.toBytes())).append(" doesn't have stake with the forger.").toString());
        }
        stakeHistory.updateOrAddCheckpoint(view, stakeHistorySize, epochNumber, (Function1<BigInteger, BigInteger>)(Function1 & Serializable & scala.Serializable)latestStake -> StakeStorage$.subtractStake$1(latestStake, stakedAmount));
        forgerHistory.updateOrAddCheckpoint(view, forgerHistorySize, epochNumber, (Function1<BigInteger, BigInteger>)(Function1 & Serializable & scala.Serializable)latestStake -> StakeStorage$.subtractStake$1(latestStake, stakedAmount));
    }

    public Seq<ForgingStakeInfo> getForgingStakes(BaseAccountStateView view) {
        Seq<StakeStorage.ForgerKey> listOfForgerKeys = ForgerMap$.MODULE$.getForgerKeys(view);
        return (Seq)listOfForgerKeys.map((Function1 & Serializable & scala.Serializable)forgerKey -> {
            ForgerInfo forger = ForgerMap$.MODULE$.getForger(view, (StakeStorage.ForgerKey)forgerKey);
            BigInteger amount = new StakeStorage.ForgerStakeHistory((StakeStorage.ForgerKey)forgerKey).getLatestAmount(view);
            return new ForgingStakeInfo(forger.forgerPublicKeys().blockSignPublicKey(), forger.forgerPublicKeys().vrfPublicKey(), ZenWeiConverter$.MODULE$.convertWeiToZennies(amount));
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<ForgerStakeData> getAllForgerStakes(BaseAccountStateView view) {
        Seq<StakeStorage.ForgerKey> listOfForgerKeys = ForgerMap$.MODULE$.getForgerKeys(view);
        return (Seq)listOfForgerKeys.flatMap((Function1 & Serializable & scala.Serializable)forgerKey -> {
            ForgerInfo forger = ForgerMap$.MODULE$.getForger(view, (StakeStorage.ForgerKey)forgerKey);
            StakeStorage.DelegatorList delegatorList = new StakeStorage.DelegatorList((StakeStorage.ForgerKey)forgerKey);
            int delegatorSize = delegatorList.getSize(view);
            ListBuffer listOfStakes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), delegatorSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                block0: {
                    StakeStorage.DelegatorKey delegator = delegatorList.getDelegatorAt(view, idx);
                    StakeStorage.StakeHistory stakeHistory = new StakeStorage.StakeHistory((StakeStorage.ForgerKey)forgerKey, delegator);
                    BigInteger amount = stakeHistory.getLatestAmount(view);
                    if (amount.signum() != 1) break block0;
                    listOfStakes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ForgerStakeData[]{new ForgerStakeData(forger.forgerPublicKeys(), new AddressProposition(delegator), amount)}));
                }
            });
            return listOfStakes;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public StakeStartCmdOutput getStakeStart(BaseAccountStateView view, ForgerPublicKeys forgerKeys, Address delegator) {
        StakeStorage.DelegatorKey delegatorKey;
        StakeStorage.ForgerKey forgerKey = StakeStorage$ForgerKey$.MODULE$.apply(forgerKeys.blockSignPublicKey(), forgerKeys.vrfPublicKey());
        StakeStorage.StakeHistory stakeHistory = new StakeStorage.StakeHistory(forgerKey, delegatorKey = new StakeStorage.DelegatorKey(delegator));
        return stakeHistory.getSize(view) == 0 ? new StakeStartCmdOutput(-1) : new StakeStartCmdOutput(stakeHistory.getCheckpoint(view, 0).fromEpochNumber());
    }

    public StakeTotalCmdOutput getStakeTotal(BaseAccountStateView view, Option<ForgerPublicKeys> forgerKeys, Option<Address> delegator, int consensusEpochStart, int consensusEpochEnd) {
        StakeTotalCmdOutput stakeTotalCmdOutput;
        Option<ForgerPublicKeys> option = forgerKeys;
        if (option instanceof Some) {
            StakeStorage.BaseStakeHistory baseStakeHistory;
            Some some = (Some)option;
            ForgerPublicKeys forgerKeys2 = (ForgerPublicKeys)some.value();
            StakeStorage.ForgerKey forgerKey = StakeStorage$ForgerKey$.MODULE$.apply(forgerKeys2.blockSignPublicKey(), forgerKeys2.vrfPublicKey());
            Option<Address> option2 = delegator;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Address address = (Address)some2.value();
                baseStakeHistory = new StakeStorage.StakeHistory(forgerKey, new StakeStorage.DelegatorKey(address));
            } else if (None$.MODULE$.equals(option2)) {
                baseStakeHistory = new StakeStorage.ForgerStakeHistory(forgerKey);
            } else {
                throw new MatchError(option2);
            }
            StakeStorage.ForgerStakeHistory history2 = baseStakeHistory;
            stakeTotalCmdOutput = new StakeTotalCmdOutput(this.getForgerStakesPerEpoch(view, history2, consensusEpochStart, consensusEpochEnd));
        } else if (None$.MODULE$.equals(option)) {
            Seq totalStakesPerEpoch = (Seq)((TraversableLike)((GenericTraversableTemplate)((TraversableLike)ForgerMap$.MODULE$.getForgerKeys(view).map((Function1)StakeStorage$ForgerStakeHistory$.MODULE$, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)history -> MODULE$.getForgerStakesPerEpoch(view, (StakeStorage.BaseStakeHistory)history, consensusEpochStart, consensusEpochEnd), Seq$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)stakes -> (BigInteger)stakes.foldLeft((Object)BigInteger.ZERO, (Function2 & Serializable & scala.Serializable)(a, b) -> a.add((BigInteger)b)), Seq$.MODULE$.canBuildFrom());
            stakeTotalCmdOutput = new StakeTotalCmdOutput((Seq<BigInteger>)totalStakesPerEpoch);
        } else {
            throw new MatchError(option);
        }
        return stakeTotalCmdOutput;
    }

    public Seq<BigInteger> getForgerStakesPerEpoch(BaseAccountStateView view, StakeStorage.BaseStakeHistory history, int consensusEpochStart, int consensusEpochEnd) {
        Seq seq;
        Object object = new Object();
        try {
            if (history.getCheckpoint(view, 0).fromEpochNumber() > consensusEpochEnd) {
                return (Seq)List$.MODULE$.fill(consensusEpochEnd - consensusEpochStart + 1, (Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO);
            }
            IntRef currIndex = IntRef.create((int)this.checkpointBSearch(view, history, consensusEpochEnd));
            ObjectRef currCheckpoint = ObjectRef.create((Object)history.getCheckpoint(view, currIndex.elem));
            ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(consensusEpochEnd), consensusEpochStart).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)currEpoch -> {
                block2: {
                    result.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigInteger[]{((StakeCheckpoint)currCheckpoint$1.elem).stakedAmount()}));
                    if (((StakeCheckpoint)currCheckpoint$1.elem).fromEpochNumber() != currEpoch) break block2;
                    --currIndex$1.elem;
                    if (currIndex$1.elem == -1) {
                        throw new NonLocalReturnControl(object, ((List)List$.MODULE$.fill(currEpoch - consensusEpochStart, (Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO)).$plus$plus((GenTraversableOnce)result, List$.MODULE$.canBuildFrom()));
                    }
                    if (currEpoch != consensusEpochStart) {
                        currCheckpoint$1.elem = history.getCheckpoint(view, currIndex$1.elem);
                    }
                }
            });
            seq = result;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public int checkpointBSearch(BaseAccountStateView view, StakeStorage.BaseStakeHistory history, int epoch) {
        int length = history.getSize(view);
        int low = 0;
        int high = length;
        int mid = 0;
        if (length > 5) {
            mid = high - (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(Math.sqrt(high)));
            int checkpointEpochNumber = history.getCheckpoint(view, mid).fromEpochNumber();
            if (checkpointEpochNumber == epoch) {
                return mid;
            }
            if (checkpointEpochNumber > epoch) {
                high = mid;
            } else {
                low = mid + 1;
            }
        }
        while (low < high) {
            mid = (high + low) / 2;
            int checkpointEpochNumber = history.getCheckpoint(view, mid).fromEpochNumber();
            if (checkpointEpochNumber == epoch) {
                return mid;
            }
            if (checkpointEpochNumber > epoch) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return high == 0 ? 0 : high - 1;
    }

    public PagedStakesByForgerResponse getPagedForgersStakesByForger(BaseAccountStateView view, ForgerPublicKeys forger, int startPos, int pageSize) {
        if (startPos < 0) {
            throw new IllegalArgumentException(new StringBuilder(45).append("Negative start position: ").append(startPos).append(" can not be negative").toString());
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Invalid page size ").append(pageSize).append(", must be positive").toString());
        }
        StakeStorage.ForgerKey forgerKey = StakeStorage$ForgerKey$.MODULE$.apply(forger.blockSignPublicKey(), forger.vrfPublicKey());
        StakeStorage.DelegatorList listOfDelegators = new StakeStorage.DelegatorList(forgerKey);
        int numOfDelegators = listOfDelegators.getSize(view);
        if (startPos == 0 && numOfDelegators == 0) {
            return new PagedStakesByForgerResponse(-1, (Seq<StakeDataDelegator>)((Seq)Nil$.MODULE$));
        }
        if (startPos > numOfDelegators - 1) {
            throw new IllegalArgumentException(new StringBuilder(76).append("Invalid start position reading list of delegators: ").append(startPos).append(", delegators array size: ").append(numOfDelegators).toString());
        }
        int endPos = startPos + pageSize;
        if (endPos > numOfDelegators) {
            endPos = numOfDelegators;
        }
        List resultList = ((TraversableViewLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPos), endPos).view().map((Function1 & Serializable & scala.Serializable)index -> StakeStorage$.$anonfun$getPagedForgersStakesByForger$1(listOfDelegators, view, forgerKey, BoxesRunTime.unboxToInt((Object)index)), SeqView$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StakeStorage$.$anonfun$getPagedForgersStakesByForger$2(x$1))).toList();
        if (endPos == numOfDelegators) {
            endPos = -1;
        }
        return new PagedStakesByForgerResponse(endPos, (Seq<StakeDataDelegator>)resultList);
    }

    public PagedStakesByDelegatorResponse getPagedForgersStakesByDelegator(BaseAccountStateView view, Address delegator, int startPos, int pageSize) {
        if (startPos < 0) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Negative start position: ").append(startPos).toString());
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Invalid page size ").append(pageSize).append(", must be positive").toString());
        }
        StakeStorage.DelegatorKey delegatorKey = new StakeStorage.DelegatorKey(delegator);
        StakeStorage.DelegatorListOfForgerKeys listOfForgers = new StakeStorage.DelegatorListOfForgerKeys(delegatorKey);
        int numOfForgers = listOfForgers.getSize(view);
        if (startPos == 0 && numOfForgers == 0) {
            return new PagedStakesByDelegatorResponse(-1, (Seq<StakeDataForger>)((Seq)Nil$.MODULE$));
        }
        if (startPos > numOfForgers - 1) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Invalid start position reading list of forgers: ").append(startPos).append(", forgers array size: ").append(numOfForgers).toString());
        }
        int endPos = startPos + pageSize;
        if (endPos > numOfForgers) {
            endPos = numOfForgers;
        }
        List resultList = ((TraversableViewLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPos), endPos).view().map((Function1 & Serializable & scala.Serializable)index -> StakeStorage$.$anonfun$getPagedForgersStakesByDelegator$1(listOfForgers, view, delegatorKey, BoxesRunTime.unboxToInt((Object)index)), SeqView$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StakeStorage$.$anonfun$getPagedForgersStakesByDelegator$3(x$2))).toList();
        if (endPos == numOfForgers) {
            endPos = -1;
        }
        return new PagedStakesByDelegatorResponse(endPos, (Seq<StakeDataForger>)resultList);
    }

    /*
     * WARNING - void declaration
     */
    private static final BigInteger subtractStake$1(BigInteger latestStake, BigInteger stakedAmount$2) {
        void var2_2;
        BigInteger newAmount = latestStake.subtract(stakedAmount$2);
        if (newAmount.signum() == -1) {
            throw new ExecutionRevertedException(new StringBuilder(38).append("Not enough stake. Claimed ").append(stakedAmount$2).append(", available ").append(latestStake).toString());
        }
        return var2_2;
    }

    public static final /* synthetic */ StakeDataDelegator $anonfun$getPagedForgersStakesByForger$1(StakeStorage.DelegatorList listOfDelegators$1, BaseAccountStateView view$5, StakeStorage.ForgerKey forgerKey$2, int index) {
        StakeStorage.DelegatorKey delegatorKey = listOfDelegators$1.getDelegatorAt(view$5, index);
        StakeStorage.StakeHistory stakeHistory = new StakeStorage.StakeHistory(forgerKey$2, delegatorKey);
        BigInteger amount = stakeHistory.getLatestAmount(view$5);
        return new StakeDataDelegator(new AddressProposition(delegatorKey), amount);
    }

    public static final /* synthetic */ boolean $anonfun$getPagedForgersStakesByForger$2(StakeDataDelegator x$1) {
        return x$1.stakedAmount().signum() > 0;
    }

    public static final /* synthetic */ StakeDataForger $anonfun$getPagedForgersStakesByDelegator$1(StakeStorage.DelegatorListOfForgerKeys listOfForgers$1, BaseAccountStateView view$6, StakeStorage.DelegatorKey delegatorKey$1, int index) {
        StakeStorage.ForgerKey forgerKey = listOfForgers$1.getForgerKey(view$6, index);
        ForgerInfo forger = (ForgerInfo)ForgerMap$.MODULE$.getForgerOption(view$6, forgerKey).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("Forger doesn't exist.");
        });
        StakeStorage.StakeHistory stakeHistory = new StakeStorage.StakeHistory(forgerKey, delegatorKey$1);
        BigInteger amount = stakeHistory.getLatestAmount(view$6);
        return new StakeDataForger(forger.forgerPublicKeys(), amount);
    }

    public static final /* synthetic */ boolean $anonfun$getPagedForgersStakesByDelegator$3(StakeDataForger x$2) {
        return x$2.stakedAmount().signum() > 0;
    }

    private StakeStorage$() {
        MODULE$ = this;
        this.ACCOUNT = WellKnownAddresses$.MODULE$.FORGER_STAKE_V2_SMART_CONTRACT_ADDRESS();
        this.ActivationKey = Blake2b256$.MODULE$.hash("Activate");
    }
}

