/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.WithdrawalMsgProcessor$;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.evm.Address;
import java.math.BigInteger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import sparkz.crypto.hash.Blake2b256$;

@ScalaSignature(bytes="\u0006\u0001\t4Aa\u0004\t\u00013!A1\u0003\u0001BC\u0002\u0013\u0005\u0001\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003\"\u0011!A\u0003A!b\u0001\n\u0003I\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u000bE\u0002A\u0011\u0001\u001a\t\u000f]\u0002!\u0019!C\tS!1\u0001\b\u0001Q\u0001\n)BQ!\u000f\u0001\u0005\u0002iBQa\u0011\u0001\u0005\u0012\u0011CQa\u0013\u0001\u0005\u00021CQ\u0001\u0015\u0001\u0005\u0002ECQ!\u0016\u0001\u0005\u0002YCQa\u0017\u0001\u0005\u0002qCQa\u0018\u0001\u0005\n\u0001\u0014Ab\u0015;bi\u0016$%-\u0011:sCfT!!\u0005\n\u0002\u000bM$\u0018\r^3\u000b\u0005M!\u0012aB1dG>,h\u000e\u001e\u0006\u0003+Y\tq\u0001[8sSj,gNC\u0001\u0018\u0003\tIwn\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-F\u0001\"!\t\u0011S%D\u0001$\u0015\t!C#A\u0002fm6L!AJ\u0012\u0003\u000f\u0005#GM]3tg\u0006A\u0011mY2pk:$\b%A\u0004lKf\u001cV-\u001a3\u0016\u0003)\u00022aG\u0016.\u0013\taCDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001c]%\u0011q\u0006\b\u0002\u0005\u0005f$X-\u0001\u0005lKf\u001cV-\u001a3!\u0003\u0019a\u0014N\\5u}Q\u00191'\u000e\u001c\u0011\u0005Q\u0002Q\"\u0001\t\t\u000bM)\u0001\u0019A\u0011\t\u000b!*\u0001\u0019\u0001\u0016\u0002\u0019\t\f7/Z!se\u0006L8*Z=\u0002\u001b\t\f7/Z!se\u0006L8*Z=!\u0003\u001d9W\r^*ju\u0016$\"a\u000f \u0011\u0005ma\u0014BA\u001f\u001d\u0005\rIe\u000e\u001e\u0005\u0006\u007f!\u0001\r\u0001Q\u0001\u0005m&,w\u000f\u0005\u00025\u0003&\u0011!\t\u0005\u0002\u0015\u0005\u0006\u001cX-Q2d_VtGo\u0015;bi\u00164\u0016.Z<\u0002\u0015U\u0004H-\u0019;f'&TX\rF\u0002F\u0011&\u0003\"a\u0007$\n\u0005\u001dc\"\u0001B+oSRDQaP\u0005A\u0002\u0001CQAS\u0005A\u0002m\nqA\\3x'&TX-\u0001\u0004baB,g\u000e\u001a\u000b\u0004w5s\u0005\"B \u000b\u0001\u0004\u0001\u0005\"B(\u000b\u0001\u0004Q\u0013!\u0002<bYV,\u0017A\u0005:f[>4X-\u00118e%\u0016\f'O]1oO\u0016$2A\u000b*T\u0011\u0015y4\u00021\u0001A\u0011\u0015!6\u00021\u0001<\u0003\u0015Ig\u000eZ3y\u0003-)\b\u000fZ1uKZ\u000bG.^3\u0015\t\u0015;\u0006,\u0017\u0005\u0006\u007f1\u0001\r\u0001\u0011\u0005\u0006)2\u0001\ra\u000f\u0005\u000652\u0001\rAK\u0001\t]\u0016<h+\u00197vK\u0006Aq-\u001a;WC2,X\rF\u0002+;zCQaP\u0007A\u0002\u0001CQ\u0001V\u0007A\u0002m\n!bZ3u\u000b2,WnS3z)\tQ\u0013\rC\u0003U\u001d\u0001\u00071\b")
public class StateDbArray {
    private final Address account;
    private final byte[] keySeed;
    private final byte[] baseArrayKey;

    public Address account() {
        return this.account;
    }

    public byte[] keySeed() {
        return this.keySeed;
    }

    public byte[] baseArrayKey() {
        return this.baseArrayKey;
    }

    /*
     * WARNING - void declaration
     */
    public int getSize(BaseAccountStateView view) {
        void var2_2;
        int size = new BigInteger(1, view.getAccountStorage(this.account(), this.baseArrayKey())).intValueExact();
        return (int)var2_2;
    }

    public void updateSize(BaseAccountStateView view, int newSize) {
        byte[] paddedSize = BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.valueOf(newSize));
        view.updateAccountStorage(this.account(), this.baseArrayKey(), paddedSize);
    }

    /*
     * WARNING - void declaration
     */
    public int append(BaseAccountStateView view, byte[] value) {
        void var3_3;
        int numOfElem = this.getSize(view);
        byte[] key = this.getElemKey(numOfElem);
        view.updateAccountStorage(this.account(), key, value);
        this.updateSize(view, numOfElem + 1);
        return (int)var3_3;
    }

    public byte[] removeAndRearrange(BaseAccountStateView view, int index) {
        byte[] lastElemValue;
        block0: {
            Predef$.MODULE$.require(index >= 0, (Function0 & java.io.Serializable & Serializable)() -> "Index cannot be negative");
            int size = this.getSize(view);
            Predef$.MODULE$.require(index < size, (Function0 & java.io.Serializable & Serializable)() -> "Index out of range");
            int lastElemIndex = size - 1;
            byte[] lastElemKey = this.getElemKey(lastElemIndex);
            lastElemValue = view.getAccountStorage(this.account(), lastElemKey);
            view.removeAccountStorage(this.account(), lastElemKey);
            this.updateSize(view, size - 1);
            if (index == lastElemIndex) break block0;
            this.updateValue(view, index, lastElemValue);
        }
        return lastElemValue;
    }

    public void updateValue(BaseAccountStateView view, int index, byte[] newValue) {
        Predef$.MODULE$.require(index >= 0, (Function0 & java.io.Serializable & Serializable)() -> "Index cannot be negative");
        int size = this.getSize(view);
        Predef$.MODULE$.require(index < size, (Function0 & java.io.Serializable & Serializable)() -> "Index out of range");
        byte[] key = this.getElemKey(index);
        view.updateAccountStorage(this.account(), key, newValue);
    }

    public byte[] getValue(BaseAccountStateView view, int index) {
        Predef$.MODULE$.require(index >= 0, (Function0 & java.io.Serializable & Serializable)() -> "Index cannot be negative");
        byte[] key = this.getElemKey(index);
        byte[] value = view.getAccountStorage(this.account(), key);
        return value;
    }

    private byte[] getElemKey(int index) {
        return WithdrawalMsgProcessor$.MODULE$.calculateKey(Bytes.concat((byte[][])new byte[][]{this.baseArrayKey(), Ints.toByteArray((int)index)}));
    }

    public StateDbArray(Address account, byte[] keySeed) {
        this.account = account;
        this.keySeed = keySeed;
        this.baseArrayKey = Blake2b256$.MODULE$.hash(keySeed);
    }
}

