/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.evm.Address;
import io.horizen.evm.FixedSizeByteArray;
import io.horizen.utils.BytesUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import org.web3j.utils.Numeric;

public class Message {
    private final Address from;
    private final Optional<Address> to;
    private final BigInteger gasPrice;
    private final BigInteger gasFeeCap;
    private final BigInteger gasTipCap;
    private final BigInteger gasLimit;
    private final BigInteger value;
    private final BigInteger nonce;
    private final byte[] data;
    private final boolean fakeMsg;

    public Message(Address from, Optional<Address> to, BigInteger gasPrice, BigInteger gasFeeCap, BigInteger gasTipCap, BigInteger gasLimit, BigInteger value, BigInteger nonce, byte[] data, boolean fakeMsg) {
        this.from = from;
        this.to = to;
        this.gasPrice = gasPrice;
        this.gasFeeCap = gasFeeCap;
        this.gasTipCap = gasTipCap;
        this.gasLimit = gasLimit;
        this.value = value;
        this.nonce = nonce;
        this.data = data == null ? null : Arrays.copyOf(data, data.length);
        this.fakeMsg = fakeMsg;
    }

    public Address getFrom() {
        return this.from;
    }

    public Optional<Address> getTo() {
        return this.to;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public BigInteger getGasFeeCap() {
        return this.gasFeeCap;
    }

    public BigInteger getGasTipCap() {
        return this.gasTipCap;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean getIsFakeMsg() {
        return this.fakeMsg;
    }

    public String toString() {
        return String.format("Message{from=%s, to=%s, gasPrice=%s, gasFeeCap=%s, gasTipCap=%s, gasLimit=%s, value=%s, nonce=%s, data=%s, fakeMsg=%s}", this.from.toString(), this.to.map(FixedSizeByteArray::toString).orElse(""), this.gasPrice != null ? Numeric.toHexStringWithPrefix((BigInteger)this.gasPrice) : "null", this.gasFeeCap != null ? Numeric.toHexStringWithPrefix((BigInteger)this.gasFeeCap) : "null", this.gasTipCap != null ? Numeric.toHexStringWithPrefix((BigInteger)this.gasTipCap) : "null", this.gasLimit != null ? Numeric.toHexStringWithPrefix((BigInteger)this.gasLimit) : "null", this.value != null ? Numeric.toHexStringWithPrefix((BigInteger)this.value) : "null", this.nonce != null ? Numeric.toHexStringWithPrefix((BigInteger)this.nonce) : "null", this.data != null ? BytesUtils.toHexString(this.data) : "null", this.fakeMsg ? "YES" : "NO");
    }
}

