/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.CertificateKeyRotationMsgProcessor$;
import io.horizen.account.state.CertificateKeysProvider;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.KeyRotationHistory;
import io.horizen.account.state.KeyRotationHistorySerializer$;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.SubmitKeyRotationCmdInput;
import io.horizen.account.state.SubmitKeyRotationCmdInputDecoder$;
import io.horizen.account.state.events.SubmitKeyRotation;
import io.horizen.account.state.events.SubmitKeyRotation$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.storage.MsgProcessorMetadataStorageReader;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofSerializer$;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.cryptolibprovider.CryptoLibProvider$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.proof.SchnorrProof;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.proposition.SchnorrPropositionSerializer;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015b\u0001\u0002\u00192\u0001jB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001b\")1\u000b\u0001C\u0001)\"9q\u000b\u0001b\u0001\n\u0003B\u0006BB0\u0001A\u0003%\u0011\fC\u0004a\u0001\t\u0007I\u0011I1\t\r!\u0004\u0001\u0015!\u0003c\u0011\u0015I\u0007\u0001\"\u0011k\u0011!\t)\u0002\u0001C!k\u0005]\u0001bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003'\u0002A\u0011BA+\u0011!\ty\u0006\u0001C!k\u0005\u0005\u0004\u0002CAO\u0001\u0011\u0005Q'a(\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t)\u000f\u0001C\u0005\u0003ODqA!\u0004\u0001\t\u0013\u0011y\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!Q\u0005\u0001\u0005\n\t\u001d\u0002b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bB\u0011Ba\u0013\u0001\u0003\u0003%\tA!\u0014\t\u0013\tE\u0003!%A\u0005\u0002\tM\u0003\"\u0003B5\u0001\u0005\u0005I\u0011\tB6\u0011%\u0011i\bAA\u0001\n\u0003\u0011y\bC\u0005\u0003\u0002\u0002\t\t\u0011\"\u0001\u0003\u0004\"I!q\u0012\u0001\u0002\u0002\u0013\u0005#\u0011\u0013\u0005\n\u0005?\u0003\u0011\u0011!C\u0001\u0005CC\u0011Ba+\u0001\u0003\u0003%\tE!,\t\u0013\t=\u0006!!A\u0005B\tE\u0006\"\u0003BZ\u0001\u0005\u0005I\u0011\tB[\u000f\u001d\u0011I,\rE\u0001\u0005w3a\u0001M\u0019\t\u0002\tu\u0006BB*&\t\u0003\u0011)\r\u0003\u0005\u0003H\u0016\u0012\r\u0011\"\u0001Y\u0011\u001d\u0011I-\nQ\u0001\neC\u0011Ba3&\u0005\u0004%\tA!4\t\u0011\tUX\u0005)A\u0005\u0005\u001fD\u0011Ba>&\u0005\u0004%\tA!?\t\u0011\r%Q\u0005)A\u0005\u0005wD\u0011ba\u0003&\u0003\u0003%\ti!\u0004\t\u0013\rEQ%!A\u0005\u0002\u000eM\u0001\"CB\u000eK\u0005\u0005I\u0011BB\u000f\u0005\t\u001aUM\u001d;jM&\u001c\u0017\r^3LKf\u0014v\u000e^1uS>tWj]4Qe>\u001cWm]:pe*\u0011!gM\u0001\u0006gR\fG/\u001a\u0006\u0003iU\nq!Y2d_VtGO\u0003\u00027o\u00059\u0001n\u001c:ju\u0016t'\"\u0001\u001d\u0002\u0005%|7\u0001A\n\u0006\u0001mz$\t\u0013\t\u0003yuj\u0011!M\u0005\u0003}E\u0012qDT1uSZ,7+\\1si\u000e{g\u000e\u001e:bGRl5o\u001a)s_\u000e,7o]8s!\ta\u0004)\u0003\u0002Bc\t92)\u001a:uS\u001aL7-\u0019;f\u0017\u0016L8\u000f\u0015:pm&$WM\u001d\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\b!J|G-^2u!\t\u0019\u0015*\u0003\u0002K\t\na1+\u001a:jC2L'0\u00192mK\u00061\u0001/\u0019:b[N,\u0012!\u0014\t\u0003\u001dBk\u0011a\u0014\u0006\u0003\u0017VJ!!U(\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u001d\u0001\u0018M]1ng\u0002\na\u0001P5oSRtDCA+W!\ta\u0004\u0001C\u0003L\u0007\u0001\u0007Q*A\bd_:$(/Y2u\u0003\u0012$'/Z:t+\u0005I\u0006C\u0001.^\u001b\u0005Y&B\u0001/6\u0003\r)g/\\\u0005\u0003=n\u0013q!\u00113ee\u0016\u001c8/\u0001\td_:$(/Y2u\u0003\u0012$'/Z:tA\u0005a1m\u001c8ue\u0006\u001cGoQ8eKV\t!\rE\u0002DG\u0016L!\u0001\u001a#\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\r3\u0017BA4E\u0005\u0011\u0011\u0015\u0010^3\u0002\u001b\r|g\u000e\u001e:bGR\u001cu\u000eZ3!\u0003\u001d\u0001(o\\2fgN$RAY6qkvDQ\u0001\u001c\u0005A\u00025\f!\"\u001b8w_\u000e\fG/[8o!\tad.\u0003\u0002pc\tQ\u0011J\u001c<pG\u0006$\u0018n\u001c8\t\u000bED\u0001\u0019\u0001:\u0002\tYLWm\u001e\t\u0003yML!\u0001^\u0019\u0003)\t\u000b7/Z!dG>,h\u000e^*uCR,g+[3x\u0011\u00151\b\u00021\u0001x\u0003!iW\r^1eCR\f\u0007C\u0001=|\u001b\u0005I(B\u0001>4\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001`=\u0003C5\u001bx\r\u0015:pG\u0016\u001c8o\u001c:NKR\fG-\u0019;b'R|'/Y4f%\u0016\fG-\u001a:\t\u000byD\u0001\u0019A@\u0002\u000f\r|g\u000e^3yiB\u0019A(!\u0001\n\u0007\u0005\r\u0011G\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"*\u0001\"a\u0002\u0002\u0014A)1)!\u0003\u0002\u000e%\u0019\u00111\u0002#\u0003\rQD'o\\<t!\ra\u0014qB\u0005\u0004\u0003#\t$\u0001G#yK\u000e,H/[8o\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]\u000e\u0012\u0011QB\u0001\u0012O\u0016$8)\u001a:uS\u001aLWM]:LKf\u001cHCBA\r\u0003S\t\u0019\u0004\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\t-,\u0017p\u001d\u0006\u0004\u0003G)\u0014\u0001F2feRLg-[2bi\u0016\u001cXOY7jiR,'/\u0003\u0003\u0002(\u0005u!AD\"feRLg-[3sg.+\u0017p\u001d\u0005\b\u0003WI\u0001\u0019AA\u0017\u0003!)\u0007o\\2i\u001dVl\u0007cA\"\u00020%\u0019\u0011\u0011\u0007#\u0003\u0007%sG\u000fC\u0003r\u0013\u0001\u0007!/\u0001\nhKRd\u0015\r^3ti6\u000b7\u000f^3s\u0017\u0016LHCCA\u001d\u0003\u000b\n9%a\u0013\u0002PA!\u00111HA!\u001b\t\tiDC\u0002\u0002@U\n1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&!\u00111IA\u001f\u0005I\u00196\r\u001b8peJ\u0004&o\u001c9pg&$\u0018n\u001c8\t\u000bET\u0001\u0019\u0001:\t\u000f\u0005%#\u00021\u0001\u0002:\u0005I1m\u001c8gS\u001e\\U-\u001f\u0005\b\u0003\u001bR\u0001\u0019AA\u0017\u00039\u0011X-];fgR,G-\u00129pG\"Dq!!\u0015\u000b\u0001\u0004\ti#A\u0003j]\u0012,\u00070A\nhKRd\u0015\r^3tiNKwM\\5oO.+\u0017\u0010\u0006\u0006\u0002:\u0005]\u0013\u0011LA.\u0003;BQ!]\u0006A\u0002IDq!!\u0013\f\u0001\u0004\tI\u0004C\u0004\u0002N-\u0001\r!!\f\t\u000f\u0005E3\u00021\u0001\u0002.\u0005\u0019r-\u001a;LKf\u0014v\u000e^1uS>t\u0007K]8pMRQ\u00111MA8\u0003c\n\u0019(a'\u0011\u000b\r\u000b)'!\u001b\n\u0007\u0005\u001dDI\u0001\u0004PaRLwN\u001c\t\u0005\u00037\tY'\u0003\u0003\u0002n\u0005u!\u0001E&fsJ{G/\u0019;j_:\u0004&o\\8g\u0011\u001d\tY\u0003\u0004a\u0001\u0003[Aq!!\u0015\r\u0001\u0004\ti\u0003C\u0004\u0002v1\u0001\r!a\u001e\u0002\u000f-,\u0017\u0010V=qKB!\u0011\u0011PAK\u001d\u0011\tY(!%\u000f\t\u0005u\u0014q\u0012\b\u0005\u0003\u007f\niI\u0004\u0003\u0002\u0002\u0006-e\u0002BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001d\u0015(\u0001\u0004=e>|GOP\u0005\u0002q%\u0011agN\u0005\u0004\u0003G)\u0014\u0002BA\u0010\u0003CIA!a%\u0002\u001e\u0005)2*Z=S_R\fG/[8o!J|wN\u001a+za\u0016\u001c\u0018\u0002BAL\u00033\u0013AcS3z%>$\u0018\r^5p]B\u0013xn\u001c4UsB,'\u0002BAJ\u0003;AQ!\u001d\u0007A\u0002I\facZ3u\u0017\u0016L8OU8uCRLwN\u001c%jgR|'/\u001f\u000b\t\u0003C\u000b9+!+\u0002,B\u0019A(a)\n\u0007\u0005\u0015\u0016G\u0001\nLKf\u0014v\u000e^1uS>t\u0007*[:u_JL\bbBA;\u001b\u0001\u0007\u0011q\u000f\u0005\b\u0003#j\u0001\u0019AA\u0017\u0011\u0015\tX\u00021\u0001s\u0003U\u0001X\u000f^&fsJ{G/\u0019;j_:D\u0015n\u001d;pef$\"\"!-\u00028\u0006e\u00161XA_!\r\u0019\u00151W\u0005\u0004\u0003k#%\u0001B+oSRDq!!\u001e\u000f\u0001\u0004\t9\bC\u0004\u0002R9\u0001\r!!\f\t\u000bEt\u0001\u0019\u0001:\t\u000f\u0005}f\u00021\u0001\u0002\"\u00069\u0001.[:u_JL\u0018a\u00059vi.+\u0017PU8uCRLwN\u001c)s_>4G\u0003CAY\u0003\u000b\f9-!3\t\u000f\u0005-r\u00021\u0001\u0002.!)\u0011o\u0004a\u0001e\"9\u00111Z\bA\u0002\u0005%\u0014\u0001E6fsJ{G/\u0019;j_:\u0004&o\\8g\u000359W\r^*jO:LgnZ&fsRA\u0011\u0011[Aj\u0003/\fI\u000eE\u0003D\u0003K\nI\u0004C\u0004\u0002VB\u0001\r!!\f\u0002\u0017\u0015\u0004xn\u00195Ok6\u0014WM\u001d\u0005\b\u0003#\u0002\u0002\u0019AA\u0017\u0011\u0015\t\b\u00031\u0001s\u000319W\r^'bgR,'oS3z)!\t\t.a8\u0002b\u0006\r\bbBAk#\u0001\u0007\u0011Q\u0006\u0005\b\u0003#\n\u0002\u0019AA\u0017\u0011\u0015\t\u0018\u00031\u0001s\u0003u\u0019\u0007.Z2l\u0017\u0016L(k\u001c;bi&|g\u000e\u0015:p_\u001a4\u0016\r\\5eSRLHCCAu\u0003k\f9Pa\u0002\u0003\fA1\u00111^Ay\u0003ck!!!<\u000b\u0007\u0005=H)\u0001\u0003vi&d\u0017\u0002BAz\u0003[\u00141\u0001\u0016:z\u0011\u001d\tYM\u0005a\u0001\u0003SBq!!?\u0013\u0001\u0004\tY0A\boK^\\U-_*jO:\fG/\u001e:f!\u0011\tiPa\u0001\u000e\u0005\u0005}(b\u0001B\u0001k\u0005)\u0001O]8pM&!!QAA\u0000\u00051\u00196\r\u001b8peJ\u0004&o\\8g\u0011\u001d\u0011IA\u0005a\u0001\u0003[\tqbY;se\u0016tG/\u00129pG\"tU/\u001c\u0005\u0006cJ\u0001\rA]\u0001\u0016Kb,7mU;c[&$8*Z=S_R\fG/[8o)\u001d\u0011'\u0011\u0003B\n\u0005+AQ\u0001\\\nA\u00025DQ!]\nA\u0002IDqA!\u0003\u0014\u0001\u0004\ti#A\fdQ\u0016\u001c7.\u00138w_\u000e\fG/[8o-\u0006d\u0017\u000eZ5usR!\u0011\u0011\u0017B\u000e\u0011\u0015aG\u00031\u0001n\u00031\u0019\u0017\r\\2vY\u0006$XmS3z)\r\u0011'\u0011\u0005\u0005\u0007\u0005G)\u0002\u0019\u00012\u0002\u000f-,\u0017pU3fI\u00061r-\u001a;LKf\u0014v\u000e^1uS>t\u0007K]8pM.+\u0017\u0010F\u0004c\u0005S\u0011YCa\f\t\u000f\u0005Ud\u00031\u0001\u0002x!9!Q\u0006\fA\u0002\u00055\u0012aD<ji\"$'/Y<bY\u0016\u0003xn\u00195\t\u000f\u0005Ec\u00031\u0001\u0002.\u0005\u0001r-\u001a;TS\u001et\u0017N\\4LKf\\U-\u001f\u000b\u0006E\nU\"\u0011\b\u0005\b\u0005o9\u0002\u0019AA\u0017\u0003\u0015)\u0007o\\2i\u0011\u001d\t\tf\u0006a\u0001\u0003[\tqbZ3u\u001b\u0006\u001cH/\u001a:LKf\\U-\u001f\u000b\u0006E\n}\"\u0011\t\u0005\b\u0005oA\u0002\u0019AA\u0017\u0011\u001d\t\t\u0006\u0007a\u0001\u0003[\t\u0011dZ3u\u0017\u0016L8OU8uCRLwN\u001c%jgR|'/_&fsR)!Ma\u0012\u0003J!9\u0011QO\rA\u0002\u0005]\u0004bBA)3\u0001\u0007\u0011QF\u0001\u0005G>\u0004\u0018\u0010F\u0002V\u0005\u001fBqa\u0013\u000e\u0011\u0002\u0003\u0007Q*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU#fA'\u0003X-\u0012!\u0011\f\t\u0005\u00057\u0012)'\u0004\u0002\u0003^)!!q\fB1\u0003%)hn\u00195fG.,GMC\u0002\u0003d\u0011\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119G!\u0018\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005[\u0002BAa\u001c\u0003z5\u0011!\u0011\u000f\u0006\u0005\u0005g\u0012)(\u0001\u0003mC:<'B\u0001B<\u0003\u0011Q\u0017M^1\n\t\tm$\u0011\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u000b\u0013Y\tE\u0002D\u0005\u000fK1A!#E\u0005\r\te.\u001f\u0005\n\u0005\u001bs\u0012\u0011!a\u0001\u0003[\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BJ!\u0019\u0011)Ja'\u0003\u00066\u0011!q\u0013\u0006\u0004\u00053#\u0015AC2pY2,7\r^5p]&!!Q\u0014BL\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\r&\u0011\u0016\t\u0004\u0007\n\u0015\u0016b\u0001BT\t\n9!i\\8mK\u0006t\u0007\"\u0003BGA\u0005\u0005\t\u0019\u0001BC\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0017\u0003!!xn\u0015;sS:<GC\u0001B7\u0003\u0019)\u0017/^1mgR!!1\u0015B\\\u0011%\u0011iiIA\u0001\u0002\u0004\u0011))\u0001\u0012DKJ$\u0018NZ5dCR,7*Z=S_R\fG/[8o\u001bN<\u0007K]8dKN\u001cxN\u001d\t\u0003y\u0015\u001aB!\nB`\u0011B\u00191I!1\n\u0007\t\rGI\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005w\u000bQeQ3si&4\u0017nY1uK.+\u0017PU8uCRLwN\\\"p]R\u0014\u0018m\u0019;BI\u0012\u0014Xm]:\u0002M\r+'\u000f^5gS\u000e\fG/Z&fsJ{G/\u0019;j_:\u001cuN\u001c;sC\u000e$\u0018\t\u001a3sKN\u001c\b%\u0001\u0012DKJ$\u0018NZ5dCR,7*Z=S_R\fG/[8o\u0007>tGO]1di\u000e{G-Z\u000b\u0003\u0005\u001f\u0004BA!5\u0003p:!!1\u001bBu\u001d\u0011\u0011)Na9\u000f\t\t]'Q\u001c\b\u0005\u0003\u0007\u0013I.\u0003\u0002\u0003\\\u000611\u000f]1sWjLAAa8\u0003b\u000611M]=qi>T!Aa7\n\t\t\u0015(q]\u0001\u0005Q\u0006\u001c\bN\u0003\u0003\u0003`\n\u0005\u0018\u0002\u0002Bv\u0005[\fq\u0001]1dW\u0006<WM\u0003\u0003\u0003f\n\u001d\u0018\u0002\u0002By\u0005g\u0014\u0001\u0002R5hKN$8G\r\u0006\u0005\u0005W\u0014i/A\u0012DKJ$\u0018NZ5dCR,7*Z=S_R\fG/[8o\u0007>tGO]1di\u000e{G-\u001a\u0011\u00025M+(-\\5u\u0017\u0016L(k\u001c;bi&|gNU3r\u00076$7+[4\u0016\u0005\tm\b\u0003\u0002B\u007f\u0007\u000bqAAa@\u0004\u0002A\u0019\u00111\u0011#\n\u0007\r\rA)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005w\u001a9AC\u0002\u0004\u0004\u0011\u000b1dU;c[&$8*Z=S_R\fG/[8o%\u0016\f8)\u001c3TS\u001e\u0004\u0013!B1qa2LHcA+\u0004\u0010!)1*\fa\u0001\u001b\u00069QO\\1qa2LH\u0003BB\u000b\u0007/\u0001BaQA3\u001b\"A1\u0011\u0004\u0018\u0002\u0002\u0003\u0007Q+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u00111q\u0004\t\u0005\u0005_\u001a\t#\u0003\u0003\u0004$\tE$AB(cU\u0016\u001cG\u000f")
public class CertificateKeyRotationMsgProcessor
extends NativeSmartContractMsgProcessor
implements CertificateKeysProvider,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;

    public static Option<NetworkParams> unapply(CertificateKeyRotationMsgProcessor certificateKeyRotationMsgProcessor) {
        return CertificateKeyRotationMsgProcessor$.MODULE$.unapply(certificateKeyRotationMsgProcessor);
    }

    public static CertificateKeyRotationMsgProcessor apply(NetworkParams networkParams) {
        return CertificateKeyRotationMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static String SubmitKeyRotationReqCmdSig() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.SubmitKeyRotationReqCmdSig();
    }

    public static byte[] CertificateKeyRotationContractCode() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractCode();
    }

    public static Address CertificateKeyRotationContractAddress() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractAddress();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    @Override
    public byte[] process(Invocation invocation, BaseAccountStateView view, MsgProcessorMetadataStorageReader metadata, ExecutionContext context) throws ExecutionFailedException {
        BaseAccountStateView gasView = view.getGasTrackedView(invocation.gasPool());
        String string = ABIUtil.getFunctionSignature(invocation.input());
        String string2 = CertificateKeyRotationMsgProcessor$.MODULE$.SubmitKeyRotationReqCmdSig();
        String string3 = string;
        if (string2 != null ? !string2.equals(string3) : string3 != null) {
            throw new ExecutionRevertedException(new StringBuilder(55).append("Requested function does not exist. Function signature: ").append(string).toString());
        }
        byte[] byArray = this.execSubmitKeyRotation(invocation, gasView, context.blockContext().withdrawalEpochNumber);
        return byArray;
    }

    @Override
    public CertifiersKeys getCertifiersKeys(int epochNum, BaseAccountStateView view) {
        Vector singingKeys = ((TraversableOnce)((TraversableLike)this.params().signersPublicKeys().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)key_index -> this.getLatestSigningKey(view, (SchnorrProposition)key_index._1(), epochNum + 1, key_index._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toVector();
        Vector masterKeys = ((TraversableOnce)((TraversableLike)this.params().mastersPublicKeys().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)key_index -> this.getLatestMasterKey(view, (SchnorrProposition)key_index._1(), epochNum + 1, key_index._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toVector();
        return new CertifiersKeys((Vector<SchnorrProposition>)singingKeys, (Vector<SchnorrProposition>)masterKeys);
    }

    private SchnorrProposition getLatestMasterKey(BaseAccountStateView view, SchnorrProposition configKey, int requestedEpoch, int index) {
        KeyRotationHistory masterKeyChangeHistory = this.getKeysRotationHistory(KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType(), index, view);
        return (SchnorrProposition)masterKeyChangeHistory.epochNumbers().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 < requestedEpoch).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.getMasterKey(BoxesRunTime.unboxToInt((Object)x$2), index, view)).getOrElse((Function0 & Serializable & scala.Serializable)() -> configKey);
    }

    private SchnorrProposition getLatestSigningKey(BaseAccountStateView view, SchnorrProposition configKey, int requestedEpoch, int index) {
        KeyRotationHistory signingKeyChangeHistory = this.getKeysRotationHistory(KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType(), index, view);
        return (SchnorrProposition)signingKeyChangeHistory.epochNumbers().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 < requestedEpoch).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> this.getSigningKey(BoxesRunTime.unboxToInt((Object)x$4), index, view)).getOrElse((Function0 & Serializable & scala.Serializable)() -> configKey);
    }

    @Override
    public Option<KeyRotationProof> getKeyRotationProof(int epochNum, int index, Enumeration.Value keyType, BaseAccountStateView view) {
        byte[] key = this.getKeyRotationProofKey(keyType, epochNum, index);
        byte[] maybeData = view.getAccountStorageBytes(this.contractAddress(), key);
        return maybeData.length > 0 ? new Some(KeyRotationProofSerializer$.MODULE$.parseBytes(maybeData)) : None$.MODULE$;
    }

    public KeyRotationHistory getKeysRotationHistory(Enumeration.Value keyType, int index, BaseAccountStateView view) {
        byte[] maybeData = view.getAccountStorageBytes(this.contractAddress(), this.getKeysRotationHistoryKey(keyType, index));
        return maybeData.length > 0 ? (KeyRotationHistory)KeyRotationHistorySerializer$.MODULE$.parseBytes(maybeData) : new KeyRotationHistory((List<Object>)Nil$.MODULE$);
    }

    private void putKeyRotationHistory(Enumeration.Value keyType, int index, BaseAccountStateView view, KeyRotationHistory history) {
        view.updateAccountStorageBytes(this.contractAddress(), this.getKeysRotationHistoryKey(keyType, index), history.bytes());
    }

    private void putKeyRotationProof(int epochNum, BaseAccountStateView view, KeyRotationProof keyRotationProof) {
        byte[] key = this.getKeyRotationProofKey(keyRotationProof.keyType(), epochNum, keyRotationProof.index());
        view.updateAccountStorageBytes(this.contractAddress(), key, keyRotationProof.bytes());
    }

    private Option<SchnorrProposition> getSigningKey(int epochNumber, int index, BaseAccountStateView view) {
        byte[] bytes = view.getAccountStorageBytes(this.contractAddress(), this.getSigningKeyKey(epochNumber, index));
        return bytes.length > 0 ? new Some(SchnorrPropositionSerializer.getSerializer().parseBytes(bytes)) : None$.MODULE$;
    }

    private Option<SchnorrProposition> getMasterKey(int epochNumber, int index, BaseAccountStateView view) {
        byte[] bytes = view.getAccountStorageBytes(this.contractAddress(), this.getMasterKeyKey(epochNumber, index));
        return bytes.length > 0 ? new Some(SchnorrPropositionSerializer.getSerializer().parseBytes(bytes)) : None$.MODULE$;
    }

    private Try<BoxedUnit> checkKeyRotationProofValidity(KeyRotationProof keyRotationProof, SchnorrProof newKeySignature, int currentEpochNum, BaseAccountStateView view) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte[] byArray;
            int index = keyRotationProof.index();
            if (index < 0 || index >= this.params().signersPublicKeys().length()) {
                throw new ExecutionRevertedException(new StringBuilder(46).append("Key rotation proof - key index out for range: ").append(index).toString());
            }
            SchnorrProposition signingKeyFromConfig = (SchnorrProposition)this.params().signersPublicKeys().apply(index);
            SchnorrProposition masterKeyFromConfig = (SchnorrProposition)this.params().mastersPublicKeys().apply(index);
            Enumeration.Value value = keyRotationProof.keyType();
            Enumeration.Value value2 = KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForSigningKeyUpdate(keyRotationProof.newKey().pubKeyBytes(), currentEpochNum, this.params().sidechainId());
            } else {
                Enumeration.Value value4 = KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForMasterKeyUpdate(keyRotationProof.newKey().pubKeyBytes(), currentEpochNum, this.params().sidechainId());
                } else {
                    throw new MatchError((Object)value);
                }
            }
            byte[] newKeyAsMessage = byArray;
            SchnorrProposition latestSigningKey = this.getLatestSigningKey(view, signingKeyFromConfig, currentEpochNum, index);
            if (!keyRotationProof.signingKeySignature().isValid(latestSigningKey, newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(51).append("Key rotation proof - signing signature is invalid: ").append(index).toString());
            }
            SchnorrProposition latestMasterKey = this.getLatestMasterKey(view, masterKeyFromConfig, currentEpochNum, index);
            if (!keyRotationProof.masterKeySignature().isValid(latestMasterKey, newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(50).append("Key rotation proof - master signature is invalid: ").append(index).toString());
            }
            if (!newKeySignature.isValid(keyRotationProof.newKey(), newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(48).append("Key rotation proof - self signature is invalid: ").append(index).toString());
            }
        });
    }

    private byte[] execSubmitKeyRotation(Invocation invocation, BaseAccountStateView view, int currentEpochNum) {
        byte[] byArray;
        this.checkInvocationValidity(invocation);
        SubmitKeyRotationCmdInput inputData = (SubmitKeyRotationCmdInput)SubmitKeyRotationCmdInputDecoder$.MODULE$.decode(ABIUtil.getArgumentsFromData(invocation.input()));
        KeyRotationProof keyRotationProof = inputData.keyRotationProof();
        int keyIndex = keyRotationProof.index();
        Enumeration.Value keyType = keyRotationProof.keyType();
        Try<BoxedUnit> try_ = this.checkKeyRotationProofValidity(keyRotationProof, inputData.newKeySignature(), currentEpochNum, view);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(31).append("Key Rotation Proof is invalid: ").append(ex.getMessage()).toString());
            }
            throw new MatchError(try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.putKeyRotationProof(currentEpochNum, view, keyRotationProof);
        Enumeration.Value value = keyType;
        Enumeration.Value value2 = KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            byArray = this.getSigningKeyKey(currentEpochNum, keyIndex);
        } else {
            Enumeration.Value value4 = KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                byArray = this.getMasterKeyKey(currentEpochNum, keyIndex);
            } else {
                throw new MatchError((Object)value);
            }
        }
        byte[] storageKey = byArray;
        view.updateAccountStorageBytes(this.contractAddress(), storageKey, keyRotationProof.newKey().bytes());
        KeyRotationHistory history = this.getKeysRotationHistory(keyType, keyIndex, view);
        if (!history.epochNumbers().headOption().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> ((Object)BoxesRunTime.boxToInteger((int)x$5)).equals(BoxesRunTime.boxToInteger((int)currentEpochNum)))) {
            int n = currentEpochNum;
            this.putKeyRotationHistory(keyType, keyIndex, view, new KeyRotationHistory((List<Object>)history.epochNumbers().$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))));
        }
        SubmitKeyRotation keyRotationEvent = SubmitKeyRotation$.MODULE$.apply(keyType, keyIndex, keyRotationProof.newKey(), currentEpochNum);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(keyRotationEvent);
        view.addLog(evmLog);
        return keyRotationProof.encode();
    }

    private void checkInvocationValidity(Invocation invocation) {
        if (invocation.input().length != 4 + SubmitKeyRotationCmdInputDecoder$.MODULE$.getABIDataParamsStaticLengthInBytes()) {
            throw new ExecutionRevertedException(new StringBuilder(36).append("Wrong invocation data field length: ").append(invocation.input().length).toString());
        }
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException(new StringBuilder(19).append("Value is non-zero: ").append(invocation).toString());
        }
    }

    private byte[] calculateKey(byte[] keySeed) {
        return Keccak256$.MODULE$.hash(keySeed);
    }

    private byte[] getKeyRotationProofKey(Enumeration.Value keyType, int withdrawalEpoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"keyRotationProof".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)keyType.id()), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getSigningKeyKey(int epoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"signingKey".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)epoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getMasterKeyKey(int epoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"masterKey".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)epoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getKeysRotationHistoryKey(Enumeration.Value keyType, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"keyHistory".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)keyType.id()), Ints.toByteArray((int)index)}));
    }

    public CertificateKeyRotationMsgProcessor copy(NetworkParams params) {
        return new CertificateKeyRotationMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "CertificateKeyRotationMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CertificateKeyRotationMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CertificateKeyRotationMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        CertificateKeyRotationMsgProcessor certificateKeyRotationMsgProcessor = (CertificateKeyRotationMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = certificateKeyRotationMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!certificateKeyRotationMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public CertificateKeyRotationMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractAddress();
        this.contractCode = CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractCode();
    }
}

