/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.history.validation;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.history.validation.ChainIdBlockSemanticValidator$;
import io.horizen.account.history.validation.InvalidTransactionChainIdException;
import io.horizen.account.history.validation.InvalidTransactionChainIdException$;
import io.horizen.account.history.validation.MissingTransactionSignatureException;
import io.horizen.account.history.validation.MissingTransactionSignatureException$;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.AccountTransactionsIdsEnum;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.history.validation.SemanticBlockValidator;
import io.horizen.params.NetworkParams;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\f\u0018\u0001\nB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000b\")1\n\u0001C\u0001\u0019\")\u0001\u000b\u0001C!#\"91\fAA\u0001\n\u0003a\u0006b\u00020\u0001#\u0003%\ta\u0018\u0005\bU\u0002\t\t\u0011\"\u0011l\u0011\u001d!\b!!A\u0005\u0002UDq!\u001f\u0001\u0002\u0002\u0013\u0005!\u0010C\u0005\u0002\u0002\u0001\t\t\u0011\"\u0011\u0002\u0004!I\u0011\u0011\u0003\u0001\u0002\u0002\u0013\u0005\u00111\u0003\u0005\n\u0003;\u0001\u0011\u0011!C!\u0003?A\u0011\"!\t\u0001\u0003\u0003%\t%a\t\t\u0013\u0005\u0015\u0002!!A\u0005B\u0005\u001dr!CA\u0016/\u0005\u0005\t\u0012AA\u0017\r!1r#!A\t\u0002\u0005=\u0002BB&\u0011\t\u0003\ti\u0004C\u0005\u0002\"A\t\t\u0011\"\u0012\u0002$!I\u0011q\b\t\u0002\u0002\u0013\u0005\u0015\u0011\t\u0005\n\u0003\u000b\u0002\u0012\u0011!CA\u0003\u000fB\u0011\"a\u0015\u0011\u0003\u0003%I!!\u0016\u0003;\rC\u0017-\u001b8JI\ncwnY6TK6\fg\u000e^5d-\u0006d\u0017\u000eZ1u_JT!\u0001G\r\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002\u001b7\u00059\u0001.[:u_JL(B\u0001\u000f\u001e\u0003\u001d\t7mY8v]RT!AH\u0010\u0002\u000f!|'/\u001b>f]*\t\u0001%\u0001\u0002j_\u000e\u00011C\u0002\u0001$SEj\u0004\t\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA!\u001e;jY*\ta&\u0001\u0004ta\u0006\u00148N_\u0005\u0003a-\u0012Qb\u00159be.THj\\4hS:<\u0007c\u0001\u001a6o5\t1G\u0003\u0002\u0019i)\u0011!$H\u0005\u0003mM\u0012acU3nC:$\u0018n\u0019\"m_\u000e\\g+\u00197jI\u0006$xN\u001d\t\u0003qmj\u0011!\u000f\u0006\u0003um\tQA\u00197pG.L!\u0001P\u001d\u0003\u0019\u0005\u001b7m\\;oi\ncwnY6\u0011\u0005\u0011r\u0014BA &\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001J!\n\u0005\t+#\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00029be\u0006l7/F\u0001F!\t1\u0005*D\u0001H\u0015\t\u0019U$\u0003\u0002J\u000f\nia*\u001a;x_J\\\u0007+\u0019:b[N\fq\u0001]1sC6\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003\u001b>\u0003\"A\u0014\u0001\u000e\u0003]AQaQ\u0002A\u0002\u0015\u000b\u0001B^1mS\u0012\fG/\u001a\u000b\u0003%j\u00032aU+X\u001b\u0005!&B\u0001\u0017&\u0013\t1FKA\u0002Uef\u0004\"\u0001\n-\n\u0005e+#\u0001B+oSRDQA\u000f\u0003A\u0002]\nAaY8qsR\u0011Q*\u0018\u0005\b\u0007\u0016\u0001\n\u00111\u0001F\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u0019\u0016\u0003\u000b\u0006\\\u0013A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u001d,\u0013AC1o]>$\u0018\r^5p]&\u0011\u0011\u000e\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001m!\ti'/D\u0001o\u0015\ty\u0007/\u0001\u0003mC:<'\"A9\u0002\t)\fg/Y\u0005\u0003g:\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001<\u0011\u0005\u0011:\u0018B\u0001=&\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\tYh\u0010\u0005\u0002%y&\u0011Q0\n\u0002\u0004\u0003:L\bbB@\n\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\u0001#BA\u0004\u0003\u001bYXBAA\u0005\u0015\r\tY!J\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\b\u0003\u0013\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QCA\u000e!\r!\u0013qC\u0005\u0004\u00033)#a\u0002\"p_2,\u0017M\u001c\u0005\b\u007f.\t\t\u00111\u0001|\u0003!A\u0017m\u001d5D_\u0012,G#\u0001<\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\\\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\u0011\u0011\u0006\u0005\b\u007f:\t\t\u00111\u0001|\u0003u\u0019\u0005.Y5o\u0013\u0012\u0014En\\2l'\u0016l\u0017M\u001c;jGZ\u000bG.\u001b3bi>\u0014\bC\u0001(\u0011'\u0011\u0001\u0012\u0011\u0007!\u0011\r\u0005M\u0012\u0011H#N\u001b\t\t)DC\u0002\u00028\u0015\nqA];oi&lW-\u0003\u0003\u0002<\u0005U\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011QF\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u001b\u0006\r\u0003\"B\"\u0014\u0001\u0004)\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0013\ny\u0005\u0005\u0003%\u0003\u0017*\u0015bAA'K\t1q\n\u001d;j_:D\u0001\"!\u0015\u0015\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0016\u0011\u00075\fI&C\u0002\u0002\\9\u0014aa\u00142kK\u000e$\b")
public class ChainIdBlockSemanticValidator
implements SparkzLogging,
SemanticBlockValidator<AccountBlock>,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Logger logger;

    public static Option<NetworkParams> unapply(ChainIdBlockSemanticValidator chainIdBlockSemanticValidator) {
        return ChainIdBlockSemanticValidator$.MODULE$.unapply(chainIdBlockSemanticValidator);
    }

    public static ChainIdBlockSemanticValidator apply(NetworkParams networkParams) {
        return ChainIdBlockSemanticValidator$.MODULE$.apply(networkParams);
    }

    public static <A> Function1<NetworkParams, A> andThen(Function1<ChainIdBlockSemanticValidator, A> function1) {
        return ChainIdBlockSemanticValidator$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ChainIdBlockSemanticValidator> compose(Function1<A, NetworkParams> function1) {
        return ChainIdBlockSemanticValidator$.MODULE$.compose(function1);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Try<BoxedUnit> validate(AccountBlock block) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> block.transactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
            ChainIdBlockSemanticValidator.$anonfun$validate$2(this, block, tx);
            return BoxedUnit.UNIT;
        }));
    }

    public ChainIdBlockSemanticValidator copy(NetworkParams params) {
        return new ChainIdBlockSemanticValidator(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "ChainIdBlockSemanticValidator";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ChainIdBlockSemanticValidator;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ChainIdBlockSemanticValidator)) return false;
        boolean bl = true;
        if (!bl) return false;
        ChainIdBlockSemanticValidator chainIdBlockSemanticValidator = (ChainIdBlockSemanticValidator)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = chainIdBlockSemanticValidator.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!chainIdBlockSemanticValidator.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$validate$2(ChainIdBlockSemanticValidator $this, AccountBlock block$1, AccountTransaction tx) {
        if (tx.transactionTypeId() == AccountTransactionsIdsEnum.EthereumTransactionId.id()) {
            EthereumTransaction ethTx = (EthereumTransaction)tx;
            if (ethTx.isSigned()) {
                if ((ethTx.isEIP1559() || ethTx.isEIP155()) && !BoxesRunTime.equalsNumObject((Number)ethTx.getChainId(), (Object)BoxesRunTime.boxToLong((long)$this.params().chainId()))) {
                    BoxedUnit boxedUnit;
                    String errMsg = new StringBuilder(55).append("Transaction ").append(ethTx.id()).append(" chain ID ").append(ethTx.getChainId()).append(" ").append("does not match network chain ID ").append($this.params().chainId()).toString();
                    if ($this.log().underlying().isWarnEnabled()) {
                        $this.log().underlying().warn(errMsg);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new InvalidTransactionChainIdException(errMsg, InvalidTransactionChainIdException$.MODULE$.$lessinit$greater$default$2());
                }
            } else {
                throw new MissingTransactionSignatureException(new StringBuilder(46).append("Transaction ").append(ethTx.id()).append(" without signature found in block ").append(block$1.id()).toString(), MissingTransactionSignatureException$.MODULE$.$lessinit$greater$default$2());
            }
        }
    }

    public ChainIdBlockSemanticValidator(NetworkParams params) {
        this.params = params;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Product.$init$((Product)this);
    }
}

