/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.types;

import io.horizen.account.api.rpc.types.EthereumLogView;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import scala.collection.JavaConverters;

public class EthereumReceiptView {
    public final Hash blockHash;
    public final BigInteger blockNumber;
    public final BigInteger transactionIndex;
    public final Hash transactionHash;
    public final BigInteger type;
    public final Address from;
    public final Address to;
    public final BigInteger effectiveGasPrice;
    public final Address contractAddress;
    public final List<EthereumLogView> logs;
    public final byte[] logsBloom;
    public final BigInteger gasUsed;
    public final BigInteger cumulativeGasUsed;
    public final BigInteger status;

    public EthereumReceiptView(EthereumReceipt receipt, EthereumTransaction tx, BigInteger baseFee, int firstLogIndex) {
        this.blockHash = new Hash(receipt.blockHash());
        this.blockNumber = BigInteger.valueOf(receipt.blockNumber());
        this.transactionIndex = BigInteger.valueOf(receipt.transactionIndex());
        this.transactionHash = new Hash(receipt.transactionHash());
        this.type = BigInteger.valueOf(tx.version());
        this.from = tx.getFromAddress();
        this.to = tx.getToAddress();
        this.effectiveGasPrice = tx.getEffectiveGasPrice(baseFee);
        this.contractAddress = (Address)receipt.contractAddress().getOrElse(() -> null);
        List consensusLogs = JavaConverters.seqAsJavaList(receipt.consensusDataReceipt().logs());
        this.logs = IntStream.range(0, consensusLogs.size()).mapToObj(i -> new EthereumLogView(receipt, (EthereumConsensusDataLog)consensusLogs.get(i), firstLogIndex + i)).collect(Collectors.toList());
        this.logsBloom = receipt.consensusDataReceipt().logsBloom().getBytes();
        this.gasUsed = receipt.gasUsed();
        this.cumulativeGasUsed = receipt.consensusDataReceipt().cumulativeGasUsed();
        this.status = BigInteger.valueOf(receipt.consensusDataReceipt().status());
    }
}

