/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.api.rpc.handler.RpcHandler;
import io.horizen.account.api.rpc.handler.RpcResponseException;
import io.horizen.account.api.rpc.request.RpcId;
import io.horizen.account.api.rpc.request.RpcRequest;
import io.horizen.account.api.rpc.response.RpcResponseError;
import io.horizen.account.api.rpc.service.RpcProcessor$;
import io.horizen.account.api.rpc.utils.RpcCode;
import io.horizen.account.api.rpc.utils.RpcError;
import io.horizen.account.serialization.EthJsonMapper;
import io.horizen.api.http.ApiResponse;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001\u0002\f\u0018\u0001\u0012B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005w!)!\t\u0001C\u0001\u0007\")q\t\u0001C\u0001\u0011\"9\u0001\u000eAA\u0001\n\u0003I\u0007bB6\u0001#\u0003%\t\u0001\u001c\u0005\bo\u0002\t\t\u0011\"\u0011y\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\f\u0001\t\t\u0011\"\u0001\u0002\u000e!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00131\u0004\u0005\n\u0003S\u0001\u0011\u0011!C\u0001\u0003WA\u0011\"a\f\u0001\u0003\u0003%\t%!\r\t\u0013\u0005M\u0002!!A\u0005B\u0005U\u0002\"CA\u001c\u0001\u0005\u0005I\u0011IA\u001d\u000f%\tidFA\u0001\u0012\u0003\tyD\u0002\u0005\u0017/\u0005\u0005\t\u0012AA!\u0011\u0019\u0011\u0005\u0003\"\u0001\u0002P!I\u00111\u0007\t\u0002\u0002\u0013\u0015\u0013Q\u0007\u0005\n\u0003#\u0002\u0012\u0011!CA\u0003'B\u0011\"a\u0016\u0011\u0003\u0003%\t)!\u0017\t\u0013\u0005\u0015\u0004#!A\u0005\n\u0005\u001d$\u0001\u0004*qGB\u0013xnY3tg>\u0014(B\u0001\r\u001a\u0003\u001d\u0019XM\u001d<jG\u0016T!AG\u000e\u0002\u0007I\u00048M\u0003\u0002\u001d;\u0005\u0019\u0011\r]5\u000b\u0005yy\u0012aB1dG>,h\u000e\u001e\u0006\u0003A\u0005\nq\u0001[8sSj,gNC\u0001#\u0003\tIwn\u0001\u0001\u0014\u000b\u0001)3f\r\u001c\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\rM\u0004\u0018M]6{\u0013\t\u0011TFA\u0007Ta\u0006\u00148N\u001f'pO\u001eLgn\u001a\t\u0003MQJ!!N\u0014\u0003\u000fA\u0013x\u000eZ;diB\u0011aeN\u0005\u0003q\u001d\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!B\u001d9d\u0011\u0006tG\r\\3s+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 \u001a\u0003\u001dA\u0017M\u001c3mKJL!\u0001Q\u001f\u0003\u0015I\u00038\rS1oI2,'/A\u0006sa\u000eD\u0015M\u001c3mKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002E\rB\u0011Q\tA\u0007\u0002/!)\u0011h\u0001a\u0001w\u0005i\u0001O]8dKN\u001cX\t\u001e5Sa\u000e$\"!\u0013.\u0011\t\u0019REjV\u0005\u0003\u0017\u001e\u0012a\u0001V;qY\u0016\u0014\u0004CA'U\u001d\tq%\u000b\u0005\u0002PO5\t\u0001K\u0003\u0002RG\u00051AH]8pizJ!aU\u0014\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'\u001e\u0002\"A\n-\n\u0005e;#a\u0002\"p_2,\u0017M\u001c\u0005\u00067\u0012\u0001\r\u0001X\u0001\u0005E>$\u0017\u0010\u0005\u0002^M6\taL\u0003\u0002`A\u0006AA-\u0019;bE&tGM\u0003\u0002bE\u00069!.Y2lg>t'BA2e\u0003%1\u0017m\u001d;feblGNC\u0001f\u0003\r\u0019w.\\\u0005\u0003Oz\u0013\u0001BS:p]:{G-Z\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002EU\"9\u0011(\u0002I\u0001\u0002\u0004Y\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002[*\u00121H\\\u0016\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001^\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002wc\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005I\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u0011a\u0017M\\4\u000b\u0003y\fAA[1wC&\u0011Qk_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000b\u00012AJA\u0004\u0013\r\tIa\n\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001f\t)\u0002E\u0002'\u0003#I1!a\u0005(\u0005\r\te.\u001f\u0005\n\u0003/I\u0011\u0011!a\u0001\u0003\u000b\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u000f!\u0019\ty\"!\n\u0002\u00105\u0011\u0011\u0011\u0005\u0006\u0004\u0003G9\u0013AC2pY2,7\r^5p]&!\u0011qEA\u0011\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007]\u000bi\u0003C\u0005\u0002\u0018-\t\t\u00111\u0001\u0002\u0010\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0006\u0005AAo\\*ue&tw\rF\u0001z\u0003\u0019)\u0017/^1mgR\u0019q+a\u000f\t\u0013\u0005]a\"!AA\u0002\u0005=\u0011\u0001\u0004*qGB\u0013xnY3tg>\u0014\bCA#\u0011'\u0011\u0001\u00121\t\u001c\u0011\r\u0005\u0015\u00131J\u001eE\u001b\t\t9EC\u0002\u0002J\u001d\nqA];oi&lW-\u0003\u0003\u0002N\u0005\u001d#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011qH\u0001\u0006CB\u0004H.\u001f\u000b\u0004\t\u0006U\u0003\"B\u001d\u0014\u0001\u0004Y\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u00037\n\t\u0007\u0005\u0003'\u0003;Z\u0014bAA0O\t1q\n\u001d;j_:D\u0001\"a\u0019\u0015\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u001b\u0011\u0007i\fY'C\u0002\u0002nm\u0014aa\u00142kK\u000e$\b")
public class RpcProcessor
implements SparkzLogging,
Product,
scala.Serializable {
    private final RpcHandler rpcHandler;
    private final Logger logger;

    public static Option<RpcHandler> unapply(RpcProcessor rpcProcessor) {
        return RpcProcessor$.MODULE$.unapply(rpcProcessor);
    }

    public static RpcProcessor apply(RpcHandler rpcHandler) {
        return RpcProcessor$.MODULE$.apply(rpcHandler);
    }

    public static <A> Function1<RpcHandler, A> andThen(Function1<RpcProcessor, A> function1) {
        return RpcProcessor$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, RpcProcessor> compose(Function1<A, RpcHandler> function1) {
        return RpcProcessor$.MODULE$.compose(function1);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RpcHandler rpcHandler() {
        return this.rpcHandler;
    }

    public Tuple2<String, Object> processEthRpc(JsonNode body2) {
        BoxedUnit boxedUnit;
        String json2;
        JsonNode[] jsonNodeArray;
        boolean jsonIsArray = false;
        if (body2.isArray() && !body2.isEmpty()) {
            jsonIsArray = true;
            jsonNodeArray = (JsonNode[])((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(body2.iterator()).asScala()).toArray(ClassTag$.MODULE$.apply(JsonNode.class));
        } else {
            jsonNodeArray = (JsonNode[])((Object[])new JsonNode[]{body2});
        }
        JsonNode[] requests = jsonNodeArray;
        BooleanRef hasError = BooleanRef.create((boolean)false);
        ApiResponse[] responses = (ApiResponse[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requests)).map((Function1 & Serializable & scala.Serializable)json -> {
            BoxedUnit boxedUnit;
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new RpcRequest((JsonNode)json)).map((Function1 & Serializable & scala.Serializable)request -> this.rpcHandler().apply((RpcRequest)request));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ApiResponse value = (ApiResponse)success.value();
                return value;
            }
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (exception instanceof RpcResponseException) {
                    RpcResponseException rpcResponseException = (RpcResponseException)exception;
                    hasError$1.elem = true;
                    return new RpcResponseError(rpcResponseException.id, rpcResponseException.error);
                }
            }
            if (!bl) throw new MatchError((Object)try_);
            Throwable exception = failure.exception();
            if (this.log().underlying().isTraceEnabled()) {
                this.log().underlying().trace("internal error on RPC call: {}", exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            hasError$1.elem = true;
            return new RpcResponseError(new RpcId(), RpcError.fromCode(RpcCode.InvalidRequest));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ApiResponse.class)));
        String string = json2 = jsonIsArray ? EthJsonMapper.serialize(responses) : EthJsonMapper.serialize(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])responses)).head());
        if (this.log().underlying().isTraceEnabled()) {
            this.log().underlying().trace("RPC message response << {}", new Object[]{json2});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)json2, (Object)BoxesRunTime.boxToBoolean((boolean)hasError.elem));
    }

    public RpcProcessor copy(RpcHandler rpcHandler) {
        return new RpcProcessor(rpcHandler);
    }

    public RpcHandler copy$default$1() {
        return this.rpcHandler();
    }

    public String productPrefix() {
        return "RpcProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.rpcHandler();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RpcProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RpcProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        RpcProcessor rpcProcessor = (RpcProcessor)x$1;
        RpcHandler rpcHandler = this.rpcHandler();
        RpcHandler rpcHandler2 = rpcProcessor.rpcHandler();
        if (rpcHandler == null) {
            if (rpcHandler2 != null) {
                return false;
            }
        } else if (!rpcHandler.equals(rpcHandler2)) return false;
        if (!rpcProcessor.canEqual(this)) return false;
        return true;
    }

    public RpcProcessor(RpcHandler rpcHandler) {
        this.rpcHandler = rpcHandler;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Product.$init$((Product)this);
    }
}

