/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.request;

import com.fasterxml.jackson.databind.JsonNode;
import io.horizen.account.api.rpc.handler.RpcResponseException;
import io.horizen.account.api.rpc.request.RpcId;
import io.horizen.account.api.rpc.utils.RpcCode;
import io.horizen.account.api.rpc.utils.RpcError;
import java.util.List;

public class RpcRequest {
    public final String jsonrpc;
    public final RpcId id;
    public final String method;
    public final JsonNode params;
    private static final String mandatoryIdField = "id";
    private static final List<String> otherMandatoryFields = List.of("jsonrpc", "method");
    private static final List<String> stringFields = List.of("jsonrpc", "method");
    private static final String JSON_RPC_VERSION = "2.0";

    public RpcRequest(JsonNode json) throws RpcResponseException {
        if (json.isArray() && json.isEmpty()) {
            throw new RpcResponseException(RpcError.fromCode(RpcCode.InvalidRequest, "Empty array as input"), new RpcId());
        }
        if (!json.has(mandatoryIdField)) {
            throw new RpcResponseException(RpcError.fromCode(RpcCode.InvalidRequest, String.format("missing field: %s", mandatoryIdField)), new RpcId());
        }
        try {
            this.id = new RpcId(json.get(mandatoryIdField));
        }
        catch (IllegalArgumentException e) {
            throw new RpcResponseException(RpcError.fromCode(RpcCode.InvalidRequest, e.getMessage()), new RpcId());
        }
        for (String field : otherMandatoryFields) {
            if (json.has(field)) continue;
            throw new RpcResponseException(RpcError.fromCode(RpcCode.InvalidRequest, String.format("missing field: %s", field)), this.id);
        }
        for (String field : stringFields) {
            if (json.get(field).isTextual()) continue;
            throw new RpcResponseException(RpcError.fromCode(RpcCode.InvalidRequest, String.format("field must be string: %s", field)), this.id);
        }
        this.jsonrpc = json.get("jsonrpc").asText();
        if (!this.jsonrpc.equals(JSON_RPC_VERSION)) {
            throw new RpcResponseException(RpcError.fromCode(RpcCode.InvalidRequest, "jsonrpc value is not valid"), this.id);
        }
        this.method = json.get("method").asText();
        this.params = json.get("params");
    }

    public String toString() {
        return String.format("RpcRequest={jsonrpc='%s', id='%s', method='%s', params=%s}", this.jsonrpc, this.id.toString(), this.method, this.params);
    }
}

