/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.wallet;

import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.consensus.ForgingStakeInfo$;
import io.horizen.consensus.package$ConsensusEpochNumber$;
import io.horizen.params.NetworkParams;
import io.horizen.proposition.ProofOfKnowledgeProposition;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.storage.SidechainSecretStorage;
import io.horizen.storage.leveldb.package$Constants$;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ForgingStakeMerklePathInfo;
import io.horizen.utils.Utils;
import io.horizen.utils.package$;
import io.horizen.utxo.backup.BackupBox;
import io.horizen.utxo.backup.BoxIterator;
import io.horizen.utxo.block.SidechainBlock;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.CoinsBox;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.node.NodeWallet;
import io.horizen.utxo.state.SidechainState$;
import io.horizen.utxo.state.UtxoMerkleTreeView;
import io.horizen.utxo.storage.ForgingBoxesInfoStorage;
import io.horizen.utxo.storage.SidechainWalletBoxStorage;
import io.horizen.utxo.storage.SidechainWalletTransactionStorage;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.utils.CswData;
import io.horizen.utxo.wallet.ApplicationWallet;
import io.horizen.utxo.wallet.SidechainWalletCswDataProvider;
import io.horizen.utxo.wallet.WalletBox;
import io.horizen.wallet.AbstractWallet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.transaction.state.BoxStateChanges;
import sparkz.util.package;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\r}c\u0001\u0002\u0014(\u0001AB\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A1\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003s\u0011!)\bA!A!\u0002\u00131\b\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0011u\u0004!\u0011!Q\u0001\nyD!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011)\ty\u0003\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003c\u0001!Q1A\u0005\u0002\u0005M\u0002BCA\u001e\u0001\t\u0005\t\u0015!\u0003\u00026!A\u0011Q\b\u0001\u0005\u0002-\ny$B\u0003\u0002T\u0001\u0001c\nC\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u0003+\u0003A\u0011AAX\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDqAa\u0003\u0001\t\u0003\u0012i\u0001C\u0004\u0003\u0014\u0001!\tE!\u0006\t\u000f\tM\u0001\u0001\"\u0011\u0003\"!9!\u0011\u0006\u0001\u0005\u0002\t-\u0002b\u0002B\u0015\u0001\u0011\u0005!\u0011\r\u0005\b\u0005\u007f\u0002A\u0011\u0001BA\u0011\u001d\u0011\u0019\u000b\u0001C!\u0005KCqAa*\u0001\t\u0003\u0012I\u000bC\u0004\u0003<\u0002!\tA!0\t\u000f\t-\b\u0001\"\u0001\u0003n\"9!q \u0001\u0005\u0002\r\u0005\u0001BDB\u0002\u0001A\u0005\u0019\u0011!A\u0005\n\r\u00151\u0011\u0002\u0005\u000f\u0007\u0017\u0001\u0001\u0013aA\u0001\u0002\u0013%1QBB\t\u000f\u001d\u0019\u0019b\nE\u0001\u0007+1aAJ\u0014\t\u0002\r]\u0001bBA\u001fE\u0011\u00051q\u0004\u0005\t\u0007C\u0011C\u0011A\u0016\u0004$!A1q\u0007\u0012\u0005\u0002-\u001aIDA\bTS\u0012,7\r[1j]^\u000bG\u000e\\3u\u0015\tA\u0013&\u0001\u0004xC2dW\r\u001e\u0006\u0003U-\nA!\u001e;y_*\u0011A&L\u0001\bQ>\u0014\u0018N_3o\u0015\u0005q\u0013AA5p\u0007\u0001\u0019B\u0001A\u0019Q)B)!\u0007\u000e\u001cI\u001d6\t1G\u0003\u0002)W%\u0011Qg\r\u0002\u000f\u0003\n\u001cHO]1di^\u000bG\u000e\\3u!\u00119$\b\u0010\"\u000e\u0003aR!!O\u0015\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003wa\u0012aBQ8y)J\fgn]1di&|g\u000e\u0005\u0002>\u00016\taH\u0003\u0002@W\u0005Y\u0001O]8q_NLG/[8o\u0013\t\teHA\u0006Qe>\u0004xn]5uS>t\u0007cA\"Gy5\tAI\u0003\u0002FS\u0005\u0019!m\u001c=\n\u0005\u001d#%a\u0001\"pqB\u0011\u0011\nT\u0007\u0002\u0015*\u00111*K\u0001\u0006E2|7m[\u0005\u0003\u001b*\u0013abU5eK\u000eD\u0017-\u001b8CY>\u001c7\u000e\u0005\u0002P\u00015\tq\u0005\u0005\u0002R%6\t1&\u0003\u0002TW\tq1+\u001b3fG\"\f\u0017N\u001c+za\u0016\u001c\bCA+Y\u001b\u00051&BA,*\u0003\u0011qw\u000eZ3\n\u0005e3&A\u0003(pI\u0016<\u0016\r\u001c7fi\u0006!1/Z3e!\rav,Y\u0007\u0002;*\ta,A\u0003tG\u0006d\u0017-\u0003\u0002a;\n)\u0011I\u001d:bsB\u0011ALY\u0005\u0003Gv\u0013AAQ=uK\u0006\u0001r/\u00197mKR\u0014u\u000e_*u_J\fw-\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q&\nqa\u001d;pe\u0006<W-\u0003\u0002kO\nI2+\u001b3fG\"\f\u0017N\\,bY2,GOQ8y'R|'/Y4f\u00035\u0019Xm\u0019:fiN#xN]1hKB\u0011Qn\\\u0007\u0002]*\u0011\u0001nK\u0005\u0003a:\u0014acU5eK\u000eD\u0017-\u001b8TK\u000e\u0014X\r^*u_J\fw-Z\u0001\u0019o\u0006dG.\u001a;Ue\u0006t7/Y2uS>t7\u000b^8sC\u001e,\u0007C\u00014t\u0013\t!xMA\u0011TS\u0012,7\r[1j]^\u000bG\u000e\\3u)J\fgn]1di&|gn\u0015;pe\u0006<W-A\fg_J<\u0017N\\4C_b,7/\u00138g_N#xN]1hKB\u0011am^\u0005\u0003q\u001e\u0014qCR8sO&twMQ8yKNLeNZ8Ti>\u0014\u0018mZ3\u0002\u001f\r\u001cx\u000fR1uCB\u0013xN^5eKJ\u0004\"aT>\n\u0005q<#AH*jI\u0016\u001c\u0007.Y5o/\u0006dG.\u001a;Dg^$\u0015\r^1Qe>4\u0018\u000eZ3s\u0003\u0019\u0001\u0018M]1ngB\u0019q0a\u0001\u000e\u0005\u0005\u0005!BA?,\u0013\u0011\t)!!\u0001\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u001d1XM]:j_:,\"!a\u0003\u0011\t\u00055\u0011\u0011\u0006\b\u0005\u0003\u001f\t\u0019C\u0004\u0003\u0002\u0012\u0005ua\u0002BA\n\u00033i!!!\u0006\u000b\u0007\u0005]q&\u0001\u0004=e>|GOP\u0005\u0003\u00037\taa\u001d9be.T\u0018\u0002BA\u0010\u0003C\tAaY8sK*\u0011\u00111D\u0005\u0005\u0003K\t9#A\u0004qC\u000e\\\u0017mZ3\u000b\t\u0005}\u0011\u0011E\u0005\u0005\u0003W\tiC\u0001\u0006WKJ\u001c\u0018n\u001c8UC\u001eTA!!\n\u0002(\u0005Aa/\u001a:tS>t\u0007%A\tbaBd\u0017nY1uS>tw+\u00197mKR,\"!!\u000e\u0011\u0007=\u000b9$C\u0002\u0002:\u001d\u0012\u0011#\u00119qY&\u001c\u0017\r^5p]^\u000bG\u000e\\3u\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8XC2dW\r\u001e\u0011\u0002\rqJg.\u001b;?)Mq\u0015\u0011IA\"\u0003\u000b\n9%!\u0013\u0002L\u00055\u0013qJA)\u0011\u0015QF\u00021\u0001\\\u0011\u0015!G\u00021\u0001f\u0011\u0015YG\u00021\u0001m\u0011\u0015\tH\u00021\u0001s\u0011\u0015)H\u00021\u0001w\u0011\u0015IH\u00021\u0001{\u0011\u0015iH\u00021\u0001\u007f\u0011\u001d\t9\u0001\u0004a\u0001\u0003\u0017Aq!!\r\r\u0001\u0004\t)D\u0001\u0003O-\u000e#\u0016!C1eIN+7M]3u)\u0011\tI&!\u001a\u0011\u000b\u0005m\u0013\u0011\r(\u000e\u0005\u0005u#bAA0;\u0006!Q\u000f^5m\u0013\u0011\t\u0019'!\u0018\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002h9\u0001\r!!\u001b\u0002\rM,7M]3u!\u0011\tY'a\u001c\u000e\u0005\u00055$bAA4W%!\u0011\u0011OA7\u0005\u0019\u0019Vm\u0019:fi\u0006a!/Z7pm\u0016\u001cVm\u0019:fiR!\u0011\u0011LA<\u0011\u0019\tIh\u0004a\u0001y\u0005Y\u0001/\u001e2mS\u000eLU.Y4f\u0003\u0015\u0011w\u000e_3t)\t\ty\b\u0005\u0004\u0002\u0002\u0006%\u0015q\u0012\b\u0005\u0003\u0007\u000b9I\u0004\u0003\u0002\u0014\u0005\u0015\u0015\"\u00010\n\u0007\u0005\u0015R,\u0003\u0003\u0002\f\u00065%aA*fc*\u0019\u0011QE/\u0011\u0007=\u000b\t*C\u0002\u0002\u0014\u001e\u0012\u0011bV1mY\u0016$(i\u001c=\u0002\u001dM\u001c\u0017M\u001c)feNL7\u000f^3oiR\u0019a*!'\t\r\u0005m\u0015\u00031\u0001I\u0003!iw\u000eZ5gS\u0016\u0014\bfA\t\u0002 B!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016\u0001\u00027b]\u001eT!!!+\u0002\t)\fg/Y\u0005\u0005\u0003[\u000b\u0019K\u0001\u0006EKB\u0014XmY1uK\u0012$\u0012BTAY\u0003g\u000bi,!3\t\r\u0005m%\u00031\u0001I\u0011\u001d\t)L\u0005a\u0001\u0003o\u000bqb^5uQ\u0012\u0014\u0018m^1m\u000bB|7\r\u001b\t\u00049\u0006e\u0016bAA^;\n\u0019\u0011J\u001c;\t\u000f\u0005}&\u00031\u0001\u0002B\u0006ya-Z3QCflWM\u001c;C_b,7\u000f\u0005\u0004\u0002\u0002\u0006%\u00151\u0019\t\u0004\u0007\u0006\u0015\u0017bAAd\t\n1!,\u001a8C_bDq!a3\u0013\u0001\u0004\ti-A\u000bvib|W*\u001a:lY\u0016$&/Z3WS\u0016<x\n\u001d;\u0011\u000bq\u000by-a5\n\u0007\u0005EWL\u0001\u0004PaRLwN\u001c\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\\\u0015\u0002\u000bM$\u0018\r^3\n\t\u0005u\u0017q\u001b\u0002\u0013+RDx.T3sW2,GK]3f-&,w/\u0001\u0006tG\u0006t')Y2l+B$b!!\u0017\u0002d\u0006M\bbBAs'\u0001\u0007\u0011q]\u0001\u0019E\u0006\u001c7.\u001e9Ti>\u0014\u0018mZ3C_bLE/\u001a:bi>\u0014\b\u0003BAu\u0003_l!!a;\u000b\u0007\u00055\u0018&\u0001\u0004cC\u000e\\W\u000f]\u0005\u0005\u0003c\fYOA\u0006C_bLE/\u001a:bi>\u0014\bbBA{'\u0001\u0007\u0011q_\u0001\u0016O\u0016tWm]5t\u00052|7m\u001b+j[\u0016\u001cH/Y7q!\u0011\tIP!\u0002\u000f\t\u0005m\u0018q \b\u0005\u0003\u001f\ti0C\u0002L\u0003OIAA!\u0001\u0003\u0004\u0005)!\t\\8dW*\u00191*a\n\n\t\t\u001d!\u0011\u0002\u0002\n)&lWm\u001d;b[BTAA!\u0001\u0003\u0004\u0005A!o\u001c7mE\u0006\u001c7\u000e\u0006\u0003\u0002Z\t=\u0001b\u0002B\t)\u0001\u0007\u00111B\u0001\u0003i>\f\u0001\"\u00197m\u0005>DXm\u001d\u000b\u0003\u0005/\u0001RA!\u0007\u0003\u001e\tk!Aa\u0007\u000b\t\u0005}\u0013qU\u0005\u0005\u0005?\u0011YB\u0001\u0003MSN$H\u0003\u0002B\f\u0005GAqA!\n\u0017\u0001\u0004\u00119#A\bc_bLEm\u001d+p\u000bb\u001cG.\u001e3f!\u0015\u0011IB!\b\\\u0003-\u0011w\u000e_3t\u001f\u001a$\u0016\u0010]3\u0015\t\t]!Q\u0006\u0005\b\u0005_9\u0002\u0019\u0001B\u0019\u0003\u001d\u0011w\u000e\u001f+za\u0016\u0004DAa\r\u0003HA1!Q\u0007B\u001f\u0005\u0007rAAa\u000e\u0003:A\u0019\u00111C/\n\u0007\tmR,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u007f\u0011\tEA\u0003DY\u0006\u001c8OC\u0002\u0003<u\u0003BA!\u0012\u0003H1\u0001A\u0001\u0004B%\u0005[\t\t\u0011!A\u0003\u0002\t-#aA0%gE!!Q\nB*!\ra&qJ\u0005\u0004\u0005#j&a\u0002(pi\"Lgn\u001a\u0019\u0005\u0005+\u0012I\u0006\u0005\u0003D\r\n]\u0003\u0003\u0002B#\u00053\"ABa\u0017\u0003^\u0005\u0005\t\u0011!B\u0001\u0005?\u00121a\u0018\u00135\t1\u0011IE!\f\u0002\u0002\u0007\u0005)\u0011\u0001B&#\r\u0011i\u0005\u0010\u000b\u0007\u0005/\u0011\u0019G! \t\u000f\t=\u0002\u00041\u0001\u0003fA\"!q\rB6!\u0019\u0011)D!\u0010\u0003jA!!Q\tB6\t1\u0011iGa\u0019\u0002\u0002\u0003\u0005)\u0011\u0001B8\u0005\ryF%N\t\u0005\u0005\u001b\u0012\t\b\r\u0003\u0003t\t]\u0004\u0003B\"G\u0005k\u0002BA!\u0012\u0003x\u0011a!\u0011\u0010B>\u0003\u0003\u0005\tQ!\u0001\u0003`\t\u0019q\f\n\u001c\u0005\u0019\t5$1MA\u0001\u0004\u0003\u0015\tAa\u001c\t\u000f\t\u0015\u0002\u00041\u0001\u0003(\u0005a!m\u001c=fg\n\u000bG.\u00198dKR!!1\u0011BE!\u0011\t\tK!\"\n\t\t\u001d\u00151\u0015\u0002\u0005\u0019>tw\rC\u0004\u00030e\u0001\rAa#1\t\t5%\u0011\u0013\t\u0007\u0005k\u0011iDa$\u0011\t\t\u0015#\u0011\u0013\u0003\r\u0005'\u0013I)!A\u0001\u0002\u000b\u0005!Q\u0013\u0002\u0004?\u0012:\u0014\u0003\u0002B'\u0005/\u0003DA!'\u0003\u001eB!1I\u0012BN!\u0011\u0011)E!(\u0005\u0019\t}%\u0011UA\u0001\u0002\u0003\u0015\tAa\u0018\u0003\u0007}#\u0003\b\u0002\u0007\u0003\u0014\n%\u0015\u0011aA\u0001\u0006\u0003\u0011)*\u0001\u000bbY2\u001cu.\u001b8t\u0005>DXm\u001d\"bY\u0006t7-\u001a\u000b\u0003\u0005\u0007\u000bq#\u00199qYf\u001cuN\\:f]N,8/\u00129pG\"LeNZ8\u0015\u00079\u0013Y\u000bC\u0004\u0003.n\u0001\rAa,\u0002\u0013\u0015\u0004xn\u00195J]\u001a|\u0007\u0003\u0002BY\u0005ok!Aa-\u000b\u0007\tU6&A\u0005d_:\u001cXM\\:vg&!!\u0011\u0018BZ\u0005I\u0019uN\\:f]N,8/\u00129pG\"LeNZ8\u0002A\u001d,GOR8sO&twm\u0015;bW\u0016lUM]6mKB\u000bG\u000f[%oM>|\u0005\u000f\u001e\u000b\u0005\u0005\u007f\u0013y\rE\u0003]\u0003\u001f\u0014\t\r\u0005\u0004\u0002\u0002\u0006%%1\u0019\t\u0005\u0005\u000b\u0014Y-\u0004\u0002\u0003H*\u0019!\u0011Z\u0016\u0002\u000bU$\u0018\u000e\\:\n\t\t5'q\u0019\u0002\u001b\r>\u0014x-\u001b8h'R\f7.Z'fe.dW\rU1uQ&sgm\u001c\u0005\b\u0005#d\u0002\u0019\u0001Bj\u00039\u0011X-];fgR,G-\u00129pG\"\u0004BA!6\u0003f:!!q\u001bBr\u001d\u0011\u0011IN!9\u000f\t\tm'q\u001c\b\u0005\u0003'\u0011i.C\u0001/\u0013\taS&C\u0002\u00036.JA!!\n\u00034&!!q\u001dBu\u0005Q\u0019uN\\:f]N,8/\u00129pG\"tU/\u001c2fe*!\u0011Q\u0005BZ\u0003)9W\r^\"to\u0012\u000bG/\u0019\u000b\u0005\u0005_\u0014Y\u0010\u0005\u0004\u0002\u0002\u0006%%\u0011\u001f\t\u0005\u0005g\u001490\u0004\u0002\u0003v*\u0019!\u0011Z\u0015\n\t\te(Q\u001f\u0002\b\u0007N<H)\u0019;b\u0011\u001d\u0011i0\ba\u0001\u0003o\u000bQc^5uQ\u0012\u0014\u0018m^1m\u000bB|7\r\u001b(v[\n,'/\u0001\u0013f]N,(/Z*u_J\fw-Z\"p]NL7\u000f^3oGf\fe\r^3s%\u0016\u001cHo\u001c:f+\t\tI&A\btkB,'\u000fJ1eIN+7M]3u)\u0011\tIfa\u0002\t\u000f\u0005\u001dt\u00041\u0001\u0002j%\u0019\u0011Q\u000b\u001b\u0002%M,\b/\u001a:%e\u0016lwN^3TK\u000e\u0014X\r\u001e\u000b\u0005\u00033\u001ay\u0001\u0003\u0004\u0002z\u0001\u0002\r\u0001P\u0005\u0004\u0003g\"\u0014aD*jI\u0016\u001c\u0007.Y5o/\u0006dG.\u001a;\u0011\u0005=\u00133c\u0001\u0012\u0004\u001aA\u0019Ala\u0007\n\u0007\ruQL\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007+\tQB]3ti>\u0014XmV1mY\u0016$HCEB\u0013\u0007O\u0019Ica\u000b\u0004.\r=2\u0011GB\u001a\u0007k\u0001B\u0001XAh\u001d\")!\f\na\u00017\")A\r\na\u0001K\")1\u000e\na\u0001Y\")\u0011\u000f\na\u0001e\")Q\u000f\na\u0001m\")\u0011\u0010\na\u0001u\")Q\u0010\na\u0001}\"9\u0011\u0011\u0007\u0013A\u0002\u0005U\u0012aE2sK\u0006$XmR3oKNL7oV1mY\u0016$HCGA-\u0007w\u0019ida\u0010\u0004B\r\r3QIB$\u0007#\u001a\u0019f!\u0016\u0004Z\rm\u0003\"\u0002.&\u0001\u0004Y\u0006\"\u00023&\u0001\u0004)\u0007\"B6&\u0001\u0004a\u0007\"B9&\u0001\u0004\u0011\b\"B;&\u0001\u00041\b\"B=&\u0001\u0004Q\bbBB%K\u0001\u000711J\u0001\u000eE\u0006\u001c7.\u001e9Ti>\u0014\u0018mZ3\u0011\u0007\u0019\u001ci%C\u0002\u0004P\u001d\u0014QBQ1dWV\u00048\u000b^8sC\u001e,\u0007\"B?&\u0001\u0004q\bbBA\u0019K\u0001\u0007\u0011Q\u0007\u0005\u0007\u0007/*\u0003\u0019\u0001%\u0002\u0019\u001d,g.Z:jg\ncwnY6\t\u000f\tuX\u00051\u0001\u00028\"91QL\u0013A\u0002\t=\u0016AE2p]N,gn];t\u000bB|7\r[%oM>\u0004")
public class SidechainWallet
extends AbstractWallet<BoxTransaction<Proposition, Box<Proposition>>, SidechainBlock, SidechainWallet>
implements NodeWallet {
    private final byte[] seed;
    private final SidechainWalletBoxStorage walletBoxStorage;
    private final SidechainSecretStorage secretStorage;
    private final SidechainWalletTransactionStorage walletTransactionStorage;
    private final ForgingBoxesInfoStorage forgingBoxesInfoStorage;
    private final SidechainWalletCswDataProvider cswDataProvider;
    private final NetworkParams params;
    private final String version;
    private final ApplicationWallet applicationWallet;

    private /* synthetic */ Try super$addSecret(Secret secret) {
        return super.addSecret(secret);
    }

    private /* synthetic */ Try super$removeSecret(Proposition publicImage) {
        return super.removeSecret(publicImage);
    }

    public String version() {
        return this.version;
    }

    public ApplicationWallet applicationWallet() {
        return this.applicationWallet;
    }

    @Override
    public Try<SidechainWallet> addSecret(Secret secret) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.super$addSecret(secret).get();
            this.applicationWallet().onAddSecret(secret);
            return this;
        });
    }

    @Override
    public Try<SidechainWallet> removeSecret(Proposition publicImage) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.super$removeSecret(publicImage).get();
            this.applicationWallet().onRemoveSecret(publicImage);
            return this;
        });
    }

    public Seq<WalletBox> boxes() {
        return this.walletBoxStorage.getAll();
    }

    @Deprecated
    public SidechainWallet scanPersistent(SidechainBlock modifier) {
        throw new UnsupportedOperationException();
    }

    public SidechainWallet scanPersistent(SidechainBlock modifier, int withdrawalEpoch, Seq<ZenBox> feePaymentBoxes, Option<UtxoMerkleTreeView> utxoMerkleTreeViewOpt) {
        byte[] version = BytesUtils.fromHexString(modifier.id());
        BoxStateChanges changes = (BoxStateChanges)SidechainState$.MODULE$.changes(modifier).get();
        Set<Proposition> pubKeys = this.publicKeys();
        java.util.List privKeys = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.secretStorage.getAll()).asJava();
        Map txBoxes = (Map)modifier.transactions().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(accMap, tx) -> accMap.$plus$plus((GenTraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(tx.boxIdsToOpen()).asScala()).map((Function1 & Serializable & scala.Serializable)boxId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(boxId), tx), Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tx.newBoxes()).asScala()).map((Function1 & Serializable & scala.Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ByteArrayWrapper(b.id())), tx), Buffer$.MODULE$.canBuildFrom())));
        Seq newBoxes = (Seq)((TraversableLike)changes.toAppend().map((Function1 & Serializable & scala.Serializable)x$1 -> (Box)x$1.box(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)feePaymentBoxes.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq newWalletBoxes = (Seq)newBoxes.withFilter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainWallet.$anonfun$scanPersistent$6(privKeys, box))).map((Function1 & Serializable & scala.Serializable)box -> {
            WalletBox walletBox;
            if (txBoxes.contains((Object)package$.MODULE$.byteArrayToWrapper(box.id()))) {
                BoxTransaction boxTransaction = (BoxTransaction)txBoxes.apply((Object)package$.MODULE$.byteArrayToWrapper(box.id()));
                walletBox = new WalletBox((Box<Proposition>)box, (String)package.ModifierId$.MODULE$.$at$at((Object)boxTransaction.id(), package.Tagger$.MODULE$.baseRaw()), modifier.timestamp());
            } else {
                walletBox = new WalletBox((Box<Proposition>)box, modifier.timestamp());
            }
            return walletBox;
        }, Seq$.MODULE$.canBuildFrom());
        Seq newDelegatedForgerBoxes = (Seq)((TraversableLike)newBoxes.withFilter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SidechainWallet.$anonfun$scanPersistent$8(x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> (ForgerBox)x$4, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)forgerBox -> BoxesRunTime.boxToBoolean((boolean)pubKeys.contains((Object)forgerBox.blockSignProposition())));
        Seq boxIdsToRemove = (Seq)changes.toRemove().map((Function1 & Serializable & scala.Serializable)x$5 -> (byte[])Predef$.MODULE$.wrapByteArray(x$5.boxId()).array(), Seq$.MODULE$.canBuildFrom());
        try {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("calling applicationWallet.onChangeBoxes");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.applicationWallet().onChangeBoxes(version, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)newBoxes.toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)boxIdsToRemove.toList()).asJava());
            Seq transactions = (Seq)((SeqLike)((TraversableLike)((TraversableLike)newWalletBoxes.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.box().id(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)boxIdsToRemove, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(txBoxes.get((Object)package$.MODULE$.byteArrayToWrapper((byte[])id))), Seq$.MODULE$.canBuildFrom())).distinct();
            this.walletBoxStorage.update(new ByteArrayWrapper(version), (List<WalletBox>)newWalletBoxes.toList(), (List<byte[]>)boxIdsToRemove.toList()).get();
            this.walletTransactionStorage.update(new ByteArrayWrapper(version), (Seq<BoxTransaction<Proposition, Box<Proposition>>>)transactions).get();
            this.forgingBoxesInfoStorage.updateForgerBoxes(new ByteArrayWrapper(version), (Seq<ForgerBox>)newDelegatedForgerBoxes, (Seq<byte[]>)boxIdsToRemove).get();
            this.cswDataProvider.update(modifier, new ByteArrayWrapper(version), withdrawalEpoch, this.params, this, utxoMerkleTreeViewOpt);
        }
        catch (Exception e) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(50).append("Could not update application wallet and storages: ").append(e.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        return this;
    }

    public Try<SidechainWallet> scanBackUp(BoxIterator backupStorageBoxIterator, long genesisBlockTimestamp) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Set<Proposition> pubKeys = this.publicKeys();
            ArrayList<WalletBox> walletBoxes = new ArrayList<WalletBox>();
            ArrayList removeList = new ArrayList();
            int nBoxes = 0;
            Optional<BackupBox> optionalBox = backupStorageBoxIterator.nextBox();
            while (optionalBox.isPresent()) {
                Box<Proposition> box = optionalBox.get().getBox();
                if (pubKeys.contains((Object)box.proposition())) {
                    walletBoxes.add(new WalletBox(box, genesisBlockTimestamp));
                    if (++nBoxes == package$Constants$.MODULE$.BatchSize()) {
                        $this.walletBoxStorage.update(new ByteArrayWrapper(Utils.nextVersion()), (List<WalletBox>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(walletBoxes).asScala()).toList(), (List<byte[]>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(removeList).asScala()).toList()).get();
                        walletBoxes.clear();
                        nBoxes = 0;
                    }
                }
                optionalBox = backupStorageBoxIterator.nextBox();
            }
            Object object = nBoxes > 0 ? $this.walletBoxStorage.update(new ByteArrayWrapper(Utils.nextVersion()), (List<WalletBox>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(walletBoxes).asScala()).toList(), (List<byte[]>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(removeList).asScala()).toList()).get() : BoxedUnit.UNIT;
            backupStorageBoxIterator.seekToFirst();
            this.applicationWallet().onBackupRestore(backupStorageBoxIterator);
            return this;
        });
    }

    public Try<SidechainWallet> rollback(String to) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("rolling back wallet to version = {}", new Object[]{to});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Predef$.MODULE$.require(to != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            ByteArrayWrapper version = new ByteArrayWrapper(BytesUtils.fromHexString(to));
            $this.cswDataProvider.rollback(version).get();
            $this.forgingBoxesInfoStorage.rollback(version).get();
            $this.walletTransactionStorage.rollback(version).get();
            $this.walletBoxStorage.rollback(version).get();
            this.applicationWallet().onRollback(version.data());
            return new SidechainWallet($this.seed, $this.walletBoxStorage, $this.secretStorage, $this.walletTransactionStorage, $this.forgingBoxesInfoStorage, $this.cswDataProvider, $this.params, to, this.applicationWallet());
        });
    }

    @Override
    public java.util.List<Box<Proposition>> allBoxes() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.walletBoxStorage.getAll().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.box(), List$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public java.util.List<Box<Proposition>> allBoxes(java.util.List<byte[]> boxIdsToExclude) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)this.walletBoxStorage.getAll().filter((Function1 & Serializable & scala.Serializable)wb -> BoxesRunTime.boxToBoolean((boolean)SidechainWallet.$anonfun$allBoxes$2(boxIdsToExclude, wb)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.box(), List$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public java.util.List<Box<Proposition>> boxesOfType(Class<? extends Box<? extends Proposition>> boxType) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.walletBoxStorage.getByType(boxType).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.box(), List$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public java.util.List<Box<Proposition>> boxesOfType(Class<? extends Box<? extends Proposition>> boxType, java.util.List<byte[]> boxIdsToExclude) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)this.walletBoxStorage.getByType(boxType).filter((Function1 & Serializable & scala.Serializable)wb -> BoxesRunTime.boxToBoolean((boolean)SidechainWallet.$anonfun$boxesOfType$2(boxIdsToExclude, wb)))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.box(), List$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public Long boxesBalance(Class<? extends Box<? extends Proposition>> boxType) {
        return Predef$.MODULE$.long2Long(this.walletBoxStorage.getBoxesBalance(boxType));
    }

    @Override
    public Long allCoinsBoxesBalance() {
        return Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.walletBoxStorage.getAll().withFilter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SidechainWallet.$anonfun$allCoinsBoxesBalance$1(x$11))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)SidechainWallet.$anonfun$allCoinsBoxesBalance$2(x$12)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    @Override
    public SidechainWallet applyConsensusEpochInfo(ConsensusEpochInfo epochInfo) {
        Buffer merkleTreeLeaves = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(epochInfo.forgingStakeInfoTree().leaves()).asScala()).map((Function1 & Serializable & scala.Serializable)leaf -> new ByteArrayWrapper((byte[])leaf), Buffer$.MODULE$.canBuildFrom());
        Seq forgingStakeMerklePathInfoSeq = (Seq)ForgingStakeInfo$.MODULE$.fromForgerBoxes((Seq<ForgerBox>)((Seq)this.forgingBoxesInfoStorage.getForgerBoxes().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)forgingStakeInfo -> {
            Iterable iterable;
            int n = merkleTreeLeaves.indexOf((Object)new ByteArrayWrapper(forgingStakeInfo.hash()));
            switch (n) {
                case -1: {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    break;
                }
                default: {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new ForgingStakeMerklePathInfo((ForgingStakeInfo)forgingStakeInfo, epochInfo.forgingStakeInfoTree().getMerklePathForLeaf(n))));
                    break;
                }
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        this.forgingBoxesInfoStorage.updateForgingStakeMerklePathInfo(epochInfo.epoch(), (Seq<ForgingStakeMerklePathInfo>)forgingStakeMerklePathInfoSeq).get();
        return this;
    }

    public Option<Seq<ForgingStakeMerklePathInfo>> getForgingStakeMerklePathInfoOpt(int requestedEpoch) {
        int n = requestedEpoch;
        int n2 = n <= 2 ? BoxesRunTime.unboxToInt((Object)package$ConsensusEpochNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)1), package.Tagger$.MODULE$.baseRaw())) : BoxesRunTime.unboxToInt((Object)package$ConsensusEpochNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)(n - 2)), package.Tagger$.MODULE$.baseRaw()));
        int storedConsensusEpochNumber = n2;
        return this.forgingBoxesInfoStorage.getForgingStakeMerklePathInfoForEpoch(storedConsensusEpochNumber);
    }

    public Seq<CswData> getCswData(int withdrawalEpochNumber) {
        return this.cswDataProvider.getCswData(withdrawalEpochNumber);
    }

    public Try<SidechainWallet> ensureStorageConsistencyAfterRestore() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            block19: {
                String version;
                boolean appWalletStateOk;
                block20: {
                    byte[] versionBytes = ((ByteArrayWrapper)$this.walletBoxStorage.lastVersionId().get()).data();
                    appWalletStateOk = this.applicationWallet().checkStoragesVersion(versionBytes);
                    String string = version = sparkz.core.package$.MODULE$.bytesToVersion(versionBytes);
                    String string2 = sparkz.core.package$.MODULE$.bytesToVersion(((ByteArrayWrapper)$this.walletTransactionStorage.lastVersionId().get()).data());
                    if (string != null ? !string.equals(string2) : string2 != null) break block19;
                    if (!$this.params.isCSWEnabled()) break block20;
                    String string3 = version;
                    String string4 = sparkz.core.package$.MODULE$.bytesToVersion(((ByteArrayWrapper)$this.cswDataProvider.lastVersionId().get()).data());
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block19;
                }
                if (appWalletStateOk) {
                    BoxedUnit boxedUnit2;
                    SidechainWallet sidechainWallet;
                    String string = version;
                    String string5 = sparkz.core.package$.MODULE$.bytesToVersion(((ByteArrayWrapper)$this.forgingBoxesInfoStorage.lastVersionId().get()).data());
                    if (!(string != null ? !string.equals(string5) : string5 != null)) {
                        BoxedUnit boxedUnit3;
                        if (this.log().underlying().isDebugEnabled()) {
                            this.log().underlying().debug("All wallet storage versions are consistent");
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        sidechainWallet = this;
                        return sidechainWallet;
                    }
                    ByteArrayWrapper versionBaw = new ByteArrayWrapper(sparkz.core.package$.MODULE$.versionToBytes(version));
                    int maxNumberOfVersionToRetrieve = 2;
                    List<ByteArrayWrapper> rollbackList = $this.forgingBoxesInfoStorage.rollbackVersions(maxNumberOfVersionToRetrieve);
                    Object object = rollbackList.last();
                    ByteArrayWrapper byteArrayWrapper = versionBaw;
                    if (!(object != null ? !object.equals(byteArrayWrapper) : byteArrayWrapper != null)) {
                        BoxedUnit boxedUnit4;
                        None$ none$;
                        BoxedUnit boxedUnit5;
                        if ($this.forgingBoxesInfoStorage.numberOfVersions() == maxNumberOfVersionToRetrieve) {
                            BoxedUnit boxedUnit6;
                            if (this.log().underlying().isDebugEnabled()) {
                                this.log().underlying().debug("All wallet storage versions are consistent");
                                boxedUnit6 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit6 = BoxedUnit.UNIT;
                            }
                            sidechainWallet = this;
                            return sidechainWallet;
                        }
                        if (this.log().underlying().isWarnEnabled()) {
                            this.log().underlying().warn("Wallet forger box storage versions is NOT consistent, trying to rollback");
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        Try<ForgingBoxesInfoStorage> try_ = $this.forgingBoxesInfoStorage.rollback(versionBaw);
                        if (try_ instanceof Success) {
                            none$ = new Some((Object)sparkz.core.package$.MODULE$.bytesToVersion(versionBaw.data()));
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError(try_);
                            none$ = None$.MODULE$;
                        }
                        None$ rbVersion = none$;
                        if (!rbVersion.isEmpty()) {
                            sidechainWallet = this;
                            return sidechainWallet;
                        }
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error("Could not recover wallet forging storages");
                            boxedUnit4 = BoxedUnit.UNIT;
                            throw new RuntimeException("Could not rollback wallet forging box info storages");
                        }
                        boxedUnit4 = BoxedUnit.UNIT;
                        throw new RuntimeException("Could not rollback wallet forging box info storages");
                    }
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("Forging boxes info storage does not have the expected version in the rollback list");
                        boxedUnit2 = BoxedUnit.UNIT;
                        throw new RuntimeException("Forging boxes info storage does not have the expected version in the rollback list");
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                    throw new RuntimeException("Forging boxes info storage does not have the expected version in the rollback list");
                }
            }
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error("Wallet storage versions are NOT consistent");
                boxedUnit = BoxedUnit.UNIT;
                throw new RuntimeException("Wallet storage versions are NOT consistent");
            }
            boxedUnit = BoxedUnit.UNIT;
            throw new RuntimeException("Wallet storage versions are NOT consistent");
        });
    }

    public static final /* synthetic */ boolean $anonfun$scanPersistent$6(java.util.List privKeys$1, Box box) {
        return box.proposition() instanceof ProofOfKnowledgeProposition && ((ProofOfKnowledgeProposition)box.proposition()).canBeProvedBy(privKeys$1).canBeProved();
    }

    public static final /* synthetic */ boolean $anonfun$scanPersistent$8(Box x$3) {
        return x$3 instanceof ForgerBox;
    }

    public static final /* synthetic */ boolean $anonfun$allBoxes$2(java.util.List boxIdsToExclude$1, WalletBox wb) {
        return !BytesUtils.contains(boxIdsToExclude$1, wb.box().id());
    }

    public static final /* synthetic */ boolean $anonfun$boxesOfType$2(java.util.List boxIdsToExclude$2, WalletBox wb) {
        return !BytesUtils.contains(boxIdsToExclude$2, wb.box().id());
    }

    public static final /* synthetic */ boolean $anonfun$allCoinsBoxesBalance$1(WalletBox x$11) {
        return x$11.box() instanceof CoinsBox;
    }

    public static final /* synthetic */ long $anonfun$allCoinsBoxesBalance$2(WalletBox x$12) {
        return x$12.box().value();
    }

    public SidechainWallet(byte[] seed, SidechainWalletBoxStorage walletBoxStorage, SidechainSecretStorage secretStorage, SidechainWalletTransactionStorage walletTransactionStorage, ForgingBoxesInfoStorage forgingBoxesInfoStorage, SidechainWalletCswDataProvider cswDataProvider, NetworkParams params, String version, ApplicationWallet applicationWallet) {
        this.seed = seed;
        this.walletBoxStorage = walletBoxStorage;
        this.secretStorage = secretStorage;
        this.walletTransactionStorage = walletTransactionStorage;
        this.forgingBoxesInfoStorage = forgingBoxesInfoStorage;
        this.cswDataProvider = cswDataProvider;
        this.params = params;
        this.version = version;
        this.applicationWallet = applicationWallet;
        super(seed, secretStorage);
        Predef$.MODULE$.require(applicationWallet != null, (Function0 & Serializable & scala.Serializable)() -> "ApplicationWallet must be NOT NULL.");
    }
}

