/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.transaction;

import io.horizen.proof.Proof;
import io.horizen.proof.ProofSerializer;
import io.horizen.proof.Signature25519Serializer;
import io.horizen.proposition.Proposition;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.DynamicTypedSerializer;
import io.horizen.utils.ListSerializer;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.data.BoxData;
import io.horizen.utxo.box.data.BoxDataSerializer;
import io.horizen.utxo.box.data.ForgerBoxDataSerializer;
import io.horizen.utxo.box.data.WithdrawalRequestBoxDataSerializer;
import io.horizen.utxo.box.data.ZenBoxDataSerializer;
import io.horizen.utxo.transaction.SidechainCoreTransaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sparkz.core.NodeViewModifier$;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Writer;

public final class SidechainCoreTransactionSerializer
implements TransactionSerializer<SidechainCoreTransaction> {
    private static SidechainCoreTransactionSerializer serializer;
    private static final ListSerializer<BoxData<Proposition, Box<Proposition>>> boxesDataSerializer;
    private static final ListSerializer<Proof<Proposition>> proofsSerializer;

    private SidechainCoreTransactionSerializer() {
    }

    public static SidechainCoreTransactionSerializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(SidechainCoreTransaction transaction, Writer writer) {
        writer.put(transaction.version());
        writer.putLong(transaction.fee());
        writer.putInt(transaction.inputsIds.size());
        for (byte[] id : transaction.inputsIds) {
            writer.putBytes(id);
        }
        boxesDataSerializer.serialize(transaction.getOutputData(), writer);
        proofsSerializer.serialize(transaction.proofs, writer);
    }

    @Override
    public SidechainCoreTransaction parse(Reader reader) {
        byte version = reader.getByte();
        if (version != 1) {
            throw new IllegalArgumentException(String.format("Unsupported transaction version[%d].", version));
        }
        long fee = reader.getLong();
        int inputsNum = reader.getInt();
        ArrayList<byte[]> inputsIds = new ArrayList<byte[]>();
        for (int i = 0; i < inputsNum; ++i) {
            inputsIds.add(reader.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize()));
        }
        Object outputsData = boxesDataSerializer.parse(reader);
        Object proofs = proofsSerializer.parse(reader);
        return new SidechainCoreTransaction(inputsIds, (List<BoxData<Proposition, Box<Proposition>>>)outputsData, (List<Proof<Proposition>>)proofs, fee, version);
    }

    static {
        boxesDataSerializer = new ListSerializer(new DynamicTypedSerializer(new HashMap<Byte, BoxDataSerializer>(){
            {
                this.put((byte)1, ZenBoxDataSerializer.getSerializer());
                this.put((byte)2, WithdrawalRequestBoxDataSerializer.getSerializer());
                this.put((byte)3, ForgerBoxDataSerializer.getSerializer());
            }
        }, new HashMap()), 1000);
        proofsSerializer = new ListSerializer(new DynamicTypedSerializer(new HashMap<Byte, ProofSerializer>(){
            {
                this.put((byte)1, Signature25519Serializer.getSerializer());
            }
        }, new HashMap()), 1000);
        serializer = new SidechainCoreTransactionSerializer();
    }
}

