/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.storage;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.companion.SidechainTransactionsCompanion;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;
import sparkz.util.package;
import sparkz.util.package$;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001\u0002\u0006\f\u0001QA\u0001\u0002\u0004\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)a\u0007\u0001C\u0001o!)A\b\u0001C\u0001{!)1\f\u0001C\u00019\")\u0001\u0010\u0001C!s\")1\u0010\u0001C\u0001y\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0002\"'&$Wm\u00195bS:<\u0016\r\u001c7fiR\u0013\u0018M\\:bGRLwN\\*u_J\fw-\u001a\u0006\u0003\u00195\tqa\u001d;pe\u0006<WM\u0003\u0002\u000f\u001f\u0005!Q\u000f\u001e=p\u0015\t\u0001\u0012#A\u0004i_JL'0\u001a8\u000b\u0003I\t!![8\u0004\u0001M)\u0001!F\u000e IA\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u000f\u000e\u0003=I!AH\b\u0003\u001dMKG-Z2iC&tG+\u001f9fgB\u0011\u0001EI\u0007\u0002C)\u0011AbD\u0005\u0003G\u0005\u0012AcU5eK\u000eD\u0017-\u001b8Ti>\u0014\u0018mZ3J]\u001a|\u0007CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011)H/\u001b7\u000b\u0003%\naa\u001d9be.T\u0018BA\u0016'\u00055\u0019\u0006/\u0019:lu2{wmZ5oOB\u0011\u0001%L\u0005\u0003]\u0005\u0012qa\u0015;pe\u0006<W-\u0001\u0010tS\u0012,7\r[1j]R\u0013\u0018M\\:bGRLwN\\:D_6\u0004\u0018M\\5p]B\u0011\u0011\u0007N\u0007\u0002e)\u00111'D\u0001\nG>l\u0007/\u00198j_:L!!\u000e\u001a\u0003=MKG-Z2iC&tGK]1og\u0006\u001cG/[8og\u000e{W\u000e]1oS>t\u0017A\u0002\u001fj]&$h\bF\u00029um\u0002\"!\u000f\u0001\u000e\u0003-AQ\u0001D\u0002A\u00021BQaL\u0002A\u0002A\n1aZ3u)\tq4\u000bE\u0002\u0017\u007f\u0005K!\u0001Q\f\u0003\r=\u0003H/[8o!\u0011\u0011UiR'\u000e\u0003\rS!\u0001R\u0007\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003\r\u000e\u0013aBQ8y)J\fgn]1di&|g\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\u001f\u0005Y\u0001O]8q_NLG/[8o\u0013\ta\u0015JA\u0006Qe>\u0004xn]5uS>t\u0007c\u0001(R\u000f6\tqJ\u0003\u0002Q\u001b\u0005\u0019!m\u001c=\n\u0005I{%a\u0001\"pq\")A\u000b\u0002a\u0001+\u0006iAO]1og\u0006\u001cG/[8o\u0013\u0012\u00042A\u0006,Y\u0013\t9vCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u00173&\u0011!l\u0006\u0002\u0005\u0005f$X-\u0001\u0004va\u0012\fG/\u001a\u000b\u0004;\nT\u0007c\u00010aq5\tqL\u0003\u0002(/%\u0011\u0011m\u0018\u0002\u0004)JL\b\"B2\u0006\u0001\u0004!\u0017a\u0002<feNLwN\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003O>\tQ!\u001e;jYNL!!\u001b4\u0003!\tKH/Z!se\u0006LxK]1qa\u0016\u0014\b\"B6\u0006\u0001\u0004a\u0017!\u0006;sC:\u001c\u0018m\u0019;j_:,\u0006\u000fZ1uK2K7\u000f\u001e\t\u0004[V\feB\u00018t\u001d\ty'/D\u0001q\u0015\t\t8#\u0001\u0004=e>|GOP\u0005\u00021%\u0011AoF\u0001\ba\u0006\u001c7.Y4f\u0013\t1xOA\u0002TKFT!\u0001^\f\u0002\u001b1\f7\u000f\u001e,feNLwN\\%e+\u0005Q\bc\u0001\f@I\u0006\u0001\"o\u001c7mE\u0006\u001c7NV3sg&|gn]\u000b\u0002{B\u0019QN 3\n\u0005}<(\u0001\u0002'jgR\f\u0001B]8mY\n\f7m\u001b\u000b\u0004;\u0006\u0015\u0001\"B2\t\u0001\u0004!\u0017aB5t\u000b6\u0004H/_\u000b\u0003\u0003\u0017\u00012AFA\u0007\u0013\r\tya\u0006\u0002\b\u0005>|G.Z1o\u0001")
public class SidechainWalletTransactionStorage
implements SidechainTypes,
SidechainStorageInfo,
SparkzLogging {
    private final Storage storage;
    private final SidechainTransactionsCompanion sidechainTransactionsCompanion;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Option<BoxTransaction<Proposition, Box<Proposition>>> get(byte[] transactionId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(Utils.calculateKey(transactionId));
        if (optional.isPresent()) {
            Option option2;
            Try try_ = this.sidechainTransactionsCompanion.parseBytesTry(optional.get().data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                BoxTransaction transaction = (BoxTransaction)success.value();
                option2 = Option$.MODULE$.apply((Object)transaction);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while Transaction parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Try<SidechainWalletTransactionStorage> update(ByteArrayWrapper version, Seq<BoxTransaction<Proposition, Box<Proposition>>> transactionUpdateList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(transactionUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Transactions to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!transactionUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Transactions to add/update must be NOT NULL.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            transactionUpdateList.foreach((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(package$.MODULE$.idToBytes((String)package.ModifierId$.MODULE$.$at$at((Object)tx.id(), package.Tagger$.MODULE$.baseRaw()))), new ByteArrayWrapper(this.sidechainTransactionsCompanion.toBytes(tx))))));
            $this.storage.update(version, updateList, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainWalletTransactionStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public SidechainWalletTransactionStorage(Storage storage, SidechainTransactionsCompanion sidechainTransactionsCompanion) {
        this.storage = storage;
        this.sidechainTransactionsCompanion = sidechainTransactionsCompanion;
        SidechainTypes.$init$(this);
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainTransactionsCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainTransactionsCompanion must be NOT NULL.");
    }
}

