/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.storage;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.ListSerializer;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import io.horizen.utxo.utils.CswData;
import io.horizen.utxo.utils.CswDataSerializer$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\n\u0015\u0001uA\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006q\u0001!\t!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019Q\u0005\u0001)A\u0005\u007f!A1\n\u0001b\u0001\n\u0003AB\n\u0003\u0004Q\u0001\u0001\u0006I!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u00191\u0006\u0001)A\u0005'\"1q\u000b\u0001C\u00011aCaa\u0017\u0001\u0005\u0002aa\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00023\u0001\t\u0003\u0011\u0006\"B3\u0001\t\u00031\u0007\"\u0002;\u0001\t\u0003)\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u0006\u0001\t\u0003\tIBA\u000fTS\u0012,7\r[1j]^\u000bG\u000e\\3u\u0007N<H)\u0019;b'R|'/Y4f\u0015\t)b#A\u0004ti>\u0014\u0018mZ3\u000b\u0005]A\u0012\u0001B;uq>T!!\u0007\u000e\u0002\u000f!|'/\u001b>f]*\t1$\u0001\u0002j_\u000e\u00011#\u0002\u0001\u001fI1\n\u0004CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!Q\u000f^5m\u0015\u0005I\u0013AB:qCJ\\'0\u0003\u0002,M\ti1\u000b]1sWjdunZ4j]\u001e\u0004\"!L\u0018\u000e\u00039R!!\u0006\r\n\u0005Ar#\u0001F*jI\u0016\u001c\u0007.Y5o'R|'/Y4f\u0013:4w\u000e\u0005\u00023g5\t\u0001$\u0003\u000251\tq1+\u001b3fG\"\f\u0017N\u001c+za\u0016\u001c\bCA\u00177\u0013\t9dFA\u0004Ti>\u0014\u0018mZ3\u0002\rqJg.\u001b;?)\tQD\b\u0005\u0002<\u00015\tA\u0003C\u0003\u0016\u0005\u0001\u0007Q'A\u000bdg^$\u0015\r^1MSN$8+\u001a:jC2L'0\u001a:\u0016\u0003}\u00022\u0001Q\"F\u001b\u0005\t%B\u0001\"\u0019\u0003\u0015)H/\u001b7t\u0013\t!\u0015I\u0001\bMSN$8+\u001a:jC2L'0\u001a:\u0011\u0005\u0019CU\"A$\u000b\u0005\t3\u0012BA%H\u0005\u001d\u00195o\u001e#bi\u0006\facY:x\t\u0006$\u0018\rT5tiN+'/[1mSj,'\u000fI\u0001\u0013o&$\b\u000e\u001a:bo\u0006dW\t]8dQ.+\u00170F\u0001N!\t\u0001e*\u0003\u0002P\u0003\n\u0001\")\u001f;f\u0003J\u0014\u0018-_,sCB\u0004XM]\u0001\u0014o&$\b\u000e\u001a:bo\u0006dW\t]8dQ.+\u0017\u0010I\u0001 k:$WMZ5oK\u0012<\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD7i\\;oi\u0016\u0014X#A*\u0011\u0005}!\u0016BA+!\u0005\rIe\u000e^\u0001!k:$WMZ5oK\u0012<\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD7i\\;oi\u0016\u0014\b%\u0001\u000fhKR<\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD7i\\;oi\u0016\u00148*Z=\u0015\u00055K\u0006\"\u0002.\n\u0001\u0004\u0019\u0016aD<ji\"$'/Y<bY\u0016\u0003xn\u00195\u0002\u001b\u001d,GoQ:x\t\u0006$\u0018mS3z)\riUL\u0018\u0005\u00065*\u0001\ra\u0015\u0005\u0006?*\u0001\raU\u0001\bG>,h\u000e^3s\u0003e9W\r^,ji\"$'/Y<bY\u0016\u0003xn\u00195D_VtG/\u001a:\u0015\u0005M\u0013\u0007\"B2\f\u0001\u0004\u0019\u0016!B3q_\u000eD\u0017AE4fi^KG\u000f\u001b3sC^\fG.\u00129pG\"\f!bZ3u\u0007N<H)\u0019;b)\t97\u000fE\u0002ia\u0016s!!\u001b8\u000f\u0005)lW\"A6\u000b\u00051d\u0012A\u0002\u001fs_>$h(C\u0001\"\u0013\ty\u0007%A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0014(aA*fc*\u0011q\u000e\t\u0005\u000656\u0001\raU\u0001\u0007kB$\u0017\r^3\u0015\tY\\XP \t\u0004ofTT\"\u0001=\u000b\u0005\u001d\u0002\u0013B\u0001>y\u0005\r!&/\u001f\u0005\u0006y:\u0001\r!T\u0001\bm\u0016\u00148/[8o\u0011\u0015Qf\u00021\u0001T\u0011\u0015yh\u00021\u0001h\u0003\u001d\u00197o\u001e#bi\u0006\fQ\u0002\\1tiZ+'o]5p]&#WCAA\u0003!\u0011y\u0012qA'\n\u0007\u0005%\u0001E\u0001\u0004PaRLwN\\\u0001\u0011e>dGNY1dWZ+'o]5p]N,\"!a\u0004\u0011\u0007!\u0004X*\u0001\u0005s_2d'-Y2l)\r1\u0018Q\u0003\u0005\u0006yF\u0001\r!T\u0001\bSN,U\u000e\u001d;z+\t\tY\u0002E\u0002 \u0003;I1!a\b!\u0005\u001d\u0011un\u001c7fC:\u0004")
public class SidechainWalletCswDataStorage
implements SparkzLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private final ListSerializer<CswData> cswDataListSerializer;
    private final ByteArrayWrapper withdrawalEpochKey;
    private final int undefinedWithdrawalEpochCounter;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ListSerializer<CswData> cswDataListSerializer() {
        return this.cswDataListSerializer;
    }

    public ByteArrayWrapper withdrawalEpochKey() {
        return this.withdrawalEpochKey;
    }

    private int undefinedWithdrawalEpochCounter() {
        return this.undefinedWithdrawalEpochCounter;
    }

    public ByteArrayWrapper getWithdrawalEpochCounterKey(int withdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalEpochCounter".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpoch)}));
    }

    public ByteArrayWrapper getCswDataKey(int withdrawalEpoch, int counter) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalRequests".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)counter)}));
    }

    public int getWithdrawalEpochCounter(int epoch) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getWithdrawalEpochCounterKey(epoch))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedWithdrawalEpochCounter()));
        } else {
            n = this.undefinedWithdrawalEpochCounter();
        }
        return n;
    }

    public int getWithdrawalEpoch() {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.withdrawalEpochKey())));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = Ints.fromByteArray((byte[])baw.data());
        } else if (None$.MODULE$.equals(option)) {
            n = 0;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<CswData> getCswData(int withdrawalEpoch) {
        void var2_2;
        ListBuffer cswDataSeq = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getWithdrawalEpochCounter(withdrawalEpoch);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getCswDataKey(withdrawalEpoch, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                Try try_ = this.cswDataListSerializer().parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while csw data parsing.", exception);
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                java.util.List list = (java.util.List)success.value();
                cswDataSeq.appendAll((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while csw data retrieving: record is missing.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Try<SidechainWalletCswDataStorage> update(ByteArrayWrapper version, int withdrawalEpoch, Seq<CswData> cswData) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Object object2;
            boolean isEpochSwitched;
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            int currentWithdrawalEpoch = this.getWithdrawalEpoch();
            boolean bl = isEpochSwitched = withdrawalEpoch != currentWithdrawalEpoch;
            if (isEpochSwitched) {
                int epochToRemove = withdrawalEpoch - 4;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getWithdrawalEpochCounter(epochToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getCswDataKey(epochToRemove, counter)));
                object2 = BoxesRunTime.boxToBoolean((boolean)removeList.add(this.getWithdrawalEpochCounterKey(epochToRemove)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            Object object3 = isEpochSwitched ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.withdrawalEpochKey(), new ByteArrayWrapper(Ints.toByteArray((int)withdrawalEpoch))))) : BoxedUnit.UNIT;
            if (cswData.nonEmpty()) {
                int nextWithdrawalEpochCounter = this.getWithdrawalEpochCounter(withdrawalEpoch) + 1;
                updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalEpochCounterKey(withdrawalEpoch), new ByteArrayWrapper(Ints.toByteArray((int)nextWithdrawalEpochCounter))));
                object = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getCswDataKey(withdrawalEpoch, nextWithdrawalEpochCounter), new ByteArrayWrapper(this.cswDataListSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(cswData).asJava())))));
            } else {
                object = BoxedUnit.UNIT;
            }
            $this.storage.update(version, updateList, removeList);
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainWalletCswDataStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public SidechainWalletCswDataStorage(Storage storage) {
        this.storage = storage;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        this.cswDataListSerializer = new ListSerializer<CswData>(CswDataSerializer$.MODULE$);
        this.withdrawalEpochKey = Utils.calculateKey("withdrawalEpoch".getBytes(StandardCharsets.UTF_8));
        this.undefinedWithdrawalEpochCounter = -1;
    }
}

