/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.state;

import com.horizen.certnative.BackwardTransfer;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AbstractState;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.block.FieldElementCertificateField;
import io.horizen.block.MainchainBackwardTransferCertificateOutput;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.consensus.ForgingStakeInfo$;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.cryptolibprovider.CryptoLibProvider$;
import io.horizen.fork.ForkManager$;
import io.horizen.params.NetworkParams;
import io.horizen.params.NetworkParamsUtils;
import io.horizen.proof.Proof;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.transaction.MC2SCAggregatedTransaction;
import io.horizen.transaction.exception.TransactionSemanticValidityException;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import io.horizen.utxo.backup.BoxIterator;
import io.horizen.utxo.block.SidechainBlock;
import io.horizen.utxo.block.SidechainBlockHeader;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.BoxUnlocker;
import io.horizen.utxo.box.CoinsBox;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.box.data.ZenBoxData;
import io.horizen.utxo.forge.ForgerList;
import io.horizen.utxo.node.NodeState;
import io.horizen.utxo.state.ApplicationState;
import io.horizen.utxo.state.SidechainState$;
import io.horizen.utxo.state.SidechainStateReader;
import io.horizen.utxo.state.SidechainStateUtxoMerkleTreeProvider;
import io.horizen.utxo.state.UtxoMerkleTreeView;
import io.horizen.utxo.storage.SidechainStateForgerBoxStorage;
import io.horizen.utxo.storage.SidechainStateStorage;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.CertificateKeyRotationTransaction;
import io.horizen.utxo.transaction.OpenStakeTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import io.horizen.utxo.utils.BlockFeeInfo;
import io.horizen.utxo.utils.FeePaymentsUtils$;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyBoolean;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.package$;
import sparkz.core.transaction.Transaction;
import sparkz.core.transaction.box.proposition.Proposition;
import sparkz.core.transaction.state.BoxStateChanges;
import sparkz.core.transaction.state.ModifierValidation;
import sparkz.core.transaction.state.TransactionValidation;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005d\u0001\u0002 @\u0001!C!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011)\ti\u0003\u0001B\u0001B\u0003%\u0011q\u0006\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005]\u0002BCA\r\u0001\t\u0015\r\u0011\"\u0001\u0002>!Q\u0011Q\t\u0001\u0003\u0002\u0003\u0006I!a\u0010\t\u0015\u0005\u001d\u0003A!b\u0001\n\u0003\nI\u0005\u0003\u0006\u0002h\u0001\u0011\t\u0011)A\u0005\u0003\u0017B!\"!\u001b\u0001\u0005\u000b\u0007I\u0011AA6\u0011)\t\u0019\b\u0001B\u0001B\u0003%\u0011Q\u000e\u0005\t\u0003k\u0002A\u0011A\"\u0002x\u0015)\u0011Q\u0011\u0001!Q\"Q\u0011q\u0011\u0001\t\u0006\u0004%\t!!#\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAj\u0001\u0011\u0005\u0013Q\u001b\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005CAqA!\u000f\u0001\t\u0003\u0012Y\u0004C\u0004\u0003Z\u0001!\tEa\u0017\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j!9!q\u000e\u0001\u0005B\tE\u0004b\u0002B;\u0001\u0011\u0005#q\u000f\u0005\b\u0005\u007f\u0002A\u0011\u0001BA\u0011\u001d\u0011\u0019\n\u0001C\u0001\u0005+CqAa(\u0001\t\u0003\u0012\t\u000bC\u0004\u0003&\u0002!\tEa*\t\u000f\tm\u0006\u0001\"\u0001\u0003>\"9!1\u001a\u0001\u0005\u0002\t5\u0007b\u0002Bn\u0001\u0011\u0005#Q\u001c\u0005\b\u0005C\u0004A\u0011\u0002Br\u0011\u001d\u00119\u000f\u0001C\u0005\u0005SDqA!<\u0001\t\u0003\u0011y\u000fC\u0004\u0003r\u0002!\tAa=\t\u000f\te\b\u0001\"\u0001\u0003|\"91q\u0004\u0001\u0005\n\r\u0005\u0002bBB\u0016\u0001\u0011\u00051Q\u0006\u0005\b\u0007g\u0001A\u0011AB\u001b\u0011\u001d\u0011Y\u000e\u0001C!\u0007wAqAa7\u0001\t\u0013\u0019y\u0004C\u0004\u0004H\u0001!\tEa\u001e\t\u000f\r%\u0003\u0001\"\u0011\u0004L!91\u0011\u000b\u0001\u0005\u0002\rM\u0003bBB2\u0001\u0011\u00051Q\r\u0005\b\u0007W\u0002A\u0011AB7\u0011\u001d\u00199\n\u0001C!\u0005_Dqa!'\u0001\t\u0003\u001aY\nC\u0004\u0004\"\u0002!\taa)\t\u000f\r%\u0006\u0001\"\u0001\u0004,\"911\u0018\u0001\u0005B\ru\u0006bBBf\u0001\u0011\u00051Q\u001a\u0005\b\u0007\u001f\u0004A\u0011ABi\u0011\u001d\u0019\u0019\u000e\u0001C\u0001\u0007+D\u0011b!;\u0001#\u0003%\taa;\t\u000f\u0011\u0005\u0001\u0001\"\u0001\u0005\u0004\u001d9A\u0011D \t\u0002\u0011maA\u0002 @\u0011\u0003!i\u0002C\u0004\u0002va\"\t\u0001\"\n\t\u000f\t-\u0007\b\"\u0001\u0005(!AA1\u0006\u001d\u0005\u0002\r#i\u0003\u0003\u0005\u0005<a\"\ta\u0011C\u001f\u0011!!9\u0006\u000fC\u0001\u0007\u0012e#AD*jI\u0016\u001c\u0007.Y5o'R\fG/\u001a\u0006\u0003\u0001\u0006\u000bQa\u001d;bi\u0016T!AQ\"\u0002\tU$\bp\u001c\u0006\u0003\t\u0016\u000bq\u0001[8sSj,gNC\u0001G\u0003\tIwn\u0001\u0001\u0014\u0019\u0001I%\u000e^<{\u0003\u0003\ti!a\u0005\u0011\r)[UjX3i\u001b\u0005\u0019\u0015B\u0001'D\u00055\t%m\u001d;sC\u000e$8\u000b^1uKB!a*U*Z\u001b\u0005y%B\u0001)B\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\u0005I{%A\u0004\"pqR\u0013\u0018M\\:bGRLwN\u001c\t\u0003)^k\u0011!\u0016\u0006\u0003-\u000e\u000b1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&\u0011\u0001,\u0016\u0002\f!J|\u0007o\\:ji&|g\u000eE\u0002[;Nk\u0011a\u0017\u0006\u00039\u0006\u000b1AY8y\u0013\tq6LA\u0002C_b\u0004\"\u0001Y2\u000e\u0003\u0005T!AY!\u0002\u000b\tdwnY6\n\u0005\u0011\f'\u0001F*jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b%fC\u0012,'\u000f\u0005\u0002aM&\u0011q-\u0019\u0002\u000f'&$Wm\u00195bS:\u0014En\\2l!\tI\u0007!D\u0001@!\rY'/T\u0007\u0002Y*\u0011\u0001)\u001c\u0006\u0003!:T!a\u001c9\u0002\t\r|'/\u001a\u0006\u0002c\u000611\u000f]1sWjL!a\u001d7\u0003+Q\u0013\u0018M\\:bGRLwN\u001c,bY&$\u0017\r^5p]B\u00191.^3\n\u0005Yd'AE'pI&4\u0017.\u001a:WC2LG-\u0019;j_:\u0004\"A\u0013=\n\u0005e\u001c%AD*jI\u0016\u001c\u0007.Y5o)f\u0004Xm\u001d\t\u0003wzl\u0011\u0001 \u0006\u0003{\u0006\u000bAA\\8eK&\u0011q\u0010 \u0002\n\u001d>$Wm\u0015;bi\u0016\u0004B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f\u0001\u0018\u0001B;uS2LA!a\u0003\u0002\u0006\ti1\u000b]1sWjdunZ4j]\u001e\u00042![A\b\u0013\r\t\tb\u0010\u0002\u0013+RDx.T3sW2,GK]3f-&,w\u000f\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIbQ\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005u\u0011q\u0003\u0002\u0013\u001d\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:Vi&d7/\u0001\u0007ti\u0006$Xm\u0015;pe\u0006<W\r\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9#Q\u0001\bgR|'/Y4f\u0013\u0011\tY#!\n\u0003+MKG-Z2iC&t7\u000b^1uKN#xN]1hK\u0006\u0001bm\u001c:hKJ\u0014u\u000e_*u_J\fw-\u001a\t\u0005\u0003G\t\t$\u0003\u0003\u00024\u0005\u0015\"AH*jI\u0016\u001c\u0007.Y5o'R\fG/\u001a$pe\u001e,'OQ8y'R|'/Y4f\u0003Y)H\u000f_8NKJ\\G.\u001a+sK\u0016\u0004&o\u001c<jI\u0016\u0014\bcA5\u0002:%\u0019\u00111H \u0003IMKG-Z2iC&t7\u000b^1uKV#\bp\\'fe.dW\r\u0016:fKB\u0013xN^5eKJ,\"!a\u0010\u0011\t\u0005U\u0011\u0011I\u0005\u0005\u0003\u0007\n9BA\u0007OKR<xN]6QCJ\fWn]\u0001\ba\u0006\u0014\u0018-\\:!\u0003\u001d1XM]:j_:,\"!a\u0013\u0011\t\u00055\u0013\u0011\r\b\u0005\u0003\u001f\niF\u0004\u0003\u0002R\u0005mc\u0002BA*\u00033j!!!\u0016\u000b\u0007\u0005]s)\u0001\u0004=e>|GOP\u0005\u0002c&\u0011q\u000e]\u0005\u0004\u0003?r\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003G\n)G\u0001\u0006WKJ\u001c\u0018n\u001c8UC\u001eT1!a\u0018o\u0003!1XM]:j_:\u0004\u0013\u0001E1qa2L7-\u0019;j_:\u001cF/\u0019;f+\t\ti\u0007E\u0002j\u0003_J1!!\u001d@\u0005A\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006$X-A\tbaBd\u0017nY1uS>t7\u000b^1uK\u0002\na\u0001P5oSRtD#\u00045\u0002z\u0005m\u0014QPA@\u0003\u0003\u000b\u0019\tC\u0004\u0002 )\u0001\r!!\t\t\u000f\u00055\"\u00021\u0001\u00020!9\u0011Q\u0007\u0006A\u0002\u0005]\u0002bBA\r\u0015\u0001\u0007\u0011q\b\u0005\b\u0003\u000fR\u0001\u0019AA&\u0011\u001d\tIG\u0003a\u0001\u0003[\u0012AA\u0014,D)\u0006Yb/\u001a:jM&\u001c\u0017\r^5p].+\u0017PR;mY\u001aKG.\u001a)bi\",\"!a#\u0011\t\u00055\u0015\u0011\u0014\b\u0005\u0003\u001f\u000b)\n\u0005\u0003\u0002T\u0005E%BAAJ\u0003\u0015\u00198-\u00197b\u0013\u0011\t9*!%\u0002\rA\u0013X\rZ3g\u0013\u0011\tY*!(\u0003\rM#(/\u001b8h\u0015\u0011\t9*!%\u0002!M,W.\u00198uS\u000e4\u0016\r\\5eSRLH\u0003BAR\u0003k\u0003b!!*\u0002*\u00065VBAAT\u0015\u0011\t9!!%\n\t\u0005-\u0016q\u0015\u0002\u0004)JL\b\u0003BAX\u0003ck!!!%\n\t\u0005M\u0016\u0011\u0013\u0002\u0005+:LG\u000f\u0003\u0004\u000286\u0001\r!T\u0001\u0003ib\f\u0011b\u00197pg\u0016$'i\u001c=\u0015\t\u0005u\u00161\u0019\t\u0006\u0003_\u000by,W\u0005\u0005\u0003\u0003\f\tJ\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000bt\u0001\u0019AAd\u0003\u0015\u0011w\u000e_%e!\u0019\ty+!3\u0002N&!\u00111ZAI\u0005\u0015\t%O]1z!\u0011\ty+a4\n\t\u0005E\u0017\u0011\u0013\u0002\u0005\u0005f$X-\u0001\u0007hKR\u001cEn\\:fI\n{\u0007\u0010\u0006\u0003\u0002X\u0006e\bCBAm\u0003C\f)/\u0004\u0002\u0002\\*!\u0011qAAo\u0015\t\ty.\u0001\u0003kCZ\f\u0017\u0002BAr\u00037\u0014\u0001b\u00149uS>t\u0017\r\u001c\u0019\u0005\u0003O\fi\u000f\u0005\u0003[;\u0006%\b\u0003BAv\u0003[d\u0001\u0001B\u0006\u0002p>\t\t\u0011!A\u0003\u0002\u0005E(aA0%cE\u0019\u00111_*\u0011\t\u0005=\u0016Q_\u0005\u0005\u0003o\f\tJA\u0004O_RD\u0017N\\4\t\u000f\u0005\u0015w\u00021\u0001\u0002H\u0006\u0011r/\u001b;iIJ\fw/\u00197SKF,Xm\u001d;t)\u0011\tyP!\u0006\u0011\r\t\u0005!\u0011\u0002B\b\u001d\u0011\u0011\u0019Aa\u0002\u000f\t\u0005M#QA\u0005\u0003\u0003'KA!a\u0018\u0002\u0012&!!1\u0002B\u0007\u0005\r\u0019V-\u001d\u0006\u0005\u0003?\n\t\nE\u0002[\u0005#I1Aa\u0005\\\u0005Q9\u0016\u000e\u001e5ee\u0006<\u0018\r\u001c*fcV,7\u000f\u001e\"pq\"9!q\u0003\tA\u0002\te\u0011aD<ji\"$'/Y<bY\u0016\u0003xn\u00195\u0011\t\u0005=&1D\u0005\u0005\u0005;\t\tJA\u0002J]R\f\u0011CY1dW^\f'\u000f\u001a+sC:\u001ch-\u001a:t)\u0011\u0011\u0019Ca\u000e\u0011\r\t\u0005!\u0011\u0002B\u0013!\u0011\u00119Ca\r\u000e\u0005\t%\"\u0002\u0002B\u0016\u0005[\t!bY3si:\fG/\u001b<f\u0015\r!%q\u0006\u0006\u0003\u0005c\t1aY8n\u0013\u0011\u0011)D!\u000b\u0003!\t\u000b7m[<be\u0012$&/\u00198tM\u0016\u0014\bb\u0002B\f#\u0001\u0007!\u0011D\u0001\u0011W\u0016L(k\u001c;bi&|g\u000e\u0015:p_\u001a$\u0002B!\u0010\u0003P\tE#Q\u000b\t\u0007\u0003_\u000byLa\u0010\u0011\t\t\u0005#1J\u0007\u0003\u0005\u0007RAA!\u0012\u0003H\u0005!1.Z=t\u0015\r\u0011IeQ\u0001\u0015G\u0016\u0014H/\u001b4jG\u0006$Xm];c[&$H/\u001a:\n\t\t5#1\t\u0002\u0011\u0017\u0016L(k\u001c;bi&|g\u000e\u0015:p_\u001aDqAa\u0006\u0013\u0001\u0004\u0011I\u0002C\u0004\u0003TI\u0001\rA!\u0007\u0002\u001b%tG-\u001a=PMNKwM\\3s\u0011\u001d\u00119F\u0005a\u0001\u00053\tqa[3z)f\u0004X-\u0001\bdKJ$\u0018NZ5feN\\U-_:\u0015\t\tu#Q\r\t\u0007\u0003_\u000byLa\u0018\u0011\t\t\u0005#\u0011M\u0005\u0005\u0005G\u0012\u0019E\u0001\bDKJ$\u0018NZ5feN\\U-_:\t\u000f\t]1\u00031\u0001\u0003\u001a\u0005\u0011R\u000f\u001e=p\u001b\u0016\u00148\u000e\\3Ue\u0016,'k\\8u)\u0011\u0011YG!\u001c\u0011\r\u0005=\u0016qXAd\u0011\u001d\u00119\u0002\u0006a\u0001\u00053\ta\"\u001e;y_6+'o\u001b7f!\u0006$\b\u000e\u0006\u0003\u0003l\tM\u0004bBAc+\u0001\u0007\u0011qY\u0001\nQ\u0006\u001c8)Z1tK\u0012$\"A!\u001f\u0011\t\u0005=&1P\u0005\u0005\u0005{\n\tJA\u0004C_>dW-\u00198\u0002\u0017\r,'\u000f^5gS\u000e\fG/\u001a\u000b\u0005\u0005\u0007\u0013y\t\u0005\u0004\u00020\u0006}&Q\u0011\t\u0005\u0005\u000f\u0013Y)\u0004\u0002\u0003\n*\u0011!mQ\u0005\u0005\u0005\u001b\u0013II\u0001\u000eXSRDGM]1xC2,\u0005o\\2i\u0007\u0016\u0014H/\u001b4jG\u0006$X\rC\u0004\u0003\u0012^\u0001\rA!\u0007\u00023I,g-\u001a:f]\u000e,GmV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\u0001\u0016G\u0016\u0014H/\u001b4jG\u0006$X\rV8q#V\fG.\u001b;z)\u0011\u00119J!(\u0011\t\u0005=&\u0011T\u0005\u0005\u00057\u000b\tJ\u0001\u0003M_:<\u0007b\u0002BI1\u0001\u0007!\u0011D\u0001\u001fY\u0006\u001cHoQ3si&4\u0017nY1uKJ+g-\u001a:f]\u000e,G-\u00129pG\"$\"Aa)\u0011\r\u0005=\u0016q\u0018B\r\u0003}a\u0017m\u001d;DKJ$\u0018NZ5dCR,7+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017\n\u001a\u000b\u0003\u0005S\u0003b!a,\u0002@\n-\u0006\u0003\u0002BW\u0005ksAAa,\u00034:!\u0011\u0011\u000bBY\u0013\r\t9\u0001]\u0005\u0005\u0003?\n)!\u0003\u0003\u00038\ne&AC'pI&4\u0017.\u001a:JI*!\u0011qLA\u0003\u0003Y9W\r^,ji\"$'/Y<bY\u0016\u0003xn\u00195J]\u001a|GC\u0001B`!\u0011\u0011\tMa2\u000e\u0005\t\r'b\u0001Bc\u0007\u0006)Q\u000f^5mg&!!\u0011\u001aBb\u0005M9\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017J\u001c4p\u0003\u001d\u0019\u0007.\u00198hKN$BAa4\u0003XB1\u0011QUAU\u0005#\u0004Ra\u001bBj'fK1A!6m\u0005=\u0011u\u000e_*uCR,7\t[1oO\u0016\u001c\bB\u0002Bm9\u0001\u0007Q-A\u0002n_\u0012\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\u0003G\u0013y\u000e\u0003\u0004\u0003Zv\u0001\r!Z\u0001#m\u0006d\u0017\u000eZ1uK\ncwnY6Ue\u0006t7/Y2uS>t7/T;uk\u0006d\u0017\u000e^=\u0015\t\u00055&Q\u001d\u0005\u0007\u00053t\u0002\u0019A3\u00027\rDWmY6XSRDGM]1xC2\u0014u\u000e_3t\u00032dwn^3e)\u0011\tiKa;\t\r\tew\u00041\u0001f\u0003M:W\r^!me\u0016\fG-_'j]\u0016$w+\u001b;iIJ\fw/\u00197SKF,Xm\u001d;C_b,7/\u00138DkJ\u0014XM\u001c;Fa>\u001c\u0007.\u0006\u0002\u0003\u001a\u0005\u0001s-\u001a;BY2|w/\u001a3XSRDGM]1xC2\u0014V-];fgR\u0014u\u000e_3t)\u0011\u0011IB!>\t\u000f\t]\u0018\u00051\u0001\u0003\u001a\u00051c.^7cKJ|e-T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3J]\ncwnY6\u00027=\u0004XM\\*uC.,GK]1og\u0006\u001cG/[8o\u000b:\f'\r\\3e)\u0011\u0011IH!@\t\u000f\t}(\u00051\u0001\u0004\u0002\u0005!2m\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJ\u0004b!a,\u0002@\u000e\r\u0001\u0003BB\u0003\u00073qAaa\u0002\u0004\u00169!1\u0011BB\t\u001d\u0011\u0019Yaa\u0004\u000f\t\u0005M3QB\u0005\u0002\r&\u0011A)R\u0005\u0004\u0007'\u0019\u0015!C2p]N,gn];t\u0013\u0011\tyfa\u0006\u000b\u0007\rM1)\u0003\u0003\u0004\u001c\ru!\u0001F\"p]N,gn];t\u000bB|7\r\u001b(v[\n,'O\u0003\u0003\u0002`\r]\u0011!\b<bY&$\u0017\r^3U_B\fV/\u00197jif\u001cUM\u001d;jM&\u001c\u0017\r^3\u0015\r\u0005561EB\u0014\u0011\u001d\u0019)c\ta\u0001\u0005\u000b\u000bQ\u0003^8q#V\fG.\u001b;z\u0007\u0016\u0014H/\u001b4jG\u0006$X\rC\u0004\u0004*\r\u0002\rA!\u0007\u00023\r,'\u000f\u001e*fM\u0016\u0014XM\\2fI\u0016\u0003xn\u00195Ok6\u0014WM]\u0001\u0011m\u0006d\u0017\u000eZ1uK^KG\u000f\u001b$pe.$b!a)\u00040\rE\u0002BBA\\I\u0001\u0007Q\nC\u0004\u0003\u0000\u0012\u0002\raa\u0001\u00027Y\fG.\u001b3bi\u0016<\u0016\u000e\u001e5XSRDGM]1xC2,\u0005o\\2i)\u0019\t\u0019ka\u000e\u0004:!1\u0011qW\u0013A\u00025CqAa\u0006&\u0001\u0004\u0011I\u0002\u0006\u0003\u0002$\u000eu\u0002BBA\\M\u0001\u0007Q\n\u0006\u0005\u0002$\u000e\u000531IB#\u0011\u0019\t9l\na\u0001\u001b\"9!q`\u0014A\u0002\r\r\u0001b\u0002B\fO\u0001\u0007!\u0011D\u0001\u000eSN4uN]4j]\u001e|\u0005/\u001a8\u0002\u001b\u0005\u0004\b\u000f\\=N_\u0012Lg-[3s)\u0011\u0019iea\u0014\u0011\u000b\u0005\u0015\u0016\u0011\u00165\t\r\te\u0017\u00061\u0001f\u0003y9W\r\u001e*fgR\u0014\u0018n\u0019;G_J<WM]%oI\u0016DHk\\+qI\u0006$X\r\u0006\u0003\u0004V\r]\u0003CBAX\u0003\u0013\u0014I\u0002C\u0004\u0004Z)\u0002\raa\u0017\u0002\u0007QD8\u000f\u0005\u0004\u0003\u0002\t%1Q\f\t\u0006\u001d\u000e}3+W\u0005\u0004\u0007Cz%\u0001F*jI\u0016\u001c\u0007.Y5o)J\fgn]1di&|g.A\rhKR\\U-\u001f*pi\u0006$\u0018n\u001c8Qe>|gm\u001d+p\u0003\u0012$G\u0003BB4\u0007S\u0002bA!\u0001\u0003\n\t}\u0002bBB-W\u0001\u000711L\u0001\rCB\u0004H._\"iC:<Wm\u001d\u000b\u0013\u0007\u001b\u001ayg!\u001d\u0004v\re4QPBA\u0007\u001f\u001b\u0019\nC\u0004\u0003L2\u0002\rA!5\t\u000f\rMD\u00061\u0001\u0002L\u0005Qa.Z<WKJ\u001c\u0018n\u001c8\t\u000f\r]D\u00061\u0001\u0003@\u0006\u0019r/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_\"911\u0010\u0017A\u0002\r\r\u0011AD2p]N,gn];t\u000bB|7\r\u001b\u0005\b\u0007\u007fb\u0003\u0019\u0001BB\u0003a!x\u000e])vC2LG/_\"feRLg-[2bi\u0016|\u0005\u000f\u001e\u0005\b\u0007\u0007c\u0003\u0019ABC\u00031\u0011Gn\\2l\r\u0016,\u0017J\u001c4p!\u0011\u00199ia#\u000e\u0005\r%%b\u0001Bc\u0003&!1QRBE\u00051\u0011En\\2l\r\u0016,\u0017J\u001c4p\u0011\u001d\u0019\t\n\fa\u0001\u0007+\n\u0011CZ8sO\u0016\u0014H*[:u\u0013:$W\r_3t\u0011\u001d\u0019)\n\fa\u0001\u0007O\nac[3z%>$\u0018\r^5p]B\u0013xn\u001c4t)>\fE\rZ\u0001\u0011[\u0006D(k\u001c7mE\u0006\u001c7\u000eR3qi\"\f!B]8mY\n\f7m\u001b+p)\u0011\u0019ie!(\t\u000f\r}e\u00061\u0001\u0002L\u0005\u0011Ao\\\u0001\u001aSN\u001cv/\u001b;dQ&twmQ8og\u0016t7/^:Fa>\u001c\u0007\u000e\u0006\u0003\u0003z\r\u0015\u0006bBBT_\u0001\u0007!qS\u0001\u000fE2|7m\u001b+j[\u0016\u001cH/Y7q\u0003q9W\r^\"veJ,g\u000e^\"p]N,gn];t\u000bB|7\r[%oM>,\"a!,\u0011\u0011\u0005=6q\u0016BV\u0007gKAa!-\u0002\u0012\n1A+\u001e9mKJ\u0002Ba!.\u000486\u00111qC\u0005\u0005\u0007s\u001b9B\u0001\nD_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|\u0017AH4fi>\u0013H-\u001a:fI\u001a{'oZ5oON#\u0018m[3t\u0013:4wnU3r)\u0011\u0019yla2\u0011\r\t\u0005!\u0011BBa!\u0011\u0019)la1\n\t\r\u00157q\u0003\u0002\u0011\r>\u0014x-\u001b8h'R\f7.Z%oM>Dqa!32\u0001\u0004\u0011I\"A\u0006fa>\u001c\u0007NT;nE\u0016\u0014\u0018AG5t/&$\b\u000e\u001a:bo\u0006dW\t]8dQ2\u000b7\u000f^%oI\u0016DXC\u0001B=\u0003\u0011*gn];sKN#xN]1hK\u000e{gn]5ti\u0016t7-_!gi\u0016\u0014(+Z:u_J,WCAB'\u000399W\r\u001e$fKB\u000b\u00170\\3oiN$baa6\u0004`\u000e\r\bC\u0002B\u0001\u0005\u0013\u0019I\u000eE\u0002[\u00077L1a!8\\\u0005\u0019QVM\u001c\"pq\"91\u0011\u001d\u001bA\u0002\te\u0011!F<ji\"$'/Y<bY\u0016\u0003xn\u00195Ok6\u0014WM\u001d\u0005\n\u0007K$\u0004\u0013!a\u0001\u0007O\fAC\u00197pG.$v.\u00119qK:$g)Z3J]\u001a|\u0007CBAX\u0003\u007f\u001b))\u0001\rhKR4U-\u001a)bs6,g\u000e^:%I\u00164\u0017-\u001e7uII*\"a!<+\t\r\u001d8q^\u0016\u0003\u0007c\u0004Baa=\u0004~6\u00111Q\u001f\u0006\u0005\u0007o\u001cI0A\u0005v]\u000eDWmY6fI*!11`AI\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u007f\u001c)PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQB]3ti>\u0014XMQ1dWV\u0004HCBB'\t\u000b!)\u0002C\u0004\u0005\bY\u0002\r\u0001\"\u0003\u00021\t\f7m[;q'R|'/Y4f\u0005>D\u0018\n^3sCR|'\u000f\u0005\u0003\u0005\f\u0011EQB\u0001C\u0007\u0015\r!y!Q\u0001\u0007E\u0006\u001c7.\u001e9\n\t\u0011MAQ\u0002\u0002\f\u0005>D\u0018\n^3sCR|'\u000fC\u0004\u0005\u0018Y\u0002\r!a2\u0002\u00171\f7\u000f\u001e,feNLwN\\\u0001\u000f'&$Wm\u00195bS:\u001cF/\u0019;f!\tI\u0007hE\u00029\t?\u0001B!a,\u0005\"%!A1EAI\u0005\u0019\te.\u001f*fMR\u0011A1\u0004\u000b\u0005\u0005\u001f$I\u0003\u0003\u0004\u0003Zj\u0002\r!Z\u0001\re\u0016\u001cHo\u001c:f'R\fG/\u001a\u000b\r\t_!\t\u0004b\r\u00056\u0011]B\u0011\b\t\u0006\u0003_\u000by\f\u001b\u0005\b\u0003?Y\u0004\u0019AA\u0011\u0011\u001d\tic\u000fa\u0001\u0003_Aq!!\u000e<\u0001\u0004\t9\u0004C\u0004\u0002\u001am\u0002\r!a\u0010\t\u000f\u0005%4\b1\u0001\u0002n\u0005\u00112M]3bi\u0016<UM\\3tSN\u001cF/\u0019;f)A\u0019i\u0005b\u0010\u0005B\u0011\rCQ\tC(\t#\"\u0019\u0006C\u0004\u0002 q\u0002\r!!\t\t\u000f\u00055B\b1\u0001\u00020!9\u0011Q\u0007\u001fA\u0002\u0005]\u0002b\u0002C$y\u0001\u0007A\u0011J\u0001\u000eE\u0006\u001c7.\u001e9Ti>\u0014\u0018mZ3\u0011\t\u0005\rB1J\u0005\u0005\t\u001b\n)CA\u0007CC\u000e\\W\u000f]*u_J\fw-\u001a\u0005\b\u00033a\u0004\u0019AA \u0011\u001d\tI\u0007\u0010a\u0001\u0003[Ba\u0001\"\u0016=\u0001\u0004)\u0017\u0001D4f]\u0016\u001c\u0018n\u001d\"m_\u000e\\\u0017aG2bY\u000e,H.\u0019;f\r\u0016,\u0007+Y=nK:$(i\u001c=O_:\u001cW\r\u0006\u0004\u0003\u0018\u0012mCQ\f\u0005\b\u0007Cl\u0004\u0019\u0001B\r\u0011\u001d!y&\u0010a\u0001\u00053\tQ!\u001b8eKb\u0004")
public class SidechainState
extends AbstractState<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>, SidechainBlockHeader, SidechainBlock, SidechainState>
implements TransactionValidation<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>>,
ModifierValidation<SidechainBlock>,
SidechainTypes,
NodeState,
SparkzLogging,
UtxoMerkleTreeView,
NetworkParamsUtils {
    private String verificationKeyFullFilePath;
    private final SidechainStateStorage stateStorage;
    private final SidechainStateForgerBoxStorage forgerBoxStorage;
    private final SidechainStateUtxoMerkleTreeProvider utxoMerkleTreeProvider;
    private final NetworkParams params;
    private final String version;
    private final ApplicationState applicationState;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public boolean isGenesisBlock(String blockId) {
        return NetworkParamsUtils.isGenesisBlock$(this, blockId);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> sidechainTxToScbt(SidechainTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<io.horizen.proposition.Proposition, Proof<io.horizen.proposition.Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<io.horizen.proposition.Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<io.horizen.proposition.Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<io.horizen.proposition.Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public scala.collection.immutable.Set<Box<io.horizen.proposition.Proposition>> zenBoxSetToScbSet(scala.collection.immutable.Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<io.horizen.proposition.Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<io.horizen.proposition.Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public boolean isValid(Transaction tx) {
        return TransactionValidation.isValid$((TransactionValidation)this, (Transaction)tx);
    }

    public Seq<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> filterValid(Seq<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> txs) {
        return TransactionValidation.filterValid$((TransactionValidation)this, txs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public NetworkParams params() {
        return this.params;
    }

    public String version() {
        return this.version;
    }

    public ApplicationState applicationState() {
        return this.applicationState;
    }

    private String verificationKeyFullFilePath$lzycompute() {
        SidechainState sidechainState = this;
        synchronized (sidechainState) {
            if (!this.bitmap$0) {
                BoxedUnit boxedUnit;
                if (this.params().certVerificationKeyFilePath().equalsIgnoreCase("")) {
                    throw new IllegalStateException("Verification key file name is not set");
                }
                File verificationFile = new File(this.params().certProvingKeyFilePath());
                if (!verificationFile.canRead()) {
                    throw new IllegalStateException(new StringBuilder(62).append("Verification key file at path ").append(verificationFile.getAbsolutePath()).append(" does not exist or can't be read").toString());
                }
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info("Verification key file at location: {}", new Object[]{verificationFile.getAbsolutePath()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.verificationKeyFullFilePath = verificationFile.getAbsolutePath();
                this.bitmap$0 = true;
            }
        }
        return this.verificationKeyFullFilePath;
    }

    public String verificationKeyFullFilePath() {
        return !this.bitmap$0 ? this.verificationKeyFullFilePath$lzycompute() : this.verificationKeyFullFilePath;
    }

    public Try<BoxedUnit> semanticValidity(BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> tx) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> tx.semanticValidity());
    }

    public Option<Box<io.horizen.proposition.Proposition>> closedBox(byte[] boxId) {
        return this.stateStorage.getBox(boxId).orElse((Function0 & Serializable & scala.Serializable)() -> $this.forgerBoxStorage.getForgerBox(boxId));
    }

    public Optional<Box<? extends io.horizen.proposition.Proposition>> getClosedBox(byte[] boxId) {
        Optional<Box<io.horizen.proposition.Proposition>> optional;
        Option<Box<io.horizen.proposition.Proposition>> option = this.closedBox(boxId);
        if (option instanceof Some) {
            Some some = (Some)option;
            Box box = (Box)some.value();
            optional = Optional.of(box);
        } else if (None$.MODULE$.equals(option)) {
            optional = Optional.empty();
        } else {
            throw new MatchError(option);
        }
        return optional;
    }

    public Seq<WithdrawalRequestBox> withdrawalRequests(int withdrawalEpoch) {
        return this.stateStorage.getWithdrawalRequests(withdrawalEpoch);
    }

    @Override
    public Seq<BackwardTransfer> backwardTransfers(int withdrawalEpoch) {
        return (Seq)this.stateStorage.getWithdrawalRequests(withdrawalEpoch).map((Function1 & Serializable & scala.Serializable)box -> new BackwardTransfer(box.proposition().bytes(), box.value()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<KeyRotationProof> keyRotationProof(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return this.stateStorage.getKeyRotationProof(withdrawalEpoch, indexOfSigner, keyType);
    }

    @Override
    public Option<CertifiersKeys> certifiersKeys(int withdrawalEpoch) {
        return withdrawalEpoch == -1 ? Option$.MODULE$.apply((Object)new CertifiersKeys((Vector<SchnorrProposition>)this.params().signersPublicKeys().toVector(), (Vector<SchnorrProposition>)this.params().mastersPublicKeys().toVector())) : this.stateStorage.getCertifiersKeys(withdrawalEpoch);
    }

    @Override
    public Option<byte[]> utxoMerkleTreeRoot(int withdrawalEpoch) {
        return this.stateStorage.getUtxoMerkleTreeRoot(withdrawalEpoch);
    }

    @Override
    public Option<byte[]> utxoMerklePath(byte[] boxId) {
        return this.utxoMerkleTreeProvider.getMerklePath(boxId);
    }

    @Override
    public boolean hasCeased() {
        return this.stateStorage.hasCeased();
    }

    @Override
    public Option<WithdrawalEpochCertificate> certificate(int referencedWithdrawalEpoch) {
        return this.stateStorage.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    public long certificateTopQuality(int referencedWithdrawalEpoch) {
        long l;
        Option<WithdrawalEpochCertificate> option = this.certificate(referencedWithdrawalEpoch);
        if (option instanceof Some) {
            Some some = (Some)option;
            WithdrawalEpochCertificate cert = (WithdrawalEpochCertificate)some.value();
            l = cert.quality();
        } else if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else {
            throw new MatchError(option);
        }
        return l;
    }

    @Override
    public Option<Object> lastCertificateReferencedEpoch() {
        return this.stateStorage.getLastCertificateReferencedEpoch();
    }

    @Override
    public Option<String> lastCertificateSidechainBlockId() {
        return this.stateStorage.getLastCertificateSidechainBlockId();
    }

    @Override
    public WithdrawalEpochInfo getWithdrawalEpochInfo() {
        return (WithdrawalEpochInfo)this.stateStorage.getWithdrawalEpochInfo().getOrElse((Function0 & Serializable & scala.Serializable)() -> new WithdrawalEpochInfo(0, 0));
    }

    public Try<BoxStateChanges<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> changes(SidechainBlock mod) {
        return SidechainState$.MODULE$.changes(mod);
    }

    public Try<BoxedUnit> validate(SidechainBlock mod) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(package$.MODULE$.versionToBytes(this.version()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray((byte[])package$.MODULE$.idToBytes().apply((Object)mod.parentId()))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Incorrect state version!: ").append(mod.parentId()).append(" found, ").append(this.version()).append(" expected").toString());
            if (this.hasCeased()) {
                throw new IllegalStateException(new StringBuilder(53).append("Can't apply Block ").append(mod.id()).append(", because the sidechain has ceased.").toString());
            }
            int consensusEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), mod.timestamp());
            WithdrawalEpochInfo currentWithdrawalEpochInfo = (WithdrawalEpochInfo)$this.stateStorage.getWithdrawalEpochInfo().getOrElse((Function0 & Serializable & scala.Serializable)() -> new WithdrawalEpochInfo(0, 0));
            WithdrawalEpochInfo modWithdrawalEpochInfo = WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mod.mainchainBlockReferencesData().size(), currentWithdrawalEpochInfo, this.params());
            this.validateBlockTransactionsMutuality(mod);
            mod.transactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                SidechainState.$anonfun$validate$4(this, consensusEpochNumber, modWithdrawalEpochInfo, tx);
                return BoxedUnit.UNIT;
            });
            if (this.params().isNonCeasing()) {
                ((IterableLike)mod.mainchainBlockReferencesData().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.topQualityCertificate()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)cert -> {
                    this.validateTopQualityCertificate(cert, cert.epochNumber());
                    return BoxedUnit.UNIT;
                });
            } else if (WithdrawalEpochUtils$.MODULE$.hasReachedCertificateSubmissionWindowEnd(mod, currentWithdrawalEpochInfo, this.params())) {
                int certReferencedEpochNumber = modWithdrawalEpochInfo.epoch() - 1;
                Option topQualityCertificateOpt = mod.topQualityCertificateOpt().orElse((Function0 & Serializable & scala.Serializable)() -> $this.stateStorage.getTopQualityCertificate(certReferencedEpochNumber));
                Option option = topQualityCertificateOpt;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WithdrawalEpochCertificate cert2 = (WithdrawalEpochCertificate)some.value();
                    this.validateTopQualityCertificate(cert2, certReferencedEpochNumber);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.log().underlying().isInfoEnabled()) {
                        this.log().underlying().info(new StringBuilder(131).append("In the end of the certificate submission window of epoch ").append(modWithdrawalEpochInfo.epoch()).append(" ").append("there are no certificates referenced to the epoch ").append(certReferencedEpochNumber).append(". Sidechain has ceased.").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    throw new MatchError((Object)option);
                }
            }
            boolean isWithdrawalEpochFinished = WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(modWithdrawalEpochInfo, this.params());
            if (isWithdrawalEpochFinished) {
                Seq<ZenBox> feePayments = this.getFeePayments(modWithdrawalEpochInfo.epoch(), (Option<BlockFeeInfo>)new Some((Object)mod.feeInfo()));
                byte[] feePaymentsHash = FeePaymentsUtils$.MODULE$.calculateFeePaymentsHash(feePayments);
                if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(feePaymentsHash))) {
                    throw new IllegalArgumentException(new StringBuilder(54).append("Block ").append(mod.id()).append(" has feePaymentsHash different to expected one: ").append(BytesUtils.toHexString(feePaymentsHash)).toString());
                }
            } else if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(FeePaymentsUtils$.MODULE$.DEFAULT_FEE_PAYMENTS_HASH()))) {
                throw new IllegalArgumentException(new StringBuilder(66).append("Block ").append(mod.id()).append(" has feePaymentsHash ").append(BytesUtils.toHexString(mod.feePaymentsHash())).append(" defined when no fee payments expected.").toString());
            }
            this.applicationState().validate((SidechainStateReader)this, mod);
        });
    }

    private void validateBlockTransactionsMutuality(SidechainBlock mod) {
        block4: {
            Seq transactionsIds = (Seq)mod.transactions().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.id(), Seq$.MODULE$.canBuildFrom());
            if (transactionsIds.toSet().size() != transactionsIds.size()) {
                throw new IllegalArgumentException(new StringBuilder(39).append("Block ").append(mod.id()).append(" contains duplicated transactions").toString());
            }
            Seq allInputBoxesIds = (Seq)mod.transactions().flatMap((Function1 & Serializable & scala.Serializable)tx -> (Set)JavaConverters$.MODULE$.asScalaSetConverter(tx.boxIdsToOpen()).asScala(), Seq$.MODULE$.canBuildFrom());
            if (allInputBoxesIds.size() != allInputBoxesIds.toSet().size()) {
                throw new IllegalArgumentException(new StringBuilder(46).append("Block ").append(mod.id()).append(" contains duplicated input boxes to open").toString());
            }
            int consensusEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), mod.timestamp());
            if (this.openStakeTransactionEnabled((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)consensusEpochNumber)))) {
                ArrayList forgerListIndexes = new ArrayList();
                mod.transactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                    Object object;
                    if (tx instanceof OpenStakeTransaction) {
                        OpenStakeTransaction openStakeTransaction = (OpenStakeTransaction)tx;
                        if (forgerListIndexes.contains(BoxesRunTime.boxToInteger((int)openStakeTransaction.getForgerIndex()))) {
                            throw new IllegalArgumentException(new StringBuilder(65).append("Block ").append(mod.id()).append(" contains OpenStakeTransactions with duplicated forgerIndex").toString());
                        }
                        object = BoxesRunTime.boxToBoolean((boolean)forgerListIndexes.add(BoxesRunTime.boxToInteger((int)openStakeTransaction.getForgerIndex())));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
            }
            Enumeration.Value value = this.params().circuitType();
            Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuitWithKeyRotation();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                HashMap keyTypeMap = new HashMap();
                mod.transactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                    Object object;
                    if (tx instanceof CertificateKeyRotationTransaction) {
                        CertificateKeyRotationTransaction keyRotationTransaction = (CertificateKeyRotationTransaction)tx;
                        Enumeration.Value keyType = keyRotationTransaction.getKeyRotationProof().keyType();
                        int keyIndex = keyRotationTransaction.getKeyRotationProof().index();
                        if (keyTypeMap.containsKey(keyType)) {
                            if (((SeqLike)keyTypeMap.get(keyType)).contains((Object)BoxesRunTime.boxToInteger((int)keyIndex))) {
                                throw new IllegalArgumentException(new StringBuilder(73).append("Block ").append(mod.id()).append(" contains multiple KeyRotationTransactions pointing to the same key").toString());
                            }
                            Seq currentValue = (Seq)keyTypeMap.get(keyType);
                            object = keyTypeMap.put(keyType, currentValue.$colon$plus((Object)BoxesRunTime.boxToInteger((int)keyIndex), Seq$.MODULE$.canBuildFrom()));
                        } else {
                            object = keyTypeMap.put(keyType, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{keyIndex})));
                        }
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
            }
            if (!ForkManager$.MODULE$.getSidechainFork(consensusEpochNumber).backwardTransferLimitEnabled()) break block4;
            this.checkWithdrawalBoxesAllowed(mod);
        }
    }

    private void checkWithdrawalBoxesAllowed(SidechainBlock mod) {
        int alreadyMinedWBs = this.getAlreadyMinedWithdrawalRequestBoxesInCurrentEpoch();
        int mainchainBlockReferenceInBlock = mod.mainchainBlockReferencesData().size();
        int allowedWBs = this.getAllowedWithdrawalRequestBoxes(mainchainBlockReferenceInBlock);
        IntRef blockWBs = IntRef.create((int)alreadyMinedWBs);
        mod.transactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
            SidechainState.$anonfun$checkWithdrawalBoxesAllowed$1(blockWBs, allowedWBs, tx);
            return BoxedUnit.UNIT;
        });
    }

    public int getAlreadyMinedWithdrawalRequestBoxesInCurrentEpoch() {
        return this.stateStorage.getWithdrawalRequests(this.getWithdrawalEpochInfo().epoch()).size();
    }

    public int getAllowedWithdrawalRequestBoxes(int numberOfMainchainBlockReferenceInBlock) {
        return Math.min(this.params().maxWBsAllowed(), this.params().maxWBsAllowed() * (this.getWithdrawalEpochInfo().lastEpochIndex() + numberOfMainchainBlockReferenceInBlock) / (this.params().withdrawalEpochLength() - 1));
    }

    public boolean openStakeTransactionEnabled(Option<Object> consensusEpochNumber) {
        boolean bl;
        Option<Object> option = consensusEpochNumber;
        if (option instanceof Some) {
            Some some = (Some)option;
            int consensusEpochNumber2 = BoxesRunTime.unboxToInt((Object)some.value());
            bl = ForkManager$.MODULE$.getSidechainFork(consensusEpochNumber2).openStakeTransactionEnabled();
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateTopQualityCertificate(WithdrawalEpochCertificate topQualityCertificate, int certReferencedEpochNumber) {
        int certReferencedEpochNumber2 = topQualityCertificate.epochNumber();
        Seq<WithdrawalRequestBox> expectedWithdrawalRequests = this.withdrawalRequests(certReferencedEpochNumber2);
        if (topQualityCertificate.backwardTransferOutputs().size() != expectedWithdrawalRequests.size()) {
            throw new IllegalStateException(new StringBuilder(139).append("Epoch ").append(certReferencedEpochNumber2).append(" top quality certificate backward transfers ").append("number ").append(topQualityCertificate.backwardTransferOutputs().size()).append(" is different than expected ").append(expectedWithdrawalRequests.size()).append(". ").append("Node's active chain is the fork from MC perspective.").toString());
        }
        ((IterableLike)topQualityCertificate.backwardTransferOutputs().zip(expectedWithdrawalRequests, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SidechainState.$anonfun$validateTopQualityCertificate$1(certReferencedEpochNumber2, x0$1);
            return BoxedUnit.UNIT;
        });
        Enumeration.Value value = this.params().circuitType();
        Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuitWithKeyRotation();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            if (topQualityCertificate.fieldElementCertificateFields().size() == 32) return;
            throw new IllegalArgumentException(new StringBuilder(132).append("Top quality certificate should contain exactly ").append(32).append(" custom fields when ceased sidechain withdrawal is disabled and key rotation enabled.").toString());
        }
        if (!this.params().isCSWEnabled()) {
            if (topQualityCertificate.fieldElementCertificateFields().size() == 0) return;
            throw new IllegalArgumentException(new StringBuilder(107).append("Top quality certificate should contain exactly ").append(0).append(" custom fields when ceased sidechain withdrawal is disabled.").toString());
        }
        if (topQualityCertificate.fieldElementCertificateFields().size() != 2) {
            throw new IllegalArgumentException(new StringBuilder(62).append("Top quality certificate should contain exactly ").append(2).append(" custom fields.").toString());
        }
        Option<byte[]> option = this.utxoMerkleTreeRoot(certReferencedEpochNumber2);
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            throw new IllegalArgumentException(new StringBuilder(67).append("There is no utxo merkle tree root stored for the referenced epoch ").append(certReferencedEpochNumber2).append(".").toString());
        }
        Some some = (Some)option;
        byte[] expectedMerkleTreeRoot = (byte[])some.value();
        byte[] certUtxoMerkleRoot = CryptoLibProvider$.MODULE$.sigProofThresholdCircuitFunctions().reconstructUtxoMerkleTreeRoot(((FieldElementCertificateField)topQualityCertificate.fieldElementCertificateFields().head()).fieldElementBytes(this.params().sidechainCreationVersion()), ((FieldElementCertificateField)topQualityCertificate.fieldElementCertificateFields().apply(1)).fieldElementBytes(this.params().sidechainCreationVersion()));
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(expectedMerkleTreeRoot)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(certUtxoMerkleRoot))) {
            throw new IllegalStateException(new StringBuilder(138).append("Epoch ").append(certReferencedEpochNumber2).append(" top quality certificate utxo merkle tree root ").append("data is different than expected. Node's active chain is the fork from MC perspective.").toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Try<BoxedUnit> validateWithFork(BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> tx, int consensusEpochNumber) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Buffer newBoxes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(tx.newBoxes()).asScala();
            Buffer newCoinBoxes = (Buffer)newBoxes.filter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainState.$anonfun$validateWithFork$2(box)));
            long coinBoxMinAmount = ForkManager$.MODULE$.getSidechainFork(consensusEpochNumber).coinBoxMinAmount();
            newCoinBoxes.foreach((Function1 & Serializable & scala.Serializable)coinBox -> {
                SidechainState.$anonfun$validateWithFork$3(coinBoxMinAmount, tx, coinBox);
                return BoxedUnit.UNIT;
            });
        });
    }

    public Try<BoxedUnit> validateWithWithdrawalEpoch(BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> tx, int withdrawalEpoch) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (tx instanceof CertificateKeyRotationTransaction) {
                byte[] byArray;
                Enumeration.Value value = this.params().circuitType();
                Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    throw new Exception("CertificateKeyRotationTransaction is not allowed with this kind of circuit!");
                }
                CertificateKeyRotationTransaction keyRotationTransaction = (CertificateKeyRotationTransaction)tx;
                KeyRotationProof keyRotationProof = keyRotationTransaction.getKeyRotationProof();
                CertifiersKeys oldCertifiersKeys = (CertifiersKeys)this.certifiersKeys(withdrawalEpoch - 1).get();
                Enumeration.Value value3 = keyRotationProof.keyType();
                Enumeration.Value value4 = KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType();
                Enumeration.Value value5 = value3;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForSigningKeyUpdate(keyRotationProof.newKey().pubKeyBytes(), withdrawalEpoch, this.params().sidechainId());
                } else {
                    Enumeration.Value value6 = KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType();
                    Enumeration.Value value7 = value3;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForMasterKeyUpdate(keyRotationProof.newKey().pubKeyBytes(), withdrawalEpoch, this.params().sidechainId());
                    } else {
                        throw new MatchError((Object)value3);
                    }
                }
                byte[] messageToSign = byArray;
                if (keyRotationProof.index() < 0 || keyRotationProof.index() > oldCertifiersKeys.masterKeys().size()) {
                    throw new Exception("Key index in CertificateKeyRotationTransaction is out of range!");
                }
                if (!keyRotationProof.signingKeySignature().isValid((SchnorrProposition)oldCertifiersKeys.signingKeys().apply(keyRotationProof.index()), messageToSign)) {
                    throw new Exception("Signing key signature in CertificateKeyRotationTransaction is not valid!");
                }
                if (!keyRotationProof.masterKeySignature().isValid((SchnorrProposition)oldCertifiersKeys.masterKeys().apply(keyRotationProof.index()), messageToSign)) {
                    throw new Exception("Master key signature in CertificateKeyRotationTransaction is not valid!");
                }
                if (!keyRotationTransaction.getNewKeySignature().isValid(keyRotationProof.newKey(), messageToSign)) {
                    throw new Exception("New key signature in CertificateKeyRotationTransaction is not valid!");
                }
            }
        });
    }

    public Try<BoxedUnit> validate(BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> tx) {
        Option<Object> option = this.stateStorage.getConsensusEpochNumber();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("Can't retrieve Consensus Epoch related info form StateStorage.");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        int consensusEpochNumber = BoxesRunTime.unboxToInt((Object)some.value());
        Try<BoxedUnit> try_ = this.validate(tx, consensusEpochNumber, this.getWithdrawalEpochInfo().epoch());
        return try_;
    }

    private Try<BoxedUnit> validate(BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> tx, int consensusEpochNumber, int withdrawalEpoch) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.semanticValidity(tx).get();
            LongRef closedCoinsBoxesAmount = LongRef.create((long)0L);
            long newCoinsBoxesAmount = 0L;
            if (!(tx instanceof MC2SCAggregatedTransaction)) {
                LazyBoolean isForgerOpen$lzy = new LazyBoolean();
                if (tx instanceof OpenStakeTransaction) {
                    if (!this.openStakeTransactionEnabled((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)consensusEpochNumber)))) {
                        throw new Exception("OpenStakeTransaction is still not allowed in this consensus epoch!");
                    }
                    if (this.isForgingOpen()) {
                        throw new Exception("OpenStakeTransactions are not allowed because the forger operation has already been opened!");
                    }
                    OpenStakeTransaction openStakeTransaction = (OpenStakeTransaction)tx;
                    if (openStakeTransaction.getForgerIndex() >= this.params().allowedForgersList().size() || openStakeTransaction.getForgerIndex() < 0) {
                        throw new Exception("ForgerIndex in OpenStakeTransaction is out of bound!");
                    }
                    Option<ForgerList> option = $this.stateStorage.getForgerList();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ForgerList forgerList = (ForgerList)some.value();
                        if (openStakeTransaction.getForgerIndex() >= forgerList.forgerIndexes().length) {
                            throw new Exception("OpenStakeTransaction forgerIndex out of bound!");
                        }
                        if (forgerList.forgerIndexes()[openStakeTransaction.getForgerIndex()] == 1) {
                            throw new Exception("Forger already opened the stake!");
                        }
                    } else {
                        if (None$.MODULE$.equals(option)) {
                            throw new Exception("Forger list was not found in the Storage!");
                        }
                        throw new MatchError(option);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Option<Box<io.horizen.proposition.Proposition>> option2 = $this.stateStorage.getBox(openStakeTransaction.getInputId());
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        Box closedBox = (Box)some.value();
                        if (!((PublicKey25519Proposition)closedBox.proposition()).equals(((Tuple2)this.params().allowedForgersList().apply(openStakeTransaction.getForgerIndex()))._1())) {
                            throw new Exception("OpenStakeTransaction input doesn't match the forgerIndex!");
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        if (None$.MODULE$.equals(option2)) {
                            throw new Exception("Input box not found!");
                        }
                        throw new MatchError(option2);
                    }
                }
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tx.unlockers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)u -> {
                    SidechainState.$anonfun$validate$9(this, tx, closedCoinsBoxesAmount, u);
                    return BoxedUnit.UNIT;
                });
                this.validateWithWithdrawalEpoch(tx, withdrawalEpoch).get();
                this.validateWithFork(tx, consensusEpochNumber).get();
                Buffer newBoxes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(tx.newBoxes()).asScala();
                newCoinsBoxesAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)newBoxes.filter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainState.$anonfun$validate$10(box)))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                if (closedCoinsBoxesAmount.elem != newCoinsBoxesAmount + tx.fee()) {
                    throw new Exception(new StringBuilder(86).append("Amounts sum of CoinsBoxes is incorrect. ").append("ClosedBox amount - ").append(closedCoinsBoxesAmount.elem).append(", NewBoxesAmount - ").append(newCoinsBoxesAmount).append(", Fee - ").append(tx.fee()).toString());
                }
                ((IterableLike)newBoxes.filter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainState.$anonfun$validate$12(box)))).foreach((Function1 & Serializable & scala.Serializable)forgerBox -> {
                    SidechainState.$anonfun$validate$13(this, isForgerOpen$lzy, forgerBox);
                    return BoxedUnit.UNIT;
                });
            }
            this.applicationState().validate((SidechainStateReader)this, tx);
        });
    }

    @Override
    public boolean isForgingOpen() {
        boolean bl;
        if (!this.params().restrictForgers()) {
            bl = true;
        } else {
            int n;
            Some some;
            ForgerList forgerList;
            Option<ForgerList> option = this.stateStorage.getForgerList();
            if (option instanceof Some && (forgerList = (ForgerList)(some = (Some)option).value()) != null) {
                ForgerList forgerList2 = forgerList;
                n = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(forgerList2.forgerIndexes())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("No forgerList found in the Storage!");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                n = 0;
            } else {
                throw new MatchError(option);
            }
            int nOpenForger = n;
            bl = nOpenForger > this.params().allowedForgersList().size() / 2;
        }
        return bl;
    }

    public Try<SidechainState> applyModifier(SidechainBlock mod) {
        return this.validate(mod).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> this.changes(mod).flatMap((Function1 & Serializable & scala.Serializable)cs -> this.applyChanges((BoxStateChanges<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>)cs, package$.MODULE$.idToVersion(mod.id()), WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mod.mainchainBlockReferencesData().size(), (WithdrawalEpochInfo)$this.stateStorage.getWithdrawalEpochInfo().getOrElse((Function0 & Serializable & scala.Serializable)() -> new WithdrawalEpochInfo(0, 0)), this.params()), TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), mod.timestamp()), mod.topQualityCertificateOpt(), mod.feeInfo(), this.getRestrictForgerIndexToUpdate(mod.sidechainTransactions()), this.getKeyRotationProofsToAdd(mod.sidechainTransactions()))));
    }

    public int[] getRestrictForgerIndexToUpdate(Seq<SidechainTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> txs) {
        return (int[])((TraversableOnce)txs.flatMap((Function1 & Serializable & scala.Serializable)tx -> {
            Iterable iterable;
            if (tx instanceof OpenStakeTransaction) {
                OpenStakeTransaction openStakeTransaction = (OpenStakeTransaction)tx;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToInteger((int)openStakeTransaction.getForgerIndex())));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public Seq<KeyRotationProof> getKeyRotationProofsToAdd(Seq<SidechainTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> txs) {
        Seq seq;
        Enumeration.Value value = this.params().circuitType();
        Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            seq = (Seq)Nil$.MODULE$;
        } else {
            Enumeration.Value value4 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuitWithKeyRotation();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                seq = (Seq)txs.flatMap((Function1 & Serializable & scala.Serializable)tx -> {
                    Iterable iterable;
                    if (tx instanceof CertificateKeyRotationTransaction) {
                        CertificateKeyRotationTransaction keyRotationTransaction = (CertificateKeyRotationTransaction)tx;
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)keyRotationTransaction.getKeyRotationProof()));
                    } else {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }, Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)value);
            }
        }
        return seq;
    }

    public Try<SidechainState> applyChanges(BoxStateChanges<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> changes, String newVersion, WithdrawalEpochInfo withdrawalEpochInfo, int consensusEpoch, Option<WithdrawalEpochCertificate> topQualityCertificateOpt, BlockFeeInfo blockFeeInfo, int[] forgerListIndexes, Seq<KeyRotationProof> keyRotationProofsToAdd) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ByteArrayWrapper version = new ByteArrayWrapper(package$.MODULE$.versionToBytes(newVersion));
            Seq boxesToAppend = (Seq)changes.toAppend().map((Function1 & Serializable & scala.Serializable)x$5 -> (Box)x$5.box(), Seq$.MODULE$.canBuildFrom());
            ListBuffer withdrawalRequestsToAppend = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ListBuffer forgerBoxesToAppend = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ListBuffer otherBoxesToAppend = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            boolean hasReachedCertificateSubmissionWindowEnd = WithdrawalEpochUtils$.MODULE$.hasReachedCertificateSubmissionWindowEnd(withdrawalEpochInfo, (WithdrawalEpochInfo)$this.stateStorage.getWithdrawalEpochInfo().getOrElse((Function0 & Serializable & scala.Serializable)() -> new WithdrawalEpochInfo(0, 0)), this.params());
            boolean scHasCeased = !this.params().isNonCeasing() && hasReachedCertificateSubmissionWindowEnd && topQualityCertificateOpt.orElse((Function0 & Serializable & scala.Serializable)() -> $this.stateStorage.getTopQualityCertificate(withdrawalEpochInfo.epoch() - 1)).isEmpty();
            Option actualCertifiersKeys = Option$.MODULE$.empty();
            boolean isWithdrawalEpochFinished = WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(withdrawalEpochInfo, this.params());
            if (isWithdrawalEpochFinished) {
                boxesToAppend = (Seq)boxesToAppend.$plus$plus((GenTraversableOnce)this.getFeePayments(withdrawalEpochInfo.epoch(), (Option<BlockFeeInfo>)new Some((Object)blockFeeInfo)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                Enumeration.Value value = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuitWithKeyRotation();
                Enumeration.Value value2 = this.params().circuitType();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    int currentEpoch = withdrawalEpochInfo.epoch();
                    CertifiersKeys certifierKeys = (CertifiersKeys)this.certifiersKeys(currentEpoch - 1).get();
                    ArrayList signerKeys = new ArrayList();
                    ArrayList masterKeys = new ArrayList();
                    certifierKeys.signingKeys().indices().foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
                        boolean bl;
                        Some some;
                        KeyRotationProof keyRotationProof;
                        boolean bl2;
                        Some some2;
                        KeyRotationProof keyRotationProof2;
                        Option<KeyRotationProof> option = this.keyRotationProof(currentEpoch, i, KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType().id());
                        if (option instanceof Some && (keyRotationProof2 = (KeyRotationProof)(some2 = (Some)option).value()) != null) {
                            KeyRotationProof keyRotationProof3 = keyRotationProof2;
                            bl2 = signerKeys.add(keyRotationProof3.newKey());
                        } else if (None$.MODULE$.equals(option)) {
                            bl2 = signerKeys.add(certifierKeys.signingKeys().apply(i));
                        } else {
                            throw new MatchError(option);
                        }
                        Option<KeyRotationProof> option2 = this.keyRotationProof(currentEpoch, i, KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType().id());
                        if (option2 instanceof Some && (keyRotationProof = (KeyRotationProof)(some = (Some)option2).value()) != null) {
                            KeyRotationProof keyRotationProof4 = keyRotationProof;
                            bl = masterKeys.add(keyRotationProof4.newKey());
                        } else if (None$.MODULE$.equals(option2)) {
                            bl = masterKeys.add(certifierKeys.masterKeys().apply(i));
                        } else {
                            throw new MatchError(option2);
                        }
                        return bl;
                    });
                    actualCertifiersKeys = Option$.MODULE$.apply((Object)new CertifiersKeys((Vector<SchnorrProposition>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(signerKeys).asScala()).toVector(), (Vector<SchnorrProposition>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(masterKeys).asScala()).toVector()));
                }
            }
            boxesToAppend.foreach((Function1 & Serializable & scala.Serializable)box -> {
                SidechainState.$anonfun$applyChanges$7(this, forgerBoxesToAppend, withdrawalRequestsToAppend, otherBoxesToAppend, box);
                return BoxedUnit.UNIT;
            });
            Try<ApplicationState> try_ = this.applicationState().onApplyChanges(this, version.data(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(boxesToAppend).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)changes.toRemove().map((Function1 & Serializable & scala.Serializable)x$7 -> (byte[])Predef$.MODULE$.wrapByteArray(x$7.boxId()).array(), Seq$.MODULE$.canBuildFrom())).asJava());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit;
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("call to onApplyChanges() method has failed: ", exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw exception;
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            ApplicationState appState = (ApplicationState)success.value();
            scala.collection.immutable.Set boxIdsToRemoveSet = ((TraversableOnce)changes.toRemove().map((Function1 & Serializable & scala.Serializable)r -> new ByteArrayWrapper(r.boxId()), Seq$.MODULE$.canBuildFrom())).toSet();
            SidechainStateUtxoMerkleTreeProvider updatedUtxoMerkleTreeProvider = (SidechainStateUtxoMerkleTreeProvider)$this.utxoMerkleTreeProvider.update(version, (Seq<Box<io.horizen.proposition.Proposition>>)boxesToAppend, (scala.collection.immutable.Set<ByteArrayWrapper>)boxIdsToRemoveSet).get();
            Option<byte[]> utxoMerkleTreeRootOpt = isWithdrawalEpochFinished ? updatedUtxoMerkleTreeProvider.getMerkleTreeRoot() : None$.MODULE$;
            SidechainState sidechainState = new SidechainState((SidechainStateStorage)$this.stateStorage.update(version, withdrawalEpochInfo, (scala.collection.immutable.Set<Box<io.horizen.proposition.Proposition>>)otherBoxesToAppend.toSet(), (scala.collection.immutable.Set<ByteArrayWrapper>)boxIdsToRemoveSet, (Seq<WithdrawalRequestBox>)withdrawalRequestsToAppend, consensusEpoch, topQualityCertificateOpt, blockFeeInfo, utxoMerkleTreeRootOpt, scHasCeased, forgerListIndexes, this.params().allowedForgersList().size(), keyRotationProofsToAdd, (Option<CertifiersKeys>)actualCertifiersKeys).get(), (SidechainStateForgerBoxStorage)$this.forgerBoxStorage.update(version, (Seq<ForgerBox>)forgerBoxesToAppend, (scala.collection.immutable.Set<ByteArrayWrapper>)boxIdsToRemoveSet).get(), updatedUtxoMerkleTreeProvider, this.params(), newVersion, appState);
            return sidechainState;
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SidechainState $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isErrorEnabled()) {
                    this.$outer.log().underlying().error("Exception was thrown during applyChanges.", A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int maxRollbackDepth() {
        return this.stateStorage.rollbackVersions().size();
    }

    public Try<SidechainState> rollbackTo(String to) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.require(to != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("rolling back state to version = {}", new Object[]{to});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            byte[] version = BytesUtils.fromHexString(to);
            ByteArrayWrapper bawVersion = new ByteArrayWrapper(version);
            SidechainStateForgerBoxStorage forgerBoxStorageNew = (SidechainStateForgerBoxStorage)$this.forgerBoxStorage.rollback(bawVersion).get();
            SidechainStateStorage stateStorageNew = (SidechainStateStorage)$this.stateStorage.rollback(bawVersion).get();
            SidechainStateUtxoMerkleTreeProvider utxoMerkleTreeProviderNew = (SidechainStateUtxoMerkleTreeProvider)$this.utxoMerkleTreeProvider.rollback(bawVersion).get();
            Try<ApplicationState> try_ = this.applicationState().onRollback(version);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit2;
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("call to applicationState.onRollback() method has failed: ", exception);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    throw exception;
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            ApplicationState appState = (ApplicationState)success.value();
            SidechainState sidechainState = new SidechainState(stateStorageNew, forgerBoxStorageNew, utxoMerkleTreeProviderNew, this.params(), to, appState);
            return sidechainState;
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SidechainState $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isErrorEnabled()) {
                    this.$outer.log().underlying().error("Exception was thrown during rollback.", A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean isSwitchingConsensusEpoch(long blockTimestamp) {
        int currentConsensusEpoch;
        int blockConsensusEpoch = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), blockTimestamp);
        return blockConsensusEpoch != (currentConsensusEpoch = BoxesRunTime.unboxToInt((Object)this.stateStorage.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(0))));
    }

    @Override
    public Tuple2<String, ConsensusEpochInfo> getCurrentConsensusEpochInfo() {
        Seq<ForgingStakeInfo> forgingStakes;
        int consensusEpochNumber;
        Option<Object> option = this.stateStorage.getConsensusEpochNumber();
        if (option instanceof Some) {
            Some some = (Some)option;
            consensusEpochNumber = BoxesRunTime.unboxToInt((Object)some.value());
            forgingStakes = this.getOrderedForgingStakesInfoSeq(consensusEpochNumber);
            if (forgingStakes.isEmpty()) {
                throw new IllegalStateException("ForgerStakes list can't be empty.");
            }
        } else {
            throw new IllegalStateException("Can't retrieve Consensus Epoch related info form StateStorage.");
        }
        String lastBlockInEpoch = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)this.stateStorage.lastVersionId().get()).data());
        ConsensusEpochInfo consensusEpochInfo = new ConsensusEpochInfo(consensusEpochNumber, MerkleTree.createMerkleTree((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)forgingStakes.map((Function1 & Serializable & scala.Serializable)info -> info.hash(), Seq$.MODULE$.canBuildFrom())).asJava()), BoxesRunTime.unboxToLong((Object)((TraversableOnce)forgingStakes.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.stakeAmount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Tuple2 tuple2 = new Tuple2((Object)lastBlockInEpoch, (Object)consensusEpochInfo);
        return tuple2;
    }

    @Override
    public Seq<ForgingStakeInfo> getOrderedForgingStakesInfoSeq(int epochNumber) {
        return (Seq)ForgingStakeInfo$.MODULE$.fromForgerBoxes(this.forgerBoxStorage.getAllForgerBoxes()).sorted(scala.package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).reverse());
    }

    @Override
    public boolean isWithdrawalEpochLastIndex() {
        return WithdrawalEpochUtils$.MODULE$.isEpochLastIndex((WithdrawalEpochInfo)this.stateStorage.getWithdrawalEpochInfo().getOrElse((Function0 & Serializable & scala.Serializable)() -> new WithdrawalEpochInfo(0, 0)), this.params());
    }

    public Try<SidechainState> ensureStorageConsistencyAfterRestore() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SidechainState sidechainState;
            byte[] versionFbBytes = ((ByteArrayWrapper)$this.forgerBoxStorage.lastVersionId().get()).data();
            boolean appStateVersionOk = this.applicationState().checkStoragesVersion(versionFbBytes);
            String versionFb = sparkz.util.package$.MODULE$.bytesToId(versionFbBytes);
            if (appStateVersionOk) {
                BoxedUnit boxedUnit;
                if (this.params().isCSWEnabled()) {
                    String versionUmt = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)$this.utxoMerkleTreeProvider.lastVersionId().get()).data());
                    String string = versionFb;
                    String string2 = versionUmt;
                    Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "ForgerBox and Utxo storage versions must be aligned");
                }
                String versionSt = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)$this.stateStorage.lastVersionId().get()).data());
                String string = versionFb;
                String string3 = versionSt;
                Predef$.MODULE$.require(!(string != null ? !string.equals(string3) : string3 != null), (Function0 & Serializable & scala.Serializable)() -> "ForgerBox and State storage versions must be aligned");
                String string4 = versionFb;
                String string5 = package$.MODULE$.versionToId(this.version());
                Predef$.MODULE$.require(!(string4 != null ? !string4.equals(string5) : string5 != null), (Function0 & Serializable & scala.Serializable)() -> "ForgerBox version and SidechainState version attribute must be aligned");
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("All state storages are consistent");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                sidechainState = this;
            } else {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("state storages are not consistent");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Try<SidechainState> rolledBackState = this.rollbackTo(package$.MODULE$.idToVersion(versionFb));
                if (rolledBackState.isFailure()) {
                    throw new IllegalStateException("Could not rollback state");
                }
                sidechainState = (SidechainState)rolledBackState.get();
            }
            return sidechainState;
        });
    }

    public Seq<ZenBox> getFeePayments(int withdrawalEpochNumber, Option<BlockFeeInfo> blockToAppendFeeInfo) {
        ObjectRef blockFeeInfoSeq = ObjectRef.create(this.stateStorage.getFeePayments(withdrawalEpochNumber));
        blockToAppendFeeInfo.foreach((Function1 & Serializable & scala.Serializable)blockFeeInfo -> {
            blockFeeInfoSeq.elem = (Seq)((Seq)blockFeeInfoSeq.elem).$colon$plus((Object)blockFeeInfo, Seq$.MODULE$.canBuildFrom());
            return BoxedUnit.UNIT;
        });
        if (((Seq)blockFeeInfoSeq.elem).isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        LongRef poolFee = LongRef.create((long)0L);
        BigDecimal forgerPercentage = new BigDecimal(this.params().forgerBlockFeeCoefficient(), MathContext.DECIMAL64);
        Seq forgersBlockRewards = (Seq)((Seq)blockFeeInfoSeq.elem).map((Function1 & Serializable & scala.Serializable)feeInfo -> {
            long forgerBlockFee = new BigDecimal(feeInfo.fee()).multiply(forgerPercentage).longValue();
            poolFee$1.elem += feeInfo.fee() - forgerBlockFee;
            return new Tuple2((Object)feeInfo.forgerRewardKey(), (Object)BoxesRunTime.boxToLong((long)forgerBlockFee));
        }, Seq$.MODULE$.canBuildFrom());
        long forgerPoolFee = poolFee.elem / (long)forgersBlockRewards.size();
        long rest = poolFee.elem % (long)forgersBlockRewards.size();
        Seq forgersRewards = (Seq)((TraversableLike)forgersBlockRewards.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int index;
            Tuple2 forgerBlockReward;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    forgerBlockReward = (Tuple2)tuple2._1();
                    index = tuple2._2$mcI$sp();
                    if (forgerBlockReward != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple2 = forgerBlockReward;
            int n = index;
            long finalForgerFee = tuple2._2$mcJ$sp() + forgerPoolFee + (long)((long)n < rest ? 1 : 0);
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToLong((long)finalForgerFee));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Seq forgerKeys = (Seq)((SeqLike)forgersRewards.map((Function1 & Serializable & scala.Serializable)x$9 -> (PublicKey25519Proposition)x$9._1(), Seq$.MODULE$.canBuildFrom())).distinct();
        Seq res = (Seq)forgerKeys.map((Function1 & Serializable & scala.Serializable)forgerKey -> {
            long forgerTotalFee = BoxesRunTime.unboxToLong((Object)((TraversableOnce)forgersRewards.withFilter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)forgerKey.equals(r._1()))).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            return new Tuple2(forgerKey, (Object)BoxesRunTime.boxToLong((long)forgerTotalFee));
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)((TraversableLike)res.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            int index;
            Tuple2 forgerRewardInfo;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    forgerRewardInfo = (Tuple2)tuple2._1();
                    index = tuple2._2$mcI$sp();
                    if (forgerRewardInfo != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple2 = forgerRewardInfo;
            int n = index;
            ZenBoxData data = new ZenBoxData((PublicKey25519Proposition)tuple2._1(), tuple2._2$mcJ$sp());
            long nonce = SidechainState$.MODULE$.calculateFeePaymentBoxNonce(withdrawalEpochNumber, n);
            ZenBox zenBox = new ZenBox(data, nonce);
            return zenBox;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainState.$anonfun$getFeePayments$9(box)));
    }

    public Option<BlockFeeInfo> getFeePayments$default$2() {
        return None$.MODULE$;
    }

    public Try<SidechainState> restoreBackup(BoxIterator backupStorageBoxIterator, byte[] lastVersion) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.stateStorage.restoreBackup(backupStorageBoxIterator, lastVersion);
            backupStorageBoxIterator.seekToFirst();
            Try<ApplicationState> try_ = this.applicationState().onBackupRestore(backupStorageBoxIterator);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("Error during the backup restore inside the SidechainState", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw e;
                }
                throw new MatchError(try_);
            }
            SidechainState sidechainState = this;
            return sidechainState;
        });
    }

    public static final /* synthetic */ void $anonfun$validate$4(SidechainState $this, int consensusEpochNumber$1, WithdrawalEpochInfo modWithdrawalEpochInfo$1, BoxTransaction tx) {
        $this.validate(tx, consensusEpochNumber$1, modWithdrawalEpochInfo$1.epoch()).get();
    }

    public static final /* synthetic */ boolean $anonfun$checkWithdrawalBoxesAllowed$2(Box box) {
        return box instanceof WithdrawalRequestBox;
    }

    public static final /* synthetic */ void $anonfun$checkWithdrawalBoxesAllowed$1(IntRef blockWBs$1, int allowedWBs$1, BoxTransaction tx) {
        blockWBs$1.elem += ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(tx.newBoxes()).asScala()).count((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainState.$anonfun$checkWithdrawalBoxesAllowed$2(box)));
        if (blockWBs$1.elem > allowedWBs$1) {
            throw new IllegalStateException("Exceeded the maximum number of WithdrawalBoxes allowed!");
        }
    }

    public static final /* synthetic */ void $anonfun$validateTopQualityCertificate$1(int certReferencedEpochNumber$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MainchainBackwardTransferCertificateOutput certOutput = (MainchainBackwardTransferCertificateOutput)tuple2._1();
            WithdrawalRequestBox expectedWithdrawalRequestBox = (WithdrawalRequestBox)tuple2._2();
            if (certOutput.amount() != expectedWithdrawalRequestBox.value() || !Arrays.equals(certOutput.pubKeyHash(), expectedWithdrawalRequestBox.proposition().bytes())) {
                throw new IllegalStateException(new StringBuilder(135).append("Epoch ").append(certReferencedEpochNumber$2).append(" top quality certificate backward transfers ").append("data is different than expected. Node's active chain is the fork from MC perspective.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$validateWithFork$2(Box box) {
        return box instanceof CoinsBox || box instanceof WithdrawalRequestBox;
    }

    public static final /* synthetic */ void $anonfun$validateWithFork$3(long coinBoxMinAmount$1, BoxTransaction tx$2, Box coinBox) {
        if (coinBox.value() < coinBoxMinAmount$1) {
            throw new TransactionSemanticValidityException(new StringBuilder(83).append("Transaction [").append(tx$2.id()).append("] is semantically invalid: ").append("Coin box value [").append(coinBox.value()).append("] is below the threshold[").append(coinBoxMinAmount$1).append("].").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validate$9(SidechainState $this, BoxTransaction tx$4, LongRef closedCoinsBoxesAmount$1, BoxUnlocker u) {
        BoxedUnit boxedUnit;
        Option<Box<io.horizen.proposition.Proposition>> option = $this.closedBox(u.closedBoxId());
        if (option instanceof Some) {
            Some some = (Some)option;
            Box box = (Box)some.value();
            Proof<Proposition> boxKey = u.boxKey();
            if (!boxKey.isValid(box.proposition(), tx$4.messageToSign())) {
                throw new Exception("Box unlocking proof is invalid.");
            }
            if (box instanceof CoinsBox) {
                closedCoinsBoxesAmount$1.elem += box.value();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringBuilder(26).append("Box ").append(u.closedBoxId()).append(" is not found in state").toString());
            }
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$validate$10(Box box) {
        return box instanceof CoinsBox || box instanceof WithdrawalRequestBox;
    }

    private final /* synthetic */ boolean isForgerOpen$lzycompute$1(LazyBoolean isForgerOpen$lzy$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isForgerOpen$lzy$1;
        synchronized (lazyBoolean) {
            bl = isForgerOpen$lzy$1.initialized() ? isForgerOpen$lzy$1.value() : isForgerOpen$lzy$1.initialize(this.isForgingOpen());
        }
        return bl;
    }

    private final boolean isForgerOpen$1(LazyBoolean isForgerOpen$lzy$1) {
        return isForgerOpen$lzy$1.initialized() ? isForgerOpen$lzy$1.value() : this.isForgerOpen$lzycompute$1(isForgerOpen$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$validate$12(Box box) {
        return box instanceof ForgerBox;
    }

    public static final /* synthetic */ void $anonfun$validate$13(SidechainState $this, LazyBoolean isForgerOpen$lzy$1, Box forgerBox) {
        if (!$this.isForgerOpen$1(isForgerOpen$lzy$1)) {
            VrfPublicKey vrfPublicKey = $this.scbToForgerBox(forgerBox).vrfPubKey();
            PublicKey25519Proposition blockSignProposition = $this.scbToForgerBox(forgerBox).blockSignProposition();
            if (!$this.params().allowedForgersList().contains((Object)new Tuple2((Object)blockSignProposition, (Object)vrfPublicKey))) {
                throw new Exception("This publicKey is not allowed to forge!");
            }
        }
    }

    public static final /* synthetic */ void $anonfun$applyChanges$7(SidechainState $this, ListBuffer forgerBoxesToAppend$1, ListBuffer withdrawalRequestsToAppend$1, ListBuffer otherBoxesToAppend$1, Box box) {
        if (box instanceof ForgerBox) {
            forgerBoxesToAppend$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ForgerBox[]{$this.scbToForgerBox(box)}));
        } else if (box instanceof WithdrawalRequestBox) {
            withdrawalRequestsToAppend$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WithdrawalRequestBox[]{$this.scbToWithdrawalRequestBox(box)}));
        } else {
            otherBoxesToAppend$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Box[]{box}));
        }
    }

    public static final /* synthetic */ boolean $anonfun$getFeePayments$9(ZenBox box) {
        return box.value() > 0L;
    }

    public SidechainState(SidechainStateStorage stateStorage, SidechainStateForgerBoxStorage forgerBoxStorage, SidechainStateUtxoMerkleTreeProvider utxoMerkleTreeProvider, NetworkParams params, String version, ApplicationState applicationState) {
        this.stateStorage = stateStorage;
        this.forgerBoxStorage = forgerBoxStorage;
        this.utxoMerkleTreeProvider = utxoMerkleTreeProvider;
        this.params = params;
        this.version = version;
        this.applicationState = applicationState;
        TransactionValidation.$init$((TransactionValidation)this);
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        NetworkParamsUtils.$init$(this);
    }
}

