/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.mempool;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.MempoolSettings;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.mempool.MempoolMap;
import io.horizen.utxo.mempool.SidechainMemoryPool$;
import io.horizen.utxo.mempool.SidechainMemoryPoolEntry;
import io.horizen.utxo.node.NodeMemoryPool;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.core.NodeViewModifier;
import sparkz.core.consensus.ContainsModifiers;
import sparkz.core.transaction.MemoryPool;
import sparkz.core.transaction.MempoolReader;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0014)\u0001EB\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\")Q\u000e\u0001C\u0005]\"9\u0011\u000f\u0001a\u0001\n\u0003\u0011\bb\u0002<\u0001\u0001\u0004%\ta\u001e\u0005\u0007{\u0002\u0001\u000b\u0015B:\t\u000fy\u0004!\u0019!C\u0001e\"1q\u0010\u0001Q\u0001\nM,Q!!\u0001\u0001AMCq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011Q\u000b\u0001\u0005B\u0005]\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\tY\b\u0001C!\u0003{Bq!a\u001f\u0001\t\u0003\t9\tC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u00111\u0015\u0001\u0005B\u0005-\u0006bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\t9\r\u0001C!\u0003\u0013Dq!a2\u0001\t\u0003\nI\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002h\"9\u00111\u001e\u0001\u0005B\u00055\bbBAy\u0001\u0011\u0005\u00131\u001f\u0005\b\u0003c\u0004A\u0011IA{\u0011\u001d\u0011\u0019\u0001\u0001C!\u0005\u000bAaAa\u0002\u0001\t\u0003\u0011\bb\u0002B\u0005\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0005\u0017\u0001A\u0011AA,\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001f9qAa\u000e)\u0011\u0003\u0011ID\u0002\u0004(Q!\u0005!1\b\u0005\u0007[\u0012\"\tA!\u0010\t\u000f\t}B\u0005\"\u0001\u0003B\t\u00192+\u001b3fG\"\f\u0017N\\'f[>\u0014\u0018\u0010U8pY*\u0011\u0011FK\u0001\b[\u0016l\u0007o\\8m\u0015\tYC&\u0001\u0003vib|'BA\u0017/\u0003\u001dAwN]5{K:T\u0011aL\u0001\u0003S>\u001c\u0001a\u0005\u0004\u0001ea*\u0016l\u0018\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\te\u0002%iU\u0007\u0002u)\u00111\bP\u0001\fiJ\fgn]1di&|gN\u0003\u0002>}\u0005!1m\u001c:f\u0015\u0005y\u0014AB:qCJ\\'0\u0003\u0002Bu\tQQ*Z7pef\u0004vn\u001c7\u0011\t\r+u)T\u0007\u0002\t*\u00111HK\u0005\u0003\r\u0012\u0013aBQ8y)J\fgn]1di&|g\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002KY\u0005Y\u0001O]8q_NLG/[8o\u0013\ta\u0015JA\u0006Qe>\u0004xn]5uS>t\u0007c\u0001(R\u000f6\tqJ\u0003\u0002QU\u0005\u0019!m\u001c=\n\u0005I{%a\u0001\"pqB\u0011A\u000bA\u0007\u0002QA\u0011akV\u0007\u0002Y%\u0011\u0001\f\f\u0002\u000f'&$Wm\u00195bS:$\u0016\u0010]3t!\tQV,D\u0001\\\u0015\ta&&\u0001\u0003o_\u0012,\u0017B\u00010\\\u00059qu\u000eZ3NK6|'/\u001f)p_2\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019 \u0002\tU$\u0018\u000e\\\u0005\u0003I\u0006\u0014Qb\u00159be.THj\\4hS:<\u0017aC;oG>tg-\u001b:nK\u0012\u0004\"\u0001V4\n\u0005!D#AC'f[B|w\u000e\\'ba\u0006yQ.Z7q_>d7+\u001a;uS:<7\u000f\u0005\u0002WW&\u0011A\u000e\f\u0002\u0010\u001b\u0016l\u0007o\\8m'\u0016$H/\u001b8hg\u00061A(\u001b8jiz\"2aU8q\u0011\u0015)7\u00011\u0001g\u0011\u0015I7\u00011\u0001k\u0003Ai\u0017\r\u001f)p_2\u001c\u0016N_3CsR,7/F\u0001t!\t\u0019D/\u0003\u0002vi\t!Aj\u001c8h\u0003Qi\u0017\r\u001f)p_2\u001c\u0016N_3CsR,7o\u0018\u0013fcR\u0011\u0001p\u001f\t\u0003geL!A\u001f\u001b\u0003\tUs\u0017\u000e\u001e\u0005\by\u0016\t\t\u00111\u0001t\u0003\rAH%M\u0001\u0012[\u0006D\bk\\8m'&TXMQ=uKN\u0004\u0013AC7j]\u001a+WMU1uK\u0006YQ.\u001b8GK\u0016\u0014\u0016\r^3!\u0005\u0011qek\u0011+\u0002\u00195|G-\u001b4jKJ\u0014\u00150\u00133\u0015\t\u0005\u001d\u0011Q\u0002\t\u0005g\u0005%!)C\u0002\u0002\fQ\u0012aa\u00149uS>t\u0007bBA\b\u0015\u0001\u0007\u0011\u0011C\u0001\u000b[>$\u0017NZ5fe&#\u0007\u0003BA\n\u0003OqA!!\u0006\u0002$9!\u0011qCA\u0011\u001d\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fa\u00051AH]8pizJ\u0011aP\u0005\u0003EzJ1!!\nb\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000b\u0002,\tQQj\u001c3jM&,'/\u00133\u000b\u0007\u0005\u0015\u0012-\u0001\u0005d_:$\u0018-\u001b8t)\u0011\t\t$a\u000e\u0011\u0007M\n\u0019$C\u0002\u00026Q\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002:-\u0001\r!!\u0005\u0002\u0005%$\u0017AB4fi\u0006cG\u000e\u0006\u0003\u0002@\u0005=\u0003#BA!\u0003\u0013\u0012e\u0002BA\"\u0003\u000frA!!\u0007\u0002F%\tQ'C\u0002\u0002&QJA!a\u0013\u0002N\t\u00191+Z9\u000b\u0007\u0005\u0015B\u0007C\u0004\u0002R1\u0001\r!a\u0015\u0002\u0007%$7\u000f\u0005\u0004\u0002B\u0005%\u0013\u0011C\u0001\u0005g&TX-\u0006\u0002\u0002ZA\u00191'a\u0017\n\u0007\u0005uCGA\u0002J]R\f!dZ3u)J\fgn]1di&|gn]*peR,GMQ=GK\u0016$B!a\u0019\u0002rA)\u0011QMA7\u00056\u0011\u0011q\r\u0006\u0004E\u0006%$BAA6\u0003\u0011Q\u0017M^1\n\t\u0005=\u0014q\r\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002t9\u0001\r!!\u0017\u0002\u000b1LW.\u001b;\u0002=\u001d,G\u000f\u0016:b]N\f7\r^5p]N\u001cvN\u001d;fI\nKh)Z3SCR,G\u0003BA2\u0003sBq!a\u001d\u0010\u0001\u0004\tI&\u0001\u0003uC.,G\u0003BA@\u0003\u000b\u0003R!!\u0011\u0002\u0002\nKA!a!\u0002N\tA\u0011\n^3sC\ndW\rC\u0004\u0002tA\u0001\r!!\u0017\u0015\r\u0005}\u0014\u0011RAM\u0011\u001d\tY)\u0005a\u0001\u0003\u001b\u000b\u0001b]8si\u001a+hn\u0019\t\ng\u0005=\u00151SAJ\u0003cI1!!%5\u0005%1UO\\2uS>t'\u0007E\u0002U\u0003+K1!a&)\u0005a\u0019\u0016\u000eZ3dQ\u0006Lg.T3n_JL\bk\\8m\u000b:$(/\u001f\u0005\b\u0003g\n\u0002\u0019AA-\u0003q!\u0018m[3XSRDw+\u001b;iIJ\fw/\u00197C_b,7\u000fT5nSR$B!a \u0002 \"9\u0011\u0011\u0015\nA\u0002\u0005e\u0013AF1mY><X\rZ,ji\"$'/Y<bY\n{\u00070Z:\u0002\r\u0019LG\u000e^3s)\r\u0019\u0016q\u0015\u0005\b\u0003S\u001b\u0002\u0019AA \u0003\r!\bp\u001d\u000b\u0004'\u00065\u0006bBAX)\u0001\u0007\u0011\u0011W\u0001\nG>tG-\u001b;j_:\u0004baMAZ\u0005\u0006E\u0012bAA[i\tIa)\u001e8di&|g.M\u0001\u0006]>$\u0018J\u001c\u000b\u0005\u0003'\nY\fC\u0004\u0002RU\u0001\r!a\u0015\u0002\u0013\u001d,GOU3bI\u0016\u0014XCAAa!\u0011I\u00141\u0019\"\n\u0007\u0005\u0015'HA\u0007NK6\u0004xn\u001c7SK\u0006$WM]\u0001\u0004aV$H\u0003BAf\u0003+\u0004R!!4\u0002RNk!!a4\u000b\u0005\t$\u0014\u0002BAj\u0003\u001f\u00141\u0001\u0016:z\u0011\u0019\t9n\u0006a\u0001\u0005\u0006\u0011A\u000f\u001f\u000b\u0005\u0003\u0017\fY\u000eC\u0004\u0002*b\u0001\r!a \u0002!\u0005$GmV5uQNK'0Z\"iK\u000e\\G\u0003BA\u0019\u0003CDq!a9\u001a\u0001\u0004\t\u0019*A\u0003f]R\u0014\u00180A\bqkR<\u0016\u000e\u001e5pkR\u001c\u0005.Z2l)\r\u0019\u0016\u0011\u001e\u0005\b\u0003SS\u0002\u0019AA@\u0003\u0019\u0011X-\\8wKR\u00191+a<\t\r\u0005]7\u00041\u0001C\u0003=9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cHCAA2)\u0019\t\u0019'a>\u0003\u0002!9\u0011\u0011`\u000fA\u0002\u0005m\u0018!A2\u0011\u000b\u0005\u0015\u0014Q \"\n\t\u0005}\u0018q\r\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\bbBA:;\u0001\u0007\u0011\u0011L\u0001\bO\u0016$8+\u001b>f)\t\tI&A\u0007vg\u0016$7+\u001b>f\u0005f$Xm]\u0001\u000fkN,GmU5{K.\u0013\u0015\u0010^3t\u00039)8/\u001a3QKJ\u001cWM\u001c;bO\u0016\f!cZ3u)J\fgn]1di&|gNQ=JIR!!\u0011\u0003B\u0012!\u0019\t)Ga\u0005\u0003\u0018%!!QCA4\u0005!y\u0005\u000f^5p]\u0006d\u0007CB\"F\u00053\u0011\t\u0003\u0005\u0003\u0003\u001c\tuQ\"\u0001\u0001\n\u0007\t}qKA\u0002T\u0007B\u0003BAT)\u0003\u001a!9!Q\u0005\u0012A\u0002\t\u001d\u0012!\u0004;sC:\u001c\u0018m\u0019;j_:LE\r\u0005\u0003\u0003*\tEb\u0002\u0002B\u0016\u0005[\u00012!!\u00075\u0013\r\u0011y\u0003N\u0001\u0007!J,G-\u001a4\n\t\tM\"Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t=B'A\nTS\u0012,7\r[1j]6+Wn\u001c:z!>|G\u000e\u0005\u0002UIM\u0011AE\r\u000b\u0003\u0005s\t!c\u0019:fCR,W)\u001c9us6+W\u000e]8pYR\u00191Ka\u0011\t\u000b%4\u0003\u0019\u00016")
public class SidechainMemoryPool
implements MemoryPool<BoxTransaction<Proposition, Box<Proposition>>, SidechainMemoryPool>,
SidechainTypes,
NodeMemoryPool,
SparkzLogging {
    private final MempoolMap unconfirmed;
    private final MempoolSettings mempoolSettings;
    private long maxPoolSizeBytes;
    private final long minFeeRate;
    private final Logger logger;

    public static SidechainMemoryPool createEmptyMempool(MempoolSettings mempoolSettings) {
        return SidechainMemoryPool$.MODULE$.createEmptyMempool(mempoolSettings);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Option<BoxTransaction<Proposition, Box<Proposition>>> getById(String id) {
        return MempoolReader.getById$((MempoolReader)this, (String)id);
    }

    public boolean contains(NodeViewModifier persistentModifier) {
        return ContainsModifiers.contains$((ContainsModifiers)this, (NodeViewModifier)persistentModifier);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long maxPoolSizeBytes() {
        return this.maxPoolSizeBytes;
    }

    public void maxPoolSizeBytes_$eq(long x$1) {
        this.maxPoolSizeBytes = x$1;
    }

    public long minFeeRate() {
        return this.minFeeRate;
    }

    public Option<BoxTransaction<Proposition, Box<Proposition>>> modifierById(String modifierId) {
        None$ none$;
        Option<SidechainMemoryPoolEntry> option = this.unconfirmed.get(modifierId);
        if (option instanceof Some) {
            Some some = (Some)option;
            SidechainMemoryPoolEntry tx = (SidechainMemoryPoolEntry)some.value();
            none$ = new Some(tx.getUnconfirmedTx());
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public boolean contains(String id) {
        return this.unconfirmed.contains(id);
    }

    public Seq<BoxTransaction<Proposition, Box<Proposition>>> getAll(Seq<String> ids) {
        return (Seq)ids.flatMap((Function1 & Serializable & scala.Serializable)modifierId -> Option$.MODULE$.option2Iterable(this.modifierById((String)modifierId)), Seq$.MODULE$.canBuildFrom());
    }

    public int size() {
        return this.unconfirmed.size();
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> getTransactionsSortedByFee(int limit) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)this.unconfirmed.values().toList().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SidechainMemoryPool.$anonfun$getTransactionsSortedByFee$1(x$1)), (Ordering)Ordering.Long$.MODULE$)).take(limit).map((Function1 & Serializable & scala.Serializable)tx -> tx.getUnconfirmedTx(), List$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> getTransactionsSortedByFeeRate(int limit) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.take(limit).toList()).asJava();
    }

    public Iterable<BoxTransaction<Proposition, Box<Proposition>>> take(int limit) {
        return (Iterable)this.unconfirmed.takeHighest(limit).map((Function1 & Serializable & scala.Serializable)ele -> ele.getUnconfirmedTx(), Seq$.MODULE$.canBuildFrom());
    }

    public Iterable<BoxTransaction<Proposition, Box<Proposition>>> take(Function2<SidechainMemoryPoolEntry, SidechainMemoryPoolEntry, Object> sortFunc, int limit) {
        return (Iterable)((TraversableLike)((IterableLike)this.unconfirmed.values().toSeq().sortWith(sortFunc)).take(limit)).map((Function1 & Serializable & scala.Serializable)tx -> tx.getUnconfirmedTx(), Seq$.MODULE$.canBuildFrom());
    }

    public Iterable<BoxTransaction<Proposition, Box<Proposition>>> takeWithWithdrawalBoxesLimit(int allowedWithdrawalBoxes) {
        ArrayList filteredTxs = new ArrayList();
        IntRef newWithdrawalBoxes = IntRef.create((int)0);
        this.take(this.size()).foreach((Function1 & Serializable & scala.Serializable)tx -> {
            Object object;
            int txWithdrawalBoxes = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(tx.newBoxes()).asScala()).count((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainMemoryPool.$anonfun$takeWithWithdrawalBoxesLimit$2(box)));
            if (txWithdrawalBoxes + newWithdrawalBoxes$1.elem <= allowedWithdrawalBoxes) {
                newWithdrawalBoxes$1.elem += txWithdrawalBoxes;
                object = BoxesRunTime.boxToBoolean((boolean)filteredTxs.add(tx));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(filteredTxs).asScala()).toList();
    }

    public SidechainMemoryPool filter(Seq<BoxTransaction<Proposition, Box<Proposition>>> txs) {
        return this.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SidechainMemoryPool.$anonfun$filter$1(txs, t)));
    }

    public SidechainMemoryPool filter(Function1<BoxTransaction<Proposition, Box<Proposition>>, Object> condition) {
        Iterable filteredMap = (Iterable)this.unconfirmed.values().filter((Function1 & Serializable & scala.Serializable)ele -> BoxesRunTime.boxToBoolean((boolean)SidechainMemoryPool.$anonfun$filter$3(condition, ele)));
        return new SidechainMemoryPool(new MempoolMap((Iterable<SidechainMemoryPoolEntry>)filteredMap), this.mempoolSettings);
    }

    public Seq<String> notIn(Seq<String> ids) {
        return MempoolReader.notIn$((MempoolReader)this, ids);
    }

    public MempoolReader<BoxTransaction<Proposition, Box<Proposition>>> getReader() {
        return this;
    }

    public Try<SidechainMemoryPool> put(BoxTransaction<Proposition, Box<Proposition>> tx) {
        SidechainMemoryPoolEntry entry = new SidechainMemoryPoolEntry(tx);
        return entry.feeRate().getFeeRate() < this.minFeeRate() ? new Failure((Throwable)new IllegalArgumentException(new StringBuilder(50).append("Transaction fee is less than mempool.minFeeRate - ").append(tx).toString())) : (tx.incompatibilityChecker().isMemoryPoolCompatible() && tx.incompatibilityChecker().isTransactionCompatible(tx, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.unconfirmed.values().toList().map((Function1 & Serializable & scala.Serializable)t -> t.getUnconfirmedTx(), List$.MODULE$.canBuildFrom())).asJava()) ? (this.addWithSizeCheck(entry) ? new Success((Object)this) : new Failure((Throwable)new IllegalArgumentException(new StringBuilder(65).append("Mempool full and tx feeRate too low, unable to add transaction - ").append(tx).toString()))) : new Failure((Throwable)new IllegalArgumentException(new StringBuilder(30).append("Transaction is incompatible - ").append(tx).toString())));
    }

    public Try<SidechainMemoryPool> put(Iterable<BoxTransaction<Proposition, Box<Proposition>>> txs) {
        Try try_;
        Object object = new Object();
        try {
            txs.tails().foreach((Function1 & Serializable & scala.Serializable)t -> {
                SidechainMemoryPool.$anonfun$put$2(object, t);
                return BoxedUnit.UNIT;
            });
            java.util.List currentUnconfimed = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.unconfirmed.values().toList().map((Function1 & Serializable & scala.Serializable)t -> t.getUnconfirmedTx(), List$.MODULE$.canBuildFrom())).asJava();
            txs.foreach((Function1 & Serializable & scala.Serializable)t -> {
                SidechainMemoryPool.$anonfun$put$4(currentUnconfimed, object, t);
                return BoxedUnit.UNIT;
            });
            txs.foreach((Function1 & Serializable & scala.Serializable)t -> {
                SidechainMemoryPoolEntry entry = new SidechainMemoryPoolEntry((BoxTransaction<Proposition, Box<Proposition>>)t);
                return entry.feeRate().getFeeRate() >= this.minFeeRate() ? BoxesRunTime.boxToBoolean((boolean)this.addWithSizeCheck(entry)) : BoxedUnit.UNIT;
            });
            try_ = new Success((Object)this);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                try_ = (Try)ex.value();
            }
            throw ex;
        }
        return try_;
    }

    public boolean addWithSizeCheck(SidechainMemoryPoolEntry entry) {
        long removingEntriesSize = 0L;
        int removingEntriesNum = 0;
        Seq<SidechainMemoryPoolEntry> mempoolEntries = this.unconfirmed.takeLowest(this.unconfirmed.size());
        while (this.unconfirmed.usedSizeBytes() - removingEntriesSize + entry.feeRate().getSize() > this.maxPoolSizeBytes()) {
            if (++removingEntriesNum > this.unconfirmed.size()) {
                return false;
            }
            if (((SidechainMemoryPoolEntry)mempoolEntries.apply(removingEntriesNum - 1)).feeRate().getFeeRate() > entry.feeRate().getFeeRate()) {
                return false;
            }
            removingEntriesSize += ((SidechainMemoryPoolEntry)mempoolEntries.apply(removingEntriesNum - 1)).getUnconfirmedTx().size();
        }
        ((IterableLike)mempoolEntries.take(removingEntriesNum)).foreach((Function1 & Serializable & scala.Serializable)lsEntry -> $this.unconfirmed.remove(lsEntry.getUnconfirmedTx().id()));
        this.unconfirmed.add(entry);
        return true;
    }

    public SidechainMemoryPool putWithoutCheck(Iterable<BoxTransaction<Proposition, Box<Proposition>>> txs) {
        ListBuffer txToRemove = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        txs.tails().foreach((Function1 & Serializable & scala.Serializable)t -> {
            Iterable iterable = t;
            Nil$ nil$ = Nil$.MODULE$;
            return (iterable == null ? nil$ != null : !iterable.equals(nil$)) && !((BoxTransaction)t.head()).incompatibilityChecker().isTransactionCompatible((BoxTransaction)t.head(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)t.tail()).toList()).asJava()) ? txToRemove.$plus$eq(t.head()) : BoxedUnit.UNIT;
        });
        Iterable compatibleTxs = (Iterable)txs.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SidechainMemoryPool.$anonfun$putWithoutCheck$2(txToRemove, t)));
        txToRemove.clear();
        compatibleTxs.foreach((Function1 & Serializable & scala.Serializable)t2 -> !t2.incompatibilityChecker().isTransactionCompatible(t2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)$this.unconfirmed.values().toList().map((Function1 & Serializable & scala.Serializable)t -> t.getUnconfirmedTx(), List$.MODULE$.canBuildFrom())).asJava()) ? txToRemove.$plus$eq(t2) : BoxedUnit.UNIT);
        compatibleTxs = (Iterable)compatibleTxs.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SidechainMemoryPool.$anonfun$putWithoutCheck$5(txToRemove, t)));
        compatibleTxs.foreach((Function1 & Serializable & scala.Serializable)t -> {
            SidechainMemoryPoolEntry entry = new SidechainMemoryPoolEntry((BoxTransaction<Proposition, Box<Proposition>>)t);
            return entry.feeRate().getFeeRate() >= this.minFeeRate() ? BoxesRunTime.boxToBoolean((boolean)this.addWithSizeCheck(entry)) : BoxedUnit.UNIT;
        });
        return this;
    }

    public SidechainMemoryPool remove(BoxTransaction<Proposition, Box<Proposition>> tx) {
        this.unconfirmed.remove(tx.id());
        return this;
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> getTransactions() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.unconfirmed.values().map((Function1 & Serializable & scala.Serializable)el -> el.getUnconfirmedTx(), Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> getTransactions(Comparator<BoxTransaction<Proposition, Box<Proposition>>> c, int limit) {
        java.util.List txs = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.unconfirmed.values().toList().map((Function1 & Serializable & scala.Serializable)tx -> tx.getUnconfirmedTx(), List$.MODULE$.canBuildFrom())).asJava();
        txs.sort(c);
        return txs.subList(0, limit);
    }

    @Override
    public int getSize() {
        return this.unconfirmed.size();
    }

    public long usedSizeBytes() {
        return this.unconfirmed.usedSizeBytes();
    }

    public int usedSizeKBytes() {
        return Math.round(this.unconfirmed.usedSizeBytes() / 1024L);
    }

    public int usedPercentage() {
        return Math.round(this.unconfirmed.usedSizeBytes() * 100L / this.maxPoolSizeBytes());
    }

    @Override
    public Optional<BoxTransaction<Proposition, Box<Proposition>>> getTransactionById(String transactionId) {
        BoxTransaction<Proposition, Box<Proposition>> boxTransaction;
        Option<SidechainMemoryPoolEntry> option = this.unconfirmed.get(transactionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            SidechainMemoryPoolEntry mempoolEntry = (SidechainMemoryPoolEntry)some.value();
            boxTransaction = mempoolEntry.getUnconfirmedTx();
        } else if (None$.MODULE$.equals(option)) {
            boxTransaction = null;
        } else {
            throw new MatchError(option);
        }
        return Optional.ofNullable(boxTransaction);
    }

    public static final /* synthetic */ long $anonfun$getTransactionsSortedByFee$1(SidechainMemoryPoolEntry x$1) {
        return -x$1.getUnconfirmedTx().fee();
    }

    public static final /* synthetic */ boolean $anonfun$takeWithWithdrawalBoxesLimit$2(Box box) {
        return box instanceof WithdrawalRequestBox;
    }

    public static final /* synthetic */ boolean $anonfun$filter$2(BoxTransaction t$1, BoxTransaction x$2) {
        String string = x$2.id();
        String string2 = t$1.id();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$filter$1(Seq txs$1, BoxTransaction t) {
        return !txs$1.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SidechainMemoryPool.$anonfun$filter$2(t, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$filter$3(Function1 condition$1, SidechainMemoryPoolEntry ele) {
        return BoxesRunTime.unboxToBoolean((Object)condition$1.apply(ele.getUnconfirmedTx()));
    }

    public static final /* synthetic */ void $anonfun$put$2(Object nonLocalReturnKey1$1, Iterable t) {
        Iterable iterable = t;
        Nil$ nil$ = Nil$.MODULE$;
        if (!(!(iterable == null ? nil$ != null : !iterable.equals(nil$)) || ((BoxTransaction)t.head()).incompatibilityChecker().isMemoryPoolCompatible() && ((BoxTransaction)t.head()).incompatibilityChecker().isTransactionCompatible((BoxTransaction)t.head(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)t.tail()).toList()).asJava()))) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Failure((Throwable)new IllegalArgumentException(new StringBuilder(36).append("There is incompatible transaction - ").append(t.head()).toString())));
        }
    }

    public static final /* synthetic */ void $anonfun$put$4(java.util.List currentUnconfimed$1, Object nonLocalReturnKey1$1, BoxTransaction t) {
        if (!t.incompatibilityChecker().isTransactionCompatible(t, currentUnconfimed$1)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Failure((Throwable)new IllegalArgumentException(new StringBuilder(36).append("There is incompatible transaction - ").append(t).toString())));
        }
    }

    public static final /* synthetic */ boolean $anonfun$putWithoutCheck$2(ListBuffer txToRemove$1, BoxTransaction t) {
        return !txToRemove$1.contains((Object)t);
    }

    public static final /* synthetic */ boolean $anonfun$putWithoutCheck$5(ListBuffer txToRemove$1, BoxTransaction t) {
        return !txToRemove$1.contains((Object)t);
    }

    public SidechainMemoryPool(MempoolMap unconfirmed, MempoolSettings mempoolSettings) {
        this.unconfirmed = unconfirmed;
        this.mempoolSettings = mempoolSettings;
        ContainsModifiers.$init$((ContainsModifiers)this);
        MempoolReader.$init$((MempoolReader)this);
        MemoryPool.$init$((MemoryPool)this);
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.maxPoolSizeBytes = mempoolSettings.maxSize() * 1024 * 1024;
        this.minFeeRate = mempoolSettings.minFeeRate();
    }
}

