/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.box;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.utxo.box.AbstractBox;
import io.horizen.utxo.box.BoxSerializer;
import io.horizen.utxo.box.CoinsBox;
import io.horizen.utxo.box.CoreBoxesIdsEnum;
import io.horizen.utxo.box.ForgerBoxSerializer;
import io.horizen.utxo.box.data.ForgerBoxData;

public final class ForgerBox
extends AbstractBox<PublicKey25519Proposition, ForgerBoxData, ForgerBox>
implements CoinsBox<PublicKey25519Proposition> {
    public ForgerBox(ForgerBoxData boxData, long nonce) {
        super(boxData, nonce);
    }

    @Override
    public byte boxTypeId() {
        return CoreBoxesIdsEnum.ForgerBoxId.id();
    }

    @JsonProperty(value="vrfPubKey")
    public VrfPublicKey vrfPubKey() {
        return ((ForgerBoxData)this.boxData).vrfPublicKey();
    }

    @JsonProperty(value="blockSignProposition")
    public PublicKey25519Proposition blockSignProposition() {
        return ((ForgerBoxData)this.boxData).blockSignProposition();
    }

    @Override
    public BoxSerializer serializer() {
        return ForgerBoxSerializer.getSerializer();
    }

    @Override
    public String toString() {
        return String.format("%s(id: %s, proposition: %s, value: %d, vrfPubKey: %s, blockSignProposition: %s, nonce: %d)", this.getClass().toString(), ForgerBox.encoder().encode(this.id()), this.proposition(), this.value(), this.vrfPubKey(), this.blockSignProposition(), this.nonce());
    }

    @Override
    public Boolean isCustom() {
        return false;
    }
}

