/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utils;

import io.horizen.utils.ChaChaPrngSecureRandom;
import io.horizen.utils.Pair;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;

public final class Ed25519 {
    private Ed25519() {
    }

    public static int privateKeyLength() {
        return 32;
    }

    public static int publicKeyLength() {
        return 32;
    }

    public static int signatureLength() {
        return 64;
    }

    public static Pair<byte[], byte[]> createKeyPair(byte[] seed) {
        SecureRandom rnd = ChaChaPrngSecureRandom.getInstance(seed);
        Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(rnd);
        Ed25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new Pair<byte[], byte[]>(privateKey.getEncoded(), publicKey.getEncoded());
    }

    public static boolean verify(byte[] signature, byte[] message, byte[] publicKey) {
        try {
            return org.bouncycastle.math.ec.rfc8032.Ed25519.verify((byte[])signature, (int)0, (byte[])publicKey, (int)0, (byte[])message, (int)0, (int)message.length);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] sign(byte[] privateKey, byte[] message, byte[] publicKey) {
        byte[] signature = new byte[64];
        org.bouncycastle.math.ec.rfc8032.Ed25519.sign((byte[])privateKey, (int)0, (byte[])publicKey, (int)0, null, (byte[])message, (int)0, (int)message.length, (byte[])signature, (int)0);
        return signature;
    }

    public static boolean validatePublicKey(byte[] publicKey) {
        try {
            return org.bouncycastle.math.ec.rfc8032.Ed25519.validatePublicKeyFull((byte[])publicKey, (int)0);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validatePublicKey(byte[] privateKey, byte[] publicKey) {
        try {
            if (!org.bouncycastle.math.ec.rfc8032.Ed25519.validatePublicKeyFull((byte[])publicKey, (int)0)) {
                return false;
            }
            byte[] correctPublicKey = new byte[Ed25519.publicKeyLength()];
            org.bouncycastle.math.ec.rfc8032.Ed25519.generatePublicKey((byte[])privateKey, (int)0, (byte[])correctPublicKey, (int)0);
            return Arrays.equals(publicKey, correctPublicKey);
        }
        catch (Exception e) {
            return false;
        }
    }
}

