/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.transaction.mainchain;

import io.horizen.block.MainchainTxForwardTransferCrosschainOutput;
import io.horizen.params.CommonParams;
import io.horizen.transaction.mainchain.ForwardTransfer;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutputSerializer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Writer;

public final class ForwardTransferSerializer
implements SidechainRelatedMainchainOutputSerializer<ForwardTransfer> {
    private static ForwardTransferSerializer serializer = new ForwardTransferSerializer();

    private ForwardTransferSerializer() {
    }

    public static ForwardTransferSerializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(ForwardTransfer forwardTransferOutput, Writer writer) {
        byte[] ftOutputBytes = forwardTransferOutput.getFtOutput().forwardTransferOutputBytes();
        writer.putInt(ftOutputBytes.length);
        writer.putBytes(ftOutputBytes);
        writer.putBytes(forwardTransferOutput.transactionHash());
        writer.putInt(forwardTransferOutput.transactionIndex());
    }

    @Override
    public ForwardTransfer parse(Reader reader) {
        int ftOutputLength = reader.getInt();
        byte[] ftOutputBytes = reader.getBytes(ftOutputLength);
        MainchainTxForwardTransferCrosschainOutput output = (MainchainTxForwardTransferCrosschainOutput)MainchainTxForwardTransferCrosschainOutput.create(ftOutputBytes, 0).get();
        byte[] transactionHash = reader.getBytes(CommonParams.mainchainTransactionHashLength());
        int transactionIndex = reader.getInt();
        return new ForwardTransfer(output, transactionHash, transactionIndex);
    }
}

