/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.storage;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.companion.SidechainSecretsCompanion;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u000b\u0017\u0001uA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\to\u0001\u0011\t\u0011)A\u0005q!)a\b\u0001C\u0001\u007f!11\t\u0001C\u00011\u0011Cqa\u0015\u0001C\u0002\u0013%A\u000b\u0003\u0004d\u0001\u0001\u0006I!\u0016\u0005\u0006I\u0002!\t!\u001a\u0005\u0006[\u0002!IA\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0006e\u0002!\t\u0001\u001f\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!!\u0006\u0001\t\u0003\t)\u0003C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005-\u0002\u0001\"\u0001\u00022!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!a\u0017\u0001\t\u0003\tiF\u0001\fTS\u0012,7\r[1j]N+7M]3u'R|'/Y4f\u0015\t9\u0002$A\u0004ti>\u0014\u0018mZ3\u000b\u0005eQ\u0012a\u00025pe&TXM\u001c\u0006\u00027\u0005\u0011\u0011n\\\u0002\u0001'\u0015\u0001a\u0004\n\u0015-!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011QEJ\u0007\u00021%\u0011q\u0005\u0007\u0002\u000f'&$Wm\u00195bS:$\u0016\u0010]3t!\tI#&D\u0001\u0017\u0013\tYcC\u0001\u000bTS\u0012,7\r[1j]N#xN]1hK&sgm\u001c\t\u0003[Ij\u0011A\f\u0006\u0003_A\nA!\u001e;jY*\t\u0011'\u0001\u0004ta\u0006\u00148N_\u0005\u0003g9\u0012Qb\u00159be.THj\\4hS:<\u0007CA\u00156\u0013\t1dCA\u0004Ti>\u0014\u0018mZ3\u00023MLG-Z2iC&t7+Z2sKR\u001c8i\\7qC:LwN\u001c\t\u0003sqj\u0011A\u000f\u0006\u0003wa\t\u0011bY8na\u0006t\u0017n\u001c8\n\u0005uR$!G*jI\u0016\u001c\u0007.Y5o'\u0016\u001c'/\u001a;t\u0007>l\u0007/\u00198j_:\fa\u0001P5oSRtDc\u0001!B\u0005B\u0011\u0011\u0006\u0001\u0005\u0006/\r\u0001\r\u0001\u000e\u0005\u0006o\r\u0001\r\u0001O\u0001\fO\u0016$hj\u001c8dK.+\u0017\u0010\u0006\u0002F\u0017B\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nG\u0001\u0006kRLGn]\u0005\u0003\u0015\u001e\u0013\u0001CQ=uK\u0006\u0013(/Y=Xe\u0006\u0004\b/\u001a:\t\u000b1#\u0001\u0019A'\u0002\u0017-,\u0017\u0010V=qKN\u000bG\u000e\u001e\t\u0004?9\u0003\u0016BA(!\u0005\u0015\t%O]1z!\ty\u0012+\u0003\u0002SA\t!!)\u001f;f\u0003\u001d\u0019Xm\u0019:fiN,\u0012!\u0016\t\u0005-n+U,D\u0001X\u0015\tA\u0016,A\u0004nkR\f'\r\\3\u000b\u0005i\u0003\u0013AC2pY2,7\r^5p]&\u0011Al\u0016\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001D\u0012AB:fGJ,G/\u0003\u0002c?\n11+Z2sKR\f\u0001b]3de\u0016$8\u000fI\u0001\rG\u0006d7-\u001e7bi\u0016\\U-\u001f\u000b\u0003\u000b\u001aDQaZ\u0004A\u0002!\f1\u0002\u001d:pa>\u001c\u0018\u000e^5p]B\u0011\u0011n[\u0007\u0002U*\u0011q\rG\u0005\u0003Y*\u00141\u0002\u0015:pa>\u001c\u0018\u000e^5p]\u0006YAn\\1e'\u0016\u001c'/\u001a;t)\u0005y\u0007CA\u0010q\u0013\t\t\bE\u0001\u0003V]&$\u0018aA4fiR\u0011Ao\u001e\t\u0004?Ul\u0016B\u0001<!\u0005\u0019y\u0005\u000f^5p]\")q-\u0003a\u0001QR\u0019\u00110a\u0003\u0011\ti\f)!\u0018\b\u0004w\u0006\u0005aB\u0001?\u0000\u001b\u0005i(B\u0001@\u001d\u0003\u0019a$o\\8u}%\t\u0011%C\u0002\u0002\u0004\u0001\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0005%!\u0001\u0002'jgRT1!a\u0001!\u0011\u001d\tiA\u0003a\u0001\u0003\u001f\tA\u0002\u001d:pa>\u001c\u0018\u000e^5p]N\u0004BA_A\u0003Q\u00061q-\u001a;BY2,\u0012!_\u0001\u0004C\u0012$G\u0003BA\r\u0003G\u0001R!a\u0007\u0002 \u0001k!!!\b\u000b\u0005=\u0002\u0013\u0002BA\u0011\u0003;\u00111\u0001\u0016:z\u0011\u0015\u0001G\u00021\u0001^)\u0011\tI\"a\n\t\r\u0005%R\u00021\u0001z\u0003)\u0019Xm\u0019:fi2K7\u000f^\u0001\u0007e\u0016lwN^3\u0015\t\u0005e\u0011q\u0006\u0005\u0006O:\u0001\r\u0001\u001b\u000b\u0005\u00033\t\u0019\u0004C\u0004\u00026=\u0001\r!a\u0004\u0002\u001fA\u0014x\u000e]8tSRLwN\u001c'jgR\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003w\t\t\u0005E\u0002 \u0003{I1!a\u0010!\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0019\tA\u0002u\u000bq![:F[B$\u00180\u0006\u0002\u0002<\u0005iA.Y:u-\u0016\u00148/[8o\u0013\u0012,\"!a\u0013\u0011\u0007})X)\u0001\u0005hKRtuN\\2f)\u0011\t\t&!\u0017\u0011\t})\u00181\u000b\t\u0004?\u0005U\u0013bAA,A\t\u0019\u0011J\u001c;\t\u000b1\u001b\u0002\u0019A'\u00023M$xN]3TK\u000e\u0014X\r^!oI:{gnY3Bi>l\u0017n\u0019\u000b\t\u00033\ty&!\u0019\u0002f!)\u0001\r\u0006a\u0001;\"9\u00111\r\u000bA\u0002\u0005M\u0013!\u00028p]\u000e,\u0007\"\u0002'\u0015\u0001\u0004i\u0005")
public class SidechainSecretStorage
implements SidechainTypes,
SidechainStorageInfo,
SparkzLogging {
    private final Storage storage;
    private final SidechainSecretsCompanion sidechainSecretsCompanion;
    private final LinkedHashMap<ByteArrayWrapper, Secret> secrets;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper getNonceKey(byte[] keyTypeSalt) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"nonce".getBytes(StandardCharsets.UTF_8), keyTypeSalt}));
    }

    private LinkedHashMap<ByteArrayWrapper, Secret> secrets() {
        return this.secrets;
    }

    public ByteArrayWrapper calculateKey(Proposition proposition) {
        return Utils.calculateKey(proposition.bytes());
    }

    private void loadSecrets() {
        this.secrets().clear();
        Buffer storageData = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala();
        ((IterableLike)((TraversableViewLike)storageData.view().map((Function1 & Serializable & scala.Serializable)keyToSecretBytes -> ((ByteArrayWrapper)keyToSecretBytes.getValue()).data(), SeqView$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)secretBytes -> {
            Iterable iterable;
            Try try_ = $this.sidechainSecretsCompanion.parseBytesTry((byte[])secretBytes);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Secret secret = (Secret)success.value();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)secret));
            } else if (try_ instanceof Failure) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                throw new MatchError((Object)try_);
            }
            return iterable;
        }, SeqView$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)secret -> this.secrets().put((Object)this.calculateKey(secret.publicImage()), secret));
    }

    public Option<Secret> get(Proposition proposition) {
        return this.secrets().get((Object)this.calculateKey(proposition));
    }

    public List<Secret> get(List<Proposition> propositions) {
        return (List)propositions.flatMap((Function1 & Serializable & scala.Serializable)p -> Option$.MODULE$.option2Iterable(this.secrets().get((Object)this.calculateKey((Proposition)p))), List$.MODULE$.canBuildFrom());
    }

    public List<Secret> getAll() {
        return this.secrets().values().toList();
    }

    public Try<SidechainSecretStorage> add(Secret secret) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(secret != null, (Function0 & Serializable & scala.Serializable)() -> "Can not add to storage: Secret must be NOT NULL.");
            ByteArrayWrapper key = this.calculateKey(secret.publicImage());
            Predef$.MODULE$.require(!this.secrets().contains((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Key already exists - ").append(secret).toString());
            ByteArrayWrapper value = new ByteArrayWrapper($this.sidechainSecretsCompanion.toBytes(secret));
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon(new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, value), (List)Nil$.MODULE$)).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
            this.secrets().put((Object)key, (Object)secret);
            return this;
        });
    }

    public Try<SidechainSecretStorage> add(List<Secret> secretList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!secretList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Null secret in list: Secret must be NOT NULL.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            secretList.foreach((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SidechainSecretStorage.$anonfun$add$6(this, updateList, s)));
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), updateList, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
            return this;
        });
    }

    public Try<SidechainSecretStorage> remove(Proposition proposition) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(proposition != null, (Function0 & Serializable & scala.Serializable)() -> "Proposition must be NOT NULL.");
            ByteArrayWrapper key = this.calculateKey(proposition);
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$)).asJava());
            this.secrets().remove((Object)key);
            return this;
        });
    }

    public Try<SidechainSecretStorage> remove(List<Proposition> propositionList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!propositionList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Proposition must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            propositionList.foreach((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SidechainSecretStorage.$anonfun$remove$5(this, removeList, p)));
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), removeList);
            return this;
        });
    }

    public boolean contains(Secret secret) {
        Predef$.MODULE$.require(secret != null, (Function0 & Serializable & scala.Serializable)() -> "Can not check if contains in storage: Secret must be NOT NULL.");
        ByteArrayWrapper key = this.calculateKey(secret.publicImage());
        return this.secrets().contains((Object)key);
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Option<Object> getNonce(byte[] keyTypeSalt) {
        Option option;
        ByteArrayWrapper key = this.getNonceKey(keyTypeSalt);
        Optional<ByteArrayWrapper> storageData = this.storage.get(key);
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(storageData));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            ByteArrayWrapper nonceBytes = (ByteArrayWrapper)some.value();
            option = new Some((Object)BoxesRunTime.boxToInteger((int)Ints.fromByteArray((byte[])nonceBytes.data())));
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Try<SidechainSecretStorage> storeSecretAndNonceAtomic(Secret secret, int nonce, byte[] keyTypeSalt) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(nonce >= 0, (Function0 & Serializable & scala.Serializable)() -> "Nonce must be not negative");
            Predef$.MODULE$.require(keyTypeSalt != null, (Function0 & Serializable & scala.Serializable)() -> "Key type salt must be NOT NULL");
            Predef$.MODULE$.require(secret != null, (Function0 & Serializable & scala.Serializable)() -> "Can not add to storage: Secret must be NOT NULL.");
            ByteArrayWrapper key = this.calculateKey(secret.publicImage());
            Predef$.MODULE$.require(!this.secrets().contains((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Key already exists - ").append(secret).toString());
            ByteArrayWrapper value = new ByteArrayWrapper($this.sidechainSecretsCompanion.toBytes(secret));
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, value));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getNonceKey(keyTypeSalt), new ByteArrayWrapper(Ints.toByteArray((int)nonce))));
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), updateList, removeList);
            this.secrets().put((Object)key, (Object)secret);
            return this;
        });
    }

    public static final /* synthetic */ boolean $anonfun$add$6(SidechainSecretStorage $this, ArrayList updateList$1, Secret s) {
        ByteArrayWrapper key = $this.calculateKey(s.publicImage());
        Predef$.MODULE$.require(!$this.secrets().contains((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Key already exists - ").append(s).toString());
        $this.secrets().put((Object)key, (Object)s);
        return updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, new ByteArrayWrapper($this.sidechainSecretsCompanion.toBytes(s))));
    }

    public static final /* synthetic */ boolean $anonfun$remove$5(SidechainSecretStorage $this, ArrayList removeList$1, Proposition p) {
        ByteArrayWrapper key = $this.calculateKey(p);
        $this.secrets().remove((Object)key);
        return removeList$1.add(key);
    }

    public SidechainSecretStorage(Storage storage, SidechainSecretsCompanion sidechainSecretsCompanion) {
        this.storage = storage;
        this.sidechainSecretsCompanion = sidechainSecretsCompanion;
        SidechainTypes.$init$(this);
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainSecretsCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainSecretsCompanion must be NOT NULL.");
        this.secrets = new LinkedHashMap();
        this.loadSecrets();
    }
}

