/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.settings;

import io.horizen.LogInfoSettings;
import io.horizen.SidechainSettings;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogInitializer {
    private static boolean initDone = false;
    private static final Set<String> levelSet = new LinkedHashSet<String>();

    public static void initLogManager(String logDir, String logFileName, String logFileLevel, String logConsoleLevel) {
        if (initDone) {
            return;
        }
        initDone = true;
        levelSet.add("all");
        levelSet.add("trace");
        levelSet.add("debug");
        levelSet.add("info");
        levelSet.add("warn");
        levelSet.add("error");
        levelSet.add("fatal");
        levelSet.add("off");
        String checkedFileLevel = LogInitializer.getCheckedLevel(logFileLevel);
        String checkedConsoleLevel = LogInitializer.getCheckedLevel(logConsoleLevel);
        String logRootLevel = "all";
        for (String level : levelSet) {
            if (!level.equals(checkedFileLevel) && !level.equals(checkedConsoleLevel)) continue;
            logRootLevel = level;
            break;
        }
        if (!((String)logDir).isBlank() && !((String)logDir).endsWith(File.separator)) {
            logDir = (String)logDir + File.separator;
        }
        System.setProperty("logDir", (String)logDir);
        System.setProperty("logFileName", logFileName);
        System.setProperty("logRootLevel", logRootLevel);
        System.setProperty("logFileLevel", checkedFileLevel);
        System.setProperty("logConsoleLevel", checkedConsoleLevel);
        Logger logger = LogManager.getLogger(LogInitializer.class);
        logger.log(Level.INFO, "Logging system started, log file: [{}], file log level: [{}], console log level: [{}]", (Object)((String)logDir + logFileName), (Object)logFileLevel, (Object)logConsoleLevel);
    }

    public static void initLogManager(SidechainSettings info) {
        String logDir = info.sparkzSettings().logDir().toString();
        LogInfoSettings logInfo = info.logInfo();
        LogInitializer.initLogManager(logDir, logInfo.logFileName(), logInfo.logFileLevel(), logInfo.logConsoleLevel());
    }

    public static String getCheckedLevel(String inLevel) {
        if (levelSet.contains(inLevel)) {
            return inLevel;
        }
        System.out.println("ERROR: specified log4j level: [" + inLevel + "] not valid: defaulting to [info]");
        return "info";
    }
}

