/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.secret;

import io.horizen.secret.SecretSerializer;
import io.horizen.secret.VrfSecretKey;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Writer;

public class VrfSecretKeySerializer
implements SecretSerializer<VrfSecretKey> {
    private static VrfSecretKeySerializer serializer = new VrfSecretKeySerializer();

    private VrfSecretKeySerializer() {
    }

    public static VrfSecretKeySerializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(VrfSecretKey secret, Writer writer) {
        writer.putBytes(secret.secretBytes);
        writer.putBytes(secret.publicBytes);
    }

    @Override
    public VrfSecretKey parse(Reader reader) {
        byte[] publicKey;
        byte[] secretKey = reader.getBytes(VrfSecretKey.SECRET_KEY_LENGTH);
        VrfSecretKey vrfSecretKey = new VrfSecretKey(secretKey, publicKey = reader.getBytes(VrfSecretKey.PUBLIC_KEY_LENGTH));
        if (!vrfSecretKey.isPublicKeyValid().booleanValue()) {
            throw new IllegalArgumentException("The public key is not corresponds to the secret key.");
        }
        return vrfSecretKey;
    }
}

