/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.secret;

import io.horizen.cryptolibprovider.CryptoLibProvider;
import io.horizen.cryptolibprovider.SchnorrFunctions;
import io.horizen.secret.SchnorrSecret;
import io.horizen.secret.SecretCreator;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;

public class SchnorrKeyGenerator
implements SecretCreator<SchnorrSecret> {
    private static final SchnorrKeyGenerator instance;
    private static final byte[] domain;

    private SchnorrKeyGenerator() {
    }

    public static SchnorrKeyGenerator getInstance() {
        return instance;
    }

    @Override
    public SchnorrSecret generateSecret(byte[] seed) {
        EnumMap<SchnorrFunctions.KeyType, byte[]> keys = CryptoLibProvider.schnorrFunctions().generateSchnorrKeys(seed);
        return new SchnorrSecret(keys.get((Object)SchnorrFunctions.KeyType.SECRET), keys.get((Object)SchnorrFunctions.KeyType.PUBLIC));
    }

    @Override
    public byte[] salt() {
        return domain;
    }

    static {
        domain = "SchnorrKey".getBytes(StandardCharsets.UTF_8);
        instance = new SchnorrKeyGenerator();
    }
}

