/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.proposition;

import io.horizen.proposition.PropositionSerializer;
import io.horizen.proposition.VrfPublicKey;
import java.nio.ByteBuffer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.VLQByteBufferReader;
import sparkz.util.serialization.Writer;

public class VrfPublicKeySerializer
implements PropositionSerializer<VrfPublicKey> {
    private static VrfPublicKeySerializer serializer = new VrfPublicKeySerializer();

    private VrfPublicKeySerializer() {
    }

    public static VrfPublicKeySerializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(VrfPublicKey proposition, Writer writer) {
        writer.putBytes(proposition.pubKeyBytes());
    }

    @Override
    public VrfPublicKey parse(Reader reader) {
        return this.parse(reader, false);
    }

    public VrfPublicKey parse(Reader reader, boolean checkPublicKey) {
        VrfPublicKey publicKey = new VrfPublicKey(reader.getBytes(VrfPublicKey.KEY_LENGTH), checkPublicKey);
        return publicKey;
    }

    public VrfPublicKey parseBytesAndCheck(byte[] propositionBytes) {
        VLQByteBufferReader bufferReader = new VLQByteBufferReader(ByteBuffer.wrap(propositionBytes));
        return this.parse((Reader)bufferReader, true);
    }
}

