/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.proof;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import io.horizen.cryptolibprovider.CryptoLibProvider;
import io.horizen.json.Views;
import io.horizen.proof.ProofOfKnowledge;
import io.horizen.proof.ProofSerializer;
import io.horizen.proof.SchnorrSignatureSerializer;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.secret.SchnorrSecret;
import java.util.Arrays;

@JsonView(value={Views.Default.class})
public class SchnorrProof
implements ProofOfKnowledge<SchnorrSecret, SchnorrProposition> {
    public static int SIGNATURE_LENGTH = CryptoLibProvider.schnorrFunctions().schnorrSignatureLength();
    @JsonProperty(value="signature")
    final byte[] signature;

    public SchnorrProof(byte[] signatureBytes) {
        if (signatureBytes.length != SIGNATURE_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect signature length, %d expected, %d found", SIGNATURE_LENGTH, signatureBytes.length));
        }
        this.signature = Arrays.copyOf(signatureBytes, signatureBytes.length);
    }

    @Override
    public boolean isValid(SchnorrProposition publicKey, byte[] message) {
        return CryptoLibProvider.schnorrFunctions().verify(message, publicKey.pubKeyBytes(), this.signature);
    }

    @Override
    public ProofSerializer serializer() {
        return SchnorrSignatureSerializer.getSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchnorrProof that = (SchnorrProof)o;
        return Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Arrays.hashCode(this.signature);
    }
}

