/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.metrics;

import io.horizen.metrics.MetricsHelp;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.core.metrics.Info;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sparkz.core.utils.TimeProvider;

public class MetricsManager {
    protected static final Logger logger = LogManager.getLogger();
    private TimeProvider timeProvider;
    private static MetricsManager me;
    private Info nodeInfo;
    private Counter blocksAppliedSuccessfully;
    private Counter blocksNotApplied;
    private Gauge blockApplyTime;
    private Gauge blockApplyTimeAbsolute;
    private Gauge mempoolSize;
    private Gauge forgeBlockCount;
    private Gauge forgeLotteryTime;
    private Gauge forgeBlockCreationTime;
    private List<MetricsHelp> helps;

    public static MetricsManager getInstance() {
        if (me == null) {
            throw new RuntimeException("Metrics manager not initialized!");
        }
        return me;
    }

    public static void init(TimeProvider timeProvider) throws IOException {
        if (me == null) {
            me = new MetricsManager(timeProvider);
        }
    }

    private MetricsManager(TimeProvider timeProvider) throws IOException {
        logger.debug("Initializing metrics engine");
        this.timeProvider = timeProvider;
        this.helps = new ArrayList<MetricsHelp>();
        this.nodeInfo = (Info)((Info.Builder)Info.builder().name("node_info").labelNames(new String[]{"version", "sdkVersion", "architecture", "jdkVersion"})).register();
        this.helps.add(new MetricsHelp(this.nodeInfo.getPrometheusName(), "Node version"));
        this.blockApplyTime = (Gauge)((Gauge.Builder)Gauge.builder().name("block_apply_time")).register();
        this.helps.add(new MetricsHelp(this.blockApplyTime.getPrometheusName(), "Time to apply block to node wallet and state (milliseconds)"));
        this.blockApplyTimeAbsolute = (Gauge)((Gauge.Builder)Gauge.builder().name("block_apply_time_fromslotstart")).register();
        this.helps.add(new MetricsHelp(this.blockApplyTimeAbsolute.getPrometheusName(), "Delta between timestamp when block has been applied successfully on this node and start timestamp of the slot it belongs to (milliseconds)"));
        this.blocksAppliedSuccessfully = (Counter)Counter.builder().name("block_applied_ok").register();
        this.helps.add(new MetricsHelp(this.blocksAppliedSuccessfully.getPrometheusName(), "Number of received blocks applied successfully (absolute value since start of the node)"));
        this.blocksNotApplied = (Counter)Counter.builder().name("block_applied_ko").register();
        this.helps.add(new MetricsHelp(this.blocksNotApplied.getPrometheusName(), "Number of received blocks not applied (absolute value since start of the node)"));
        this.mempoolSize = (Gauge)((Gauge.Builder)Gauge.builder().name("mempool_size")).register();
        this.helps.add(new MetricsHelp(this.mempoolSize.getPrometheusName(), "Mempool size (number of transactions in this node mempool)"));
        this.forgeBlockCount = (Gauge)((Gauge.Builder)Gauge.builder().name("forge_block_count")).register();
        this.helps.add(new MetricsHelp(this.forgeBlockCount.getPrometheusName(), "Number of forged blocks by this node (absolute value since start of the node)"));
        this.forgeLotteryTime = (Gauge)((Gauge.Builder)Gauge.builder().name("forge_lottery_time")).register();
        this.helps.add(new MetricsHelp(this.forgeLotteryTime.getPrometheusName(), "Time to execute the lottery (milliseconds)"));
        this.forgeBlockCreationTime = (Gauge)((Gauge.Builder)Gauge.builder().name("forge_blockcreation_time")).register();
        this.helps.add(new MetricsHelp(this.forgeBlockCreationTime.getPrometheusName(), "Time to create a new forged block (calculated from the start timestamp of the slot it belongs to) (milliseconds)"));
    }

    public long currentMillis() {
        return this.timeProvider.time();
    }

    public List<MetricsHelp> getHelp() {
        return this.helps;
    }

    public void appliedBlockOk(long millis, long millisFromBlockStamp) {
        this.blockApplyTime.set((double)millis);
        this.blockApplyTimeAbsolute.set((double)millisFromBlockStamp);
        this.blocksAppliedSuccessfully.inc();
    }

    public void setVersion(String version) {
        this.nodeInfo.setLabelValues(version.split("/"));
    }

    public void forgedBlock(long millis) {
        this.forgeBlockCount.inc();
        this.forgeBlockCreationTime.set((double)millis);
    }

    public void appliedBlockKo() {
        this.blocksNotApplied.inc();
    }

    public void mempoolSize(int size) {
        this.mempoolSize.set((double)size);
    }

    public void lotteryDone(long millis) {
        this.forgeLotteryTime.set((double)millis);
    }
}

